/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __panel_disk_h
#define __panel_disk_h

G_BEGIN_DECLS

#if _MDH_HAS_DISK

MdhPanelFlags mdh_panel_disk_flags(MdhPanel *obj);
void mdh_panel_disk_flags_set(MdhPanel *obj, MdhPanelFlags flags);

gint mdh_panel_disk_threshold(MdhPanel *obj);
void mdh_panel_disk_threshold_set(MdhPanel *obj, gint threshold);

gint mdh_panel_disk_count(MdhPanel *obj);
void mdh_panel_disk_count_set(MdhPanel *obj, gint count);

MdhPanel *mdh_panel_disk_new(const gchar *value,
                             const gchar *display,
                             const gchar *command,
                             gboolean enabled);

#define _DISK_MIN 5    /* min interval */
#define _DISK_MAX 300  /* max interval */
#define _DISK_DEF 60   /* default interval */

#define _DISK_THRESH_MIN 1
#define _DISK_THRESH_MAX 100
#define _DISK_THRESH_DEF 85

#define _DISK_DIS "%u (%U)"

#define _MDH_PANEL_COUNT_DISK_MIN  3
#define _MDH_PANEL_COUNT_DISK_MAX 10

MdhPanel **P_Disk;

#endif /* _MDH_HAS_DISK */

G_END_DECLS

#endif /* __panel_disk_h */
