/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __panel_mem_h
#define __panel_mem_h

G_BEGIN_DECLS

#if _MDH_HAS_MEM

MdhPanelFlags mdh_panel_mem_flags(MdhPanel *obj);
void mdh_panel_mem_flags_set(MdhPanel *obj, MdhPanelFlags flags);

gint mdh_panel_mem_threshold(MdhPanel *obj);
void mdh_panel_mem_threshold_set(MdhPanel *obj, gint threshold);

MdhPanel *mdh_panel_mem_new(const gchar *display,
                            const gchar *command,
                            gboolean enabled);

#define _MEM_MIN 1   /* min interval */
#define _MEM_MAX 60  /* max interval */
#define _MEM_DEF 15  /* default interval */

#define _MEM_THRESH_MIN 1
#define _MEM_THRESH_MAX 100
#define _MEM_THRESH_DEF 85

#define _MEM_DIS "%u (%U)"

MdhPanel *P_Mem;

#endif /* _MDH_HAS_MEM */

G_END_DECLS

#endif /* __panel_mem_h */
