/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>

#include <gtk/gtk.h>

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#include "mdh.h"

#include "panel.h"

#include "panel_time.h"

#include "util.h"

#if _MDH_HAS_TIME

static gboolean panel_main(gpointer data, GError **err)
{
    gchar text[255];

    MdhPanel *obj = data;

    time_t timep;

    g_return_val_if_fail(obj != NULL, FALSE);
    g_return_val_if_fail(obj->display != NULL, FALSE);

    debug("panel_main(): %d: %s", obj->handler, obj->display);

    if(!*obj->display) {
        g_set_error(err, 0, 0, "Failed to process 'time': Empty value.");
        mdh_panel_stop(obj);
        mdh_panel_set_text_r(obj, FALSE, "Error");
        return(FALSE);
    }

    timep = time(NULL);

    if(!strftime(text, sizeof(text), obj->display, localtime(&timep)))
        g_strlcpy(text, "N/A", sizeof(text));

    mdh_panel_set_text_r(obj, FALSE, "%s", text);

    return(TRUE);
}

static MdhPanelFuncs funcs = {
    panel_main,
    NULL,
    NULL,
    NULL,
    NULL
};

MdhPanel *mdh_panel_time_new(const gchar *display,
                             const gchar *command,
                             gboolean enabled)
{
    MdhPanel *obj = mdh_panel_new();

    g_return_val_if_fail(obj != NULL, NULL);

    obj->display  = (display) ? g_strdup(display) : g_strdup(_TIME_DIS);
    obj->command  = (command) ? g_strdup(command) : g_strdup("evolution");
    obj->tooltip  = g_strdup("Time");
    obj->interval = 1;
    obj->enabled  = enabled;
    obj->funcs    = funcs;

    return(obj);
}

#endif /* _MDH_HAS_TIME */
