/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdarg.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "run_history.h"
#include "util.h"

static GList *run_history_list;

/*
 * maximum run history size (used when loaded from history file). should
 * this be configurable? if so, perhaps a pre-defined radio-button type
 * setup on the run window's Option menu? 25, 50, 100, 250 ...
 */
#define _RUN_HIST_MAX     50

gboolean mdh_run_history_load(const gchar *file, GError **err)
{
    FILE *fp;

    gchar buf[LINE_MAX];

    gint count = 0;

    g_return_val_if_fail(file != NULL, TRUE);

    if(!IS_FILE(file))
        return(TRUE);

    if(!(fp = fopen(file, "r"))) {
        g_set_error(err, 0, 0, "Failed to open '%s': %s",
                               file, g_strerror(errno));
        return(FALSE);
    }

    while((fgets(buf, sizeof(buf), fp))) {
        gchar *cp;

        if((cp = strchr(buf, '\n')))
          *cp = 0;

        if(!*buf || *buf == '#')
            continue;

        if(count++ >= _RUN_HIST_MAX)
            break;

        mdh_run_history_append(g_strdup(buf));
    }

    fclose(fp);

    return(TRUE);
}

gboolean mdh_run_history_save(const gchar *file, GError **err)
{
    FILE *fp;

    GList *p;

    g_return_val_if_fail(file != NULL, FALSE);

    if(!run_history_list)
        return(TRUE);

    if(!(fp = fopen(file, "w"))) {
        g_set_error(err, 0, 0, "Failed to open '%s': %s",
                               file, g_strerror(errno));
        return(FALSE);
    }

    for(p = run_history_list; p; p = g_list_next(p))
        fprintf(fp, "%s\n", (gchar *) p->data);

    fclose(fp);

    return(TRUE);
}

GList *mdh_run_history_list(void)
{
    return(run_history_list);
}

void mdh_run_history_append(gchar *text)
{
    g_return_if_fail(text != NULL);

    run_history_list = g_list_append(run_history_list, text);
}

void mdh_run_history_prepend(gchar *text)
{
    g_return_if_fail(text != NULL);

    run_history_list = g_list_prepend(run_history_list, text);
}

void mdh_run_history_free(void)
{
    g_list_foreach(run_history_list, (GFunc) g_free, NULL);
    g_list_free(run_history_list);
    run_history_list = NULL;
}
