/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __scratch_pad_h
#define __scratch_pad_h

#define _MDH_MAX_PAD 4

gboolean mdh_scratch_pad_load(const gchar *file, GError **err);
gboolean mdh_scratch_pad_save(GError **err);

void mdh_scratch_pad_free(void);

void mdh_scratch_pad_set_tab(gint tab);
gboolean mdh_scratch_pad_get_tab(gint *tab);
void mdh_scratch_pad_set_geometry(gint x, gint y, gint w, gint h);
gboolean mdh_scratch_pad_get_geometry(gint *x, gint *y, gint *w, gint *h);

GtkTextBuffer *mdh_scratch_pad_get_buffer(gint tab);

#endif /* __scratch_pad_h */
