/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <sys/types.h>
#include <unistd.h>

#include <glib.h>

#ifdef HAVE_GLIBTOP_H
# include "sysdeps/gtop.h"
#else /* HAVE_GLIBTOP_H */
# ifdef __linux__
#  include <sys/vfs.h>
#  include "sysdeps/linux.h"
#  include "sysdeps/common.h"
# endif
# ifdef __sun__
#  include <sys/statvfs.h>
#  include "sysdeps/solaris.h"
#  include "sysdeps/common.h"
# endif
# ifdef __FreeBSD__
#  include <sys/mount.h>
#  include "sysdeps/freebsd.h"
#  include "sysdeps/bsd.h"
#  include "sysdeps/common.h"
# endif
# if (defined(__NetBSD__) || defined(__OpenBSD__))
#  include <sys/mount.h>
#  include "sysdeps/netbsd.h"
#  include "sysdeps/bsd.h"
#  include "sysdeps/common.h"
# endif
#endif /* HAVE_GLIBTOP_H */
