/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/time.h>

#include <sys/socket.h>
#include <ifaddrs.h>
#include <net/if.h>
#include <net/if_media.h>
#include <sys/ioctl.h>

gboolean mdh_sys_get_net(const gchar *dev,
                         guint64 *rx,
                         guint64 *tx,
                         gboolean *up,
                         GError **err)
{
    guint64  net_rx = 0, net_tx = 0;
    gboolean net_up = FALSE;

    struct ifaddrs *net, *net_ptr;

    g_return_val_if_fail(dev != NULL, FALSE);
    g_return_val_if_fail(rx != NULL, FALSE);
    g_return_val_if_fail(tx != NULL, FALSE);
    g_return_val_if_fail(up != NULL, FALSE);

    if(getifaddrs(&net) != 0) {
        g_set_error(err, 0, 0, "getifaddrs: %s", g_strerror(errno));
        return(FALSE);
    }

    for(net_ptr = net; net_ptr; net_ptr = net_ptr->ifa_next) {
        if(net_ptr->ifa_addr->sa_family != AF_LINK)
            continue;

        if(!strcmp(net_ptr->ifa_name, dev)) {
            struct if_data *net_data = (struct if_data *)net_ptr->ifa_data;

            net_rx = (guint64) net_data->ifi_ibytes;
            net_tx = (guint64) net_data->ifi_obytes;
            net_up = TRUE;

            break;
        }
    }

    freeifaddrs(net);

    *rx = net_rx;
    *tx = net_tx;
    *up = net_up;

    return(TRUE);
}

gboolean mdh_sys_get_uptime(gulong *seconds, GError **err)
{
    gulong sec = 0;

    static gint mib[] = { CTL_KERN, KERN_BOOTTIME };
    struct timeval btime;
    size_t size = sizeof(btime);

    g_return_val_if_fail(seconds != NULL, FALSE);

    if(sysctl(mib, 2, &btime, &size, NULL, 0) != -1 && btime.tv_sec != 0)
        sec = (time(NULL) - btime.tv_sec) + 30;

    *seconds = sec;

    return(TRUE);
}
