/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

gboolean mdh_sys_get_cpu(gdouble loadavg[3],
                         guint64 *nr_running,
                         guint64 *nr_tasks,
                         GError **err)
{
    g_return_val_if_fail(loadavg != NULL, FALSE);
    g_return_val_if_fail(nr_running != NULL, FALSE);
    g_return_val_if_fail(nr_tasks != NULL, FALSE);

    if(getloadavg(loadavg, sizeof(loadavg)) == -1) {
        g_set_error(err, 0, 0, "getloadavg: %s", g_strerror(errno));
        return(FALSE);
    }

    *nr_running = 0;
    *nr_tasks   = 0;

    return(TRUE);
}

#if (defined(HAVE_STATFS) || defined(HAVE_STATVFS))
gboolean mdh_sys_get_disk(const gchar *fs,
                          guint64 *total,
                          guint64 *free,
                          guint64 *avail,
                          GError **err)
{
#ifdef HAVE_STATFS
    struct statfs  sfs;
#else
    struct statvfs sfs;
#endif

    g_return_val_if_fail(fs != NULL, FALSE);
    g_return_val_if_fail(total != NULL, FALSE);
    g_return_val_if_fail(free != NULL, FALSE);
    g_return_val_if_fail(avail != NULL, FALSE);

#ifdef HAVE_STATFS
    if(statfs(fs, &sfs) == -1) {
#else
    if(statvfs(fs, &sfs) == -1) {
#endif
        g_set_error(err, 0, 0, "statfs '%s': %s", fs, g_strerror(errno));
        return(FALSE);
    }

#ifdef HAVE_STATFS
    *total = (guint64) sfs.f_blocks * sfs.f_bsize;
    *free  = (guint64) sfs.f_bfree  * sfs.f_bsize;
    *avail = (guint64) sfs.f_bavail * sfs.f_bsize;
#else
    *total = (guint64) sfs.f_blocks * sfs.f_frsize;
    *free  = (guint64) sfs.f_bfree  * sfs.f_frsize;
    *avail = (guint64) sfs.f_bavail * sfs.f_frsize;
#endif

    return(TRUE);
}
#else /* (defined(HAVE_STATFS) || defined(HAVE_STATVFS)) */
gboolean mdh_sys_get_disk(const gchar *fs,
                          guint64 *total,
                          guint64 *free,
                          guint64 *avail,
                          GError **err)
{
    g_set_error(err, 0, 0, "mdh_sys_get_disk() is unsupported on this OS.");
    return(FALSE);
}
#endif /* (defined(HAVE_STATFS) || defined(HAVE_STATVFS)) */
