/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "threads.h"

static gboolean init;

void mdh_threads_init(void)
{
    if(init)
        return;

#if (defined(G_THREADS_ENABLED) && defined(ENABLE_THREADS))
    if(!g_thread_supported())
        g_thread_init(NULL);

    gdk_threads_init();
#endif

    init = TRUE;
}

void mdh_threads_enter(void)
{
    g_return_if_fail(init != FALSE);

#if (defined(G_THREADS_ENABLED) && defined(ENABLE_THREADS))
    gdk_threads_enter();
#endif
}

void mdh_threads_leave(void)
{
    g_return_if_fail(init != FALSE);

#if (defined(G_THREADS_ENABLED) && defined(ENABLE_THREADS))
    gdk_flush();
    gdk_threads_leave();
#endif
}

GThread *mdh_thread_create(GFunc func, gpointer data)
{
    GThread *thread = NULL;

    g_return_val_if_fail(init != FALSE, NULL);
    g_return_val_if_fail(func != NULL, NULL);

#if (defined(G_THREADS_ENABLED) && defined(ENABLE_THREADS))
    thread = g_thread_create((GThreadFunc) func, data, FALSE, NULL);
#else
    func(data, NULL);
#endif

    return(thread);
}
