/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __toolbar_h
#define __toolbar_h

G_BEGIN_DECLS

typedef enum {
    MDH_WINDOW_LAYER_NORMAL,
    MDH_WINDOW_LAYER_BELOW,
    MDH_WINDOW_LAYER_ABOVE
} MdhWindowLayer;

typedef struct {
    GtkWidget   *window,
                *hbox;

    GtkWidget   *menu;

    GtkTooltips *tips;
} MdhToolbarWidgets;

typedef struct {
    gint               geom_x,
                       geom_y;

    MdhWindowLayer     layer;

    gboolean           sticky;

    gboolean           tooltips;

    gchar             *font;

    GtkReliefStyle     button_relief;

    GtkShadowType      panel_shadow;

    gboolean           hidden;

    GSList            *buttons,
                      *custom,
                      *panels;

    MdhToolbarWidgets  widgets;
} MdhToolbar;

MdhToolbar *mdh_toolbar_new(gboolean type_dock);
void mdh_toolbar_free(MdhToolbar *toolbar);

void mdh_toolbar_show(MdhToolbar *toolbar);

void mdh_toolbar_menu_destroy(MdhToolbar *toolbar);
gboolean mdh_toolbar_menu_show(MdhToolbar *toolbar);

void mdh_toolbar_set_layer(MdhToolbar *toolbar, MdhWindowLayer layer);
void mdh_toolbar_set_sticky(MdhToolbar *toolbar, gboolean sticky);

void mdh_toolbar_move(MdhToolbar *toolbar, gint x, gint y);

gboolean mdh_toolbar_hidden(MdhToolbar *toolbar);

void mdh_toolbar_toggle(MdhToolbar *toolbar);
void mdh_toolbar_reset(MdhToolbar *toolbar);
void mdh_toolbar_reset_custom(MdhToolbar *toolbar);

void mdh_toolbar_button_add(MdhToolbar *toolbar, gpointer data);
void mdh_toolbar_custom_add(MdhToolbar *toolbar, gpointer data);
void mdh_toolbar_panel_add(MdhToolbar *toolbar, gpointer data);

#define MDH_TOOLBAR(t) ((MdhToolbar *) t)

MdhToolbar *Toolbar;

G_END_DECLS

#endif /* __toolbar_h */
