/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "ui_scratch_pad.h"

#include "scratch_pad.h"
#include "widget.h"
#include "window.h"

static gint pad_width;
static gint pad_height;
static gint pad_x;
static gint pad_y;

#define _MDH_MAX_PAD 4

static GtkWidget *pad_notebook;
static GtkWidget *pad_text[_MDH_MAX_PAD + 1];

static void ui_scratch_pad_clear(GtkWidget *widget,
                                 GtkWidget *notebook)
{
    GtkTextBuffer *buffer;

    gint tab;

    tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));

    buffer = mdh_scratch_pad_get_buffer(tab);

    gtk_text_buffer_set_text(buffer, "", 0);

    gtk_text_view_set_buffer(GTK_TEXT_VIEW(pad_text[tab]), buffer);
}

static void ui_scratch_pad_clear_all(void)
{
    gint i;

    for(i = 0; i <= _MDH_MAX_PAD; i++) {
        GtkTextBuffer *buffer = mdh_scratch_pad_get_buffer(i);
        gtk_text_buffer_set_text(buffer, "", 0);
        gtk_text_view_set_buffer(GTK_TEXT_VIEW(pad_text[i]), buffer);
    }
}

static void ui_scratch_pad_close(void)
{
    gint tab;

    mdh_window_item_open_set(&wi_scratch_pad, FALSE);

    tab = gtk_notebook_get_current_page(GTK_NOTEBOOK(pad_notebook));

    mdh_scratch_pad_set_tab(tab);
    mdh_scratch_pad_set_geometry(pad_x, pad_y, pad_width, pad_height);
}

static GtkFunction ui_scratch_pad_configure(GtkWidget *widget,
                                            GdkEventConfigure *event)
{
    pad_width  = event->width;
    pad_height = event->height;

    pad_x      = event->x;
    pad_y      = event->y;

    return((GtkFunction) FALSE);
}

void mdh_ui_scratch_pad(void)
{
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *vbox2;
    GtkWidget *hbox;
    GtkWidget *table;
    GtkWidget *button;
    GtkWidget *label;

    gint i;

    if(mdh_window_item_open(&wi_scratch_pad))
        return;

    mdh_window_item_open_set(&wi_scratch_pad, TRUE);

    if(!mdh_scratch_pad_get_geometry(&pad_x, &pad_y, &pad_width, &pad_height)) {
        pad_width = pad_height = 300;
        pad_x     = pad_y      = -1;
    }

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "MailDooHicky: Scratch-Pad");
    gtk_widget_set_size_request(GTK_WIDGET(window), 300, 300);
    gtk_window_set_default_size(GTK_WINDOW(window), pad_width, pad_height);

    if(pad_x != -1 && pad_y != -1)
        gtk_window_move(GTK_WINDOW(window), pad_x, pad_y);

    g_signal_connect(G_OBJECT(window), "destroy",
                     G_CALLBACK(ui_scratch_pad_close), NULL);

    g_signal_connect(G_OBJECT(window), "configure_event",
                     G_CALLBACK(ui_scratch_pad_configure), NULL);

    /* g_signal_connect(G_OBJECT(window), "event",
                        G_CALLBACK(mdh_window_event), NULL); */

    g_signal_connect(G_OBJECT(window), "expose_event",
                     G_CALLBACK(mdh_window_expose_event), NULL);

    gtk_container_set_border_width(GTK_CONTAINER(window), 5);

    vbox = gtk_vbox_new(FALSE, 5);
    gtk_widget_show(vbox);

    gtk_container_add(GTK_CONTAINER(window), vbox);

    pad_notebook = gtk_notebook_new();
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(pad_notebook), GTK_POS_TOP);
    gtk_notebook_set_scrollable(GTK_NOTEBOOK(pad_notebook), TRUE);
    gtk_widget_show(pad_notebook);

    gtk_box_pack_start(GTK_BOX(vbox), pad_notebook, TRUE, TRUE, 0);

    for(i = 0; i <= _MDH_MAX_PAD; i++) {
        GtkWidget *scrolled_window;

        vbox2 = gtk_vbox_new(FALSE, 0);
        gtk_widget_show(vbox2);

        scrolled_window = gtk_scrolled_window_new(NULL, NULL);
        gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
                                       GTK_POLICY_AUTOMATIC,
                                       GTK_POLICY_AUTOMATIC);
        gtk_widget_show(scrolled_window);

        table = gtk_table_new(2, 5, FALSE);
        gtk_box_pack_start(GTK_BOX(vbox2), table, TRUE, TRUE, 0);
        gtk_widget_show(table);

        pad_text[i] = gtk_text_view_new();
        gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(pad_text[i]), GTK_WRAP_CHAR);
        gtk_text_view_set_editable(GTK_TEXT_VIEW(pad_text[i]), TRUE);
        gtk_widget_show(pad_text[i]);

        gtk_container_add(GTK_CONTAINER(scrolled_window), pad_text[i]);

        gtk_table_attach(GTK_TABLE(table), scrolled_window, 0, 4, 0, 1,
                         GTK_EXPAND | GTK_SHRINK | GTK_FILL,
                         GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);

        /* insert data from a previous use */
        gtk_text_view_set_buffer(GTK_TEXT_VIEW(pad_text[i]),
                                 mdh_scratch_pad_get_buffer(i));

        button = mdh_button_new_from_stock(GTK_STOCK_CLEAR, "Clear");
        gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
        gtk_widget_show(button);

        g_signal_connect(G_OBJECT(button), "clicked",
                         G_CALLBACK(ui_scratch_pad_clear),
                         pad_notebook);

        gtk_table_attach(GTK_TABLE(table), button, 0, 2, 1, 2,
                         GTK_FILL, GTK_FILL, 0, 0);

        button = mdh_button_new_from_stock(GTK_STOCK_GO_BACK, "");
        gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
        gtk_widget_show(button);

        g_signal_connect_swapped(G_OBJECT(button), "clicked",
                                 G_CALLBACK(gtk_notebook_prev_page),
                                 pad_notebook);

        gtk_table_attach(GTK_TABLE(table), button, 2, 3, 1, 2,
                         GTK_FILL, GTK_FILL, 0, 0);

        button = mdh_button_new_from_stock(GTK_STOCK_GO_FORWARD, "");
        gtk_button_set_relief(GTK_BUTTON(button), GTK_RELIEF_NONE);
        gtk_widget_show(button);

        g_signal_connect_swapped(G_OBJECT(button), "clicked",
                                 G_CALLBACK(gtk_notebook_next_page),
                                 pad_notebook);

        gtk_table_attach(GTK_TABLE(table), button, 3, 4, 1, 2,
                         GTK_FILL, GTK_FILL, 0, 0);

        {
            gchar *p = g_strdup_printf("Pad %d", i + 1);
            label = gtk_label_new(p);
            g_free(p);
        }

        gtk_notebook_append_page(GTK_NOTEBOOK(pad_notebook), vbox2, label);
    }

    hbox = gtk_hbox_new(TRUE, 3);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 3);
    gtk_widget_show(hbox);

    button = mdh_button_new_from_stock(GTK_STOCK_CLEAR, "Clear All");
    gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
    gtk_widget_show(button);

    g_signal_connect(G_OBJECT(button), "clicked",
                     G_CALLBACK(ui_scratch_pad_clear_all), NULL);

    button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
    gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 0);
    gtk_widget_show(button);

    /* update scratch-pad buffer data and close the window */
    g_signal_connect_swapped(G_OBJECT(button), "clicked",
                             G_CALLBACK(gtk_widget_destroy), window);

    {
        gint tab;

        if(!mdh_scratch_pad_get_tab(&tab))
            tab = 0;

        /* set the last page used */
        gtk_notebook_set_current_page(GTK_NOTEBOOK(pad_notebook), tab);
        gtk_widget_grab_focus(GTK_WIDGET(pad_text[tab]));
    }

    gtk_widget_show(window);
}

