/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <gtk/gtk.h>

#include "mdh.h"

#include "config.h"
#include "util.h"

const gchar *mdh_basename(const gchar *name)
{
    const gchar *base;

    g_return_val_if_fail(name != NULL, NULL);

    if((base = strrchr(name, G_DIR_SEPARATOR)))
        return(base + 1);

    return(name);
}

gchar *mdh_expand_tilde(const gchar *str)
{
    if(!str || !str[0])
        return(g_strdup(""));

    if(strncmp(str, "~/", 2))
        return(g_strdup(str));

    return(g_build_filename(g_get_home_dir(), str + 2, NULL));
}

gboolean mdh_browser_open_uri(const gchar *uri, GError **err)
{
    const gchar *browser = NULL;

    gboolean ret;

    gchar *command;

    g_return_val_if_fail(uri != NULL, FALSE);

    mdh_config_get_string("general", "browser", &browser);

    if(!browser) {
        g_set_error(err, 0, 0, "Unable to locate a known browser.");
        return(FALSE);
    }

    command = g_strdup_printf("%s %s", browser, uri);

    ret = g_spawn_command_line_async(command, err);

    g_free(command);

    return(ret);
}

gboolean mdh_mkdir(const gchar *path, gint mode)
{
    g_return_val_if_fail(path != NULL, FALSE);

    if(!IS_DIR(path))
        if(mkdir(path, mode) == -1) {
            perror("mkdir");
            return(FALSE);
        }

    return(TRUE);
}

gboolean mdh_mkdir_path(const gchar *path, gint mode)
{
    gchar *c, *e;

    gboolean ret = TRUE;

    g_return_val_if_fail(path != NULL, FALSE);

    if(IS_DIR(path))
        return(TRUE);

    c = g_strdup(path);
    e = c;

    while((e = strchr(e + 1, G_DIR_SEPARATOR))) {
        *e = 0;

        if(!(ret = mdh_mkdir(c, mode)))
            break;

        *e = G_DIR_SEPARATOR;
    }

    if(ret)
        ret = mdh_mkdir(c, mode);

    g_free(c);

    return(ret);
}


const gchar *mdh_icon_path(const gchar *base)
{
    static gchar path[PATH_MAX];

    return(mdh_icon_path_r(base, path, sizeof(path)));
}

gchar *mdh_icon_path_r(const gchar *base, gchar *dest, gsize dest_size)
{
    g_return_val_if_fail(base != NULL, NULL);
    g_return_val_if_fail(dest != NULL, NULL);
    g_return_val_if_fail(dest_size > 0, NULL);

    g_snprintf(dest, dest_size, DATADIR"%cicons%c%s.png",
                                G_DIR_SEPARATOR, G_DIR_SEPARATOR, base);

    return(dest);
}
