/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __util_h
#define __util_h

G_BEGIN_DECLS

const gchar *mdh_basename(const gchar *name);

gchar *mdh_expand_tilde(const gchar *str);

gboolean mdh_browser_open_uri(const gchar *uri, GError **err);

gboolean mdh_mkdir(const gchar *path, gint mode);
gboolean mdh_mkdir_path(const gchar *path, gint mode);

const gchar *mdh_icon_path(const gchar *base);
gchar *mdh_icon_path_r(const gchar *base, gchar *dest, gsize dest_size);

#if   (defined(DEBUG) && defined(G_HAVE_ISO_VARARGS))
# define debug(...) \
             g_log(G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, \
                   __FILE__ ":" G_STRINGIFY (__LINE__) ": " __VA_ARGS__);
#elif (defined(DEBUG) && defined(G_HAVE_GNUC_VARARGS))
# define debug(format...) \
             g_log(G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, \
                   __FILE__ ":" G_STRINGIFY (__LINE__) ": " format);
#elif DEBUG
# define debug g_debug
#else
# define debug(...)
#endif

#ifndef PATH_MAX
# ifdef MAXPATHLEN
#  define PATH_MAX  MAXPATHLEN
# else
#  define PATH_MAX  1024
# endif
#endif

#ifndef LINE_MAX
#define LINE_MAX    2048
#endif

#define IS_FILE(s)  (g_file_test(s, G_FILE_TEST_IS_REGULAR))
#define IS_LINK(s)  (g_file_test(s, G_FILE_TEST_IS_SYMLINK))
#define IS_DIR(s)   (g_file_test(s, G_FILE_TEST_IS_DIR))
#define IS_EXEC(s)  (g_file_test(s, G_FILE_TEST_IS_EXECUTABLE))
#define IS_EXIST(s) (g_file_test(s, G_FILE_TEST_EXISTS))

#define BUG()       (g_critical("MailDooHicky BUG at %s.\n", _STRLOC))

G_END_DECLS

#endif /* __util_h */
