/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "widget.h"
#include "window.h"
#include "x11.h"

/* generic event handler which closes the window on Escape */
gboolean mdh_window_event(GtkWidget *widget, GdkEvent *event)
{
    g_return_val_if_fail(widget != NULL, FALSE);
    g_return_val_if_fail(event != NULL, FALSE);

    switch(event->type) {
        case GDK_KEY_PRESS:
            switch(event->key.keyval) {
                case GDK_Escape:
                    gtk_widget_destroy(widget);
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }

    return(FALSE);
}

/*
 * strips _NET_WM_STATE_ABOVE/BELOW from any windows created by the
 * main toolbar, should a window manager pass the attribute on. rare
 * but extremely annoying, especially for _BELOW.
 *
 * Pass:
 *   Fluxbox 0.9.x
 *   Sawfish 1.3.x
 *
 * Fail:
 *   Openbox 3.x (https://bugzilla.icculus.org/show_bug.cgi?id=2221)
 *
 * This seems to help a bit for Openbox, but something's still weird.
 */
gboolean mdh_window_expose_event(GtkWidget *widget, GdkEventExpose *event)
{
    g_return_val_if_fail(widget != NULL, FALSE);

    if(mdh_x11_has_netwm_layers()) {
        gtk_window_set_keep_above(GTK_WINDOW(widget), FALSE);
        gtk_window_set_keep_below(GTK_WINDOW(widget), FALSE);
    }

    return(FALSE);
}

void mdh_window_notice(const gchar *head, const gchar *body)
{
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *vbox2;
    GtkWidget *hbox;
    GtkWidget *image;
    GtkWidget *label;
    GtkWidget *button;

    g_return_if_fail(head != NULL);
    g_return_if_fail(body != NULL);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "MailDooHicky: Notice");
    gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
    gtk_widget_set_size_request(GTK_WIDGET(window), 425, -1);

    gtk_window_set_type_hint(GTK_WINDOW(window), GDK_WINDOW_TYPE_HINT_UTILITY);

    g_signal_connect(G_OBJECT(window), "event",
                     G_CALLBACK(mdh_window_event), NULL);

    gtk_container_set_border_width(GTK_CONTAINER(window), 5);

    vbox = gtk_vbox_new(FALSE, 5);
    gtk_widget_show(vbox);

    gtk_container_add(GTK_CONTAINER(window), vbox);

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show(hbox);

    image = gtk_image_new_from_stock(GTK_STOCK_DIALOG_WARNING,
        GTK_ICON_SIZE_DIALOG);
    gtk_box_pack_start(GTK_BOX(hbox), image, FALSE, FALSE, 0);
    gtk_widget_show(image);

    gtk_misc_set_alignment(GTK_MISC(image), 0.5, 0.0);
    gtk_misc_set_padding(GTK_MISC(image), 0, 5);

    vbox2 = gtk_vbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(hbox), vbox2, FALSE, FALSE, 0);
    gtk_widget_show(vbox2);

    gtk_container_set_border_width(GTK_CONTAINER(vbox2), 5);

    label = gtk_label_new(NULL);
    gtk_box_pack_start(GTK_BOX(vbox2), label, TRUE, FALSE, 5);
    gtk_widget_show(label);

    gtk_widget_set_size_request(GTK_WIDGET(label), 350, -1);
    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
    mdh_label_set_larger(GTK_LABEL(label), head);

    label = gtk_label_new(body);
    gtk_box_pack_start(GTK_BOX(vbox2), label, TRUE, FALSE, 0);
    gtk_widget_show(label);

    gtk_widget_set_size_request(GTK_WIDGET(label), 350, -1);
    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);

    button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    gtk_widget_show(button);

    mdh_widget_grab_default(button);

    g_signal_connect_swapped(G_OBJECT(button), "clicked",
                             G_CALLBACK(gtk_widget_destroy), window);

    gtk_widget_show(window);
}

void mdh_window_error(const gchar *head, const gchar *body)
{
    GtkWidget *window;
    GtkWidget *vbox;
    GtkWidget *vbox2;
    GtkWidget *hbox;
    GtkWidget *image;
    GtkWidget *label;
    GtkWidget *button;

    g_return_if_fail(head != NULL);
    g_return_if_fail(body != NULL);

    window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(window), "MailDooHicky: Error");
    gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
    gtk_widget_set_size_request(GTK_WIDGET(window), 425, -1);

    gtk_window_set_type_hint(GTK_WINDOW(window), GDK_WINDOW_TYPE_HINT_UTILITY);

    g_signal_connect(G_OBJECT(window), "event",
                     G_CALLBACK(mdh_window_event), NULL);

    gtk_container_set_border_width(GTK_CONTAINER(window), 5);

    vbox = gtk_vbox_new(FALSE, 5);
    gtk_widget_show(vbox);

    gtk_container_add(GTK_CONTAINER(window), vbox);

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show(hbox);

    image = gtk_image_new_from_stock(GTK_STOCK_DIALOG_ERROR,
        GTK_ICON_SIZE_DIALOG);
    gtk_box_pack_start(GTK_BOX(hbox), image, FALSE, FALSE, 0);
    gtk_widget_show(image);

    gtk_misc_set_alignment(GTK_MISC(image), 0.5, 0.0);
    gtk_misc_set_padding(GTK_MISC(image), 0, 5);

    vbox2 = gtk_vbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(hbox), vbox2, FALSE, FALSE, 0);
    gtk_widget_show(vbox2);

    gtk_container_set_border_width(GTK_CONTAINER(vbox2), 5);

    label = gtk_label_new(NULL);
    gtk_box_pack_start(GTK_BOX(vbox2), label, TRUE, FALSE, 5);
    gtk_widget_show(label);

    gtk_widget_set_size_request(GTK_WIDGET(label), 350, -1);
    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
    mdh_label_set_larger(GTK_LABEL(label), head);

    label = gtk_label_new(body);
    gtk_box_pack_start(GTK_BOX(vbox2), label, TRUE, FALSE, 0);
    gtk_widget_show(label);

    gtk_widget_set_size_request(GTK_WIDGET(label), 350, -1);
    gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);

    button = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    gtk_widget_show(button);

    mdh_widget_grab_default(button);

    g_signal_connect_swapped(G_OBJECT(button), "clicked",
                             G_CALLBACK(gtk_widget_destroy), window);

    gtk_widget_show(window);
}

#if 0
static void window_toggle_button_toggle(GtkWidget *widget, gboolean *data)
{
    if(data)
        *data = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));
}

gboolean mdh_window_yes_no_prompt(const gchar *text, gboolean *ask)
{
    GtkWidget *dialog,
              *hbox,
              *vbox,
              *image,
              *label,
              *button;

    g_return_val_if_fail(text != NULL, FALSE);

    dialog = gtk_dialog_new();
    gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);

    gtk_window_set_title(GTK_WINDOW(dialog), "MailDooHicky: Question");

    gtk_container_set_border_width(GTK_CONTAINER(dialog), 5);

    hbox = gtk_hbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),
                       hbox, FALSE, FALSE, 0);
    gtk_widget_show(hbox);

    image = gtk_image_new_from_stock(GTK_STOCK_DIALOG_QUESTION,
                                     GTK_ICON_SIZE_DIALOG);
    gtk_box_pack_start(GTK_BOX(hbox), image, FALSE, FALSE, 0);
    gtk_widget_show(image);

    gtk_misc_set_alignment(GTK_MISC(image), 0.5, 0.0);
    gtk_misc_set_padding(GTK_MISC(image), 0, 5);

    vbox = gtk_vbox_new(FALSE, 5);
    gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, FALSE, 0);
    gtk_widget_show(vbox);

    gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);

    label = gtk_label_new(text);
    gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, FALSE, 0);
    gtk_widget_show(label);

    if(ask) {
        button = gtk_check_button_new_with_label("Ask again");
        gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
                           button, FALSE, FALSE, 0);
        gtk_widget_show(button);

        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), *ask);

        g_signal_connect(G_OBJECT(button), "clicked",
                         G_CALLBACK(window_toggle_button_toggle), ask);
    }

    button = gtk_dialog_add_button(GTK_DIALOG(dialog),
                                   GTK_STOCK_NO,
                                   GTK_RESPONSE_NO);
    gtk_widget_show(button);

    gtk_widget_grab_default(button);

    button = gtk_dialog_add_button(GTK_DIALOG(dialog),
                                   GTK_STOCK_YES,
                                   GTK_RESPONSE_YES);
    gtk_widget_show(button);

    switch(gtk_dialog_run(GTK_DIALOG(dialog))) {
        case GTK_RESPONSE_YES:
            gtk_widget_destroy(dialog);
            return(TRUE);
        default:
            break;
    }

    gtk_widget_destroy(dialog);

    return(FALSE);
}
#endif

gboolean mdh_window_yes_no_prompt(const gchar *text)
{
    GtkWidget *dialog;

    dialog = gtk_message_dialog_new(NULL,
                                    GTK_DIALOG_MODAL,
                                    GTK_MESSAGE_QUESTION,
                                    GTK_BUTTONS_YES_NO,
                                    text);

    switch(gtk_dialog_run(GTK_DIALOG(dialog))) {
        case GTK_RESPONSE_YES:
            gtk_widget_destroy(dialog);
            return(TRUE);
        default:
            break;
    }

    gtk_widget_destroy(dialog);

    return(FALSE);
}

gboolean mdh_window_item_open(MdhWindowItem *item)
{
    g_return_val_if_fail(item != NULL, FALSE);

    return(item->open);
}

void mdh_window_item_open_set(MdhWindowItem *item, gboolean open)
{
    g_return_if_fail(item != NULL);

    item->open = open;

    if(item->menu_item && GTK_IS_WIDGET(item->menu_item))
        gtk_widget_set_sensitive(GTK_WIDGET(item->menu_item), !open);
}
