/*
 * mdh (MailDooHicky), a GTK+-based toolbar.
 *
 * Copyright (c) 2003-2005 by Mike Hokenson <mdh at gozer dot org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __x11_h
#define __x11_h

G_BEGIN_DECLS

gboolean mdh_x11_has_property(GdkWindow *window,
                              const gchar *prop,
                              const gchar *atom);

gboolean mdh_x11_wait_for_window_manager(void);

void mdh_x11_enable_netwm(gboolean enable);
void mdh_x11_enable_gnome(gboolean enable);

void mdh_x11_get_features(void);

gboolean mdh_x11_has_netwm(void);
gboolean mdh_x11_has_netwm_state_above(void);
gboolean mdh_x11_has_netwm_state_below(void);
gboolean mdh_x11_has_netwm_state_skip_taskbar(void);
gboolean mdh_x11_has_netwm_state_skip_pager(void);

#define mdh_x11_has_netwm_layers() \
    (mdh_x11_has_netwm_state_above() && mdh_x11_has_netwm_state_below())

gboolean mdh_x11_has_gnome(void);
gboolean mdh_x11_has_gnome_state_above(void);
gboolean mdh_x11_has_gnome_state_below(void);

void mdh_x11_set_gnome_layer_above(GtkWidget *window, gboolean above);
void mdh_x11_set_gnome_layer_below(GtkWidget *window, gboolean below);

#define mdh_x11_has_gnome_layers() \
    (mdh_x11_has_gnome_state_above() && mdh_x11_has_gnome_state_below())

G_END_DECLS

#endif /* __x11_h */
