/*
 MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

 $Id: common.h,v 1.17 2003/07/01 06:43:20 taku-ku Exp $;

 Copyright (C) 2001-2002  Taku Kudo <taku-ku@is.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later verjsion.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#ifndef _MECAB_COMMON_H
#define _MECAB_COMMON_H

// tricky macro for MSVC
#ifdef _MSC_VER
#define for if(0); else for
#endif

#define COPYRIGHT "Yet Another Part-of-Speech and Morphological Analyzer\n\
Copyright (C) 2001-2003 Taku Kudo, All rights reserved.\n"

#define  CONNECTION_FILE      "matrix.me"
#define  POS_FILE             "feature.me"
#define  DOUBLE_ARRAY_FILE    "da.me"
#define  TOKEN_FILE           "token.me"
#define  OTHERS_FILE          "info.me"

#define  TEXT_DIC_FILE        "dic.csv"
#define  TEXT_CONNECTION_FILE "connect.csv"

#define NBEST_MAX (512)

#define NODE_FREELIST_SIZE (2048)
#define PATH_FREELIST_SIZE (2048 * 8)

#define MIN_INPUT_BUFFER_SIZE  (8192)
#define MAX_INPUT_BUFFER_SIZE  (8192*64)

#ifndef EXIT_FAILURE
#define EXIT_FAILURE (1)
#endif

#ifndef EXIT_SUCCESS
#define EXIT_SUCCESS (0)
#endif

#ifndef INT32_MAX
#define INT32_MAX (2147483647)
#endif

#ifndef INT16_MAX
#define INT16_MAX (32767)
#endif

#include <string>
#include <stdexcept>
#include <cstdlib>
#include <algorithm>

namespace MeCab {

  using namespace std;

  template <class T> inline T _min (T x, T y) { return (x < y) ? x : y; }
  template <class T> inline T _max (T x, T y) { return (x > y) ? x : y; }

  static inline void itoa (int val, char *s)
  {
     char *t;
     int mod;
     if(val < 0) {
	*s++ = '-';
	val = -val;
     }
     t = s;
   
     while(val) {
	mod = val % 10;
	*t++ = (char)mod + '0';
	val /= 10;
     }

     if (s == t) *t++ = '0';
     *t = '\0';
     std::reverse (s, t);
     
     return;
  }
   
  static inline char *mystrdup (const char *str)
  {
     if (!str) throw std::runtime_error ("MeCab::mystrdup(): NULL str is given");
     unsigned int l = strlen (str);
     char *r = new char [l + 1];
     strncpy (r, str, l+1);
     return r;
  }
   
  static inline std::string createFileName (const std::string &path, const std::string &file)
  {
    std::string s = path;
#if defined (_WIN32) && !defined (__CYGWIN__)
    if (s.size () && s[s.size()-1] != '\\') s += '\\';
#else
    if (s.size () && s[s.size()-1] != '/') s += '/';
#endif      
    s += file;
    return s;
  }

  static inline void removeFileName (std::string &s)
  {
    int len = (int)s.size() - 1;
    bool ok = false;
    for (; len >= 0; --len) {
#if defined (_WIN32) && !defined (__CYGWIN__)      
      if (s[len] == '\\') { ok = true; break; }
#else
      if (s[len] == '/')  { ok = true; break; }
#endif      
    }
    if (ok) s = s.substr (0, len);
    else s = ".";
  }

  static inline void replaceString (std::string &s, const std::string &src, const std::string &dst)
  {
    unsigned int pos = s.find (src);
    if (pos != std::string::npos) s.replace (pos, src.size(), dst);
  }
}
#endif
