/*
 *  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 * 
 *  $Id: stringbuffer.cpp,v 1.2 2003/07/01 06:43:21 taku-ku Exp $;
 * 
 *  Copyright (C) 2001-2002  Taku Kudo <taku-ku@is.aist-nara.ac.jp>
 * 
 *  All rights reserved.
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later verjsion.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include "common.h"
#include "stringbuffer.h"
#include <cstring>
#include <cstdio>

#define DEFAULT_ALLOC_SIZE 8192

namespace MeCab {

  bool StringBuffer::reserve (unsigned int _l)
  {
    if (! flg) {
      error = (size + _l >= alloc_size);
      return (! error);
    } 

    if (size + _l >= alloc_size) {
      if (alloc_size == 0) {
	alloc_size = DEFAULT_ALLOC_SIZE;
	buf = new char [alloc_size];
      }
      unsigned int len = size + _l;
      do { alloc_size *= 2; } while (len > alloc_size);
      char *new_buf = new char [alloc_size];
      memcpy (new_buf, buf, size);
      delete [] buf;
      buf = new_buf;
    }
      
    return true;
  }

  StringBuffer::~StringBuffer () 
  { 
     if (flg) { delete [] buf; buf = 0; }
  }

  StringBuffer& StringBuffer::write (char _n)
  {
    if (reserve (1)) {
      buf[size] = _n;
      ++size;
    }
    return *this;
  }
   
  StringBuffer& StringBuffer::write (const char* _n)
  {
    return this->write (_n, strlen(_n));
  }
   
  StringBuffer& StringBuffer::write (const char* _n, unsigned int _l)
  {
    if (reserve (_l)) {
      memcpy (buf + size , _n, _l);
      size += _l;
    }
    return *this;	
  }

  StringBuffer& StringBuffer::write (int _n)
  {
    char fbuf[64];
    itoa (_n, fbuf);
    return this->write (fbuf);
  }
}
