/*
 *  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 * 
 *  $Id: stringbuffer.h,v 1.1 2003/07/03 16:09:27 taku-ku Exp $;
 * 
 *  Copyright (C) 2001-2002  Taku Kudo <taku-ku@is.aist-nara.ac.jp>
 * 
 *  All rights reserved.
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later verjsion.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */
#ifndef _MECAB_STRINGBUFFER_H
#define _MECAB_STRINGBUFFER_H

namespace MeCab {

  class StringBuffer 
  {
  private:
    unsigned int size;
    unsigned int alloc_size;
    char *buf;
    bool flg;
    bool error;
    bool reserve (unsigned int);

  public:
    StringBuffer (): size(0), alloc_size(0), buf(0), flg (true), error (false) {}
    StringBuffer (char *_s, unsigned int _l):
      size(0), alloc_size(_l), buf (_s), flg(false), error(false) {}
    virtual ~StringBuffer ();
    
    StringBuffer& write (char);
    StringBuffer& write (const char*, unsigned int);
    StringBuffer& write (const char*);
    StringBuffer& write (int);

    StringBuffer& operator<< (int _n)                { return this->write (_n); }
    StringBuffer& operator<< (short int _n)          { return this->write ((int)_n); }
    StringBuffer& operator<< (unsigned int _n)       { return this->write ((int)_n); }
    StringBuffer& operator<< (unsigned short int _n) { return this->write ((int)_n); }
    StringBuffer& operator<< (char _n)               { return this->write (_n); }
    StringBuffer& operator<< (const char* _n)        { return this->write (_n); }
   
    void clear () { size = 0; }
    char *str ()  { return error ?  0 : buf; };
  };
}

#endif
