/*
 *  MeCab -- Yet Another Part-of-Speech and Morphological Analyzer
 * 
 *  $Id: writer.h,v 1.1 2003/06/29 19:43:45 taku-ku Exp $;
 * 
 *  Copyright (C) 2001-2002  Taku Kudo <taku-ku@is.aist-nara.ac.jp>
 * 
 *  All rights reserved.
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later verjsion.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */
#include "mecab.h"
#include <string>

namespace MeCab {

  class StringBuffer;
  class Param;

  class Writer
  {
  private:
    char*        node_format;
    char*        bos_format;
    char*        eos_format;
    
    std::string _what;

    void writeNode         (StringBuffer&, const char*, const char*, Node*);
    void writeLattice      (StringBuffer&, const char*, Node*);
    void writeWakati       (StringBuffer&, const char*, Node*);
    void writeNone         (StringBuffer&, const char*, Node*);
    void writeUser         (StringBuffer&, const char*, Node*);
    void (Writer::*_write) (StringBuffer&, const char*, Node*);

  public:
    Writer (Param &);
    Writer ();
    virtual ~Writer();
    bool open (Param &);
    bool close ();
    void write (StringBuffer &, const char*, Node *);
  };
}

