C*************************************************************************
C COPYRIGHT (C) 1999 - 2003  EDF R&D
C THIS LIBRARY IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
C IT UNDER THE TERMS OF THE GNU LESSER GENERAL PUBLIC LICENSE 
C AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
C EITHER VERSION 2.1 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
C
C THIS LIBRARY IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
C WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
C MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
C LESSER GENERAL PUBLIC LICENSE FOR MORE DETAILS.
C
C YOU SHOULD HAVE RECEIVED A COPY OF THE GNU LESSER GENERAL PUBLIC LICENSE
C ALONG WITH THIS LIBRARY; IF NOT, WRITE TO THE FREE SOFTWARE FOUNDATION,
C INC., 59 TEMPLE PLACE, SUITE 330, BOSTON, MA 02111-1307 USA
C
C**************************************************************************


C ******************************************************************************
C * - Nom du fichier : test29.f
C *
C * - Description : ecriture d'un joint dans un maillage MED 
C *
C ******************************************************************************
	program test29
C     
	implicit none
	include 'med.hf'
C
C
        integer cret,fid, domdst
        character*32 maa , jnt, maadst, nodenn,nodent
        character*200 des, dcornn, dcornt
        integer mdim ,ncor
        integer cor(6)

        parameter (maa ="maa1",maadst="maa1", domdst=2,
     &     mdim = 3,ncor = 3 )
        data cor /1,2,3,4,5,6/, jnt / "joint"/
        data des / "joint avec le sous-domaine 2" /



C  ** Creation du fichier test29.med **
	call efouvr(fid,'test29.med',MED_CREATION, cret)
	print *,cret
	if (cret .ne. 0 ) then
	   print *,'Erreur creation du fichier'
	   call efexit(-1)
	endif      

  
C  ** Creation du maillage **
	call efmaac(fid,maa,mdim,MED_NON_STRUCTURE,
     &                 'Un maillage pour test29',cret)
	print *,cret  
	if (cret .ne. 0 ) then
	   print *,'Erreur creation du maillage'
	   call efexit(-1)
	endif      
  
C ** Creation du joint **
	call efjntc(fid,maa,jnt,des,domdst,maadst,cret)
	print *,cret  
	if (cret .ne. 0 ) then
	   print *,'Erreur creation joint'
	   call efexit(-1)
	endif      
        

C ** Ecriture de la correspondance Noeud, Noeud **
	call efjnte(fid,maa,jnt,cor,ncor,
     &    MED_NOEUD,0,MED_NOEUD,0,
     &    cret)
	print *,cret  
	if (cret .ne. 0 ) then
	   print *,'Erreur ecriture correspondance (Noeud,Noeud)'
	   call efexit(-1)
	endif      


C ** Ecriture de la correspondance Noeud, TRIA3 **
	call efjnte(fid,maa,jnt,cor,ncor,
     &    MED_NOEUD,0,MED_MAILLE,MED_TRIA3,
     &    cret)
	print *,cret  
	if (cret .ne. 0 ) then
	   print *,'Erreur ecriture correspondance (Noeud,Tria3)'
	   call efexit(-1)
	endif      
        
C ** Fermeture du fichier                                **
 	call efferm (fid,cret)
	print *,cret
	if (cret .ne. 0 ) then
	   print *,'Erreur fermeture du fichier'
	   call efexit(-1)
	endif      
C     
	end
