// Persistence of Vision Ray Tracer Scene Description File
// File: tutorial06.pov
// Desc: mechanics simulation tutorial scene 6
// Date: October 2002
// Auth: Christoph Hormann
// Requirements: IsoCSG library: http://www.tu-bs.de/~y0013390/pov/ic/
//
//
// Render instructions:
// --------------------
//
// first render as still to generate simulation data:
//
// -w320 -h240
//
// then render as animation:
//
// -w320 -h240 +a0.3 -j +kff50

#version unofficial megapov 1.0;

#include "mechsim.inc"
#include "iso_csg.inc"

#declare fn_Env=
IC_Merge2(
  IC_Plane(z, 0),
  IC_Box(<-1.5, -0.6, -1.0>, <1.5, 0.6, 0.5>)
)

#declare Trans1 =
  transform {
    translate <-0.5, -6*0.4, 1.0>
  }

global_settings {
  assumed_gamma 1.0

  mechsim {
    gravity <0, 0, -9.81>
    method 1

    environment {
      function { fn_Env(x, y, z) }
      stiffness 90000
      damping 10000
      friction 0.1, 1.001
      method 1
    }

    #if (clock_on)
      step_count 800
      time_step (1/30)/800

      topology {
        load_file "tut06.dat"
        save_file "tut06.dat"
      }
    #else
      step_count 0

      topology {
        MechSim_Generate_Grid_Std(<0, 0, 0>, 0.07, 25000, 22000, 2000, true, <0.4,0.4,0.4>, <3, 12, 3>, Trans1, 3)
        save_file "tut06.dat"
      }
    #end
  }
}

// ----------------------------------------

camera {
  location  <-6.0, -16.0, 3.0>*0.5
  up z
  sky z
  look_at   <0.0, 0.0, 0.4>
  angle 30
}

light_source {
  <2000, -3000, 2700>
  color rgb <1.7, 1.5, 1.2>
}

sky_sphere {
  pigment {
    gradient z
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.2 rgb <0.2,0.3,0.9>]
    }
  }
}

// ----------------------------------------

#declare T_Env=
  texture {
    pigment { color rgb 1.5 }
    finish { ambient 0.05 diffuse 0.6 }
  }


union {
  plane { z, 0 }

  box { <-1.5, -0.6, -1.0>, <1.5, 0.6, 0.5> }

  texture { T_Env }
}

// ----------------------------------------

MechSim_Show_All_Objects(-1, true, -1, "")

