//Reading sources of POV-Ray 3.5a I found that torus object has 
//defined method for UV Mapping. But it was not mentioned in 
//documentation so I checked how it worked. Wrong! I have investigated 
//sources and found that there are two bugs. First: UV mapping is 
//calculated for coordinates in scene space instead of object space. 
//Second: author assumed that torus is located on x-y plane while it 
//is located on x-z plane. Therefore I made necessary changes. 

#version unofficial MegaPOV 1.0;

#declare minor=1/3;
#declare major=minor*3;

torus{
  major minor
  uv_mapping
  pigment{checker rgb 0 rgb 1 scale .1}
  rotate x*90
  rotate y*45
  translate 3*z*major
}

light_source{-9-9*z 1}
background{1}
camera{up y right x}