/****************************************************************************
*                   POLYSOLV.h
*
*  This module contains all defines, typedefs, and prototypes for MATH.CPP.
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996-2002 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available it may be found online at -
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*##############################################################################
*  This file is part of MegaPOV, which is a modified and unofficial version of POV-Ray
*
* $RCSfile: polysolv.h,v $
* $Revision: 1.4 $
* $Author: smellenbergh $
* $Log: polysolv.h,v $
* Revision 1.4  2002/12/07 16:48:34  smellenbergh
* Adds listed pattern, displacement warp
* Header CVS keywords fix
*
* Revision 1.3  2002/11/27 15:01:27  abx
* built-in tokens available in function parser, cached polynomial solver in SDL and in function VM
*
* Revision 1.2  2002/11/14 12:15:56  abx
* PoPOV 0.3 core + windows
*
*
*****************************************************************************/


#ifndef POLYSOLV_H
#define POLYSOLV_H



/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#define MAX_ORDER 15

#ifdef POLYNOMIAL_SOLVER_PATCH
  #define USE_NEW_DIFFICULT_COEFFS
  #define TEST_SOLVER
  #define POLYNOMIAL_PARAMS 2       /* sturm, epsilon */
  #define MIN_POLYNOMIAL_COEFFS 2   /* linear equation */
  #define MIN_POLYNOMIAL_PARAMS (MIN_POLYNOMIAL_COEFFS + POLYNOMIAL_PARAMS)
  #define MAX_POLYNOMIAL_COEFFS (MAX_ORDER + 1)
  #define MAX_POLYNOMIAL_PARAMS (MAX_POLYNOMIAL_COEFFS + POLYNOMIAL_PARAMS)
#endif

/*****************************************************************************
* Global typedefs
******************************************************************************/




/*****************************************************************************
* Global variables
******************************************************************************/

#ifdef POLYNOMIAL_SOLVER_PATCH
  extern DBL cached_polynomial_roots[MAX_ORDER];
#endif


/*****************************************************************************
* Global functions
******************************************************************************/

int Solve_Polynomial (int n, DBL *c, DBL *r, int sturm, DBL epsilon);

#ifdef POLYNOMIAL_SOLVER_PATCH
  int buffered_polynomial_solver(int n, DBL *params);
#endif


#endif
