/****************************************************************************
*                   truetype.h
*
*  This module contains all defines, typedefs, and prototypes for TRUETYPE.CPP.
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996-2002 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available it may be found online at -
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*##############################################################################
*  This file is part of MegaPOV, which is a modified and unofficial version of POV-Ray
*
* $RCSfile: truetype.h,v $
* $Revision: 1.4 $
* $Author: smellenbergh $
* $Log: truetype.h,v $
* Revision 1.4  2002/12/07 16:48:35  smellenbergh
* Adds listed pattern, displacement warp
* Header CVS keywords fix
*
* Revision 1.3  2002/11/17 18:14:27  smellenbergh
* Added GLOW_PATCH, TIME_DATE_PATCH, TIME_MEASUREMENT_PATCH AND FONT_ALIGNMENT_PATCH.
* Created the folder Patches, all new files should be put in here.
*
* Revision 1.2  2002/11/14 12:15:57  abx
* PoPOV 0.3 core + windows
*
*
*****************************************************************************/


#ifndef TRUETYPE_H
#define TRUETYPE_H



/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#define TTF_OBJECT (BASIC_OBJECT)

#ifdef FONT_ALIGNMENT_PATCH
	#define H_ALIGN_LEFT   0
	#define H_ALIGN_CENTER 1
	#define H_ALIGN_RRIGHT 2

	#define V_ALIGN_TOP   3
	#define V_ALIGN_CENTER 4
	#define V_ALIGN_BOTTOM 5
	#define V_ALIGN_NONE	 6
#endif	

/*****************************************************************************
* Global typedefs
******************************************************************************/

typedef struct TrueTypeFont_Struct TTF;

struct TrueTypeFont_Struct
{
  OBJECT_FIELDS
  void *glyph;      /* (GlyphPtr) Pointer to the glyph */
  DBL depth;        /* Amount of extrusion */
};



/*****************************************************************************
* Global variables
******************************************************************************/

extern METHODS TTF_Methods;



/*****************************************************************************
* Global functions
******************************************************************************/

#ifdef FONT_ALIGNMENT_PATCH
  void ProcessNewTTF(OBJECT *object, char *filename, UCS2 *text_string,DBL depth,VECTOR offset,int h_position, int v_position);
#else
  void ProcessNewTTF (OBJECT *object, char *filename, UCS2 *text_string, DBL depth, VECTOR offset);
#endif
void Compute_TTF_BBox (TTF *Ttf);
void FreeFontInfo (void);


#endif
