/*****************************************************************************
*               config.h
*
*  This header file contains all constants and types required to run on a
*  UNIX system.
*
*  from Persistence of Vision Raytracer
*  Copyright 1995,1999 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available or for more info please contact the POV-Ray
*  Team Coordinator by email to team-coord@povray.org or visit us on the web at
*  http://www.povray.org. The latest version of POV-Ray may be found at this site.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
* Modifications by Mike Fleetwood, February 1999
*
*****************************************************************************/

/*
 * Note: this is not the typical automatically generated by a configure script.
 * POV-Ray has been using a configure.h file since long before it was using
 * automake.  If you're looking for the automatically generated header file,
 * try conf.h
 */

#ifndef BEENHERE

/*
 * Below are several defines needed by the Unix parts of POV.  You
 * may redefine them as needed in this config.h file. Each has a default
 * which will be defined in frame.h if you don't define it here.
 */

#include "conf.h"
#include <algorithm>
using std::max;
using std::min;

//---------------------------------MegaPOV Switches

#ifndef VERSIONBUILDERS_MESSAGE
   #define VERSIONBUILDERS_MESSAGE "Christoph Hormann <chris_hormann@gmx.de>"
#endif

//---------------------------------End MegaPOV Switches

/*
 * This should use the standard C header files, if they exist, or just
 * our own prototypes if they don't.  Modify to suit your needs.
 */

#ifdef __STDC__
#define PARAMS(x) x
#  ifndef CONST
#  define CONST const
#  endif
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#else
#define PARAMS(x) ()
#  ifndef volatile
#  define volatile
#  endif
int unlink(char *);
char *getenv(char *);
void *malloc(size_t);
void free(void *);
double fmod(double, double);
double atof(char *);
#endif

/* Who we are */
#ifndef UNIX
#define UNIX
#endif

#define POVRAY_PLATFORM_NAME "Unix"

#define DONT_USE_POVMS

#define POV_CPP_MEM_HAS_NEW_INCLUDE       0
#define POV_CPP_MEM_HAS_PLACEMENT_FORMS   0
#define POV_CPP_MEM_HAS_NOTHROW_SUPPORT   0

#include <stdio.h>

#undef printf

/*
 * Try to use system specified values for the maximum filename length, or
 * at least some Unix sized ones, rather than DOS sized ones.
 */
#if defined (PATH_MAX)
#  define POV_NAME_MAX PATH_MAX
#  define FILE_NAME_MAX PATH_MAX
#elif defined (_POSIX_PATH_MAX)
#  define POV_NAME_MAX _POSIX_PATH_MAX
#  define FILE_NAME_MAX _POSIX_PATH_MAX
#else
#  define POV_NAME_MAX 200
#  define FILE_NAME_MAX 250
#endif

/*
 * Define the default location of the POV-Ray library
 */

#ifndef POV_LIB_DIR
#define POV_LIB_DIR    "/usr/local/lib/povray35"
#endif

/*
 *  NULL was causing g++ to whine, and 0 fixed the problem.  The solution below
 *  is recommended by Stroustrop in _The C++ Programming Language, 3rd Ed_ p. 88
 */

#ifndef NULL
const int NULL 0
#endif

#ifndef READ_TXTFILE_STRING
#define READ_TXTFILE_STRING "r"
#endif

/**********************************************************/
/*
 * Search for and process a default POV-Ray INI file.  The first file
 * from the list below is used:
 *     $POVINI                          Environment over-ride defaults file
 *     ./povray.ini                     Per-directory defaults file
 *     $HOME/.povrayrc                  User defaults file
 *     POV_LIB_DIR/povray.ini           System wide fall-back defaults file
 */
#ifndef READ_ENV_VAR
#define READ_ENV_VAR           UNIX_Process_Env();
#endif

#ifndef PROCESS_POVRAY_INI
#define PROCESS_POVRAY_INI     UNIX_Process_Povray_Ini();
#endif

void UNIX_Process_Env          PARAMS((void));
void UNIX_Process_Povray_Ini   PARAMS((void));

#ifndef TIME_ELAPSED
#define TIME_ELAPSED (tstop - tstart);
#endif

/*
 * This is the image file format that POV will choose by default if none is
 * specified on the command-line.  Although the default value is already 't'
 * for TGA format files, many Unix sites may want to change this to 'p' to
 * get ppm format files, which more Unix utilities understand.
 */
#ifndef DEFAULT_OUTPUT_FORMAT
#define DEFAULT_OUTPUT_FORMAT  't'
#endif

/*
 * What level of memory statistics we want.  See mem.h for more info.
 */
#ifndef MEM_STATS
#define MEM_STATS 1
#endif

/*
 * The UNIX precision timer uses gettimeofday().  If this is unavailable,
 * define PRECISION_TIMER_AVAILABLE to 0, which means you won't be able
 * to generate histogram output files.
 */

#ifndef PRECISION_TIMER_AVAILABLE
#define PRECISION_TIMER_AVAILABLE 1
#endif

#if PRECISION_TIMER_AVAILABLE

#ifndef PRECISION_TIMER_INIT
#define PRECISION_TIMER_INIT
#endif

#ifndef PRECISION_TIMER_START
#define PRECISION_TIMER_START UNIX_Timer_Start();
#endif

#ifndef PRECISION_TIMER_STOP
#define PRECISION_TIMER_STOP  UNIX_Timer_Stop();
#endif

#ifndef PRECISION_TIMER_COUNT
#define PRECISION_TIMER_COUNT UNIX_Timer_Count();
#endif

void UNIX_Timer_Start PARAMS((void));
void UNIX_Timer_Stop  PARAMS((void));
int  UNIX_Timer_Count PARAMS((void));

#endif /* PRECISION_TIMER_AVAILABLE */

/*
 * Some systems don't have setvbuf.  If not, just define it away - it's
 * not critical to the raytracer.  It just sets up the disk buffers.
 * #define setvbuf(w,x,y,z)
 */

/*
 * This sets up the signal handler during a rendering so that if CTRL-C is
 * pressed, the normal user abort function is called.  If your system
 * doesn't support signal(), you can try to modify these functions to use
 * an available signal function, or just comment these out, although
 * in this case you will lose anything in the output buffer if the trace
 * is interrupted with CTRL-C.
 */
#ifndef POV_PRE_RENDER
#define POV_PRE_RENDER   UNIX_Abort_Start();
#endif

#ifndef POV_PRE_SHUTDOWN
#define POV_PRE_SHUTDOWN UNIX_Abort_Handler(0);
#endif

#define POV_ALLOW_FILE_WRITE(f,t) UNIX_Allow_File_Write (f, t)
#define POV_ALLOW_FILE_READ(f,t) UNIX_Allow_File_Read (f, t)
#define POV_SYSTEM(s) UNIX_System(s)

void UNIX_Abort_Start PARAMS((void));
void UNIX_Abort_Handler PARAMS((int signum));

#define MAIN_RETURN_TYPE       int
#define MAIN_RETURN_STATEMENT  return 0;

#ifndef UNIX
#define UNIX UNIX
#endif

static uid_t euid;

/*
 * These handle the parsing of the usual X Windows command-line args.
 */

void UNIX_init_povray PARAMS((int *argc, char **argv[]));
extern void (*UNIX_finish_povray) PARAMS((void));

#ifndef STARTUP_POVRAY
#define STARTUP_POVRAY    UNIX_init_povray(&argc, &argv);
#endif

#ifndef FINISH_POVRAY
#define FINISH_POVRAY  UNIX_finish_povray();
#endif

/*
 * These are the display routines.
 */

#ifndef POV_DISPLAY_INIT
#define POV_DISPLAY_INIT(ref,w,h) UNIX_display_init((w),(h))
#endif

#ifndef POV_DISPLAY_PLOT
#define POV_DISPLAY_PLOT(ref,x,y,r,g,b,a) UNIX_display_plot((x),(y),(r),(g),(b),(a))
#endif

#ifndef POV_DISPLAY_PLOT_RECT
#define POV_DISPLAY_PLOT_RECT(ref,x1,y1,x2,y2,r,g,b,a) UNIX_display_plot_rect((x1),(y1),(x2),(y2),(r),(g),(b),(a))
#endif

#ifndef POV_DISPLAY_PLOT_BOX
#define POV_DISPLAY_PLOT_BOX(ref,x1,y1,x2,y2,r,g,b,a) UNIX_display_plot_box((x1),(y1),(x2),(y2),(r),(g),(b),(a))
#endif

#ifndef POV_DISPLAY_FINISHED
#define POV_DISPLAY_FINISHED(ref)  UNIX_display_finished();
#endif

#ifndef POV_DISPLAY_CLOSE
#define POV_DISPLAY_CLOSE(ref) UNIX_display_close();
#endif

extern int (*UNIX_display_init) PARAMS((int w, int h));
extern void (*UNIX_display_plot) PARAMS((int x, int y,
                               unsigned int Red, unsigned int Green,
                               unsigned int Blue, unsigned int Alpha));
extern void (*UNIX_display_plot_rect) PARAMS((int x1, int y1, int x2, int y2,
                                    unsigned int Red, unsigned int Green,
                                    unsigned int Blue, unsigned int Alpha));
extern void (*UNIX_display_plot_box) PARAMS((int x1, int y1, int x2, int y2,
                                    unsigned int Red, unsigned int Green,
                                    unsigned int Blue, unsigned int Alpha));
extern void (*UNIX_display_finished) PARAMS((void));
extern void (*UNIX_display_close) PARAMS((void));

/*
 * This is the render abort function.  It is not needed for the command-line interface,
 * since the abort is handled via interrupts.
 */
#ifndef TEST_ABORT
#define TEST_ABORT Stop_Flag += UNIX_Test_Abort();
#endif

extern int (*UNIX_Test_Abort) PARAMS((void));

void     POV_Std_Finish_Povray PARAMS((void));
int      POV_Std_Test_Abort PARAMS((void));
int      UNIX_Allow_File_Write PARAMS((const char *Filename, const unsigned int FileType));
int      UNIX_Allow_File_Read PARAMS((const char *Filename, const unsigned int FileType));
int      UNIX_System PARAMS((const char *string));

#ifndef X_DISPLAY_MISSING
void     XWIN_init_povray PARAMS((int *argc, char **argv[]));
void     XWIN_finish_povray PARAMS((void));
int      XWIN_display_init PARAMS((int w, int h));
void     XWIN_display_plot PARAMS((int x, int y,
					  unsigned int Red, unsigned int Green,
					  unsigned int Blue, unsigned int Alpha));
void     XWIN_display_plot_rect PARAMS((int x1, int y1, int x2, int y2,
					       unsigned int Red, unsigned int Green,
					       unsigned int Blue, unsigned int Alpha));
void     XWIN_display_plot_box PARAMS((int x1, int y1, int x2, int y2,
					      unsigned int Red, unsigned int Green,
					      unsigned int Blue, unsigned int Alpha));
void     XWIN_display_finished PARAMS((void));
void     XWIN_display_close PARAMS((void));
int      XWIN_Test_Abort PARAMS((void));
#endif

#ifdef HAVE_LIBVGA
void     SVGA_init_povray PARAMS((void));
void     SVGA_finish_povray PARAMS((void));
int      SVGA_display_init PARAMS((int w, int h));
void     SVGA_display_plot PARAMS((int x, int y,
					  unsigned int Red, unsigned int Green,
					  unsigned int Blue, unsigned int Alpha));
void     SVGA_display_plot_rect PARAMS((int x1, int y1, int x2, int y2,
					       unsigned int Red, unsigned int Green,
					       unsigned int Blue, unsigned int Alpha));
void     SVGA_display_plot_box PARAMS((int x1, int y1, int x2, int y2,
					      unsigned int Red, unsigned int Green,
					      unsigned int Blue, unsigned int Alpha));
void     SVGA_display_finished PARAMS((void));
void     SVGA_display_close PARAMS((void));
int      SVGA_Test_Abort PARAMS((void));
#endif

#endif /* BEENHERE */
#define BEENHERE
