// Persistence Of Vision Ray Tracer Scene Description File
// File: bar.pov
// Desciption: mechanics simulation sample scene
//             This scene demonstrates the use of moving environments.
// Requirements: IsoCSG library: http://www.tu-bs.de/~y0013390/pov/ic/
// Date: August 2002
//
//
// Render instructions:
// --------------------
//
// First render as still with:
//
// -w320 -h240
//
// Then as animation with:
//
// -w320 -h240 +a0.3 -j +kff70

#version unofficial megapov 1.0;

#include "mechsim.inc"
#include "iso_csg.inc"


#if (clock_on)
  #declare FCnt=final_frame;
#else
  #declare FCnt=10000;
#end

#if (clock_on)
  #if (clock<0.14)
    #declare Clock=0;
  #else
    #if (clock>0.65)
      #declare Clock=1;
    #else
      #declare Clock=(clock-0.14)/(0.65-0.14);
    #end
  #end
#else
  #declare Clock=0;
#end

#declare fn_Move=
  IC_Round_Box ( <-3, -1.2, -1>, <-5,  1.2, 3.2>, 0.2 )

#declare fn_NonMove=
  IC_Merge3 (
    IC_Plane(z, 0),
    IC_Round_Box ( <0, -1.2, -1>, <-5, -2.2, 1.8>, 0.2 ),
    IC_Round_Box ( <0,  1.2, -1>, <-5,  2.2, 1.8>, 0.2 )
  )

#declare fn_Env=
  function(x, y, z, tim) {
    min(
      fn_Move(x-(Clock+(tim/FCnt))*3, y, z),
      fn_NonMove(x, y, z)
    )
  }

#declare Trans1 =
  transform {
    translate 2.5*z
    translate -7*0.45*y
    translate -1.6*x
  }

global_settings {
  max_trace_level 10
  assumed_gamma 1

  mechsim {
    gravity <0, 0, -9.81>

    environment {
      function(x, y, z, tim) { fn_Env(x, y, z, tim) }
      stiffness 280000
      damping 50000
      friction 0.1
    }

    collision { off }

    #if (clock_on)
      step_count 300
      time_step (1/30)/300

      topology {
	load_file "bar1.dat"
	save_file "bar1.dat"
      }
    #else
      step_count 0
      topology {
	MechSim_Generate_Grid_Std(<0, 0, 0>, 0.05, 16000, 24000, 4000, true, <0.45, 0.45, 0.45>, <3, 15, 3>, Trans1, 3)
	save_file "bar1.dat"
      }
    #end

  }
}

MechSim_Show_All_Objects(-1, true, false, "")

#include "shapes.inc"

camera {
  location    <10, -9, 5.5>
  direction   y
  sky         z
  up          z
  right       (4/3)*x
  look_at     <-1, 0, 1.3>
  angle       36
}

light_source {
  <3.2, -0.3, 1.8>*100000
  color rgb <1.6, 1.5, 1.0>
}

sky_sphere {
  pigment {
    gradient z
    color_map {
      [0.00 rgb <0.8,0.9,1.0>]
      [0.10 rgb <0.6,0.7,1.0>]
      [0.25 rgb <0.2,0.3,0.8>]
    }
  }
}

union {
  plane { z, 0 }

  Round_Box ( <0, -1.2, -1>, <-5, -2.2, 1.8>, 0.2, false )
  Round_Box ( <0,  1.2, -1>, <-5,  2.2, 1.8>, 0.2, false )

  object {
    Round_Box ( <-3, -1.2, -1>, <-5,  1.2, 3.2>, 0.2, false )
    translate (Clock+(1/FCnt))*3*x
  }
  texture {
    pigment { color rgb 1 }
    finish { ambient 0.05 diffuse 0.45 }
  }
}



