/****************************************************************************
*                   colour.h
*
*  This module contains all defines, typedefs, and prototypes for COLOUR.CPP.
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996-2002 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available it may be found online at -
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*##############################################################################
*  This file is part of MegaPOV, which is a modified and unofficial version of POV-Ray
*
* $RCSfile: colour.h,v $
* $Revision: 1.3 $
* $Author: smellenbergh $
* $Log: colour.h,v $
* Revision 1.3  2002/12/07 16:48:31  smellenbergh
* Adds listed pattern, displacement warp
* Header CVS keywords fix
*
* Revision 1.2  2002/11/14 12:15:54  abx
* PoPOV 0.3 core + windows
*
*
*****************************************************************************/

/* NOTE: FRAME.H contains other colour stuff. */

#ifndef COLOUR_H
#define COLOUR_H



/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

#ifdef CONNECT_GRAY_EVALUATION_PATCH
  #define RED2GRAY 0.297
  #define GREEN2GRAY 0.589
  #define BLUE2GRAY 0.114
  #define GREY_SCALE3(CR,CG,CB) (RED2GRAY*(CR) + GREEN2GRAY*(CG) + BLUE2GRAY*(CB))
  #define GREY_SCALE(C) GREY_SCALE3((C)[pRED],(C)[pGREEN],(C)[pBLUE])
#else
  #define GREY_SCALE(C) (0.297*(C)[0] + 0.589*(C)[1] + 0.114*(C)[2])
  #define GREY_SCALE3(CR,CG,CB) (0.297*(CR) + 0.589*(CG) + 0.114*(CB))
#endif

/*****************************************************************************
* Global typedefs
******************************************************************************/




/*****************************************************************************
* Global variables
******************************************************************************/



/*****************************************************************************
* Global functions
******************************************************************************/

COLOUR *Create_Colour (void);
COLOUR *Copy_Colour (COLOUR Old);
BLEND_MAP_ENTRY *Create_BMap_Entries (int Map_Size);
BLEND_MAP_ENTRY *Copy_BMap_Entries (BLEND_MAP_ENTRY *Old,int Map_Size,int Type);
BLEND_MAP *Create_Blend_Map (void);
BLEND_MAP *Copy_Blend_Map (BLEND_MAP *Old);
DBL Colour_Distance (COLOUR colour1, COLOUR colour2);
DBL Colour_Distance_RGBT (COLOUR colour1, COLOUR colour2);
void Add_Colour (COLOUR result, COLOUR colour1, COLOUR colour2);
void Scale_Colour (COLOUR result, COLOUR colour, DBL factor);
void Clip_Colour (COLOUR result, COLOUR colour);
void Destroy_Blend_Map (BLEND_MAP *BMap);
DBL RGBtoHue( COLOUR c );




#endif
