/****************************************************************************
*                   function.h
*
*  This module contains all defines, typedefs, and prototypes for fnsyntax.c.
*
*  This module is based on code by D. Skarda, T. Bily and R. Suzuki.
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996-2002 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available it may be found online at -
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*##############################################################################
*  This file is part of MegaPOV, which is a modified and unofficial version of POV-Ray
*
* $RCSfile: function.h,v $
* $Revision: 1.5 $
* $Author: smellenbergh $
* $Log: function.h,v $
* Revision 1.5  2002/12/07 16:48:32  smellenbergh
* Adds listed pattern, displacement warp
* Header CVS keywords fix
*
* Revision 1.4  2002/12/05 21:01:41  chris
* added Parse_SplineFunction() and Parse_PigmentFunction() for mechsim
*
* Revision 1.3  2002/12/02 00:03:23  smellenbergh
* Adds Mechanics Simulation Patch and Clothray Patch
*
* Revision 1.2  2002/11/14 12:15:55  abx
* PoPOV 0.3 core + windows
*
*
*****************************************************************************/


#ifndef FUNCTION_H
#define FUNCTION_H

typedef unsigned int FUNCTION;
typedef FUNCTION * FUNCTION_PTR;

FUNCTION_PTR Parse_Function(void);
FUNCTION_PTR Parse_FunctionContent(void);
FUNCTION_PTR Parse_DeclareFunction(int *token_id, char *fn_name, bool is_loca);
void Destroy_Function(FUNCTION_PTR Function);
FUNCTION_PTR Copy_Function(FUNCTION_PTR Function);

#ifdef MECHANICS_SIMULATION_PATCH            /* Christoph Hormann August 2002 */
  FUNCTION_PTR Parse_ParameterFunction(void);
  FUNCTION_PTR Parse_SplineFunction(void);
  FUNCTION_PTR Parse_PigmentFunction(void);
#endif

#endif
