/****************************************************************************
*                patches.h
*
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available it may be found online at -
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*###################################################################
*  This file is part of MegaPOV, which is a modified and unofficial version of POV-Ray
*
* $RCSfile: patches.h,v $
* $Revision: 1.17 $
* $Author: abx $
* $Log: patches.h,v $
* Revision 1.17  2002/12/27 09:53:14  abx
* support for DMC compiler (warnings removed)
*
* Revision 1.16  2002/12/16 15:37:20  chris
* fixing the 'render finish beep' problem (UNIX_FINISH_BEEP_PATCH)
*
* Revision 1.15  2002/12/14 11:31:01  smellenbergh
* Bugfix Post_Pigment() added for DISPLACE_WARP_PATCH
* Added noise_pigment_patch
*
* Revision 1.14  2002/12/12 13:33:29  abx
* missed empty line at end
*
* Revision 1.13  2002/12/12 13:03:28  abx
* film exposure simulation patch included in sources
*
* Revision 1.12  2002/12/09 10:14:01  abx
* Parallel rendering of animation with radiosity from one source available
*
* Revision 1.11  2002/12/07 16:48:33  smellenbergh
* Adds listed pattern, displacement warp
* Header CVS keywords fix
*
* Revision 1.10  2002/12/02 00:03:22  smellenbergh
* Adds Mechanics Simulation Patch and Clothray Patch
*
* Revision 1.9  2002/11/27 15:01:27  abx
* built-in tokens available in function parser, cached polynomial solver in SDL and in function VM
*
* Revision 1.7  2002/11/17 18:14:27  smellenbergh
* Added GLOW_PATCH, TIME_DATE_PATCH, TIME_MEASUREMENT_PATCH AND FONT_ALIGNMENT_PATCH.
* Created the folder Patches, all new files should be put in here.
*
* Revision 1.6  2002/11/15 12:45:17  smellenbergh
* SET_PATCH, MESSAGE_PATCH added
*
* Revision 1.5  2002/11/15 12:11:06  smellenbergh
* Syntax harmonizing MegaPOV <==> PoPOV
*
* Revision 1.4  2002/11/15 09:50:32  smellenbergh
* Adds UnofficialBlocking (#version unofficial MegaPOV 1.0;)
* Some minor changes for printing credits
*
* Revision 1.3  2002/11/14 18:28:42  smellenbergh
* Added MultiPlatformLineFeedPatch (Better line number displaying)
*
* Revision 1.2  2002/11/14 18:23:40  smellenbergh
* Added MultiPlatformLineFeedPatch (Better line number displaying)
*
* Revision 1.3  2002/11/14 18:04:19  smellenbergh
* Added some switches for Mac version only. (ignored on other platforms)
* Removed some compiler warnings (splines.ccp)
* Added a missing "include" in splines.ccp
*
* Revision 1.2  2002/11/14 12:15:57  abx
* PoPOV 0.3 core + windows
*
*
*****************************************************************************/

#define PATCHES_BY_ABX     // this major switch turns all
                           // MegaPOv related settings

#define PATCHES_BY_CHRISTOPHE_BOUFFARTIGUE
#define PATCHES_BY_CHRISTOPH_HORMANN
#define PATCHES_BY_MASSIMO_VALENTINI
#define PATCHES_BY_THORSTEN_FROEHLICH
#define PATCHES_BY_VAHUR_KROUVERK
#define PATCHES_BY_WILLIAM_F_POKORNY
#define PATCHES_BY_JURJEN
#define PATCHES_BY_MICHA_RISER
#define PATCHES_BY_JOHN_HAGGERTY
#define PATCHES_BY_SMELLENBERGH
#define PATCHES_BY_NATHAN_KOPP
#define PATCHES_BY_CHRIS_HUFF
#define PATCHES_BY_KARI_KIVISALO

#ifdef PATCHES_BY_ABX

  // patches to avoid some warnings with gcc (under djgpp), bcc and dmc
  #define AVOID_TYPE_CONVERSION_WARNINGS_PATCH
  #define AVOID_MIGHT_BE_USED_UNINITIALIZED_WARNINGS_PATCH
  #define AVOID_EMPTY_STRING_WARNING
  #define REMOVE_NOT_USED_CODE_WARNINGS_PATCH
  #define MIN_MAX_DEFINITION_PATCH
  #define AVOID_ALWAYS_FALSE_COMPARISON_WARNINGS_PATCH
  #define AVOID_PARTLY_BRACKETED_INITIALIZER_WARNINGS_PATCH
  #define AVOID_NAME_CONFLICT_PATCH
  #define WHITE_SPACE_BEFORE_SEMICOLON_PATCH

  // command options
  #define FRAME_STEP_PATCH

  // radiosity
  #define CACHE_IN_ANIMATED_RADIOSITY_PATCH

  // connecting similar code
  #define CONNECT_GRAY_EVALUATION_PATCH

  // parametric related patches
  #define UV_MAPPED_PARAMETRIC_PATCH
  #define PARAMETRIC_MINOR_CHANGES_PATCH

  // spline related patches
  #define SOR_SPLINE_PATCH
  #define SPLINE_LIKE_ARRAY_ACCESS_PATCH

  // torus related patches
  #define UV_MAPPED_TORUS_PATCH

  // internal functions
  #define F_TRIANGLE_PATCH
  #define MISSED_FLOAT_CONSTANTS_RECOGNITION_PATCH

  // expressions
  #define POLYNOMIAL_SOLVER_PATCH

  // platform specific patches
  #define CUSTOM_KEYWORDS_IN_WINPOV_PATCH

#endif

#ifdef PATCHES_BY_MASSIMO_VALENTINI
  #define CORRECT_ASSIGN_FOR_COLORS_PATCH
  #define COPY_FLAG_BUGFIX_PATCH
#endif

#ifdef PATCHES_BY_THORSTEN_FROEHLICH
  #define INLINED_ASSIGN_PATCH
  #define SPLINE_IN_FUNCTION_PATCH
#endif

#ifdef PATCHES_BY_VAHUR_KROUVERK
  #define NO_ZTIMER_PATCH
  #define HMATH_PATCH
  #define INCLUDE_DIR_PATCH
  #define SHORT_FONT_DEFINITION_PATCH
#endif

#ifdef PATCHES_BY_WILLIAM_F_POKORNY
  #define END_ROW_1_PATCH
#endif

#ifdef PATCHES_BY_JURJEN
  #define TRANSPARENT_INVERTED_NORMALS_PATCH
#endif

#ifdef PATCHES_BY_MICHA_RISER
  #define BOUNDINGS_AS_INSIDE_PATCH
#endif

#ifdef PATCHES_BY_JOHN_HAGGERTY
  #define NORMAL_ACCURACY_BUGFIX_PATCH
  #define SMOOTH_HF_PATCH
#endif

#ifdef PATCHES_BY_CHRIS_HUFF
  #define SET_PATCH   // Chris Huff #set, you can not change a variable
                      // unless it was declared before.
  #define GLOW_PATCH
	#define DISPLACE_WARP_PATCH  
	#define LISTED_PATTERN_PATCH
	#define NOISE_PIGMENT_PATCH	
#endif

#ifdef PATCHES_BY_NATHAN_KOPP
  #define UNOFFICIAL_BLOCKING_PATCH  //we are MegaPOV
#endif                               // we need #version unofficial MegaPov x.x in all files

#ifdef PATCHES_BY_SMELLENBERGH
  #define MULTI_PLATFORM_LINE_FEED_PATCH // Files from Unix, DOS, Windows and
                                         // Mac will be read the right way
                                         // Avoid problems with line endings
                                         // especially for displaying errors in the message window

  #define MESSAGE_PATCH					// Yvo & Rene Smellenbergh Message control (max_gradient)
	#define TIME_DATE_PATCH
  #define TIME_MEASUREMENT_PATCH
  #define FONT_ALIGNMENT_PATCH

#endif

#ifdef PATCHES_BY_CHRISTOPH_HORMANN	//Christoph Hormann <chris_hormann@gmx.de>
  #define MECHANICS_SIMULATION_PATCH  
  #define UNIX_FINISH_BEEP_PATCH 
  
  #ifndef MECHSIM_DEBUG
    #define MECHSIM_DEBUG 0
  #endif

#endif 

#ifdef PATCHES_BY_CHRISTOPHE_BOUFFARTIGUE	//Christophe Bouffartigue (tofbouf@oreka.com)
	#define CLOTHRAY_PATCH  
#endif 

#ifdef PATCHES_BY_KARI_KIVISALO
	#define FILM_EXPOSURE_SIMULATION_PATCH
#endif
