/****************************************************************************
*                   glow.h
*
*  This module contains all defines, typedefs, and prototypes for glow.c.
*   Author: Chris Huff
*
*****************************************************************************
*
*  from Persistence of Vision(tm) Ray Tracer
*  Copyright 1996-2002 Persistence of Vision Team
*---------------------------------------------------------------------------
*  NOTICE: This source code file is provided so that users may experiment
*  with enhancements to POV-Ray and to port the software to platforms other
*  than those supported by the POV-Ray Team.  There are strict rules under
*  which you are permitted to use this file.  The rules are in the file
*  named POVLEGAL.DOC which should be distributed with this file.
*  If POVLEGAL.DOC is not available it may be found online at -
*
*    http://www.povray.org/povlegal.html.
*
* This program is based on the popular DKB raytracer version 2.12.
* DKBTrace was originally written by David K. Buck.
* DKBTrace Ver 2.0-2.12 were written by David K. Buck & Aaron A. Collins.
*
*###################################################################
*  This file is part of MegaPOV, which is a modified and unofficial version of POV-Ray
*
* $RCSfile: glow.h,v $
* $Revision: 1.4 $
* $Author: smellenbergh $
* $Log: glow.h,v $
* Revision 1.4  2002/12/07 16:48:43  smellenbergh
* Adds listed pattern, displacement warp
* Header CVS keywords fix
*
* Revision 1.3  2002/12/03 08:50:13  smellenbergh
* syntax corrections
*
*
*
*****************************************************************************/


#ifndef GLOW_H
#define GLOW_H


/*****************************************************************************
* Global preprocessor defines
******************************************************************************/

/*This is defined in povray.h, uncommenting it causes a warning or error.
Maybe it should be defined in frame.h instead...
typedef GLOW * GLOW_PTR;*/

/*****************************************************************************
* Global typedefs
******************************************************************************/
struct Glow_Struct
{
    VECTOR Center;
    COLOUR Colour;
    int Glow_Type;
    DBL Size;
    DBL Cutoff_Radius;
    DBL fade_pow;
    TPATTERN * Warps;
    GLOW * next;
};

/*****************************************************************************
* Global variables
******************************************************************************/



/*****************************************************************************
* Global functions
******************************************************************************/

void Do_Glow(INTERSECTION * Isect, RAY * Ray, COLOUR Colour);
GLOW * Create_Glow();
void Add_Glow(GLOW * Glow);
void Destroy_Glow(GLOW * Glow);
void Destroy_Glow_List(GLOW * Glow_List);
void Parse_Glow(GLOW * Glow);
void Transform_Glow(GLOW * Glow, TRANSFORM * Trans);

#endif
