#ifndef __KONST_STRING_H_
#define __KONST_STRING_H_

#include <string>
#include <vector>

// this include added by Alex Agibalov for FreeBSD compatibility
#include <time.h>

#include "konst.list.h"
#include "konst.conf.h"

#define randlimit(l, h) ((int)((float)rand()/(float)RAND_MAX*(float)(h+1-l)+(float)l))

#define SWAPVAL(v1, v2) { \
    int SWAPVAL__v = v2; \
    v2 = v1, v1 = SWAPVAL__v; \
}

#define PRINTNULL(p) (p ? p : "")
#define TAB_SIZE      8

void charpointerfree(void *p);
void nothingfree(void *p);
int stringcompare(void *s1, void *s2);
int intcompare(void *s1, void *s2);
bool in_numberlist(linkedlist *list, int n);
void del_numberlist(linkedlist *list, int n);

string leadcut(string base, string delim = "\t\n\r ");
string trailcut(string base, string delim = "\t\n\r ");

string getword(string &base, string delim = "\t\n\r ");
string getrword(string &base, string delim = "\t\n\r ");

string getwordquote(string &base, string quote = "\"", string delim = "\t\n\r ");
string getrwordquote(string &base, string quote = "\"", string delim = "\t\n\r ");

int rtabmargin(bool fake, int curpos, const char *p = 0);
int ltabmargin(bool fake, int curpos, const char *p = 0);
void formattext(string buf, vector<string> &lst, bool wrap, int width);

__KTOOL_BEGIN_C

int kwordcount(const char *strin, const char *delim);
char *kgetword(int wordn, const char *strin, const char *delim, char *sout, int maxout);

int kwordcountq(char *strin, char *delim, char *q);
int kwordposq(int n, char *s, char *delim, char *q);
char *kgetwordq(int wordn, char *strin, char *delim, char *q, char *sout, int maxout);

char *strcut(char *strin, int frompos, int count);
char *kstrcopy(char *strin, int frompos, int count, char *strout);
char *kcuturls(char *strin, char *strout);
char *trimlead(char *str, char *chr);
char *trimtrail(char *str, char *chr);
char *trim(char *str, char *chr);

char *strimlead(char *str);
char *strimtrail(char *str);
char *strim(char *str);

const char *strqpbrk(
    const char *s, int offset,
    const char *accept,
    const char *q,
    const char *esc = "");

const char *strqcasestr(
    const char *s,
    const char *str,
    const char *q,
    const char *esc = "");
    
const char *strqstr(const char *s,
    const char *str,
    const char *q,
    const char *esc = "");

char *strccat(char *dest, char c);
char *strinsert(char *buf, int pos, char *ins);
char *strcinsert(char *buf, int pos, char ins);

int strchcount(char *s, char *accept);
int stralone(char *buf, char *startword, int wordlen, char *delim);

char *time2str(time_t *t, char *mask, char *sout);
time_t str2time(char *sdate, char *mask, time_t *t);

char *unmime(char *text);
char *mime(char *dst, const char *src);

int parseformat(char *command, char *quotes, char *fmt, ...);

const char *justfname(const char *fullname);
string i2str(int i);
string ui2str(int i);
string textscreen(string text);

__KTOOL_END_C

#endif
