#include <string.h>
#include <signal.h>
#include <syslog.h>
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>
#include <iostream.h>

#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>

#include "konst.d.h"

tcpdaemon *__daemonref;

tcpdaemon::tcpdaemon(): port(0), logfname(0), conffname(0), keyfile(0) {
    signal(SIGTERM, &handlesignal);
    signal(SIGINT, &handlesignal);
    signal(SIGCHLD, &handlesignal);
    remoteip = new char[16];
    __daemonref = this;
    logopt = strdup("cs");
    dname = strdup("abstractd");
    openlog(0, LOG_PID, 0);
}

tcpdaemon::~tcpdaemon() {
    if(logopt) free(logopt);
    if(logfname) free(logfname);
    if(dname) free(dname);
    delete remoteip;
}

void tcpdaemon::commandline(int argc, char **argv) {
    int ch;
    
    if(dname) free(dname);
    char *p = strrchr(argv[0], '/');
    if(p) dname = strdup(p+1); else dname = strdup(argv[0]);
    
    while((ch = getopt(argc, argv, "c:p:l:")) != EOF) switch(ch) {
        case 'c': conffname = strdup(optarg); break;
        case 'p': port = atol(optarg); break;
        case 'l': logfname = strdup(optarg); break;
        case '?': default: break;
    }
}

void tcpdaemon::listen() {
    struct sockaddr_in address, inaddr;
    int slistener, npid, saccept = -1;
    char reuse_addr = 1;
    socklen_t i;

    memset((char *) &address, 0, sizeof(address));
    address.sin_family = AF_INET;
    address.sin_port = htons(port);
    address.sin_addr.s_addr = htonl(INADDR_ANY);

    if((slistener = socket(AF_INET, SOCK_STREAM, 0)) < 0) throw D_SOCKCREATE;
    setsockopt(slistener, SOL_SOCKET, SO_REUSEADDR, &reuse_addr, sizeof(reuse_addr));

    if(bind(slistener, (struct sockaddr *) &address, sizeof(address)) < 0) {
        close(slistener);
        throw D_SOCKBIND;
    }
  
    ::listen(slistener, 5);

    while(saccept < 0) {
        i = sizeof(inaddr);
        saccept = ::accept(slistener, (struct sockaddr *) &inaddr, &i);
      
        if(saccept < 0) {
            if(errno != EINTR) {
                ::close(slistener);
                throw D_SOCKACCEPT;
            } else {
                continue;
            }
        }

        sprintf(remoteip, "%d.%d.%d.%d",
            ((unsigned char *) &inaddr.sin_addr.s_addr)[0], 
            ((unsigned char *) &inaddr.sin_addr.s_addr)[1], 
            ((unsigned char *) &inaddr.sin_addr.s_addr)[2], 
            ((unsigned char *) &inaddr.sin_addr.s_addr)[3]);

        if(accept()) {
            if((npid = fork()) < 0) {
                ::close(saccept);
                saccept = -1;
            } else {
                if(!npid) {
                    ::close(slistener);
                    sockfd = saccept;
                } else {
                    ::close(saccept);
                    saccept = -1;
                }
            }
        } else {
            log("connection rejected");
            saccept = -1;
        }
    }

    log("connect from %s", remoteip);
    operate();
    log("connection closed");
}

void tcpdaemon::handlesignal(int signum) {
    int status;

    switch(signum) {
        case SIGTERM:
        case SIGINT:    
            __daemonref->log("terminating on signal %d", signum);
            exit(signum);
            break;
        case SIGCHLD:
            while(wait3(&status, WNOHANG, 0) > 0);
            signal(SIGCHLD, &handlesignal);
            break;
    }
}

void tcpdaemon::log(const char *fmt, ...) {
    char buf[1024];
    va_list ap;
    
    va_start(ap, fmt);
    vsprintf(buf, fmt, ap);

    for(int i = 0; i < strlen(logopt); i++) switch(toupper(logopt[i])) {
        case 'C': cout << dname << " [" << getpid() << "]: " << buf << endl; break;
        case 'S': syslog(LOG_DAEMON, "%s", buf); break;
        case 'F': break;
    }
}

void tcpdaemon::operate() {
}

bool tcpdaemon::accept() {
    return true;
}

char *tcpdaemon::strerr(int code) {
    switch(code) {
        case D_SOCKCREATE: return "socket() failed";
        case D_SOCKACCEPT: return "accept() failed";
        case D_SOCKBIND: return "bind() failed";
        case D_TERM: return "terminated";
    }
}
