/*
 * menushki: -- converts the menus between different Desktop Environments
 * Copyright (C) 2001 Alex "Loki" Agibalov <loki_bg@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// Menu editor

#include <curses.h>

#include "functs.h"
#include "editor.h"
#include "konst.ui.dlg.h"
#include "konst.ui.input.h"
#include "menushki.h"
#include "m_kde.h"
#include "m_gnome.h"
#include "m_bb.h"
#include "m_wm.h"
#include "m_ice.h"
#include "m_enl.h"

dialogbox db;

char *edit_prop(char *cont, char *title) {
    char static ret[256];
    
    textinputline line1(boldcolor(2));
    textwindow twi(5, 5, 60, 15, color(1), TW_CENTERED);
    twi.set_title(boldcolor(1), " [ Change propery ] ");
    twi.open();
    twi.write(2, 2, "Changing value for the field:");
    twi.write(2, 3, title);
    strcpy(ret, line1.open(twi.x1+3, twi.y1+6, cont, 40, 255));
    line1.close();
    twi.close();
    if (strlen(ret)==0) return cont;
    return ret;
}

void edit_item(int n) {
    bool found=false;
    bool directory=false;
    bool finished;
    int i=0, j=1, ch;
    char st[256];
    char name[256], exec[256], icon[256], comment[256], type[256], term[256], id[256];
    long l, rec_start, rec_end; // to store the position of a record in file
    FILE *fTmp1; // another temp file
    
    rewind(fTmp);
    while ((ch=fgetc(fTmp))!=EOF && found==false) {
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    if (strstr(st, "_DIR_")) j++;
	    else if (strstr(st, "_ITEM_") && !strstr(st, ".directory")) j++;
	    found=j==n;
	    // remember the starting pos.
	    if (found) {
		rec_start=ftell(fTmp)-strlen(st)-1; 
		strcpy(id, st);
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    if (strstr(st, "_DIR_")) directory=true; else directory=false;
    if (found && !directory) { // changing properties for an item
	found=false;
	name[0]=exec[0]=icon[0]=comment[0]=type[0]=term[0]='\0';
	i=0;
	st[0]='\0';
	fseek(fTmp, -1, SEEK_CUR); // step back for 1 byte
	while ((ch=fgetc(fTmp))!=EOF && found==false) {
	    if (ch=='\n') {
		st[i]='\0';
		i=0;
		if (strstr(st, "_DIR_") || strstr(st, "_ITEM_") ||
		    strstr(st, "_ENDDIR_")) found=true;
		else {
		    if (strstr(st, "_NAME_")) strcpy(name, del_prefix(st, "_NAME_"));
		    else if (strstr(st, "_ICON_")) strcpy(icon, del_prefix(st, "_ICON_"));
		    else if (strstr(st, "_EXEC_")) strcpy(exec, del_prefix(st, "_EXEC_"));
		    else if (strstr(st, "_COMMENT_")) strcpy(comment, del_prefix(st, "_COMMENT_"));
		    else if (strstr(st, "_TYPE_")) strcpy(type, st);
//                    else if (strstr(st, "_TERMINAL_")) strcpy(term, st);
		}
		if (found) rec_end=ftell(fTmp)-strlen(st)-1;
		// remember the end of a record block
	    }
	    else {
		st[i]=ch;
		i++;
	    }
	} // end of read from tmp cycle
	
	finished=false;
	while (!finished) { // properties dialog
	    dialogbox db1;
	    db1.setwindow(new textwindow(9, 7, 72, 15, color(1), TW_CENTERED));
	    db1.setmenu(new verticalmenu(10, 10, 70, 10, color(1), color(2)));
	    db1.setbar(new horizontalbar(color(1), color(2), "Change", "Ok", "Cancel", 0));
	    db1.getwindow()->set_title(boldcolor(1), " [ Item properties ] ");

	    strcpy(st, "Name: ");
	    strcat(st, name);
	    db1.getmenu()->additem(st);
	    strcpy(st, "Exec: ");
	    strcat(st, exec);
	    db1.getmenu()->additem(st);
	    strcpy(st, "Icon: ");
	    strcat(st, icon);
	    db1.getmenu()->additem(st);
	    strcpy(st, "Comment: ");
	    strcat(st, comment);
	    db1.getmenu()->additem(st);
	
	    if (!db1.open(i, j)) finished=true;
	    else if (j==2) finished=true;
	    else {
		if (j==1) { // save2temp and quit
		    fTmp1=tmpfile();
//                    fTmp1=fopen("tmp2.$$$", "wb+");
		    rewind(fTmp);
		    for (l=0; l<rec_start; l++) {
			ch=fgetc(fTmp);
			fputc(ch, fTmp1);
		    }
		    fprintf(fTmp1, "_ITEM_%s\n_NAME_%s\n_EXEC_%s\n_ICON_%s\n_COMMENT_%s\n%s\n", 
			    remove_invalid(name), name, exec, icon, comment, type);
		    fseek(fTmp, rec_end, SEEK_SET);
		    while ((ch=fgetc(fTmp))!=EOF) fputc(ch, fTmp1);
		    fclose(fTmp);
		    fTmp=tmpfile();
		    rewind(fTmp1);
		    while ((ch=fgetc(fTmp1))!=EOF) fputc(ch, fTmp);
		    fclose(fTmp1);
		    finished=true;
		}
		else if (j==0) { // change property
		    switch (i) {
			case 1: strcpy(name, edit_prop(name, "Name"));
				break;
			case 2: strcpy(exec, edit_prop(exec, "Exec"));
				break;
			case 3: strcpy(icon, edit_prop(icon, "Icon"));
				break;
			case 4: strcpy(comment, edit_prop(comment, "Comment"));
				break;
		    }
		}
	    }
	    db1.close();
	} //end of properties cycle
    } // end of not-a-dir cycle
    
    else { // changing properties for a dir
	name[0]=icon[0]=type[0]='\0';
	strcpy(type, "Directory");
	i=0;
	st[0]='\0';
	found=false;
	fseek(fTmp, -1, SEEK_CUR); // step back for 1 byte
	while ((ch=fgetc(fTmp))!=EOF && found==false) {
	    if (ch=='\n') {
		st[i]='\0';
		i=0;
		if (strstr(st, "_DIR_") || strstr(st, "_ENDDIR_") || 
		    (strstr(st, "_ITEM_") && !strstr(st, ".directory"))) found=true;
		else {
		    if (strstr(st, "_NAME_")) strcpy(name, del_prefix(st, "_NAME_"));
		    else if (strstr(st, "_ICON_")) strcpy(icon, del_prefix(st, "_ICON_"));
		    else if (strstr(st, "_TYPE_")) strcpy(type, st);
		}
		if (found) rec_end=ftell(fTmp)-strlen(st)-1;
		// remember the end of a record block
	    }
	    else {
		st[i]=ch;
		i++;
	    }
	} // end of read from tmp cycle
	
	finished=false;
	while (!finished) { // properties dialog
	    dialogbox db1;
	    db1.setwindow(new textwindow(9, 7, 72, 12, color(1), TW_CENTERED));
	    db1.setmenu(new verticalmenu(10, 10, 70, 7, color(1), color(2)));
	    db1.setbar(new horizontalbar(color(1), color(2), "Change", "Ok", "Cancel", 0));
	    db1.getwindow()->set_title(boldcolor(1), " [ Folder properties ] ");
	    
	    strcpy(st, "Name: ");
	    strcat(st, name);
	    db1.getmenu()->additem(st);
	    strcpy(st, "Icon: ");
	    strcat(st, icon);
	    db1.getmenu()->additem(st);
	    
	    if (!db1.open(i, j)) finished=true;
	    else if (j==2) finished=true; // quit
	    else {
		if (j==1) { // save2temp and quit
		    fTmp1=tmpfile();
//                    fTmp1=fopen("tmp2.$$$", "wb+");
		    rewind(fTmp);
		    for (l=0; l<rec_start; l++) {
			ch=fgetc(fTmp);
			fputc(ch, fTmp1);
		    }
		    fprintf(fTmp1, "_DIR_%s\n_ITEM_.directory\n_NAME_%s\n_TYPE_%s\n_ICON_%s\n",
			remove_invalid(name), name, type, icon);
		    fseek(fTmp, rec_end, SEEK_SET);
		    while ((ch=fgetc(fTmp))!=EOF) fputc(ch, fTmp1);
		    fclose(fTmp);
		    fTmp=tmpfile();
		    rewind(fTmp1);
		    while ((ch=fgetc(fTmp1))!=EOF) fputc(ch, fTmp);
		    fclose(fTmp1);
		    finished=true;
		}
		else if (j==0) { // change property
		    switch (i) {
			case 1: strcpy(name, edit_prop(name, "Name"));
				break;
			case 2: strcpy(icon, edit_prop(icon, "Icon"));
				break;
		    } // end of switch
		} // end of changing property cycle
	    }
	    db1.close();
	} // end of property cycle;
    } // end of dir cycle
}


void ins_item(int n) {
    int im, jm, i=0, j=1;
    bool found=false;
    long l, rec_start, rec_end;
    FILE *fTmp1;
    int ch;
    char st[256];
    char name[256], exec[256], icon[256], comment[256], type[256];
    
    dialogbox db1;
    db1.setwindow(new textwindow(19, 7, 62, 12, color(1), TW_CENTERED));
    db1.setmenu(new verticalmenu(20, 10, 70, 7, color(1), color(2)));
    db1.setbar(new horizontalbar(color(1), color(2), "Ok", "Cancel", 0));
    db1.getwindow()->set_title(boldcolor(1), " [ Insert item ] ");
    db1.getmenu()->additem("New program shortcut");
    db1.getmenu()->additem("New folder");
    if (db1.open(im, jm)) {
	if (jm==0) {
	    // find the starting position
	    rewind(fTmp);
	    while ((ch=fgetc(fTmp))!=EOF && found==false) {
		if (ch=='\n') {
		    st[i]='\0';
		    i=0;
		    if (strstr(st, "_DIR_")) j++;
		    else if (strstr(st, "_ITEM_") && !strstr(st, ".directory")) j++;
		    found=j==n;
		    if (found) rec_start=ftell(fTmp)-strlen(st)-1;
		}
		else {
		    st[i]=ch;
		    i++;
		}
	    }
	    rec_end=rec_start+1;
	    
	    fTmp1=tmpfile();
//            fTmp1=fopen("tmp2.$$$", "wb+");
	    rewind(fTmp);
	    for (l=0; l<rec_start; l++) {
		ch=fgetc(fTmp);
		fputc(ch, fTmp1);
	    }
	    
	    strcpy(exec, "");
	    strcpy(icon, "");
	    strcpy(comment, "");
//            if (im==1) { // create application
//                strcpy(name, "New application");
//                strcpy(type, "Application");
//                fprintf(fTmp1, "_ITEM_%s\n_NAME_%s\n_EXEC_%s\n_ICON_%s\n_COMMENT_%s\n_TYPE_%s\n",
//                    name, name, exec, icon, comment, type);
//            }
	    if (im==2) { // create folder
		strcpy(name, "New folder");
		fprintf(fTmp1, "_DIR_%s\n_ITEM_.directory\n_NAME_%s\n_ICON_%s\n",
		    name, name, icon);
//                fprintf(fTmp1, "_ITEM_New Application\n_NAME_%s\n
//                fprintf(fTmp1, "_ENDDIR_\n");
	    }
	    strcpy(name, "New application");
	    strcpy(type, "Application");
	    fprintf(fTmp1, "_ITEM_%s\n_NAME_%s\n_EXEC_%s\n_ICON_%s\n_COMMENT_%s\n_TYPE_%s\n",
		name, name, exec, icon, comment, type);
	    if (im==2) fprintf(fTmp1, "_ENDDIR_\n");
	    while ((ch=fgetc(fTmp))!=EOF) fputc(ch, fTmp1);
	    fclose(fTmp);
	    fTmp=tmpfile();
	    rewind(fTmp1);
	    while ((ch=fgetc(fTmp1))!=EOF) fputc(ch, fTmp);
	    fclose(fTmp1);
	} // end of OK
    } // end of db1.open
    db1.close();
}


void remove_item(int n) {
    FILE *fTmp1;
    int ch, i=0, j=1;
    int subdirs=0; // nu of sub-dirs to be removed too
    char st[256];
    bool found=false;
    bool directory;
    long l, rec_start, rec_end; // to store the position of removed block in file

    // confirmation dialog
    // TODO

    rewind(fTmp);
    // find the beginning of a record to be removed
    while ((ch=fgetc(fTmp))!=EOF && found==false) {
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    if (strstr(st, "_DIR_")) j++;
	    else if (strstr(st, "_ITEM_") && !strstr(st, ".directory")) j++;
	    found=j==n;
	    if (found) rec_start=ftell(fTmp)-strlen(st)-1;
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    if (!found) print_err("Can't find the record in file");
    if (strstr(st, "_DIR_")) directory=true; else directory=false;
    found=false;
    i=0;
    st[0]='\0';
    // find the end of a record
    while ((ch=fgetc(fTmp))!=EOF && found==false) {
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    if (directory) {
		if (strstr(st, "_ENDDIR_") && (subdirs==0)) {
		    found=true;
		    rec_end=ftell(fTmp);
		}
		else if (strstr(st, "_ENDDIR_")) subdirs--;
		else if (strstr(st, "_DIR_")) subdirs++;
	    } else if (strstr(st, "_DIR_") || strstr(st, "_ITEM_") ||
			strstr(st, "_ENDDIR_")) {
		found=true;
		rec_end=ftell(fTmp)-strlen(st)-1;
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    if (!found) print_err("Can't find the record in file");
    
    // update the temp file
    fTmp1=tmpfile();
//    fTmp1=fopen("tmp2.$$$", "wb+");
    rewind(fTmp);
    for (l=0; l<rec_start; l++) {
	ch=fgetc(fTmp);
	fputc(ch, fTmp1);
    }
    fseek(fTmp, rec_end, SEEK_SET);
    while ((ch=fgetc(fTmp))!=EOF) fputc(ch, fTmp1);
    fclose(fTmp);
    fTmp=tmpfile();
    rewind(fTmp1);
    while ((ch=fgetc(fTmp1))!=EOF) fputc(ch, fTmp);
    fclose(fTmp1);
}


void save_tree(char *mType, char *sName) {
    rewind(fTmp);
    if (strstr(mType, "KDE")) buf2kde(sName);
    if (strstr(mType, "indow")) buf2wm(sName);
    if (strstr(mType, "GNOME")) buf2gnome(sName);
    if (strstr(mType, "IceWM")) buf2ice(sName);
    if (strstr(mType, "nlight")) buf2enl(sName, "Converted");
    if (strstr(mType, "BlackBox")) buf2bb(sName);
}


char *saveas_tree(char *mType, char *sName) {
    char tmpres[256];
    strcpy(tmpres, get_name(mType, "destination"));
    if (strlen(tmpres) > 0) {
	strcpy(sName, tmpres);
	save_tree(mType, sName);
    }
    return sName;
}


void redraw_tree(char *mType) {
    int ch;
    char st[256], name[256];
    int i=0;
    int nodelev=0; // level of the node
    int node[25]; // does someone have more than 25 levels in menu? :)
    int skip=0; // we do not display .directory entries
    int ID=1; //nu of item - to be able to find it later
    void *vd;
    
//    dialogbox db;
    
    rewind(fTmp);
    strcpy(name, " ");
    strcat(name, mType);
    strcat(name, " menu ");
    node[nodelev]=db.gettree()->addnode(0, 0, (void *) ID, name);
    nodelev++;
    ID++;
    
    while ((ch=fgetc(fTmp))!=EOF) {
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    if (strstr(st, "_DIR_")) {
		strcpy(name, " ");
		strcat(name, del_prefix(st, "_DIR_"));
		node[nodelev]=db.gettree()->addnode(node[nodelev-1], 0, (void *) ID, name);
		nodelev++;
		ID++;
	    }
	    else if (strstr(st, "_ENDDIR")) {
		strcpy(name, del_prefix(st, "_ENDDIR_"));
		nodelev--;
	    }
	    else if (strstr(st, "_ITEM_")) {
		if (strstr(st, ".directory")) skip=1;
		else skip=0;
	    }
	    else if (strstr(st, "_NAME_") && !skip) {
		strcpy(name, " ");
		strcat(name, del_prefix(st, "_NAME_"));
		db.gettree()->addleaf(node[nodelev-1], 0, (void *) ID, name);
		ID++;
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
}

char *launch_editor(char *mType, char *sName) {
    char s0[256];
    int node;
    int i, j, k;
    bool quit_editor=false;
    bool finished = false;

    textwindow tw0(0, 0, 65, 18, color(1), TW_CENTERED);
    tw0.open();
    db.setwindow(new textwindow(0, 0, 65, 18, color(1), TW_CENTERED));
    db.settree(new treeview(color(1), color(2), color(1), color(1)));
    db.setbar(new horizontalbar(color(1), color(2), "Properties", "Insert", "Remove", "Save", "Save as...", "Exit", 0));

    while (!quit_editor) {
	tw0.set_title(boldcolor(1), " [ %s: %s ] ", mType, sName);
	db.getwindow()->set_title(boldcolor(1), " [ %s: %s ] ", mType, sName);
	redraw_tree(mType);
	db.getwindow()->redraw();
	db.redraw();

	if (!db.open(i, j)) quit_editor=true;
	else {
	    switch(j) {
		case 0: if (i>1) edit_item(i);  // edit
			break;
		case 1: if (i>1) ins_item(i);  // insert
			break;
		case 2: if (i>1) remove_item(i);  // remove
			break;
		case 3: save_tree(mType, sName);  // save
			break;
		case 4: strcpy(sName, saveas_tree(mType, sName));  // save as
			break;
		case 5: quit_editor=true;  // exit
			break;
	    }
	}
		
	db.gettree()->clear();
    }
    // TODO: save confirmation
    db.close();
    tw0.close();
    clear();
    return sName; // it might be different if 'save as' was chosen
}


