/*
 * menushki: -- converts the menus between different Desktop Environments
 * Copyright (C) 2001 Alex "Loki" Agibalov <loki_bg@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Small functions for menushki project */

#include <stdio.h>
#include <string.h>
#include <ncurses.h>
#include <unistd.h>
#include <dirent.h>

#include "functs.h"

// delete a file
void del_file(char *fname) {
    unlink(fname);
}

// remove a directory
int del_dir(char *dname) {
    DIR *dir;
    struct dirent *dirent;
    char olddir[1024], newdir[1024], st[1024];
    
    strcpy(newdir, dname);
    
    if (rmdir(dname)==0) // maybe it's already empty
	return 0;
    if ((dir=opendir(dname))!=NULL) {
	while ((dirent=readdir(dir))!=NULL) {
	    if (dirent->d_type==DT_DIR && strcmp(dirent->d_name,".")
		    && strcmp(dirent->d_name,"..")) { 
			strcpy(olddir, newdir);
			strcat(newdir, "/");
			strcat(newdir, dirent->d_name);
			del_dir(newdir);
			strcpy(newdir, olddir);
		}
	    if (dirent->d_type==DT_REG) {
		strcpy(st, newdir);
		strcat(st, "/");
		strcat(st, dirent->d_name);
		remove(st);
	    }
	}
	closedir(dir);
	rmdir(dname); // now it's empty for sure
	return 0;
    }
//    else fprintf(stderr, "can't open %s\n", dname);
}

// remove the extention from filename
char *del_ext(char *fname, char *ext) {
    int i;
    static char st[256];
    if (strstr(fname, ext)!=0) {
	strncpy(st, fname, strlen(fname)-strlen(strstr(fname, ext)));
	st[strlen(fname)-strlen(strstr(fname, ext))]='\0';
	return st;
    }
    return fname;
}

// remove leading prefix
char *del_prefix(char *txt, char *pref) {
  static char st[256];
  int i, j;
  j=strlen(pref);
  for (i=j; i<strlen(txt);i++) st[i-j]=txt[i];
  st[i-j]='\0';
  return st;
}

// remove leading spaces
char *del_leading_space(char *txt) {
    static char st[256];
    int i, j;
    if (txt[0]==' ' || txt[0]=='\t') {
	for (i=0; i<strlen(txt);i++) if (txt[i]!=' ' && txt[i]!='\t') break;
	for (j=i; j<strlen(txt);j++) st[j-i]=txt[j];
	st[j-i]='\0';
	return st;
    }
    return txt;
}

// get name inside " " the opening quote should be the 1st symbol in string!!!
char *get_name_q(char *txt) {
    static char st[256], st1[256];
    int i;
    // remove leading "
    for (i=1; i<strlen(txt); i++) st1[i-1]=txt[i];
    st1[i-1]='\0';
    // get name
    for (i=0; i<(strlen(st1)-strlen(strchr(st1, '"'))); i++)
	st[i]=st1[i];
    st[i]='\0';
    return st;
}

// replace/remove invalid symbols
char *remove_invalid(char *txt) {
    static char st[256];
    int i;
    
    strcpy(st, txt);
    for (i=0; i<strlen(st); i++) {
	switch(st[i]) {
	    case '/': st[i]='-'; break;
	}
    }
    return st;
    
}

// print centered line
void print_center(int x, char *st) {
    mvaddstr(x, 40-strlen(st)/2, st);
}

// get name inside some symbols
char *get_name_symb(char *txt, int symb, int symb1) {
    static char st[256], st1[256];
    int i, j, k, counter=0;
    // remove leading symbol
    j=strlen(strchr(txt, symb));
    k=strlen(txt)-j+1;
    for (i=k; i<strlen(txt); i++) 
	st1[i-k]=txt[i];
    st1[i-k]='\0';
    // get name
//    for (i=0; i<(strlen(st1)-strlen(strchr(st1, symb1))); i++)
    for (i=0; i<(strlen(st1)); i++) {
	if (st1[i]==symb) counter++;
	if (st1[i]==symb1) {
	    if (counter > 0) {
		counter--;
		st[i]=st1[i];
	    }
	    else break;
	}
	else st[i]=st1[i];
    }
    st[i]='\0';
    return st;
}
					    




