/*
 * menushki: -- converts the menus between different Desktop Environments
 * Copyright (C) 2001 Alex "Loki" Agibalov <loki_bg@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Working with BlackBox menu for menushki project */

#include <stdio.h>
#include <string.h>

#include "functs.h"
#include "m_bb.h"
#include "menushki.h"

int buf2bb(char *fname) {
    FILE *fPtr;
    char st[256];
    int i=0, ch, j;
    int skip=0; // 1 - yes, 0 - no
    int needed=0; // we need Name&Exec, so to proceed it should be =2
    char enddir[256]; // name of the current dir (to put END tag)
    char name[256], exec[256]; // to store name&exec until needed=2
    char tmp[256];
    int dircnt=1; // trying to fix the bug of exceeding [end] tags
    // later should be done in another way, as this solution is the worst

    if ((fPtr=fopen(fname, "w"))==NULL) {
	print_err("Can't create BlackBox menu file");
	return 666;
    }
    fprintf(fPtr, "# BlackBox menu generated by Menushki\n[begin] (New BlackBox menu)\n");
    while ((ch=fgetc(fTmp))!=EOF) {
	// we've got everything - now insert it in file
	if (needed==2) {
	    strcpy(tmp, "  ");
	    if (dircnt > 1)
		for (j=1; j<dircnt; j++)
		    strcat(tmp, "  ");
	    strcat(tmp, "[exec] (");
	    strcat(tmp, name);
	    strcat(tmp, ") {");
	    strcat(tmp, exec);
	    strcat(tmp, "}");
	    fprintf(fPtr, "%s\n", tmp);
	    needed=0;
	}
						    
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    if (strstr(st, "_ITEM_")!=0) {
		if (strstr(st, ".directory")==0) {
		    skip=0;
		    strcpy(name, "");
		    strcpy(exec, "");
		    needed=0;
		}
		else {
		    strcpy(name, "");
		    strcpy(exec, "");
		    needed=0;
		    skip=1;
		}
	    }
	    else if (strstr(st, "_EXEC_")!=0 && skip==0) {
		needed++;
		strcpy(exec, del_prefix(st, "_EXEC_"));
		if (strstr(exec, "-caption")!=0)
		    exec[strlen(exec)-strlen(strstr(exec,"-caption"))-1]='\0';
	    }
	    else if (strstr(st, "_NAME_")!=0 && skip==0) {
		needed++;
		strcpy(name, del_prefix(st, "_NAME_"));
	    }
	    else if (strstr(st, "_DIR_")!=0) {
		strcpy(enddir, del_prefix(st, "_DIR_"));
		strcpy(tmp, "  ");
		if (dircnt>1)
		    for (j=1; j<dircnt;j++)
			strcat(tmp, "  ");
		strcat(tmp, "[submenu] (");
		strcat(tmp, enddir);
		strcat(tmp, ")");
		fprintf(fPtr, "%s\n", tmp);
		dircnt++;
	    }
	    else if (strstr(st, "_ENDDIR_")!=0) {
		strcpy(tmp, "  ");
		if (dircnt > 1)
		    for (j=1; j<dircnt-1; j++)
			strcat(tmp, "  ");
		strcat(tmp, "[end]");
		if (dircnt>1) {
		    fprintf(fPtr, "%s\n", tmp);
		    dircnt--;
		}
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    fprintf(fPtr, "[workspaces] (Workspace List)\n[config] (Configuration)\n");
    fprintf(fPtr, "[reconfig] (Reconfigure)\n[restart] (Restart)\n");
    fprintf(fPtr, "[exit] (Exit)\n[end]\n# End of generated menu\n");
  
    fclose(fPtr);
    return 0;
}

int bb2buf(char *fname) {
    int skip=0; // 1-start skipping lines, 0-read all
    FILE *fPtr;
    char st[256], tmp[256], tmp1[256];
    int ch, i=0;

    if ((fPtr=fopen(fname, "r"))==NULL) {
	sprintf(tmp1, "Can't open source BlackBox menu: %s\n", fname);
	print_err(tmp1);
	return 666;
    }
    while ((ch=fgetc(fPtr))!=EOF) {
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    strcpy(st, del_leading_space(st));
	    if (strchr(st, '#'))
		strcpy(st, del_ext(st, strchr(st, '#')));

	    if (strstr(st, "[submenu]")) {
		strcpy(st, get_name_symb(st, '(', ')'));
		fprintf(fTmp, "_DIR_%s\n", st);
		fprintf(fTmp, "_ITEM_.directory\n");
		fprintf(fTmp, "_NAME_%s\n", st);
//                fprintf(fTmp, "_ICON_NONE\n");
	    }
	    else if (strstr(st, "[end]")) {
//                strcpy(st, get_name_q(st));
		fprintf(fTmp, "_ENDDIR_\n");
	    }
	    else if (strstr(st, "[exec]")) {
		strcpy(tmp, get_name_symb(st, '(', ')'));
		strcpy(tmp1, remove_invalid(tmp));
		fprintf(fTmp, "_ITEM_%s\n_NAME_%s\n", tmp1, tmp);
		fprintf(fTmp, "_TYPE_Application\n");
		strcpy(tmp, get_name_symb(st, '{', '}'));
		fprintf(fTmp, "_EXEC_%s\n", tmp);
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    return 0;
}


