/*
 * menushki: -- converts the menus between different Desktop Environments
 * Copyright (C) 2001 Alex "Loki" Agibalov <loki_bg@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Work with Enlightenment menu */

#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <sys/stat.h> 
#include <unistd.h> 

#include "m_enl.h"
#include "functs.h"
#include "menushki.h"

extern FILE *fTmp;
extern char currdir[256];

int recurs=0; // recursion counter for buf2enl
int cnt=0; // number of folder (to create a file)

// move buffer to Enlightenment
int buf2enl(char *fname, char *dname) {
    FILE *fPtr;
    char st[256];
    int i=0, ch;
    int skip=0; // 1 - yes, 0 - no
    int needed=0; // we need Name&Exec&icon, so to proceed it should be =3
    char enddir[256]; // name of the current dir (to put END tag)
    char name[256], exec[256], icon[256]; // to store name&exec&icon until needed=3
    char tmp[256], tmp1[256];
    
    recurs++;
    
// get last part of the path
    if (strchr(fname, '/')) {
	tmp[0]=0;
	int j00=strlen(fname)-strlen(strrchr(fname, '/'))+1;
	int ii;
	for (ii=j00; ii<strlen(fname); ii++)
	    tmp[ii-j00]=fname[ii];
	tmp[ii-j00]=0;
    }
    else strcpy(tmp, fname);
    
    mkdir(tmp, S_IRWXU);
    chdir(tmp);

    strcpy(tmp1, tmp);
    strcat(tmp1, ".menu");
    
    if ((fPtr=fopen(tmp1, "w"))==NULL) {
	print_err("Can't create Enlightenment menu file");
	return 666;
    }
    
    fprintf(fPtr, "\"%s\"\n", dname);
    
    while ((ch=fgetc(fTmp))!=EOF) {
	// we've got everything - now insert it in file
	if (needed==3) {
	    strcpy(tmp, "\"");
	    strcat(tmp, name);
	    strcat(tmp, "\" ");
	    if (strlen(icon)>1) {
		strcat(tmp, "\"");
		strcat(tmp, icon);
		strcat(tmp, "\"");
	    }
	    else
		strcat(tmp, "NULL");
	    strcat(tmp, " exec \"");
	    strcat(tmp, exec);
	    strcat(tmp, "\"");
	    fprintf(fPtr, "%s\n", tmp);
	    needed=0;
	}
						    
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    if (strstr(st, "_ITEM_")!=0) {
		if (strstr(st, ".directory")==0) {
		    skip=0;
		    // didn't find icon, but name&exec are here
		    if (needed==2) {
			strcpy(tmp, "\"");
			strcat(tmp, name);
			strcat(tmp, "\" NULL exec \"");
			strcat(tmp, exec);
			strcat(tmp, "\"");
			fprintf(fPtr, "%s\n", tmp);
		    }
		    strcpy(name, "");
		    strcpy(exec, "");
		    strcpy(icon, "");
		    needed=0;
		}
		else {
		    strcpy(name, "");
		    strcpy(exec, "");
		    strcpy(icon, "");
		    needed=0;
		    skip=1;
		}
	    }
	    else if (strstr(st, "_EXEC_")!=0 && skip==0) {
		needed++;
		// hmm, do we really need to remove -caption for enlightenment?
		strcpy(exec, del_prefix(st, "_EXEC_"));
		if (strstr(exec, "-caption")!=0)
		    exec[strlen(exec)-strlen(strstr(exec,"-caption"))-1]='\0';
	    }
	    else if (strstr(st, "_NAME_")!=0 && skip==0) {
		needed++;
		strcpy(name, del_prefix(st, "_NAME_"));
	    }
	    else if (strstr(st, "_ICON_") && skip==0) {
		needed++;
		strcpy(icon, del_prefix(st, "_ICON_"));
	    }
	    else if (strstr(st, "_DIR_")!=0) {
		cnt++;
		strcpy(tmp, "\"");
		strcat(tmp, del_prefix(st, "_DIR_"));
		strcat(tmp, "\" \"\" menu \"");
		sprintf(tmp1, "%s/%d/%d.menu", fname, cnt, cnt);
		strcat(tmp, tmp1);
		strcat(tmp, "\"");
		fprintf(fPtr, "%s\n", tmp);
		
		sprintf(tmp1, "%s/%d", fname, cnt);
		buf2enl(tmp1, del_prefix(st, "_DIR_"));                
	    }
	    else if (strstr(st, "_ENDDIR_")!=0) {
		fclose(fPtr);
		chdir("..");
		return 0;
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    if (fPtr) { 
	fclose(fPtr);
	chdir("..");
    }
    return 0;
}

// move Enlightenment to buf
int enl2buf(char *fname) {
    FILE *fPtr;
    char st[256], tmp[256], tmp1[256];
    int ch, i=0;
    int nline=0; // line number, if ==1 then it's folder name
    
    if ((fPtr=fopen(fname, "r"))==NULL) {
	sprintf(tmp1, "Can't open source Enlightenment menu: %s\n", fname);
	print_err(tmp1);
	return 666;
    }
    while ((ch=fgetc(fPtr))!=EOF) {
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    nline++;
	    
	    // first line of file - folder name
	    if (nline==1) {
		strcpy(st, get_name_q(st));
		fprintf(fTmp, "_DIR_%s\n", st);
		fprintf(fTmp, "_ITEM_.directory\n");
		fprintf(fTmp, "_NAME_%s\n");
	    }
	    else {
		if (strstr(st, " menu \"")) {
		    // get menu filename in last quotes
		    int j00=strlen(st)-strlen(strstr(st, " menu \""))+6;
		    tmp[0]=0;
		    int j01;
		    for (j01=j00; j01 < strlen(st); j01++)
			tmp[j01-j00]=st[j01];
		    tmp[j01-j00]=0;
		    strcpy(tmp1, get_name_q(tmp));
		    // if there's no path, we need to fetch the prev. one
		    if (!strchr(tmp1, '/') && strchr(fname, '/')) {
			tmp[0]=0;
			j00=strlen(fname)-strlen(strrchr(fname, '/'))+1;
			strncpy(tmp, fname, j00);
			tmp[j00]=0;
			strcat(tmp, tmp1);
			strcpy(tmp1, tmp);
		    }
		    if (enl2buf(tmp1)!=0) {
			sprintf(tmp, "Couldn't open %s file, skipping...", tmp1);
			print_err(tmp);
		    }
		}
		else if (strstr(st, " exec \"")) {
			// get name
			strcpy(tmp, get_name_q(st));
			strcpy(tmp1, remove_invalid(tmp));
			fprintf(fTmp, "_ITEM_%s\n_NAME_%s\n", tmp1, tmp);
			fprintf(fTmp, "_TYPE_Application\n");
			// remove quotes with name
			strcpy(tmp1, "\"");
			strcat(tmp1, tmp);
			strcat(tmp1, "\" ");
			strcpy(st, del_prefix(st, tmp1));
			// check for icon
			if (strstr(st, "NULL")) {
			    strcpy(st, del_prefix(st, "NULL exec "));
			}
			else {
			    strcpy(tmp, get_name_q(st));
			    fprintf(fTmp, "_ICON_%s\n", tmp);
			    strcpy(tmp1, "\"");
			    strcat(tmp1, tmp);
			    strcat(tmp1, "\" exec ");
			    strcpy(st, del_prefix(st, tmp1));
			}
			// get exec string
			strcpy(tmp, get_name_q(st));
			fprintf(fTmp, "_EXEC_%s\n", tmp);
		}
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    // finished reading file, so it's the end of directory
    fprintf(fTmp, "_ENDDIR_\n");
    
    return 0;
}


