/*
 * menushki: -- converts the menus between different Desktop Environments
 * Copyright (C) 2001 Alex "Loki" Agibalov <loki_bg@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// Working with IceWM menu

#include <stdio.h>
#include <string.h>

#include "functs.h"
#include "m_ice.h"
#include "menushki.h"

int buf2ice(char *fname) {
    FILE *fPtr;
    char st[256];
    int i=0, ch;
    int skip=0; // 1 - yes, 0 - no
    int needed=0; // we need Name&Exec, so to proceed it should be =2
    char enddir[256]; // name of the current dir (to put END tag)
    char name[256], exec[256]; // to store name&exec until needed=2
    char tmp[256], tmp1[256];
    char p[256];
    int dircnt=1, j;
    
    if ((fPtr=fopen(fname, "w"))==NULL) {
	print_err("Can't create IceWM menu!\n");
	return 666;
    }
    fprintf(fPtr, "# IceWM menu generated by Menushki\n");
    while ((ch=fgetc(fTmp))!=EOF) {
	// we've got everything - now insert it in file
	if (needed==2) {
	    strcpy(tmp, "  ");
	    if (dircnt > 1)
		for (j=1; j<dircnt; j++)
		    strcat(tmp, "  ");
	    strcat(tmp, "prog ");
	    if (strchr(name, ' ')) strcat(tmp, "\"");
	    strcat(tmp, name);
	    if (strchr(name, ' ')) strcat(tmp, "\"");
	    strcat(tmp, " ");
	    strcpy(tmp1, exec);
	    if (strtok(name, " ")) {
		strcpy(p, strtok(exec, " "));
		if (p) strcat(tmp, p);
		else strcat(tmp, exec);
	    }
	    else strcat(tmp, name);
	    
	    strcat(tmp, " ");
	    strcat(tmp, tmp1);
	    fprintf(fPtr, "%s\n", tmp);
	    needed=0;
	}
						    
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    if (strstr(st, "_ITEM_")!=0) {
		if (strstr(st, ".directory")==0) {
		    skip=0;
		    strcpy(name, "");
		    strcpy(exec, "");
		    needed=0;
		}
		else {
		    strcpy(name, "");
		    strcpy(exec, "");
		    needed=0;
		    skip=1;
		}
	    }
	    else if (strstr(st, "_EXEC_")!=0 && skip==0) {
		needed++;
		strcpy(exec, del_prefix(st, "_EXEC_"));
		if (strstr(exec, "-caption")!=0)
		    exec[strlen(exec)-strlen(strstr(exec,"-caption"))-1]='\0';
	    }
	    else if (strstr(st, "_NAME_")!=0 && skip==0) {
		needed++;
		strcpy(name, del_prefix(st, "_NAME_"));
	    }
	    else if (strstr(st, "_DIR_")!=0) {
		strcpy(enddir, del_prefix(st, "_DIR_"));
		strcpy(tmp, "  ");
		if (dircnt>1)
		    for (j=1; j<dircnt;j++)
			strcat(tmp, "  ");
		strcat(tmp, "menu \"");
		strcat(tmp, enddir);
		strcat(tmp, "\" folder {");
		fprintf(fPtr, "%s\n", tmp);
		dircnt++;
	    }
	    else if (strstr(st, "_ENDDIR_")!=0) {
		strcpy(tmp, "  ");
		if (dircnt > 1)
		    for (j=1; j<dircnt-1; j++)
			strcat(tmp, "  ");
		strcat(tmp, "}");
		fprintf(fPtr, "%s\n", tmp);
		dircnt--;
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    fclose(fPtr);
    return 0;
}

int ice2buf(char *fname) {
    FILE *fPtr;
    char st[256], tmp[256], name[256], name1[256], exec[256];
    int ch, i=0;
    
    if ((fPtr=fopen(fname, "r"))==NULL) {
	print_err("Can't open source IceWM menu!");
	return 666;
    }
    while ((ch=fgetc(fPtr))!=EOF) {
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    strcpy(st, del_leading_space(st));
	    if (strchr(st, '#')) {
		strcpy(st, del_ext(st, strchr(st, '#')));
	    }
	    if (strstr(st, "menu") && strstr(st, "folder {")) {
		strcpy(st, del_ext(st, " folder {"));
		strcpy(st, del_prefix(st, "menu "));
		if (strchr(st, '"'))
		    strcpy(st, get_name_q(st));
		fprintf(fTmp, "_DIR_%s\n", st);
		fprintf(fTmp, "_ITEM_.directory\n");
		fprintf(fTmp, "_NAME_%s\n", st);
//                fprintf(fTmp, "_ICON_NONE\n");
	    }
	    else if (strstr(st, "prog ")) {
		strcpy(st, del_prefix(st, "prog "));
		if (strchr(st, '"')) {
		    strcpy(name, get_name_q(st));
		    strcpy(st, del_prefix(st, "\""));
		    strcpy(st, del_prefix(st, name));
		    strcpy(st, del_prefix(st, "\" "));
		}
		else {
		    strcpy(tmp, st);
		    strcpy(name, strtok(tmp, " "));
		    strcpy(st, del_prefix(st, name));
		    strcpy(st, del_leading_space(st));
		}
		strcpy(tmp, st);
		strcpy(name1, strtok(tmp, " ")); // still don't know what 2nd param means?
		strcpy(exec, del_prefix(st, name1));
		strcpy(exec, del_leading_space(exec));
		fprintf(fTmp, "_ITEM_%s\n", remove_invalid(name));
		fprintf(fTmp, "_NAME_%s\n", name);
		fprintf(fTmp, "_EXEC_%s\n", exec);
		fprintf(fTmp, "_TYPE_Application\n");
	    }
	    else if (strchr(st, '}')) {
		fprintf(fTmp, "_ENDDIR_\n");
	    } 
	}
	else {
	    st[i]=ch;
	    i++;
	} 
    } 
    return 0;
}


