/*
 * menushki: -- converts the menus between different Desktop Environments
 * Copyright (C) 2001 Alex "Loki" Agibalov <loki_bg@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Working with KDE menu for menushki project */

#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <sys/stat.h> 
#include <unistd.h> 

#include "m_kde.h"
#include "functs.h"
#include "menushki.h"

extern FILE *fTmp;

// return part of a string after '=' sign
char *after_equal(char *st) {
    static char s[256];
    int i;
    strcpy(s, strchr(st, '='));
    for (i=0; i<strlen(s); i++) s[i]=s[i+1];
    
    return s;
}

// leave only needed part of a string
void filter_line (char st[]) {
    char st1[256];
    st1[0]='\0';
    if (strstr(st, "Name=")!=0) {
	strcpy(st1, "_NAME_");
	strcat(st1, after_equal(st));
    }
    else if (strstr(st, "Exec=")!=0 && strstr(st, "SwallowExec=")==0
	    && strstr(st, "TryExec=")==0) {
	strcpy(st1, "_EXEC_");
	strcat(st1, after_equal(st));
    }
    else if (strstr(st, "Icon=")!=0 && strstr(st, "MiniIcon=")==0) {
	strcpy(st1, "_ICON_");
	strcat(st1, after_equal(st));
    }
    else if (strstr(st, "Type=")!=0 && strstr(st, "MimeType=")==0) {
	strcpy(st1, "_TYPE_");
	strcat(st1, after_equal(st));
    }
    else if (strstr(st, "Comment=")!=0) {
	strcpy(st1, "_COMMENT_");
	strcat(st1, after_equal(st));
    }
    else if (strstr(st, "Terminal=")!=0) {
	strcpy(st1, "_TERMINAL_");
	strcat(st1, after_equal(st));
    }
						
    strcpy(st, st1);
}

// move KDE menu to buffer
int kde2buf(char *dirName) {
    DIR *dir;
    FILE *fPtr;
    int ch, i;
    char st[256];
    struct dirent *dirent;
    char olddir[256], newdir[256];
    strcpy(newdir, dirName);
    if ((dir=opendir(dirName))!=NULL) {
	while ((dirent=readdir(dir))!=NULL) {
	    if (dirent->d_type==DT_DIR 
	    && strcmp(dirent->d_name,".")!=0 
	    && strcmp(dirent->d_name,"..")!=0) {
		fprintf(fTmp, "_DIR_%s\n", dirent->d_name);
		strcpy(olddir, newdir);
		strcat(newdir, "/");
		strcat(newdir, dirent->d_name);
		kde2buf(newdir);
		strcpy(newdir, olddir);
		fprintf(fTmp, "_ENDDIR_\n");
	    }
	    if (dirent->d_type==DT_REG) {
		fprintf(fTmp, "_ITEM_%s\n", del_ext(dirent->d_name, ".kdelnk"));
		strcpy(st, newdir);
		strcat(st, "/");
		strcat(st, dirent->d_name);
		if ((fPtr=fopen(st, "r"))!=NULL) {
		    i=0;
		    while ((ch=fgetc(fPtr))!=EOF) {
			if (ch!='\n') {
			    st[i]=ch;
			    i++;
			}
			else {
			    st[i]='\0';
			    filter_line(st);
			    if (st[0]!='\0')
				    fprintf(fTmp, "%s\n", st);
			    i=0;
			}
		    }
		    if (i>0) { // if there's no EOL at EOF
		      st[i]='\0';
		      fprintf(fTmp, "%s\n", st);
		    }
		    fclose(fPtr);
		}
		else {
		    print_err("can't open some file");
		    return 666;
		}
	    }
	}
	closedir(dir);
    }
    else {
	print_err("error opening KDE menu");
	return 666;
    }
    return 0;
}

// move menu from buffer to KDE
int buf2kde(char *dirName) {
    int ch, i0=0;
    static char st[256];
    FILE *fPtr;
    char cur_dir[1024];
    
    fPtr=NULL;
    sprintf(cur_dir, "%s", getcwd(NULL, 0));
    del_dir(dirName);
    chdir(cur_dir);
    mkdir(dirName, S_IRWXU);
    chdir(dirName);
    st[i0]='\0';
    while ((ch=fgetc(fTmp))!=EOF) {
	if (ch=='\n') {
	    st[i0]='\0';
	    if (i0>0) {
		if (strstr(st, "_ITEM_")!=0) {
		    if (fPtr!=NULL) fclose(fPtr);
		    if (strstr(st, ".directory")!=0) fPtr=fopen(".directory", "w");
		    else fPtr=fopen(strcat(del_prefix(st, "_ITEM_"), ".kdelnk"), "w");
		    fprintf(fPtr, "# KDE Config File\n# Generated by Menushki\n[Desktop Entry]\n");
		}
		else if (strstr(st, "_ENDDIR_")!=0) {
		    chdir("..");
		}
		else if (strstr(st, "_DIR_")!=0) {
		    mkdir(del_prefix(st, "_DIR_"), S_IRWXU);
		    chdir(del_prefix(st, "_DIR_"));
		}
		else if (strstr(st, "_NAME_")!=0) {
		    if (fPtr!=NULL) 
			fprintf(fPtr, "Name=%s\n", del_prefix(st, "_NAME_"));
		}
		else if (strstr(st, "_ICON_")!=0) {
		    if (fPtr!=NULL) {
			fprintf(fPtr, "Icon=%s\n", del_prefix(st, "_ICON_"));
		    }
		}
		else if (strstr(st, "_COMMENT_")!=0) {
		    if (fPtr!=NULL)
			fprintf(fPtr, "Comment=%s\n", del_prefix(st, "_COMMENT_"));
		}
		else if (strstr(st, "_EXEC_")!=0) {
		    if (fPtr!=NULL)
			fprintf(fPtr, "Exec=%s\n", del_prefix(st, "_EXEC_"));
		}
		else if (strstr(st, "_TYPE_")!=0) {
		    if (fPtr!=NULL)
			fprintf(fPtr, "Type=%s\n", del_prefix(st, "_TYPE_"));
		}
		else if (strstr(st, "_TERMINAL_")!=0) {
		    if (fPtr!=NULL)
			fprintf(fPtr, "Terminal=%s\n", del_prefix(st, "_TERMINAL_"));
		}
	    }
	    i0=0;
	    st[i0]='\0';
	}
	else {
	    st[i0]=ch;
	    i0++;
	}
    }
    chdir("..");
    return 0;
}
