/*
 * menushki: -- converts the menus between different Desktop Environments
 * Copyright (C) 2001 Alex "Loki" Agibalov <loki_bg@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Working with WindowMaker menu for menushki project */

#include <stdio.h>
#include <string.h>

#include "functs.h"
#include "m_wm.h"
#include "menushki.h"

int buf2wm(char *fname) {
    FILE *fPtr;
    char st[256];
    int i=0, ch;
    int skip=0; // 1 - yes, 0 - no
    int needed=0; // we need Name&Exec, so to proceed it should be =2
    char enddir[256]; // name of the current dir (to put END tag)
    char name[256], exec[256]; // to store name&exec until needed=2
    char tmp[256];
    int dircnt=1, j;
    
    if ((fPtr=fopen(fname, "w"))==NULL) {
	print_err("Can't create WindowMaker menu file");
	return 666;
    }
    fprintf(fPtr, "# WindowMaker menu generated by Menushki\n\"Converted\" MENU\n");
    while ((ch=fgetc(fTmp))!=EOF) {
	// we've got everything - now insert it in file
	if (needed==2) {
	    strcpy(tmp, "  ");
	    if (dircnt > 1)
		for (j=0; j<dircnt;j++)
		    strcat(tmp, "  ");
	    strcat(tmp, "\"");
	    strcat(tmp, name);
	    strcat(tmp, "\"");
	    strcat(tmp, " EXEC ");
	    strcat(tmp, exec);
	    fprintf(fPtr, "%s\n", tmp);
	    needed=0;
	}
						    
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    if (strstr(st, "_ITEM_")!=0) {
		if (strstr(st, ".directory")==0) {
		    skip=0;
		    strcpy(name, "");
		    strcpy(exec, "");
		    needed=0;
		}
		else {
		    strcpy(name, "");
		    strcpy(exec, "");
		    needed=0;
		    skip=1;
		}
	    }
	    else if (strstr(st, "_EXEC_")!=0 && skip==0) {
		needed++;
		strcpy(exec, del_prefix(st, "_EXEC_"));
		if (strstr(exec, "-caption")!=0)
		    exec[strlen(exec)-strlen(strstr(exec,"-caption"))-1]='\0';
	    }
	    else if (strstr(st, "_NAME_")!=0 && skip==0) {
		needed++;
		strcpy(name, del_prefix(st, "_NAME_"));
	    }
	    else if (strstr(st, "_DIR_")!=0) {
		strcpy(enddir, del_prefix(st, "_DIR_"));
		strcpy(tmp, "  ");
		if (dircnt>1)
		    for (j=0;j<dircnt;j++)
			strcat(tmp, "  ");
		strcat(tmp, "\"");
		strcat(tmp, enddir);
		strcat(tmp, "\" MENU");
		fprintf(fPtr, "%s\n", tmp);
		dircnt++;
	    }
	    else if (strstr(st, "_ENDDIR_")!=0) {
		strcpy(tmp, "  ");
		if (dircnt>1)
		    for (j=0; j<dircnt-1;j++)
			strcat(tmp, "  ");
		strcat(tmp, "\"");
		strcat(tmp, enddir);
		strcat(tmp, "\" END");
		fprintf(fPtr, "%s\n", tmp);
		dircnt--;
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    fprintf(fPtr, "\"Converted\" END\n");
    fclose(fPtr);
    return 0;
}

int wm2buf(char *fname) {
    int skip=0; // 1-start skipping lines, 0-read all
    FILE *fPtr;
    char st[256], tmp[256], tmp1[256];
    int ch, i=0;
    
    if ((fPtr=fopen(fname, "r"))==NULL) {
	sprintf(tmp1, "Can't open source WindowMaker menu: %s\n", fname);
	print_err(tmp1);
	return 666;
    }
    while ((ch=fgetc(fPtr))!=EOF) {
	if (ch=='\n') {
	    st[i]='\0';
	    i=0;
	    strcpy(st, del_leading_space(st));
	    if (skip) {
		if (strstr(st, "*/")) skip=0;
	    }
	    else {
		if (strstr(st, "/*")) skip=1;
		else {
		    if (strstr(st, "//")) {
			strcpy(st, del_ext(st, strstr(st, "//")));
		    }
		    if (strstr(st, "MENU") && strstr(st, "_MENU")==0) {
			strcpy(st, get_name_q(st));
			fprintf(fTmp, "_DIR_%s\n", st);
			fprintf(fTmp, "_ITEM_.directory\n");
			fprintf(fTmp, "_NAME_%s\n", st);
//                        fprintf(fTmp, "_ICON_NONE\n");
		    }
		    else if (strstr(st, "END")) {
			strcpy(st, get_name_q(st));
			fprintf(fTmp, "_ENDDIR_\n");
		    }
		    else if (strstr(st, "OPEN_MENU") &&
			    strstr(st, "_DIR")==0) {
/*                        strcpy(tmp, get_name_q(st));
			strcpy(tmp1, "\"");
			strcat(tmp1, tmp);
			strcat(tmp1, "\"");
			strcat(tmp1, " OPEN_MENU ");
			strcpy(tmp, currdir);
			strcat(tmp, "/");
			strcat(tmp, del_prefix(st, tmp1));*/

			// get filename
			strcpy(tmp1, "\"");
			strcat(tmp1, get_name_q(st));
			strcat(tmp1, "\"");
			strcat(tmp1, " OPEN_MENU ");
			strcpy(tmp, del_prefix(st, tmp1));
			if (strchr(tmp, '/')) // we have it with the path
			    wm2buf(tmp);
			else { // fetch the path of the last file
			    tmp1[0]=0;
			    int j00=strlen(fname)-strlen(strrchr(fname, '/'))+1;
			    strncpy(tmp1, fname, j00);
			    tmp1[j00]=0;
			    strcat(tmp1, tmp);
			    wm2buf(tmp1);
			}
		    }
		    else if (strstr(st, "EXEC") || strstr(st, "SHEXEC")) {
			strcpy(tmp, get_name_q(st));
			strcpy(tmp1, remove_invalid(tmp));
			fprintf(fTmp, "_ITEM_%s\n_NAME_%s\n", tmp1, tmp);
			fprintf(fTmp, "_TYPE_Application\n");
			strcpy(tmp1, "\"");
			strcat(tmp1, tmp);
			strcat(tmp1, "\"");
			if (strstr(st, "SHEXEC"))
			    strcat(tmp1, " SHEXEC ");
			else 
			    strcat(tmp1, " EXEC ");
			strcpy(tmp, del_prefix(st, tmp1));
			fprintf(fTmp, "_EXEC_%s\n", tmp);
		    }
		}
	    }
	}
	else {
	    st[i]=ch;
	    i++;
	}
    }
    return 0;
}


