/*
 * menushki: -- converts the menus between different Desktop Environments
 * Copyright (C) 2001 Alex "Loki" Agibalov <loki_bg@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Main file for the project */

#include <stdio.h>
#include <curses.h>
#include <stdlib.h>
#include <dirent.h>
#include <string.h>
#include <unistd.h>

#include "menushki.h"
#include "glob.h"
#include "editor.h"
#include "functs.h"
#include "m_kde.h"
#include "m_wm.h"
#include "m_ice.h"
#include "m_gnome.h"
#include "m_bb.h"
#include "m_enl.h"

#include "konst.ui.window.h"
#include "konst.ui.menu.h"
#include "konst.ui.input.h"

void show_welcome(void) {
    textwindow tw_w(0, 0, 65, 12, color(1), TW_CENTERED);
    tw_w.set_title(boldcolor(1), " [ menushki v1.0 ] ");
    tw_w.open();
    tw_w.write(2, 2, "Please, make your choice:");
    tw_w.write(5, 4, "Editor - to edit the existing menu");
    tw_w.write(5, 5, "(not completely implemented, yet)");
    tw_w.write(5, 7, "Any other top menu (execept Exit, of course) is");
    tw_w.write(5, 8, "the source format, and its sub-menu - destination.");
//    tw_w.close();
}

// Whether menu is a path to file structure (ret 1) or filename (ret 0)
int isPath(char *mType) {
    if (strstr(mType, "KDE") || strstr(mType, "GNOME")) return 1;
	else return 0;
}

// Get the menu path (and filename if applicable)
char *get_name(char *mType, char *mWhich) {
    char s[256];
    bool bPath=isPath(mType);

    if (strstr(mWhich, "source")) {
	textwindow tw(5, 3, 60, 20, color(1));
	if (bPath)
	    tw.set_title(boldcolor(1), " [ Directory name ] ");
	else
	    tw.set_title(boldcolor(1), " [ File name ] ");
	tw.open();
	if (bPath)
	    sprintf(s, "Choose the source %s dir (with space)", mType);
	else
	    sprintf(s, "Choose the source %s file", mType);
	tw.write(2, 1, s);
	
	filemanager fm(5, 5, 60, 20, color(1), boldcolor(1), boldcolor(3), color(2), boldcolor(1));
//    fm.setstartpoint(currdir);
	fm.multi = false;
	fm.fullpath = true; // orig: true
	//fm.onlydirs = false; // orig: false
	fm.onlydirs=bPath;
	fm.chroot = true; // orig: true
	fm.open();
	fm.close();
	tw.close();
//    chdir(currdir);
//        printf((char *) fm.selected->at(0));
//        getkey();
    
	if (fm.selected->count==0) return "";
	sprintf(retBuf, "%s", (char *) fm.selected->at(0));
	return retBuf;
    }

//    clear();
    textinputline line(boldcolor(2));
    textwindow tw(5, 5, 60, 15, color(1), TW_CENTERED);
    tw.set_title(boldcolor(1), " [ File name ] ");
    tw.open();
    sprintf(s, "Enter the path %s", isPath(mType)?"to ":"and filename for");
    if (strstr(mWhich, "dest") && strstr(mType, "nlight"))
	sprintf(s, "Enter the path of ");
    tw.write(2, 2, s);
    sprintf(s, "the %s %s menu:", mWhich, mType);
    tw.write(2, 3, s);
    tw.write(2, 4, "(you can't use ~ for now)");
    strcpy(retBuf, line.open(tw.x1+3, tw.y1+6, "noname", 40, 255));
    tw.close();

    return retBuf;
}

// Whether such file/path exists
int isExists(char *fPath, char *mType) {
    DIR *dir;
    FILE *fPtr;
    if (isPath(mType)) {
	if ((dir=opendir(fPath))==NULL) return 0;
	else {
	    closedir(dir);
	    return 1;
	}
    }
    else {
	if ((fPtr=fopen(fPath, "r"))==NULL) return 0;
	else {
	    fclose(fPtr);
	    return 1;
	}
    }
}

// print error message
void print_err(char *reason) {
    textwindow tw(0, 10, 65, 13, color(1), TW_CENTERED);
    tw.set_title(boldcolor(1), " [ Error ] ");
    tw.open();
    tw.write(33-strlen(reason)/2, 2, reason);
    getkey();
//    tw.close();
}


int main(int argc, char **argv) {
    int src, dest;
    char src_name[256], dest_name[256], s0[256], s01[256], s02[256], s03[256];
    char *src_namePtr=src_name;
    char *dest_namePtr=dest_name;
    int i;

    // get current dir
    sprintf(currdir, "%s", getcwd(NULL, 0));

    kinterface();
    init_pair(1, COLOR_WHITE, COLOR_BLUE);
    init_pair(2, COLOR_BLACK, COLOR_WHITE);
    init_pair(3, COLOR_YELLOW, COLOR_BLUE);

    show_welcome();
    
    int im;
    int hor_menu, vert_menu;
    int rres;
// Start main program circle
for (;;) {
    horizontalmenu menu(1, 0, boldcolor(1), color(2), color(1));
    menu.additem(" Editor ");
    for (int im0=0; im0 < MENUITEMS-1; im0++)
	menu.pulldown(0)->additem(mainmenu[im0]);
	
    for (im=0; im < MENUITEMS-1; im++) {
	menu.additem(mainmenu[im]);
	for (int im0=0; im0 < MENUITEMS-1; im0++)
	    menu.pulldown(1+im)->additem(mainmenu[im0]);
    }
    
    menu.additem(" Exit ");
    menu.pulldown(1+im)->additem(" YES ");

    menu.open(&hor_menu, &vert_menu);
    menu.close();
    
    src=hor_menu-2;
    dest=vert_menu-1;
		    
    if (hor_menu < 1 || hor_menu > MENUITEMS+2 ||
	vert_menu < 1 || vert_menu > MENUITEMS+1) {
	    exit(0);
    }
    switch(hor_menu) {
	case MENUITEMS+1:
	    exit(0);
	    break;
	case 1: // menu editor
	    strcpy(src_namePtr, get_name(mainmenu[dest], "source"));
	    if (strlen(src_namePtr)==0) break;
	    
	    if (fTmp=tmpfile()) {
	    // for debugging
//            if ((fTmp=fopen("tmp1.$$$", "wb+"))!=NULL) {
		if (strstr(mainmenu[dest], "KDE")) rres=kde2buf(src_namePtr);
		if (strstr(mainmenu[dest], "WindowMaker")) rres=wm2buf(src_namePtr);
		if (strstr(mainmenu[dest], "IceWM")) rres=ice2buf(src_namePtr);
		if (strstr(mainmenu[dest], "GNOME")) rres=gnome2buf(src_namePtr);
		if (strstr(mainmenu[dest], "BlackBox")) rres=bb2buf(src_namePtr);
		if (strstr(mainmenu[dest], "nlight")) rres=enl2buf(src_namePtr);
		rewind(fTmp);
		if (rres==0) {
		    // we pass and get the name cuz there are 'save' and 'save as' inside
		    strcpy(src_namePtr, launch_editor(mainmenu[dest], src_namePtr));
		}
		fclose(fTmp);
	    }
//            show_welcome();
	    break; // end of menu editor cycle
	default:
	    // enter the name and path of source menu
	    strcpy(src_namePtr, get_name(mainmenu[src], "source"));
	    if (strlen(src_namePtr)==0) break;
	    // check whether it exists
	    if (isExists(src_namePtr, mainmenu[src])==0) {
		sprintf(s00, "Invalid name: %s\n", src_namePtr);
		print_err(s00);
	    }
	    else {
 
		// enter the name and path of dest menu
		strcpy(dest_namePtr, get_name(mainmenu[dest], "destination"));
		if (strlen(dest_namePtr)==0) break;
    
		// for debugging purposes - use first line, 
		// for release - the second
//                    if ((fTmp=fopen("tmp.$$$", "w+"))!=NULL) {
		if (fTmp=tmpfile()) {
		    // move src menu to structure
		    if (strstr(mainmenu[src], "KDE")) rres=kde2buf(src_namePtr);
		    if (strstr(mainmenu[src], "WindowMaker")) rres=wm2buf(src_namePtr);
		    if (strstr(mainmenu[src], "IceWM")) rres=ice2buf(src_namePtr);
		    if (strstr(mainmenu[src], "GNOME")) rres=gnome2buf(src_namePtr);
		    if (strstr(mainmenu[src], "BlackBox")) rres=bb2buf(src_namePtr);
		    if (strstr(mainmenu[src], "nlight")) rres=enl2buf(src_namePtr);
	
		    // BUG: wrong _ENDMENU_ name if many subfolders
    
		    // add missing entries (for KDE only Type&Exec are essential)
		    // TODO !!!!!!!!!!!
		    if (rres==0) {        
			rewind(fTmp);
			// move structure to dest menu
			if (strstr(mainmenu[dest], "KDE")) rres=buf2kde(dest_namePtr);
			if (strstr(mainmenu[dest], "WindowMaker")) rres=buf2wm(dest_namePtr);
			if (strstr(mainmenu[dest], "IceWM")) rres=buf2ice(dest_namePtr);
			if (strstr(mainmenu[dest], "GNOME")) rres=buf2gnome(dest_namePtr);
			if (strstr(mainmenu[dest], "BlackBox")) rres=buf2bb(dest_namePtr);
			if (strstr(mainmenu[dest], "nlight")) rres=buf2enl(dest_namePtr, "Converted");
		    }        
		    // or validate here instead of missing entries before
	
		    fclose(fTmp);
		    if (rres==0) {
			//      Printing instructions
			clear();
			sprintf(s0, "Successfully converted %s menu from", mainmenu[src]);

			textwindow tw(0, 0, 65, 18, color(1), TW_CENTERED);
			tw.set_title(boldcolor(1), " [ Final instructions ] ");
			tw.open();
			tw.write(33-strlen(s0)/2, 3, s0);
			sprintf(s0, "to %s menu in", mainmenu[dest]);
			tw.write(33-strlen(src_namePtr)/2, 5, src_namePtr);
			tw.write(33-strlen(s0)/2, 7, s0);
			tw.write(33-strlen(dest_namePtr)/2, 9, dest_namePtr);

			if (strstr(mainmenu[dest], "KDE")) {
			    sprintf(s0, "Now copy the \"%s\" directory wherever you want", dest_namePtr);
			    sprintf(s01, "and symlink it from kde applnk directory (or copy there)");
			    sprintf(s02, "(usually ~/.kde/share/applnk or /usr/share/applnk)");
			    sprintf(s03, "In KDE menu it will appear under \"personal\" folder.");
			}

			if (strstr(mainmenu[dest], "WindowMaker")) {
			    sprintf(s0, "Now copy the file \"%s\" to", dest_namePtr);
			    sprintf(s01, "~/GNUstep/Library/WindowMaker directory");
			    sprintf(s02, "And insert the following line in your menu[.LANG] file:");
			    sprintf(s03, "\"Converted\" OPEN_MENU %s", dest_namePtr);
			}

			if (strstr(mainmenu[dest], "GNOME")) {
			    sprintf(s0, "Now copy the \"%s\" directory wherever you want", dest_namePtr);
			    sprintf(s01, "and symlink it from gnome apps directory (or copy there)");
			    sprintf(s02, "(usually ~/.gnome/apps or /usr/share/gnome/apps)");
			    sprintf(s03, "If it's put in ~/.gnome/apps the menu will be under \"Favorites\"");
			}
	
			if (strstr(mainmenu[dest], "IceWM")) {
			    sprintf(s0, "Now either insert the content of \"%s\" in IceWM original menu,", dest_namePtr);
			    sprintf(s01, "(usually ~/.icewm/menu or /usr/local/lib/X11/icewm/menu)");
			    sprintf(s02, "Or replace the existing menu with the new one.");
			    sprintf(s03, "Of course, you should rename the file if needed.");
			}

			if (strstr(mainmenu[dest], "BlackBox")) {
			    sprintf(s0, "Now copy the file \"%s\" wherever you want,", dest_namePtr);
			    sprintf(s01, "and indicate the path to it in your ~/.blackboxrc file,");
			    sprintf(s02, "something like: session.menuFile: /usr/share/BlackBox/%s", dest_namePtr);
			    sprintf(s03, "Or just copy the content of \"%s\" to your existing menu file.", dest_namePtr);
			}

			if (strstr(mainmenu[dest], "nlight")) {
			    sprintf(s0, "Now copy the directory %s to ", dest_namePtr);
			    sprintf(s01, "your ~/.enlightenment folder");
			    sprintf(s02, "And insert the following line in ~./enlightenment/file.menu");
			    sprintf(s03, "\"Converted\" NULL menu \"%s/%s.menu\"", dest_namePtr, dest_namePtr);
			}
	
			tw.write(33-strlen(s0)/2, 12, s0);
			tw.write(33-strlen(s01)/2, 13, s01);
			tw.write(33-strlen(s02)/2, 14, s02);
			tw.write(33-strlen(s03)/2, 15, s03);
			refresh();
//                        tw.close();
		    } // end of "no errors" cycle
		} // end of "create tmp file" cycle
		else print_err("Can't create temporary file!\n");

	    } // end of "source file exists" cycle
	} // end of switch() & default;
//        clear();
    } // end of main cycle
} // EOF menushki.cc


