<?xml version="1.0" encoding="UTF-8"?>
<!--
########################################################################
# metaf-sum.xsl
#
# copyright (c) metaf2xml 2006
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
########################################################################
-->

<xsl:stylesheet
    xmlns:xsl = "http://www.w3.org/1999/XSL/Transform"
    version = "1.0">
 <xsl:output
    method = "html"
    encoding = "UTF-8"
    indent = "yes"
 />

 <!-- this must be passed with "- -stringparam name value" from xsltproc -->
 <xsl:param name="lang"/>

 <xsl:variable name="NM2KM" select="1.852"/>
 <xsl:variable name="FT2M" select="0.3048"/>
 <xsl:variable name="SM2M" select="1609.3412196"/> <!-- statute mile! -->
 <xsl:variable name="METER_PER_SEC2KT" select="3.6 div $NM2KM"/>
 <xsl:variable name="INHG2HPA" select="33.86388640341"/>

 <xsl:template match="data">
  <table border="1" cellpadding="2">
  <xsl:choose>
   <xsl:when test="$lang = 'en'">
    <xsl:apply-templates select="metafList/taf|metafList/metar">
     <xsl:with-param name="trans" select="document('metaf-lang.xsl')//trans/en"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:when test="$lang = 'es'">
    <xsl:apply-templates select="metafList/taf|metafList/metar">
     <xsl:with-param name="trans" select="document('metaf-lang.xsl')//trans/es"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:when test="$lang = 'ru'">
    <xsl:apply-templates select="metafList/taf|metafList/metar">
     <xsl:with-param name="trans" select="document('metaf-lang.xsl')//trans/ru"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates select="metafList/taf|metafList/metar">
     <xsl:with-param name="trans" select="document('metaf-lang.xsl')//trans/de"/>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
  </table>
  <xsl:text>&#10;</xsl:text>
   <xsl:comment> metaf: $Id: metaf-sum.xsl,v 1.1 2006/11/07 07:36:21 metaf2xml Exp $ </xsl:comment>
   <xsl:text>&#10;</xsl:text>
   <xsl:comment>
   <xsl:value-of select="concat(' metaf-lang: ', document('metaf-lang.xsl')//trans/version, ' ')"/>
   </xsl:comment>
   <xsl:text>&#10;</xsl:text>
   <xsl:apply-templates select="versionList/version"/>
   <xsl:comment> end of data </xsl:comment>
 </xsl:template>

 <xsl:template match="version">
  <xsl:comment><xsl:value-of select="concat(' ', ., ' ')"/></xsl:comment>
  <xsl:text>&#10;</xsl:text>
 </xsl:template>

 <xsl:template match="metar">
  <xsl:param name="trans"/>
  <tr>
  <td nowrap="1"><xsl:apply-templates select="obsStation"/></td>
  <td nowrap="1"><xsl:apply-templates select="obsTime"/></td>
  <xsl:apply-templates select="sfcWind">
   <xsl:with-param name="trans" select="$trans"/>
  </xsl:apply-templates>
  <xsl:choose>
   <xsl:when test="boolean(CAVOK)">
    <td colspan="3">CAVOK</td>
   </xsl:when>
   <xsl:otherwise>
    <td nowrap="1">
    <xsl:apply-templates select="visPrev">
     <xsl:with-param name="trans" select="$trans"/>
    </xsl:apply-templates>
    <xsl:apply-templates select="visMin">
     <xsl:with-param name="trans" select="$trans"/>
    </xsl:apply-templates>
    </td>
    <td nowrap="1"><xsl:apply-templates select="weatherList/weather"/></td>
    <td nowrap="1">
     <xsl:apply-templates select="cloudList/cloud"/>
     <xsl:apply-templates select="visVert"/>
    </td>
   </xsl:otherwise>
  </xsl:choose>
  <td nowrap="1"><xsl:apply-templates select="temperature/air/temp"/></td>
  <td nowrap="1"><xsl:apply-templates select="temperature/dewpoint/temp"/></td>
  <td nowrap="1">
  <xsl:apply-templates select="QNH">
   <xsl:with-param name="trans" select="$trans"/>
  </xsl:apply-templates>
  </td>
  <td nowrap="1"><xsl:apply-templates select="notRecognised"/></td>
  <td nowrap="1">
  <xsl:choose>
   <xsl:when test="boolean(ERROR)">
    <xsl:value-of select="substring-before(ERROR/pos/@v, '&lt;')"/>
    <b>
    <xsl:value-of select="substring-after(ERROR/pos/@v, '&gt;')"/>
    </b>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="@s"/>
   </xsl:otherwise>
  </xsl:choose>
  </td>
  </tr>
 </xsl:template>

 <xsl:template match="obsStation">
  <xsl:value-of select="id/@v"/>
 </xsl:template>

 <xsl:template match="obsTime">
  <xsl:choose>
   <xsl:when test="boolean(invalidFormat)">
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="concat(day/@v, hour/@v, minute/@v)"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="visPrev">
  <xsl:param name="trans"/>
  <xsl:call-template name="visibility">
   <xsl:with-param name="notavail" select="N/A"/>
   <xsl:with-param name="rnd_m" select="50"/>
   <xsl:with-param name="unitThreshold" select="1000"/>
   <xsl:with-param name="visVal" select="."/>
   <xsl:with-param name="trans" select="$trans"/>
  </xsl:call-template>
 </xsl:template>

 <xsl:template match="visVert">
  <xsl:choose>
   <xsl:when test="boolean(invalidFormat)">
   </xsl:when>
   <xsl:when test="boolean(notAvailable)">
    <xsl:text>N/A</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>VV</xsl:text>
    <xsl:value-of select="format-number(distance/@v, '000')"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template name="visibility">
  <xsl:param name="visVal"/>
  <xsl:param name="unitThreshold"/>
  <xsl:param name="trans"/>
  <xsl:choose>
   <xsl:when test="boolean($visVal/invalidFormat)">
   </xsl:when>
   <xsl:when test="boolean($visVal/notAvailable)">
    <xsl:text>N/A</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:variable name="lt_gt">
     <xsl:choose>
      <xsl:when test="boolean($visVal/isLess)">
       <xsl:text>&lt;</xsl:text>
      </xsl:when>
      <xsl:when test="boolean($visVal/isGreater)">
       <xsl:text>&gt;</xsl:text>
      </xsl:when>
      <xsl:when test="boolean($visVal/isEqualGreater)">
       <xsl:text>&gt;=</xsl:text>
      </xsl:when>
      <xsl:otherwise></xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:variable name="vis">
     <xsl:choose>
      <xsl:when test="$visVal/unitLength/@v = 'M'">
       <xsl:choose>
        <xsl:when test="$visVal/distance/@v = 0">&lt;|50</xsl:when>
        <xsl:when test="$visVal/distance/@v = 9999">&gt;=|10000</xsl:when>
        <xsl:otherwise>
        <xsl:value-of select="concat($lt_gt, '|', $visVal/distance/@v)"/>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:when>
      <xsl:when test="$visVal/unitLength/@v = 'KM'">
       <xsl:text>|</xsl:text><xsl:value-of select="$visVal/distance/@v * 1000"/>
      </xsl:when>
      <xsl:when test="$visVal/unitLength/@v = 'SM'">
       <xsl:value-of select="concat($lt_gt, '|', $visVal/distance/@v * $SM2M)"/>
      </xsl:when>
      <xsl:when test="$visVal/unitLength/@v = 'FT' or $visVal/unitHeight/@v = 'FT'">
       <xsl:value-of select="concat($lt_gt, '|', $visVal/distance/@v * $FT2M)"/>
      </xsl:when>
      <xsl:when test="$visVal/unitHeight/@v = 'FL'">
       <xsl:value-of select="concat($lt_gt, '|', $visVal/distance/@v * 100 * $FT2M)"/>
      </xsl:when>
     </xsl:choose>
    </xsl:variable>
    <xsl:call-template name="printVis">
     <xsl:with-param name="vis" select="$vis"/>
     <xsl:with-param name="compassDir" select="$visVal/compassDir/@v"/>
     <xsl:with-param name="rnd_m" select="50"/>
     <xsl:with-param name="unitThreshold" select="$unitThreshold"/>
     <xsl:with-param name="trans" select="$trans"/>
    </xsl:call-template>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template name="printVis">
  <xsl:param name="vis"/>
  <xsl:param name="compassDir"/>
  <xsl:param name="fromto"/>
  <xsl:param name="rnd_m"/>
  <xsl:param name="unitThreshold"/>
  <xsl:param name="trans"/>
  <xsl:variable name="amountMeter" select="substring-after($vis, '|')"/>
  <xsl:variable name="lt_gt" select="substring-before($vis, '|')"/>
  <xsl:value-of select="$fromto"/>
  <xsl:value-of select="$lt_gt"/>
  <xsl:choose>
   <xsl:when test="$amountMeter &gt;= $unitThreshold">
    <xsl:value-of select="concat(format-number($amountMeter div 1000,'0.#'), $trans/units[@o='KM'])"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="concat(format-number($amountMeter div $rnd_m ,'#0') * $rnd_m, $trans/units[@o='M'])"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$compassDir != ''">
    <xsl:value-of select="concat(' ', $compassDir)"/>
  </xsl:if>
 </xsl:template>

 <xsl:template match="sfcWind|gridWind">
  <xsl:param name="trans"/>
  <xsl:variable name="this" select="."/>
  <xsl:apply-templates select="wind">
   <xsl:with-param name="hdr"   select="$trans/hdr[@o=name($this)]"/>
   <xsl:with-param name="s"     select="@s"/>
   <xsl:with-param name="trans" select="$trans"/>
  </xsl:apply-templates>
 </xsl:template>

 <xsl:template match="wind">
  <xsl:param name="hdr"/>
  <xsl:param name="s"/>
  <xsl:param name="trans"/>
  <xsl:variable name="this" select="."/>
  <xsl:choose>
   <xsl:when test="boolean(invalidFormat)">
    <td colspan="2"></td>
   </xsl:when>
   <xsl:when test="boolean(notAvailable)">
    <td colspan="2"><xsl:text>N/A</xsl:text></td>
   </xsl:when>
   <xsl:when test="dir/@v = '0' and speed/@v = '0' and not(boolean(gustSpeed))">
    <td colspan="2"><xsl:value-of select="$trans/t[@o='calm']"/></td>
   </xsl:when>
   <xsl:otherwise>
    <xsl:variable name="dir">
     <xsl:choose>
      <xsl:when test="boolean(dirNotAvailable)">
       <xsl:text>N/A</xsl:text>
      </xsl:when>
      <xsl:when test="boolean(dirVariable)">
       <xsl:text>VRB</xsl:text>
      </xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="concat(dir/@v, '°')"/>
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="dir/@v = '0' and speed/@v = '0'">
      <td colspan="2"><xsl:value-of select="$trans/t[@o='calm']"/></td>
     </xsl:when>
     <xsl:when test="boolean(speedNotAvailable)">
      <td><xsl:value-of select="$dir"/></td>
      <td></td>
     </xsl:when>
     <xsl:otherwise>
      <xsl:variable name="speed">
       <xsl:call-template name="speed2kt">
        <xsl:with-param name="speed" select="speed/@v"/>
        <xsl:with-param name="unit" select="unitSpeed/@v"/>
       </xsl:call-template>
      </xsl:variable>
      <td nowrap="1"><xsl:value-of select="$dir"/></td>
      <td nowrap="1">
      <xsl:call-template name="printSpeed">
       <xsl:with-param name="speed" select="$speed"/>
       <xsl:with-param name="delim" select="'&#9;&#9;'"/>
       <xsl:with-param name="greater" select="speedGreater/@v"/>
       <xsl:with-param name="trans" select="$trans"/>
      </xsl:call-template>
      </td>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
  <td nowrap="1">
  <xsl:if test="boolean(gustSpeed)">
   <xsl:variable name="gustSpeed">
    <xsl:call-template name="speed2kt">
     <xsl:with-param name="speed" select="gustSpeed/@v"/>
     <xsl:with-param name="unit" select="unitSpeed/@v"/>
    </xsl:call-template>
   </xsl:variable>
   <xsl:call-template name="printSpeed">
    <xsl:with-param name="speed" select="$gustSpeed"/>
    <xsl:with-param name="delim" select="'&#9;&#9;&#9;'"/>
    <xsl:with-param name="greater" select="gustSpeedGreater/@v"/>
    <xsl:with-param name="trans" select="$trans"/>
   </xsl:call-template>
  </xsl:if>
  </td>
  <td nowrap="1">
  <xsl:if test="boolean(windVarLeft)">
   <xsl:value-of select="concat(windVarLeft/@v, '°-', windVarRight/@v, '°')"/>
  </xsl:if>
  </td>
 </xsl:template>

 <xsl:template name="printSpeed">
  <xsl:param name="speed"/>
  <xsl:param name="delim"/>
  <xsl:param name="greater"/>
  <xsl:param name="trans"/>
  <xsl:variable name="gt">
   <xsl:if test="$greater != ''">&gt;</xsl:if>
  </xsl:variable>
  <xsl:value-of select="concat($gt, format-number($speed, '0.#'), $trans/units[@o='KT'])"/>
 </xsl:template>

 <xsl:template name="speed2kt">
  <xsl:param name="speed"/>
  <xsl:param name="unit"/>
  <xsl:choose>
   <xsl:when test="$unit = 'KT'">
    <xsl:value-of select="$speed"/>
   </xsl:when>
   <xsl:when test="$unit = 'KMH'">
    <xsl:value-of select="$speed div $NM2KM"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:value-of select="$speed * $METER_PER_SEC2KT"/>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="weather">
  <xsl:if test="position() != 1"><xsl:value-of select="' '"/></xsl:if>
  <xsl:apply-templates select="intensity"/>
  <xsl:apply-templates select="descriptor"/>
  <xsl:apply-templates select="phenomenon"/>
 </xsl:template>

 <xsl:template match="intensity">
  <xsl:if test="@v = 'HEAVY'">+</xsl:if>
  <xsl:if test="@v = 'LIGHT'">-</xsl:if>
 </xsl:template>

 <xsl:template match="descriptor">
  <xsl:value-of select="@v"/>
 </xsl:template>

 <xsl:template match="phenomenon">
  <xsl:value-of select="@v"/>
 </xsl:template>

 <xsl:template match="cloud">
  <xsl:if test="position() != 1"><xsl:value-of select="' '"/></xsl:if>
  <xsl:choose>
   <xsl:when test="boolean(invalidFormat)">
   </xsl:when>
   <xsl:when test="boolean(notAvailable)">
    <xsl:text>N/A</xsl:text>
   </xsl:when>
   <xsl:when test="boolean(noClouds)">
    <xsl:value-of select="noClouds/@v"/>
   </xsl:when>
   <xsl:otherwise>
    <xsl:variable name="cloud">
     <xsl:value-of select="cloudCover/@v"/>
     <xsl:choose>
      <xsl:when test="boolean(baseBelowStation)">///</xsl:when>
      <xsl:otherwise>
       <xsl:value-of select="format-number(cloudBase/@v, '000')"/>
      </xsl:otherwise>
     </xsl:choose>
     <xsl:if test="boolean(cloudType)">
      <xsl:value-of select="cloudType/@v"/>
     </xsl:if>
     <xsl:if test="boolean(cloudTypeNotAvailable)">
      <xsl:text>///</xsl:text>
     </xsl:if>
    </xsl:variable>
    <xsl:choose>
     <xsl:when test="boolean(isCeiling)">
      <b><xsl:value-of select="$cloud"/></b>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="$cloud"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="temp">
  <xsl:call-template name="printTemp">
   <xsl:with-param name="temp" select=".."/>
  </xsl:call-template>
 </xsl:template>

 <xsl:template match="notRecognised">
  <xsl:value-of select="@s"/>
 </xsl:template>

 <xsl:template name="printTemp">
  <xsl:param name="temp"/>
  <xsl:choose>
   <xsl:when test="boolean($temp/notAvailable)">
    <xsl:text>N/A</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:choose>
     <xsl:when test="$temp/unitTemp/@v = 'C'">
      <xsl:value-of select="$temp/temp/@v"/>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="format-number(($temp/temp/@v - 32) div 1.8, '0.#')"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text> °C</xsl:text>
 </xsl:template>

 <xsl:template match="QNH|somePressure|SLPdPa|SLPinHg|regQNH|QFE|QFF">
  <xsl:param name="trans"/>
  <xsl:if test="boolean(inHg) or boolean(hPa) or boolean(mmHg)">
   <xsl:choose>
    <xsl:when test="boolean(hPa)">
     <xsl:value-of select="hPa/@v"/>
    </xsl:when>
    <xsl:when test="boolean(mmHg)">
     <xsl:value-of select="format-number(mmHg/@v div ($FT2M div 12 * 1000) * $INHG2HPA, '0')"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="format-number(inHg/@v * $INHG2HPA, '0')"/>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:value-of select="$trans/units[@o='hPa']"/>
  </xsl:if>
  <xsl:if test="boolean(notAvailable)">
   <xsl:text>N/A</xsl:text>
  </xsl:if>
 </xsl:template>

 <xsl:template match="remarkList">
  <xsl:param name="trans"/>
  <xsl:text>&#10;</xsl:text>
  <tr>
  <xsl:if test="$method = 'html'">
   <td><b>RMK</b></td>
  </xsl:if>
  <td nowrap="1" colspan="3"><b>
   <xsl:value-of select="$trans/hdr[@o='remarkList']"/>
   <xsl:if test="$method != 'html'">
    <xsl:value-of select="concat('&#10;', $trans/hdr[@o='remarkList_ul'])"/>
   </xsl:if>
  </b></td>
  </tr><xsl:text>&#10;</xsl:text>
  <xsl:apply-templates select="remark">
   <xsl:with-param name="trans" select="$trans"/>
  </xsl:apply-templates>
 </xsl:template>

 <xsl:template match="remark">
  <xsl:param name="trans"/>
  <xsl:variable name="rmk">
   <xsl:value-of select="name(child::*[last()])"/>
  </xsl:variable>
  <xsl:choose>
   <xsl:when test="$rmk = 'cloud'">
    <xsl:apply-templates select="cloud">
     <xsl:with-param name="trans" select="$trans"/>
     <xsl:with-param name="s_list" select="cloud/@s"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:when test="$rmk = 'visRwy'">
    <xsl:apply-templates select="visRwy">
     <xsl:with-param name="trans" select="$trans"/>
     <xsl:with-param name="unitThreshold" select="1000"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates select="child::*[last()]">
     <xsl:with-param name="trans" select="$trans"/>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="visMin">
  <xsl:param name="trans"/>
  <xsl:text>, </xsl:text>
  <xsl:call-template name="visibility">
   <xsl:with-param name="notavail" select="$trans/t[@o='notAvailable']"/>
   <xsl:with-param name="rnd_m" select="10"/>
   <xsl:with-param name="unitThreshold" select="1000"/>
   <xsl:with-param name="visVal" select="."/>
   <xsl:with-param name="trans" select="$trans"/>
  </xsl:call-template>
 </xsl:template>

</xsl:stylesheet>
