<?xml version="1.0" encoding="UTF-8"?>
<!--
########################################################################
# metaf-add.xsl
#
# copyright (c) metaf2xml 2006
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
########################################################################
-->

<xsl:stylesheet
    xmlns:xsl = "http://www.w3.org/1999/XSL/Transform"
    xmlns:adddata = "urn:data-section"
    exclude-result-prefixes="adddata"
    version = "1.0">

 <xsl:output
    method = "xml"
    encoding = "UTF-8"
    indent = "yes"
 />

 <xsl:variable name="NM2KM" select="1.852"/>
 <xsl:variable name="FT2M" select="0.3048"/>
 <xsl:variable name="SM2M" select="1609.3412196"/> <!-- statute mile! -->
 <xsl:variable name="METER_PER_SEC2KT" select="3.6 div $NM2KM"/>
 <xsl:variable name="INHG2HPA" select="33.86388640341"/>

 <xsl:template match="metar">
  <xsl:element name="metar">
   <xsl:attribute name="s"><xsl:value-of select="@s"/></xsl:attribute>
   <obsStationInfo>
    <xsl:variable name="this" select="obsStation/id"/>
    <xsl:if test="boolean(obsStation/id)">
     <xsl:copy-of select="document('')//adddata:obsStationInfo/id[@o=$this/@v]/*"/>
    </xsl:if>
   </obsStationInfo>
   <xsl:apply-templates select="*"/>
  </xsl:element>
 </xsl:template>

 <xsl:template match="speed|gustSpeed">
  <xsl:variable name="speed">
   <xsl:choose>
    <xsl:when test="../unitSpeed/@v = 'MPS'">
     <xsl:value-of select="@v * 3.6"/>
    </xsl:when>
    <xsl:when test="../unitSpeed/@v = 'KT'">
     <xsl:value-of select="@v * $NM2KM"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="@v"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:element name="{name()}">
   <xsl:attribute name="v"><xsl:value-of select="$speed"/></xsl:attribute>
  </xsl:element>
 </xsl:template>

 <xsl:template match="unitSpeed">
  <xsl:element name="unitSpeed">
   <xsl:attribute name="v">KMH</xsl:attribute>
  </xsl:element>
 </xsl:template>

 <xsl:template match="temp">
  <xsl:variable name="temp">
   <xsl:choose>
    <xsl:when test="../unitTemp/@v = 'F'">
     <xsl:value-of select="(@v - 32) div 1.8"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="@v"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:element name="temp">
   <xsl:attribute name="v"><xsl:value-of select="$temp"/></xsl:attribute>
  </xsl:element>
 </xsl:template>

 <xsl:template match="unitTemp">
  <xsl:element name="unitTemp">
   <xsl:attribute name="v">C</xsl:attribute>
  </xsl:element>
 </xsl:template>

 <xsl:template match="distance">
  <xsl:variable name="distance">
   <xsl:choose>
    <xsl:when test="../unitLength/@v = 'KM' or ../unitHeight/@v = 'KM'">
     <xsl:value-of select="@v div 1000"/>
    </xsl:when>
    <xsl:when test="../unitLength/@v = 'SM' or ../unitHeight/@v = 'SM'">
     <xsl:value-of select="@v * $SM2M"/>
    </xsl:when>
    <xsl:when test="../unitLength/@v = 'FT' or ../unitHeight/@v = 'FT'">
     <xsl:value-of select="@v * $FT2M"/>
    </xsl:when>
    <xsl:when test="../unitLength/@v = 'FL' or ../unitHeight/@v = 'FL'">
     <xsl:value-of select="@v * $FT2M * 100"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:value-of select="@v"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>
  <xsl:element name="distance">
   <xsl:attribute name="v"><xsl:value-of select="$distance"/></xsl:attribute>
  </xsl:element>
 </xsl:template>

 <xsl:template match="unitLength|unitHeight">
  <xsl:element name="{name()}">
   <xsl:attribute name="v">M</xsl:attribute>
  </xsl:element>
 </xsl:template>

 <xsl:template match="inHg">
  <xsl:element name="hPa">
   <xsl:attribute name="v"><xsl:value-of select="@v * $INHG2HPA"/></xsl:attribute>
  </xsl:element>
 </xsl:template>

 <xsl:template match="mmHg">
  <xsl:element name="hPa">
   <xsl:attribute name="v"><xsl:value-of select="@v div ($FT2M div 12 * 1000) * $INHG2HPA"/></xsl:attribute>
  </xsl:element>
 </xsl:template>

 <xsl:template match="version">
  <xsl:element name="version">
   <xsl:value-of select="."/>
  </xsl:element>
 </xsl:template>

 <xsl:template match="*">
  <xsl:element name="{name()}">
   <xsl:if test="@s != ''">
    <xsl:attribute name="s"><xsl:value-of select="@s"/></xsl:attribute>
   </xsl:if>
   <xsl:if test="@v != ''">
    <xsl:attribute name="v"><xsl:value-of select="@v"/></xsl:attribute>
   </xsl:if>
   <xsl:apply-templates select="*"/>
  </xsl:element>
 </xsl:template>

 <!-- altitude in ft -->
 <adddata:obsStationInfo>
  <id o="AYMO"> <lat>-2.061903</lat> <lon>147.424156</lon> <alt>12</alt> </id>
 </adddata:obsStationInfo>

</xsl:stylesheet>
