<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
    xmlns:xsl = "http://www.w3.org/1999/XSL/Transform"
    version = "1.0">
 <xsl:output
    method = "html"
    encoding = "UTF-8"
    doctype-public = "-//W3C//DTD HTML 4.01 Transitional//EN"
    doctype-system = "http://www.w3.org/TR/html4/loose.dtd"
    indent = "yes"
 />

 <xsl:variable name="method">html</xsl:variable>

 <xsl:include href="metaf.xsl"/>

 <xsl:template match="/">
  <xsl:choose>
   <xsl:when test="data/options/lang/@v = 'en'">
    <xsl:apply-templates select="data">
     <xsl:with-param name="trans" select="document('metaf-lang.xsl')//trans/en"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:when test="data/options/lang/@v = 'es'">
    <xsl:apply-templates select="data">
     <xsl:with-param name="trans" select="document('metaf-lang.xsl')//trans/es"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:when test="data/options/lang/@v = 'ru'">
    <xsl:apply-templates select="data">
     <xsl:with-param name="trans" select="document('metaf-lang.xsl')//trans/ru"/>
    </xsl:apply-templates>
   </xsl:when>
   <xsl:otherwise>
    <xsl:apply-templates select="data">
     <xsl:with-param name="trans" select="document('metaf-lang.xsl')//trans/de"/>
    </xsl:apply-templates>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>

 <xsl:template match="data">
  <xsl:param name="trans"/>
  <xsl:element name="html">
   <xsl:attribute name="lang">
    <xsl:choose>
     <xsl:when test="not (options/lang/@v = 'en' or options/lang/@v = 'es' or options/lang/@v = 'ru')">
      <xsl:text>de</xsl:text>
     </xsl:when>
     <xsl:otherwise>
      <xsl:value-of select="options/lang/@v"/>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:attribute>
  <head>
  <title><xsl:value-of select="$trans/cgi[@o='title']"/></title>
  <meta name="robots" content="noindex,nofollow"/>
  <meta name="keywords"
        content="metaf2xml,METAR,TAF,XML,aviation,weather,report,forecast"/>
  </head>
  <body>
  <h2><xsl:value-of select="$trans/cgi[@o='title']"/></h2>
  <xsl:value-of select="$trans/cgi[@o='infosrc']"/>
  <xsl:text>: </xsl:text>
  <kbd>http://weather.noaa.gov/weather/coded.html</kbd>
  <p />
  <!--b><xsl:value-of select="$trans/cgi[@o='outdated']"/></b>
  <p /-->
  <xsl:value-of select="$trans/cgi[@o='infofetch']"/>
  <p />
  <form method="post"
        action="metaf.pl"
        enctype="application/x-www-form-urlencoded"
        name="processMessage">
  <table border="0" cellspacing="0">
<tr><td colspan="5"><xsl:value-of select="$trans/cgi[@o='example']"/></td></tr>

<tr>
<td />
<td colspan="4" style="font-family: monospace;">
METAR YUDO 090600Z 00000KT CAVOK 22/15 Q1021
</td>
</tr>

<tr>
<td />
<td colspan="4" style="font-family: monospace;">
TAF YUDO 090600Z 090716 VRB03KT 8000 SKC PROB40 TEMPO 0708 0200 +TSRA FM0800 CAVOK
</td>
</tr>

<tr>
<td />
<td colspan="4" style="font-family: monospace;">
FETCH SBGL KJFK RJTT
</td>
</tr>

<tr>
<td nowrap="1"><xsl:value-of select="$trans/cgi[@o='message']"/></td>
<td colspan="4">
 <xsl:element name="input">
  <xsl:attribute name="type">text</xsl:attribute>
  <xsl:attribute name="name">msg</xsl:attribute>
  <xsl:attribute name="size">90</xsl:attribute>
  <xsl:attribute name="maxlength">300</xsl:attribute>
  <xsl:attribute name="style">font-family: monospace;</xsl:attribute>
  <xsl:attribute name="value">
   <xsl:value-of select="options/msg/@v"/>
  </xsl:attribute>
 </xsl:element>
</td>
</tr>

<tr>
<td nowrap="1"><xsl:value-of select="$trans/cgi[@o='type']"/></td>
<td>
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">type</xsl:attribute>
  <xsl:attribute name="value">metar</xsl:attribute>
  <xsl:if test="not (options/type/@v = 'taf')">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>METAR</xsl:text>
</td>
<td colspan="3">
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">type</xsl:attribute>
  <xsl:attribute name="value">taf</xsl:attribute>
  <xsl:if test="options/type/@v = 'taf'">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>TAF</xsl:text>
</td>
</tr>

<tr>
<td nowrap="1"><xsl:value-of select="$trans/cgi[@o='source']"/></td>
<td>
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">source</xsl:attribute>
  <xsl:attribute name="value">noaa</xsl:attribute>
  <xsl:if test="not (options/source/@v = 'adds' or options/source/@v = 'addsds') and not (options/source/@v = 'file')">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
  <xsl:if test="options/source/@v = 'file'">
   <xsl:attribute name="disabled">1</xsl:attribute>
   <xsl:attribute name="readonly">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>NOAA/IWS</xsl:text>
</td>
<td>
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">source</xsl:attribute>
  <xsl:attribute name="value">adds</xsl:attribute>
  <xsl:if test="options/source/@v = 'adds'">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
  <xsl:if test="options/source/@v = 'file'">
   <xsl:attribute name="disabled">1</xsl:attribute>
   <xsl:attribute name="readonly">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>NOAA/ADDS</xsl:text>
</td>
<td colspan="2">
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">source</xsl:attribute>
  <xsl:attribute name="value">addsds</xsl:attribute>
  <xsl:if test="options/source/@v = 'addsds'">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
  <xsl:if test="options/source/@v = 'file'">
   <xsl:attribute name="disabled">1</xsl:attribute>
   <xsl:attribute name="readonly">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>NOAA/ADDS dataserver</xsl:text>
</td>
</tr>

<tr>
<td nowrap="1"><xsl:value-of select="$trans/cgi[@o='language']"/></td>
<td width="16%">
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">lang</xsl:attribute>
  <xsl:attribute name="value">de</xsl:attribute>
  <xsl:if test="not (options/lang/@v = 'en' or options/lang/@v = 'es' or options/lang/@v = 'ru')">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>Deutsch</xsl:text>
</td>
<td width="19%">
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">lang</xsl:attribute>
  <xsl:attribute name="value">en</xsl:attribute>
  <xsl:if test="options/lang/@v = 'en'">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>English</xsl:text>
</td>
<td width="25%">
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">lang</xsl:attribute>
  <xsl:attribute name="value">es</xsl:attribute>
  <xsl:if test="options/lang/@v = 'es'">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>Español</xsl:text>
</td>
<td>
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">lang</xsl:attribute>
  <xsl:attribute name="value">ru</xsl:attribute>
  <xsl:if test="options/lang/@v = 'ru'">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>Русский</xsl:text>
</td>
</tr>

<tr>
<td nowrap="1"><xsl:value-of select="$trans/cgi[@o='format']"/></td>
<td>
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">format</xsl:attribute>
  <xsl:attribute name="value">html</xsl:attribute>
  <xsl:if test="not (options/format/@v = 'text' or options/format/@v = 'xml')">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>HTML</xsl:text>
</td>
<td>
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">format</xsl:attribute>
  <xsl:attribute name="value">text</xsl:attribute>
  <xsl:if test="options/format/@v = 'text'">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>text</xsl:text>
</td>
<td colspan="2">
 <xsl:element name="input">
  <xsl:attribute name="type">radio</xsl:attribute>
  <xsl:attribute name="name">format</xsl:attribute>
  <xsl:attribute name="value">xml</xsl:attribute>
  <xsl:if test="options/format/@v = 'xml'">
   <xsl:attribute name="checked">1</xsl:attribute>
  </xsl:if>
 </xsl:element>
 <xsl:text>XML (+XSL -> HTML)</xsl:text>
</td>
</tr>
</table>

<xsl:element name="input">
 <xsl:attribute name="type">submit</xsl:attribute>
 <xsl:attribute name="value">
  <xsl:value-of select="$trans/cgi[@o='decode']"/>
 </xsl:attribute>
</xsl:element>
</form>
  <p />
  <xsl:if test="options/msg/@v != ''">
   <b><xsl:value-of select="$trans/cgi[@o='disclaimer']"/></b><p />
  </xsl:if>
  <xsl:if test="$method = 'html'">
   <xsl:comment> start of data </xsl:comment>
   <xsl:text>&#10;</xsl:text>
  </xsl:if>
  <xsl:apply-templates select="metafList/taf|metafList/metar">
   <xsl:with-param name="trans" select="$trans"/>
  </xsl:apply-templates>
  <xsl:if test="$method = 'html'">
   <xsl:comment> metaf-fullhtml: $Id: metaf-fullhtml.xsl,v 1.15 2006/10/20 06:04:54 metaf2xml Exp $ </xsl:comment>
   <xsl:text>&#10;</xsl:text>
   <xsl:comment>
   <xsl:value-of select="concat(' metaf-lang: ', document('metaf-lang.xsl')//version, ' ')"/>
   </xsl:comment>
   <xsl:text>&#10;</xsl:text>
   <xsl:apply-templates select="versionList/version"/>
   <xsl:comment> end of data </xsl:comment>
  </xsl:if>
  <p />copyright (c) 2006 metaf2xml @ <a href="http://metaf2xml.sourceforge.net/"><img border="0" src="http://sflogo.sourceforge.net/sflogo.php?group_id=168043&amp;type=1" alt="SourceForge.net Logo"/></a>
  </body>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
