<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
    xmlns:xsl = "http://www.w3.org/1999/XSL/Transform"
    version = "1.0">

 <trans> <!-- thanks to XX.wikipedia.org -->

  <version>$Id: metaf-lang.xsl,v 1.33 2006/11/03 10:08:32 metaf2xml Exp $</version>

  <de>
   <compassDir16>
    <arr>N</arr>
    <arr>NNO</arr>
    <arr>NO</arr>
    <arr>ONO</arr>
    <arr>O</arr>
    <arr>OSO</arr>
    <arr>SO</arr>
    <arr>SSO</arr>
    <arr>S</arr>
    <arr>SSW</arr>
    <arr>SW</arr>
    <arr>WSW</arr>
    <arr>W</arr>
    <arr>WNW</arr>
    <arr>NW</arr>
    <arr>NNW</arr>
    <arr>N</arr>
   </compassDir16>

   <hdr o="metar">Flugplatz-Bericht</hdr>
   <hdr o="metar_ul">=================</hdr>
   <hdr o="speci">Flugplatz-Sonderbericht</hdr>
   <hdr o="speci_ul">=======================</hdr>
   <hdr o="taf">Flugplatz-Vorhersage</hdr>
   <hdr o="taf_hour">|-Stunden Flugplatz-Vorhersage</hdr>
   <hdr o="taf_ul">====================</hdr>
   <hdr o="obsStation">Flugplatz-Kürzel:&#9;</hdr>
   <hdr o="obsTime">Beobachtungszeit:&#9;</hdr>
   <hdr o="issueTime">Ausgabezeit:&#9;&#9;</hdr>
   <hdr o="fcstPeriod">Vorhersagezeitraum:&#9;</hdr>
   <hdr o="visPrev">vorherrschende Sicht:&#9;</hdr>
   <hdr o="visMin">&#9;&#9;&#9;</hdr>
   <hdr o="visRwy">Sicht Piste |:&#9;</hdr>
   <hdr o="visTrend">&#9;Trend:&#9;&#9;</hdr>
   <hdr o="visVert">Vertikale Sicht:&#9;</hdr>
   <hdr o="sfcWind">Bodenwind:&#9;&#9;</hdr>
   <hdr o="weather-1">Wetter:&#9;&#9;&#9;</hdr>
   <hdr o="cloud-1">Bewölkung:&#9;&#9;</hdr>
   <hdr o="ceiling">Hauptwolkenuntergrenze:&#9;</hdr>
   <hdr o="temperature-temp">Temperatur:&#9;&#9;</hdr>
   <hdr o="temperature-dew">Taupunkt:&#9;&#9;</hdr>
   <hdr o="tempHourly-temp">1h-Mittel Temperatur:&#9;</hdr>
   <hdr o="tempHourly-dew">1h-Mittel Taupunkt:&#9;</hdr>
   <hdr o="relHumid">rel. Feuchte:&#9;&#9;</hdr>
   <hdr o="tempMax">max. Temperatur:&#9;</hdr>
   <hdr o="tempMin">min. Temperatur:&#9;</hdr>
   <hdr o="temp6hMax">6h max. Temperatur:&#9;</hdr>
   <hdr o="temp6hMin">6h min. Temperatur:&#9;</hdr>
   <hdr o="temp24hMax">24h max. Temperatur:&#9;</hdr>
   <hdr o="temp24hMin">24h min. Temperatur:&#9;</hdr>
   <hdr o="tempAt">Temperatur:&#9;&#9;</hdr>
   <hdr o="tempMaxFQ">max. Temperatur:&#9;</hdr>
   <hdr o="QNH">Luftdruck:&#9;&#9;</hdr>
   <hdr o="somePressure">anderer Luftdruck:&#9;</hdr>
   <hdr o="stateOfRwy">Status |:&#9;</hdr>
   <hdr o="windShearRwy">|:&#9;&#9;</hdr>
   <hdr o="recentWeather-1">Wetter vor kurzem:&#9;</hdr>
   <hdr o="windShearLvl">WINDSCHERUNG! Wind:&#9;</hdr>
   <hdr o="colourCode">Farb-Kode:&#9;&#9;</hdr>
   <hdr o="cloudMaxCover">max. Bedeckung:&#9;&#9;</hdr>
   <hdr o="cloudCoverVar">Bewölkung:&#9;&#9;</hdr>
   <hdr o="cloudCoverVar2">abwechselnd mit:&#9;&#9;</hdr>
   <hdr o="reportConcerns">Report betrifft:&#9;&#9;</hdr>
   <hdr o="cloudOpacityLvl">Phänomen mit Bedeckung:&#9;</hdr>
   <hdr o="trendList">Änderungen in den nächsten 2 Stunden:</hdr>
   <hdr o="trendList_ul">=====================================</hdr>
   <hdr o="trendListTAF">vorhergesagte Änderungen:</hdr>
   <hdr o="trendListTAF_ul">=========================</hdr>
   <hdr o="remarkList">Bemerkungen:</hdr>
   <hdr o="remarkList_ul">============</hdr>
   <hdr o="visLoc">Sicht|:&#9;</hdr>
   <hdr o="gridWind">Grid Wind:&#9;&#9;</hdr>
   <hdr o="rwyWind">Wind für Piste |:&#9;</hdr>
   <hdr o="thrWind">Wind für Piste |:&#9;</hdr>
   <hdr o="peakWind">Windspitze|:&#9;</hdr>
   <hdr o="SLPhPa">Luftdruck Meeresniveau:&#9;</hdr>
   <hdr o="SLPdPa">Luftdruck Meeresniveau:&#9;</hdr>
   <hdr o="SLPinHg">Luftdruck Meeresniveau:&#9;</hdr>
   <hdr o="regQNH">reg. QNH:&#9;&#9;</hdr>
   <hdr o="QFE">QFE Luftdruck:&#9;&#9;</hdr>
   <hdr o="QFF">QFF Luftdruck:&#9;&#9;</hdr>
   <hdr o="rmkVisMin">Minimalsicht:&#9;&#9;</hdr>
   <hdr o="rmkVisVar">Sicht veränderlich von:&#9;</hdr>
   <hdr o="correctedAt">Bericht korrigiert um:&#9;</hdr>
   <hdr o="precip1Hour">Niederschlagsmenge seit 1h:&#9;</hdr>
   <hdr o="precip3Hour">Niederschlagsmenge seit 3h:&#9;</hdr>
   <hdr o="precip6Hour">Niederschlagsmenge seit 6h:&#9;</hdr>
   <hdr o="precip24Hour">Niederschlagsmenge seit 24h:&#9;</hdr>
   <hdr o="precip36Hour">Niederschlagsmenge seit 3 o. 6h:&#9;</hdr>
   <hdr o="ERROR">Fehler bei '@':&#9;&#9;</hdr>
   <hdr o="SST">Wasseroberflächentemp.:&#9;</hdr>
   <hdr o="OAT">Aussentemperatur:&#9;</hdr>
   <hdr o="AI">AI:&#9;&#9;&#9;</hdr>
   <hdr o="snowIncr">schnell zunehmender Schnee:&#9;</hdr>
   <hdr o="cloudTypeFamily">Wolkentypen:&#10;</hdr>
   <hdr o="windShift">Windveränderung</hdr>
   <hdr o="beginEndPrecip">Niederschlag:&#9;</hdr>
   <hdr o="conditionMountain">Berge:&#9;&#9;&#9;</hdr>
   <hdr o="conditionValley">Täler:&#9;&#9;&#9;</hdr>
   <hdr o="turbulence">Turbulenz:&#9;&#9;</hdr>
   <hdr o="icing">Vereisung:&#9;&#9;</hdr>
   <hdr o="tracesOf">Spuren von:&#9;&#9;</hdr>
   <hdr o="seaCondition">Zustand der See:&#9;</hdr>
   <hdr o="swellCondition">Zustand der Dünung:&#9;</hdr>
   <hdr o="cloudLayer">Wolkenschicht:&#9;&#9;</hdr>
   <hdr o="cloudLayerThin">dünne Wolkenschicht:&#9;</hdr>
   <hdr o="obscuration">Bewölkung infolge |:&#9;</hdr>
   <hdr o="variableCeiling">Wolkenuntergrenze variabel:&#9;</hdr>
   <hdr o="pressureTendency3h">3-h Luftdruck-Tend.:&#9;</hdr>
   <hdr o="ceilVisVariable">Wolkenuntergrenze bei oder unter 900 m und variabel, Sicht von:&#9;</hdr>
   <hdr o="rwySfcCondition">Zustand Pistenoberfläche:&#9;</hdr>
   <hdr o="rainfall">Regenmenge:&#9;&#9;</hdr>
   <hdr o="NEFO_PLAYA">NEFO PLAYA:&#9;&#9;</hdr>
   <hdr o="densityAlt">Dichtehöhe:&#9;</hdr>
   <hdr o="pressureAlt">Druckhöhe:&#9;</hdr>
   <hdr o="obsTimeOffset">Zeitabstand zur Beobachtungszeit:&#9;</hdr>
   <hdr o="nextFcstBy">nächste Vorhersage bis:&#9;</hdr>
   <hdr o="nextFcstAt">nächste Vorhersage:&#9;</hdr>
   <hdr o="amdAt">Ergänzung:&#9;&#9;</hdr>
   <hdr o="fcstAutoObs">Vorhersage basiert auf automatisierter Beobachtung</hdr>
   <hdr o="waterEquivOfSnow">dem Schnee entsprechende Wassermenge am Boden:&#9;</hdr>
   <hdr o="snowOnGround">Schnee am Boden:&#9;&#9;</hdr>
   <hdr o="snowCover">Schneebedeckung:&#9;</hdr>
   <hdr o="fcstNotAvbl">Vorhersage nicht verfügbar:&#9;</hdr>
   <hdr o="temp1">Temperatur 1:&#9;&#9;</hdr>
   <hdr o="temp2">Temperatur 2:&#9;&#9;</hdr>
   <hdr o="precipAmount1">Niederschlag 1:&#9;&#9;</hdr>
   <hdr o="precipAmount2">Niederschlag 2:&#9;&#9;</hdr>
   <hdr o="notRecognised">NICHT ERKANNT:&#9;&#9;</hdr>
   <hdr o="RSNK">Daten für Rattlesnake Mountain:</hdr>
   <hdr o="LAG_PK">Daten für Laguna Peak:</hdr>
   <hdr o="RADAT">Radiosonde-Beobachtungsdaten für 0 °C-Grenze:</hdr>
   <hdr o="freezingLvl">0 °C-Grenze:&#9;&#9;</hdr>
   <hdr o="durationOfSunshine">Sonnenscheindauer gestern:&#9;</hdr>
   <hdr o="hailStones">Hagelkörner:&#9;&#9;</hdr>

   <t o="notAvailable">(nicht verfügbar)</t>
   <t o="invalidFormat">ungültiges Format</t>
   <t o="calm">windstill</t>
   <t o="onThe">am |., </t>
   <t o="dirVariable">aus wechselnden Richtungen</t>
   <t o="dirNotAvailable">Richtung nicht verfügbar,</t>
   <t o="speedNotAvailable"> Geschwindigkeit nicht verfügbar</t>
   <t o="wind-from">aus</t>
   <t o="last">letztes</t>
   <t o="segment">Segment</t>
   <t o="wind-at">mit</t>
   <t o="wind-gusts">&#9;&#9;&#9;Böen</t>
   <t o="cloud-at">in</t>
   <t o="cloud-above">oberhalb</t>
   <t o="cloudTypeNotAvailable">(Wolkentyp nicht beobachtbar)</t>
   <t o="baseBelowStation">Wolkenuntergrenze unterhalb der Station</t>
   <t o="time-at"> um |</t>
   <t o="afterHour">| Minuten nach der vollen Stunde</t>
   <t o="time-from">ab |</t>
   <t o="time-till">bis |</t>
   <t o="variable">&#9;&#9;&#9;veränderlich</t>
   <t o="variable-from">zwischen</t>
   <t o="variable-to">und</t>
   <t o="varying-to">&#9;&#9;bis:&#9;</t>
   <t o="visVertNA">nicht bestimmbar</t>
   <t o="windShear">Windscherung</t>
   <t o="rwyNotInUse">Piste wird nicht benutzt</t>
   <t o="rwyVisNotAvailable">(Sicht nicht verfügbar)</t>
   <t o="rwyDesigAll">alle Pisten</t>
   <t o="rwyDesigRep">vorige Piste</t>
   <t o="rwyDesig">Piste |</t>
   <t o="SNOCLO">Flugplatz geschlossen wegen Schnee</t>
   <t o="cleared">geräumt</t>
   <t o="friction">Reibung: </t>
   <t o="depositExtent"> der Piste bedeckt</t>
   <t o="depositDepth">| hohe Ablagerungen</t>
   <t o="NOSIG">keine wesentlichen Änderungen</t>
   <t o="BECMG">Änderung zu:</t>
   <t o="TEMPO">kurzzeitig:</t>
   <t o="PROB">:</t>
   <t o="CAVOK">Bewölkung und Sicht OK</t>
   <t o="RVRNO">RVR sollte gemeldet werden, fehlt aber</t>
   <t o="PWINO">Sensor für Erkennung des aktuellen Wetters defekt</t>
   <t o="FZRANO">Sensor für Erkennung gefrierenden Regens defekt</t>
   <t o="TSNO">Sensor für Erkennung von Blitzen defekt</t>
   <t o="PNO">Sensor für Regenmessung defekt</t>
   <t o="CHINO">sekundärer Sensor | für Messung der Wolkenuntergrenze defekt</t>
   <t o="VISNO">sekundärer Sensor | für Messung der Sicht defekt</t>
   <t o="NOSPECI">keine Sonderberichte (SPECI) von dieser Station</t>
   <t o="VIA_PHONE">über Telefon</t>
   <t o="RCRNR">Werte für Pistenzustand nicht gemeldet</t>
   <t o="HALO">Halo</t>
   <t o="FROIN">Frost am Messgerät</t>
   <t o="LGT_FROIN">leichter Frost am Messgerät</t>
   <t o="HVY_FROIN">starker Frost am Messgerät</t>
   <t o="VRBL_CONDS">wechselnde Bedingungen</t>
   <t o="ACFT_MSHP">Flugzeugmissgeschick</t>
   <t o="CIG_RAG">Wolkenuntergrenze zerfasert</t>
   <t o="needMaint">Wartung an automatisierter Station notwendig</t>
   <t o="loc-and">und</t>
   <t o="loc-to">bis</t>
   <t o="predictedColour">Vorhersage:</t>
   <t o="prob">mit |% Wahrscheinlichkeit</t>
   <t o="nextDay"> am Folgetag</t>
   <t o="distant"> in der Ferne</t>
   <t o="isStationary"> ortsfest</t>
   <t o="obscgMtns"> verdecken die Berge</t>
   <t o="isGrid"> Grid</t>
   <t o="quadrant">Quadrant</t>
   <t o="snowIncrPastHour">| in. seit 1h</t>
   <t o="snowIncrOnGround">| in. am Boden</t>
   <t o="low">niedrig:&#9;&#9;</t>
   <t o="middle">mittel:&#9;&#9;</t>
   <t o="high">hoch:&#9;&#9;</t>
   <t o="cloudLayerAboveOvercast">Wolken oberhalb geschlossener Wolkendecke</t>
   <t o="FROPA">wegen Durchzug einer Front</t>
   <t o="MOV"> zieh(t,en)</t>
   <t o="MOVD"> zog(en)</t>
   <t o="began">begann</t>
   <t o="ended">endete</t>
   <t o="compassDirLocation"> im|</t>
   <t o="compassDirTo"> nach|</t>
   <t o="compassDirFrom"> aus Richtung|</t>
   <t o="compassDirThrough"> bis|</t>
   <t o="compassDirDescr"> |en</t>
   <t o="compassDirDescrQuad"> |-Quadrant</t>
   <t o="isLower">niedrig(e,er)</t>
   <t o="isLow">niedrig(e,er)</t>
   <t o="isFrequent">häufig(e,er)</t>
   <t o="isOccasional">gelegentlich(e,er)</t>
   <t o="isThick">dick(e,er)</t>
   <t o="isPrettyThick">ziemlich dick(e,er)</t>
   <t o="isVeryThick">sehr dick(e,er)</t>
   <t o="isThin">dünn(e,er)</t>
   <t o="isPrettyThin">ziemlich dünn(e,er)</t>
   <t o="isVeryThin">sehr dünn(e,er)</t>
   <t o="isFeeble">schwach(e,er)</t>
   <t o="isPrettyFeeble">ziemlich schwach(e,er)</t>
   <t o="isVeryFeeble">sehr schwach(e,er)</t>
   <t o="isLight">leicht(e,er)</t>
   <t o="isPrettyLight">ziemlich leicht(e,er)</t>
   <t o="isVeryLight">sehr leicht(e,er)</t>
   <t o="isModerate">mäßige(r,m)</t>
   <t o="isIntermittent">sporadisch(e,er)</t>
   <t o="isContinuous">ununterbrochen(e,er)</t>
   <t o="isIsolated">vereinzelt(e)</t>
   <t o="isConvective">konvektive</t>
   <t o="isDissipated">zerstreut(e)</t>
   <t o="isFreezing">gefrierende(r)</t>
   <t o="isPatchy">stellenweise</t>
   <t o="inPastHour">in voriger Stunde</t>
   <t o="isAloft">oberhalb</t>
   <t o="isAround">ringsherum</t>
   <t o="topOfLayer">Obergrenze der Schicht</t>
   <t o="level-from">von</t>
   <t o="level-to">bis</t>
   <t o="toTopOfCloud"> bis Wolkenobergrenze</t>
   <t o="isNotScheduled">ist nicht geplant</t>
   <t o="isLtdToCldVisWind">beschränkt auf Wolken, Sicht und Wind</t>
   <t o="amendment">Ergänzung</t>
   <t o="ceiling">Wolkenuntergrenze</t>
   <t o="approach">Anflug</t>
   <t o="cloudTypeAsoctd">in Verbindung mit |</t>
   <t o="cloudTypeEmbd">| innen</t>
   <t o="change-by"> um</t>
   <t o="decelerometerReading">Verzögerungsmesser-Messwert</t>
   <t o="decelerometerReadingNA">kein Verzögerungsmesser-Messwert verfügbar</t>
   <t o="rainfall10min"> mm in den letzten 10 Minuten, </t>
   <t o="rainfall0900"> mm seit 09:00 Flugplatz-Zeit</t>
   <t o="minutes">Minuten</t>
   <t o="fcstAutoMETAR">Vorhersage basiert auf automatisiertem METAR</t>
   <t o="CAVU">wolkenlos oder aufgelockerte Bewölkung und Sicht &gt;10 US-miles</t>
   <t o="EPC">Pass voraussichtlich versperrt</t>
   <t o="EPO">Pass voraussichtlich offen</t>
   <t o="EPM">Pass voraussichtlich marginal</t>
   <t o="RTS">wieder in Betrieb</t>
   <t o="visibilityAt">Sicht nahe</t>
   <t o="traces">Spuren</t>
   <t o="firstObs">erste Beobachtung|</t>
   <t o="nextObs">nächste Beobachtung|</t>
   <t o="lastObs">letzte Beobachtung|</t>
   <t o="isStaffed"> durch Personal</t>
   <t o="isManned"> durch Personal</t>
   <t o="balloonDisapp">Ballon verschwand in |</t>
   <t o="balloonVisib">Ballon sichtbar bis |</t>
   <t o="estimated">geschätzt</t>
   <t o="dueToIceAccretion"> wegen Eisablagerung</t>
   <t o="BA_GOOD">gute Bremswirkung</t>
   <t o="BA_POOR">schlechte Bremswirkung</t>
   <t o="THN_SPTS_IOVC">kleine Lücken in geschlossener Wolkendecke</t>
   <t o="FUOCTY">Rauch über Stadt</t>
   <t o="ALTM_MISG">Luftdruckwert fehlt</t>
   <t o="ALL_WNDS_GRID">alle Windrichtungen in Grid</t>
   <t o="CONTRAILS">Kondensstreifen</t>
   <t o="SKY_OBSC">Himmel verdeckt</t>
   <t o="MTNS_OBSC">Berge verdeckt</t>
   <t o="FOGGY">neblig</t>
   <t o="TWLGT">Dämmerung</t>
   <t o="missing">fehlen</t>
   <t o="slash">/</t>
   <t o="FIBI">abgelegt, aber Übersendung unpraktisch</t>
   <t o="hailStoneSize">größter Durchmesser </t>

   <reportModifierType o="NIL" >Bericht fehlt</reportModifierType>
   <reportModifierType o="AUTO">automatisch erzeugt</reportModifierType>
   <reportModifierType o="COR" >manuell korrigiert</reportModifierType>
   <reportModifierType o="RTD" >Ablauf verspätet</reportModifierType>
   <reportModifierType o="P"   >segmentiert, </reportModifierType>
   <reportModifierType o="RR"  >verspätet</reportModifierType>
   <reportModifierType o="CC"  >korrigiert</reportModifierType>
   <reportModifierType o="AA"  >ergänzt</reportModifierType>
   <reportModifierType o="AMD" >ergänzt</reportModifierType>

   <compassDir o="N">Nord</compassDir>
   <compassDir o="NNE">Nord-Nordost</compassDir>
   <compassDir o="NE">Nordost</compassDir>
   <compassDir o="ENE">Ost-Nordost</compassDir>
   <compassDir o="E">Ost</compassDir>
   <compassDir o="ESE">Ost-Südost</compassDir>
   <compassDir o="SE">Südost</compassDir>
   <compassDir o="SSE">Süd-Südost</compassDir>
   <compassDir o="S">Süd</compassDir>
   <compassDir o="SSW">Süd-Südwest</compassDir>
   <compassDir o="SW">Südwest</compassDir>
   <compassDir o="WSW">West-Südwest</compassDir>
   <compassDir o="W">West</compassDir>
   <compassDir o="WNW">West-Nordwest</compassDir>
   <compassDir o="NW">Nordwest</compassDir>
   <compassDir o="NNW">Nord-Nordwest</compassDir>

   <units o="M"> m</units>
   <units o="KM"> km</units>
   <units o="MM"> mm</units>
   <units o="SM"> US-miles</units>
   <units o="NM"> NM</units>
   <units o="FT"> ft</units>
   <units o="IN"> in.</units>
   <units o="KMH"> km/h</units>
   <units o="KT"> kt</units>
   <units o="MPH"> mph</units>
   <units o="MPS"> m/s</units>
   <units o="hPa"> hPa</units>
   <units o="inHg"> in. Hg</units>
   <units o="MIN"> Min.</units>
   <units o="H"> Stunde(n)</units>

   <locationSpec o="OMTNS">über den Bergen</locationSpec>
   <locationSpec o="OHD">über Station</locationSpec>
   <locationSpec o="ALQDS">in allen Quadranten</locationSpec>
   <locationSpec o="AT_AP">am Flugplatz</locationSpec>
   <locationSpec o="OVR_AP">über Flugplatz</locationSpec>
   <locationSpec o="IN_VLY">im Tal</locationSpec>
   <locationSpec o="V_D">in verschiedenen Richtungen</locationSpec>
   <locationSpec o="OVR_LK">über dem See</locationSpec>
   <locationSpec o="OVR_RIVER">über dem Fluß</locationSpec>
   <locationSpec o="OVR_VLYS">über den Tälern</locationSpec>
   <locationSpec o="ALG_LK">entlang des Sees</locationSpec>
   <locationSpec o="ALG_MT">entlang der Berge</locationSpec>
   <locationSpec o="ALG_RIVER">entlang des Flusses</locationSpec>
   <locationSpec o="UNKN">in unbekannte Richtung</locationSpec>

   <cloudCover o="SKC-s">wolkenlos</cloudCover>
   <cloudCover o="NSC-s">keine signifikanten Wolken</cloudCover>
   <cloudCover o="CLR-s">keine Wolken unter 10000 ft</cloudCover>
   <cloudCover o="NCD-s">keine Wolken festgestellt</cloudCover>

   <cloudCover o="SKC">wolkenlos</cloudCover>
   <cloudCover o="NSC">keine signifikanten Wolken</cloudCover>
   <cloudCover o="CLR">keine Wolken unter 10000 ft</cloudCover>
   <cloudCover o="NCD">keine Wolken festgestellt</cloudCover>
   <cloudCover o="FEW">leicht (1-2/8)</cloudCover>
   <cloudCover o="SCT">aufgelockert (3-4/8)</cloudCover>
   <cloudCover o="BKN">durchbrochen (5-7/8)</cloudCover>
   <cloudCover o="OVC">Himmel bedeckt (8/8)</cloudCover>

   <cloudType o="AC">Altocumulus</cloudType>
   <cloudType o="ACC">Altocumulus castellanus</cloudType>
   <cloudType o="ACSL">Altocumulus standing lenticular</cloudType>
   <cloudType o="AS">Altostratus</cloudType>
   <cloudType o="CB">Cumulonimbus</cloudType>
   <cloudType o="CBMAM">Cumulonimbus mammatus</cloudType>
   <cloudType o="CC">Cirrocumulus</cloudType>
   <cloudType o="CCSL">Cirrocumulus standing lenticular</cloudType>
   <cloudType o="CF">Cumulus fractus</cloudType>
   <cloudType o="CI">Cirrus</cloudType>
   <cloudType o="CS">Cirrostratus</cloudType>
   <cloudType o="CU">Cumulus</cloudType>
   <cloudType o="CUFRA">Cumulus fractus</cloudType>
   <cloudType o="NS">Nimbostratus</cloudType>
   <cloudType o="SAC">Stratoaltocumulus</cloudType>
   <cloudType o="SC">Stratocumulus</cloudType>
   <cloudType o="SCSL">Stratocumulus standing lenticular</cloudType>
   <cloudType o="SF">Stratus fractus</cloudType>
   <cloudType o="ST">Stratus</cloudType>
   <cloudType o="STFRA">Stratus fractus</cloudType>
   <cloudType o="TCU">hochauftürmende Cumulus</cloudType>

<!-- thanks to http://www.wolkenatlas.de/wolken/code.htm -->
   <cloudTypeLow o="0">keine Wolken</cloudTypeLow>
   <cloudTypeLow o="1">Cumulus von geringer vertikaler Ausdehnung oder zerfetzt</cloudTypeLow>
   <cloudTypeLow o="2">Cumulus von mäßiger bis großer vertikaler Ausdehnung</cloudTypeLow>
   <cloudTypeLow o="3">Cumulonimbus ohne deutlich faseriges oder streifiges Oberteil</cloudTypeLow>
   <cloudTypeLow o="4">Stratocumulus, durch Ausbreitung von Cumulus entstanden</cloudTypeLow>
   <cloudTypeLow o="5">Stratocumulus, nicht durch Ausbreitung von Cumulus entstanden</cloudTypeLow>
   <cloudTypeLow o="6">Stratus oder zerfetzter Stratus</cloudTypeLow>
   <cloudTypeLow o="7">Stratus-Fetzen oder Cumulus-Fetzen bei Schlechtwetter oder beide</cloudTypeLow>
   <cloudTypeLow o="8">Cumulus und Stratocumulus mit Untergrenzen in verschiedenen Höhen</cloudTypeLow>
   <cloudTypeLow o="9">Cumulonimbus mit deutlich faserigem oder streifigem Oberteil</cloudTypeLow>

   <cloudTypeMiddle o="0">keine Wolken</cloudTypeMiddle>
   <cloudTypeMiddle o="1">halbdurchscheinender Altostratus</cloudTypeMiddle>
   <cloudTypeMiddle o="2">dichter Altostratus oder Nimbostratus</cloudTypeMiddle>
   <cloudTypeMiddle o="3">halbdurchscheinender Altocumulus vorherrschend</cloudTypeMiddle>
   <cloudTypeMiddle o="4">Altocumulus in fortwährender Veränderung</cloudTypeMiddle>
   <cloudTypeMiddle o="5">Altocumulus den Himmel überziehend </cloudTypeMiddle>
   <cloudTypeMiddle o="6">Altocumulus, durch Ausbreitung von Cumulus oder Cumulonimbus entstanden</cloudTypeMiddle>
   <cloudTypeMiddle o="7">Altocumulus unter Altostratus oder Nimbostratus oder dichter Altocumulus vorherrschend </cloudTypeMiddle>
   <cloudTypeMiddle o="8">Altocumulus mit Türmchen oder in Flocken</cloudTypeMiddle>
   <cloudTypeMiddle o="9">chaotischer Himmel</cloudTypeMiddle>

   <cloudTypeHigh o="0">keine Wolken</cloudTypeHigh>
   <cloudTypeHigh o="1">Cirrus in Fäden oder Haken, mehr als sonstiger Cirrus</cloudTypeHigh>
   <cloudTypeHigh o="2">dichter Cirrus und Cirrus mit Türmchen und Cirrus in Flocken, mehr als sonstiger Cirrus</cloudTypeHigh>
   <cloudTypeHigh o="3">dichter Cirrus, aus Cumulonimbus entstanden</cloudTypeHigh>
   <cloudTypeHigh o="4">Cirrus, den Himmel überziehend</cloudTypeHigh>
   <cloudTypeHigh o="5">Cirrus &lt;45° über Horizont</cloudTypeHigh>
   <cloudTypeHigh o="6">Cirrus &gt;45° über Horizont</cloudTypeHigh>
   <cloudTypeHigh o="7">Cirrostratus, den ganzen Himmel bedeckend</cloudTypeHigh>
   <cloudTypeHigh o="8">Cirrostratus, nicht den Himmel überziehend</cloudTypeHigh>
   <cloudTypeHigh o="9">Cirrocumulus allein, oder Cirrocumulus mehr als Cirrus und Cirrostratus</cloudTypeHigh>

   <weather o="phen-light">leichte(r,m) </weather>
   <weather o="phen-moderate">mäßige(r,m) </weather>
   <weather o="phen-heavy">starke(r,s,m) </weather>
   <weather o="inVicinity"> in der Nähe</weather>
   <weather o="BCFG">|Nebelschwaden</weather>
   <weather o="BLDU">|treibender Staub</weather>
   <weather o="BLSA">|treibender Sand</weather>
   <weather o="BLSN">|Schneetreiben</weather>
   <weather o="BR">|feuchter Dunst</weather>
   <weather o="DRSA">|tief treibender Sand</weather>
   <weather o="DRSN">|Schneefegen</weather>
   <weather o="DS">|Staubsturm</weather>
   <weather o="DU">|Staub</weather>
   <weather o="DZ">|Sprühregen</weather>
   <weather o="DZRA">|Sprühregen mit Regen</weather>
   <weather o="DZSN">|Sprühregen mit Schnee</weather>
   <weather o="FC">|Trichterwolke</weather>
   <weather o="FG">|Nebel</weather>
   <weather o="FU">|Rauch</weather>
   <weather o="FZBCFG">|gefrierende Nebelschwaden</weather>
   <weather o="FZBR">|gefrierender feuchter Dunst</weather>
   <weather o="FZDZ">|gefrierender Sprühregen</weather>
   <weather o="FZFG">|gefrierender Nebel</weather>
   <weather o="FZRA">|gefrierender Regen</weather>
   <weather o="FZRAPL">|gefrierender Regen mit Eiskörnern</weather>
   <weather o="FZRAPLSN">|gefrierender Regen mit Eiskörnern und Schnee</weather>
   <weather o="FZRASN">|gefrierender Regen mit Schnee</weather>
   <weather o="GR">|Hagel</weather>
   <weather o="GRRA">|Hagel mit Regen</weather>
   <weather o="GS">|Graupel</weather>
   <weather o="HZ">|trockener Dunst</weather>
   <weather o="IC">|Eisnadeln</weather>
   <weather o="JP">|benachbarter Niederschlag</weather>
   <weather o="MIFG">|flacher Nebel</weather>
   <weather o="NSW">kein signifikantes Wetter</weather>
   <weather o="PL">|Eiskörner</weather>
   <weather o="PO">|Sand- oder Staubwirbel</weather>
   <weather o="PRFG">|teilweise Nebel</weather>
   <weather o="RA">|Regen</weather>
   <weather o="RADZ">|Regen mit Sprühregen</weather>
   <weather o="RAPL">|Regen mit Eiskörnern</weather>
   <weather o="RASN">|Regen mit Schnee</weather>
   <weather o="SA">|Sand</weather>
   <weather o="SG">|Schneegriesel</weather>
   <weather o="SH">|Schauer</weather>
   <weather o="SHGR">|Hagelschauer</weather>
   <weather o="SHGSRA">|Graupelschauer mit Regen</weather>
   <weather o="SHPL">|Eiskörnerschauer</weather>
   <weather o="SHRA">|Regenschauer</weather>
   <weather o="SHRADZ">|Regenschauer mit Sprühregen</weather>
   <weather o="SHRAGS">|Regenschauer mit Graupel</weather>
   <weather o="SHSN">|Schneeschauer</weather>
   <weather o="SHRAPL">|Regenschauer mit Eiskörnern</weather>
   <weather o="SHRASN">|Regenschauer mit Schnee</weather>
   <weather o="SHSNGS">|Schneeschauer mit Graupel</weather>
   <weather o="SHSNPL">|Schneeschauer mit Eiskörnern</weather>
   <weather o="SHSNRA">|Schneeschauer mit Regen</weather>
   <weather o="SN">|Schnee</weather>
   <weather o="SNPL">|Schnee mit Eiskörnern</weather>
   <weather o="SNRA">|Schnee mit Regen</weather>
   <weather o="SQ">|Sturmböen</weather>
   <weather o="SS">|Sandsturm</weather>
   <weather o="TS">|Gewitter</weather>
   <weather o="TSDZ">Gewitter mit |Sprühregen</weather>
   <weather o="TSRA">Gewitter mit |Regen</weather>
   <weather o="TSRAGR">Gewitter mit |Regen und Hagel</weather>
   <weather o="TSGS">Gewitter mit |Graupel</weather>
   <weather o="UP">|unbekannter Niederschlag</weather>
   <weather o="VA">|Vulkanasche</weather>
   <weather o="tornado">Wind-/Wasserhose</weather>

   <tornadicActivity o="tornado">Windhose</tornadicActivity>
   <tornadicActivity o="funnel_cloud">Trichterwolke</tornadicActivity>
   <tornadicActivity o="waterspout">Wasserhose</tornadicActivity>

   <lightningType o="CA">Wolke-zu-Luft</lightningType>
   <lightningType o="CC">Wolke-zu-Wolke</lightningType>
   <lightningType o="CG">Wolke-zu-Boden</lightningType>
   <lightningType o="CW">Wolke-zu-Wasser</lightningType>
   <lightningType o="IC">innnerhalb der Wolken</lightningType>

   <visTrend o="U">zunehmend</visTrend>
   <visTrend o="N">keine Änderung</visTrend>
   <visTrend o="D">abnehmend</visTrend>

   <stationType o="AO1">automatisierte Station ohne Niederschlagsunterscheidung</stationType>
   <stationType o="AO2">automatisierte Station mit Niederschlagsunterscheidung</stationType>
   <stationType o="AO2A">automatisierte Station mit Niederschlagsunterscheidung und manuellen Ergänzungen</stationType>

   <depositType o="0">trocken und frei von Ablagerungen</depositType>
   <depositType o="1">feucht</depositType>
   <depositType o="2">nass oder Wasserpfützen</depositType>
   <depositType o="3">Nebelfrostablagerungen</depositType>
   <depositType o="4">trockener Schnee</depositType>
   <depositType o="5">nasser Schnee</depositType>
   <depositType o="6">Schneematsch</depositType>
   <depositType o="7">Eis</depositType>
   <depositType o="8">zusammengepresster Schnee</depositType>
   <depositType o="9">festgefrorene Radspuren</depositType>

   <depositExtent o="0">0%|</depositExtent>
   <depositExtent o="1">1-10%|</depositExtent>
   <depositExtent o="2">11-25%|</depositExtent>
   <depositExtent o="5">26-50%|</depositExtent>
   <depositExtent o="9">51-100%|</depositExtent>

   <friction o="91">schlechte Bremswirkung</friction>
   <friction o="92">schlechte/mäßige Bremswirkung</friction>
   <friction o="93">mäßige Bremswirkung</friction>
   <friction o="94">mäßige/gute Bremswirkung</friction>
   <friction o="95">gute Bremswirkung</friction>
   <friction o="99">Reibung: unzuverlässige Messung</friction>

   <colour o="BLACK"  >Flugplatz aus technischen Gründen nicht benutzbar</colour>
   <colour o="BLUplus">Hauptwolkenuntergrenze 20000 ft, Sicht 8 km</colour>
   <colour o="BLU"    >Hauptwolkenuntergrenze 2500 ft, Sicht 8 km</colour>
   <colour o="WHT"    >Hauptwolkenuntergrenze 1500 ft, Sicht 5 km</colour>
   <colour o="GRN"    >Hauptwolkenuntergrenze 700 ft, Sicht 3700 m</colour>
   <colour o="YLO1"   >Hauptwolkenuntergrenze 500 ft, Sicht 2500 m</colour>
   <colour o="YLO2"   >Hauptwolkenuntergrenze 300 ft, Sicht 1600 m</colour>
   <colour o="YLO"    >Hauptwolkenuntergrenze 300 ft, Sicht 1600 m</colour>
   <colour o="AMB"    >Hauptwolkenuntergrenze 200 ft, Sicht 800 m</colour>
   <colour o="RED"    >Hauptwolkenuntergrenze &lt;200 ft, Sicht &lt;800 m</colour>
   <colour o="FCSTCANCEL">forecast cancelled</colour>
   <colour o="noChange">keine Änderung von Hauptwolkenuntergrenze oder Sicht</colour>

   <visibilityAtLoc o="MAR">Sicht am Meer:&#9;&#9;</visibilityAtLoc>
   <visibilityAtLoc o="SFC">Sicht am Boden:&#9;&#9;</visibilityAtLoc>
   <visibilityAtLoc o="TWR">Sicht am Turm:&#9;&#9;</visibilityAtLoc>

   <concernsChange o="M">verschlechterte Bedingungen bezüglich |</concernsChange>
   <concernsChange o="B">verbesserte Bedingungen bezüglich |</concernsChange>
   <concernsSubject o="0">Böen</concernsSubject>
   <concernsSubject o="1">Wind</concernsSubject>
   <concernsSubject o="2">Sicht</concernsSubject>
   <concernsSubject o="3">Wolken</concernsSubject>
   <concernsSubject o="4">Niederschlag</concernsSubject>
   <concernsSubject o="5">Luftdruck</concernsSubject>
   <concernsSubject o="6">Zustand der See oder Dünung</concernsSubject>
   <concernsSubject o="7">Staubsturm, Sandsturm oder Schneetreiben</concernsSubject>
   <concernsSubject o="8">Gewitter</concernsSubject>
   <concernsSubject o="9">Sturmböen oder Tornado</concernsSubject>

   <phenomenon o="LTG">Blitze</phenomenon>
   <phenomenon o="VIRGA">Virga</phenomenon>
   <phenomenon o="AURBO">Nordlicht</phenomenon>
   <phenomenon o="FG_BNK">Nebelbank</phenomenon>
   <phenomenon o="PCPN">Niederschlag</phenomenon>
   <phenomenon o="VLY_FG">Talnebel</phenomenon>
   <phenomenon o="HIR_CLDS">höhere Wolken</phenomenon>
   <phenomenon o="FULYR">Schicht mit Rauch</phenomenon>
   <phenomenon o="HZY">dunstig</phenomenon>
   <phenomenon o="BINOVC">Lücken in geschlossener Bewölkung</phenomenon>
   <phenomenon o="ICG">Vereisung</phenomenon>
   <phenomenon o="SH">Schauer</phenomenon>
   <phenomenon o="SHS">Schauer</phenomenon>
   <phenomenon o="DEW">Tau</phenomenon>
   <phenomenon o="VIS_HYR">Sicht besser</phenomenon>
   <phenomenon o="VIS_LWR">Sicht schlechter</phenomenon>
   <phenomenon o="VIS_RDCD">Sicht reduziert</phenomenon>
   <phenomenon o="CIG_HYR">Wolkenuntergrenze höher</phenomenon>
   <phenomenon o="CIG_LWR">Wolkenuntergrenze niedriger</phenomenon>
   <phenomenon o="CLD">Wolken</phenomenon>
   <phenomenon o="CLDS">Wolken</phenomenon>
   <phenomenon o="CLD_EMBD">Wolken innen</phenomenon>
   <phenomenon o="CLDS_EMBD">Wolken innen</phenomenon>
   <phenomenon o="PRESFR">Luftdrucktendenz: schnell fallend</phenomenon>
   <phenomenon o="PRESRR">Luftdrucktendenz: schnell steigend</phenomenon>
   <phenomenon o="FIRE">Feuer</phenomenon>
   <phenomenon o="FIRES">Feuer</phenomenon>
   <phenomenon o="GRASS_FIRE">Grasfeuer</phenomenon>
   <phenomenon o="GRASS_FIRES">Grasfeuer</phenomenon>

   <quadrant o="1">ersten</quadrant>
   <quadrant o="2">zweiten</quadrant>
   <quadrant o="3">dritten</quadrant>
   <quadrant o="4">vierten</quadrant>

   <condMounType o="LIB">frei von Wolken</condMounType>
   <condMounType o="CLD_SCT">teilweise in vereinzelten Wolken verhüllt</condMounType>
   <condMounType o="VERS_INC">Hänge in Wolken, Gipfel ist frei</condMounType>
   <condMounType o="CNS_POST">frei auf der Betrachterseite, andere Seite in Wolken</condMounType>
   <condMounType o="CLD_CIME">Wolken berühren den Gipfel</condMounType>
   <condMounType o="CIME_INC">Gipfel in Wolken, Hänge frei</condMounType>
   <condMounType o="GEN_INC">überwiegend in Wolken, einige Gipfel frei</condMounType>
   <condMounType o="INC">in Wolken</condMounType>
   <condMounType o="INVIS">nicht sichtbar</condMounType>

   <condMounChange o="NC">keine Änderung</condMounChange>
   <condMounChange o="CUF">cumuli entwickeln sich</condMounChange>
   <condMounChange o="ELEV_SLW">langsam aufsteigend</condMounChange>
   <condMounChange o="ELEV_RAPID">schnell aufsteigend</condMounChange>
   <condMounChange o="ELEV_STF">steigen auf und schichten sich</condMounChange>
   <condMounChange o="ABB_SLW">langsam absinkend</condMounChange>
   <condMounChange o="ABB_RAPID">schnell absinkend</condMounChange>
   <condMounChange o="STF">schichten sich</condMounChange>
   <condMounChange o="STF_ABB">schichten sich and sinken ab</condMounChange>
   <condMounChange o="VAR_RAPID">verändern sich schnell</condMounChange>

   <condVallType o="NIL">keine tiefen Wolken, Nebel or Dunst</condVallType>
   <condVallType o="FOSCHIA">Dunst</condVallType>
   <condVallType o="FOSCHIA_SKC_SUP">Dunst, Himmel darüber klar</condVallType>
   <condVallType o="NEBBIA">Nebel</condVallType>
   <condVallType o="NEBBIA_SCT">vereinzelte Nebelbänke</condVallType>
   <condVallType o="CLD_SCT">vereinzelte Wolken</condVallType>
   <condVallType o="CLD_SCT_NEBBIA_INF">vereinzelte Wolken, darunter Nebel</condVallType>
   <condVallType o="MAR_CLD">Meer in Wolken</condVallType>
   <condVallType o="INVIS">nicht sichtbar</condVallType>

   <condVallChange o="NC">keine Änderung</condVallChange>
   <condVallChange o="DIM">abnehmend</condVallChange>
   <condVallChange o="DIM_ELEV">abnehmend und aufsteigend</condVallChange>
   <condVallChange o="DIM_ABB">abnehmend und absinkend</condVallChange>
   <condVallChange o="AUM">zunehmend</condVallChange>
   <condVallChange o="AUM_ELEV">zunehmend und aufsteigend</condVallChange>
   <condVallChange o="AUM_ABB">zunehmend und absinkend</condVallChange>
   <condVallChange o="ELEV">aufsteigend</condVallChange>
   <condVallChange o="ABB">absinkend</condVallChange>
   <condVallChange o="NEBBIA_INTER">sporadischer Nebel an der Station</condVallChange>

   <turbulenceDescr o="0">keine</turbulenceDescr>
   <turbulenceDescr o="1">leicht</turbulenceDescr>
   <turbulenceDescr o="2">gelegentlich, moderat, in klarer Luft</turbulenceDescr>
   <turbulenceDescr o="3">häufig, mäßig, in klarer Luft</turbulenceDescr>
   <turbulenceDescr o="4">gelegentlich, moderat, in Wolken</turbulenceDescr>
   <turbulenceDescr o="5">häufig, mäßig, in Wolken</turbulenceDescr>
   <turbulenceDescr o="6">gelegentlich, stark, in klarer Luft</turbulenceDescr>
   <turbulenceDescr o="7">häufig, stark, in klarer Luft</turbulenceDescr>
   <turbulenceDescr o="8">gelegentlich, stark, in Wolken</turbulenceDescr>
   <turbulenceDescr o="9">häufig, stark, in Wolken</turbulenceDescr>

   <icingDescr o="0">keine</icingDescr>
   <icingDescr o="1">leicht</icingDescr>
   <icingDescr o="2">leicht, in Wolken</icingDescr>
   <icingDescr o="3">leicht, in Niederschlag</icingDescr>
   <icingDescr o="4">mäßig</icingDescr>
   <icingDescr o="5">mäßig, in Wolken</icingDescr>
   <icingDescr o="6">mäßig, in Niederschlag</icingDescr>
   <icingDescr o="7">stark</icingDescr>
   <icingDescr o="8">stark, in Wolken</icingDescr>
   <icingDescr o="9">stark, in Niederschlag</icingDescr>

   <seaCondition o="0">Flaute (spiegelglatt)</seaCondition>
   <seaCondition o="1">Flaute (wellig)</seaCondition>
   <seaCondition o="2">ruhig (kleine Wellen)</seaCondition>
   <seaCondition o="3">schwache Wellen</seaCondition>
   <seaCondition o="4">mäßige Wellen</seaCondition>
   <seaCondition o="5">rauh</seaCondition>
   <seaCondition o="6">sehr rauh</seaCondition>
   <seaCondition o="7">hohe Wellen</seaCondition>
   <seaCondition o="8">sehr hohe Wellen</seaCondition>
   <seaCondition o="9">gewaltige Wellen</seaCondition>

   <swellCondition o="0">keine</swellCondition>
   <swellCondition o="1">Länge: kurz oder mittel, Höhe: flach</swellCondition>
   <swellCondition o="2">Länge: lang, Höhe: flach</swellCondition>
   <swellCondition o="3">Länge: kurz, Höhe: mäßig</swellCondition>
   <swellCondition o="4">Länge: mittel, Höhe: mäßig</swellCondition>
   <swellCondition o="5">Länge: lang, Höhe: mäßig</swellCondition>
   <swellCondition o="6">Länge: kurz, Höhe: hoch</swellCondition>
   <swellCondition o="7">Länge: mittel, Höhe: hoch</swellCondition>
   <swellCondition o="8">Länge: lang, Höhe: hoch</swellCondition>
   <swellCondition o="9">chaotisch</swellCondition>

   <cloudPhenom o="PWR_PLNT">Kraftwerk</cloudPhenom>
   <cloudPhenom o="PWR_PLNT_PLUME">Kraftwerkschwaden</cloudPhenom>

   <pressureTend o="0">steigend, dann fallend</pressureTend>
   <pressureTend o="1">steigend, dann konstant, oder steigend dann langsamer steigend</pressureTend>
   <pressureTend o="2">gleichmäßig oder ungleichmäßig steigend</pressureTend>
   <pressureTend o="3">fallend oder konstant, dann steigend; oder steigend dann schneller steigend</pressureTend>
   <pressureTend o="4">konstant</pressureTend>
   <pressureTend o="5">fallend dann steigend</pressureTend>
   <pressureTend o="6">fallend, dann konstant, oder fallend dann langsamer fallend</pressureTend>
   <pressureTend o="7">gleichmäßig oder ungleichmäßig fallend</pressureTend>
   <pressureTend o="8">konstant oder steigend, dann fallend; oder fallend dann schneller fallend</pressureTend>

   <rwySfc o="SLR">Schneematsch auf der Piste</rwySfc>
   <rwySfc o="LSR">lockerer Schnee auf der Piste</rwySfc>
   <rwySfc o="PSR">zusammengepresster Schnee auf der Piste</rwySfc>
   <rwySfc o="P">stellenweise</rwySfc>
   <rwySfc o="SANDED">Sand gestreut</rwySfc>
   <rwySfc o="WET">naß</rwySfc>
   <rwySfc o="DRY">trocken</rwySfc>
   <rwySfc o="IR">Eis auf der Piste</rwySfc>
   <rwySfc o="WR">Piste naß</rwySfc>

   <snowCoverType o="ONE_LOOSE">one loose</snowCoverType>
   <snowCoverType o="MUCH_LOOSE">meist locker</snowCoverType>
   <snowCoverType o="TRACE_LOOSE">Spuren locker</snowCoverType>
   <snowCoverType o="MEDIUM_PACKED">mäßig gepackt</snowCoverType>
   <snowCoverType o="HARD_PACKED">fest gepackt</snowCoverType>
   <snowCoverType o="NIL">keine</snowCoverType>

   <estimatedItem o="WND">Wind</estimatedItem>
   <estimatedItem o="CIG">Wolkenuntergrenze</estimatedItem>
   <estimatedItem o="CIG_BLN">Wolkenuntergrenze von Ballondaten</estimatedItem>
   <estimatedItem o="CLD_HGTS">Wolkenhöhen</estimatedItem>
   <estimatedItem o="SLP">Luftdruck Meeresniveau</estimatedItem>
   <estimatedItem o="ALSTG">Höhenmessereinstellung</estimatedItem>

   <fcstNotAvblReason o="NOOBS">keine Beobachtungen</fcstNotAvblReason>
   <fcstNotAvblReason o="INSUFFICIENTOBS">unzureichende Beobachtungen</fcstNotAvblReason>

   <error o="obsStation">keine Flugplatz-Id</error>
   <error o="obsTime">keine Beobachtungszeit</error>
   <error o="other">ungültiges Format</error>

   <cgi o="title">METAR/TAF-Übersetzer</cgi>
   <cgi o="infosrc">Eine gute Quelle für aktuelle METAR- und TAF-Meldungen ist</cgi>
   <cgi o="outdated">Warnung: Die Wetter-Vorhersagen bei NOAA werden seit 3. August 2006 für viele Stationen nicht mehr aktualisiert.</cgi>
   <cgi o="infofetch">Wird das Schlüsselwort "FETCH" und ein oder mehrere Flugplatz-Kürzel verwendet, werden Meldungen von der ausgewählten Quelle (oder, falls diese Option gesperrt ist, von einer Datei auf dem Server, von dem diese Web-Seite kommt) geholt.</cgi>
   <cgi o="example">Beispiele für Meldungen:</cgi>
   <cgi o="message">Meldung:</cgi>
   <cgi o="type">ist vom Typ:</cgi>
   <cgi o="source">hole von:</cgi>
   <cgi o="language">Sprache:</cgi>
   <cgi o="format">gib aus als:</cgi>
   <cgi o="decode">Übersetzen</cgi>
   <cgi o="disclaimer">Warnung: Die Informationen auf dieser Seite könnten veraltet, falsch oder beides sein. Sie sind nicht für die Verwendung in der Luftfahrt geeignet.</cgi>
  </de>

  <en>
   <compassDir16>
    <arr>N</arr>
    <arr>NNE</arr>
    <arr>NE</arr>
    <arr>ENE</arr>
    <arr>E</arr>
    <arr>ESE</arr>
    <arr>SE</arr>
    <arr>SSE</arr>
    <arr>S</arr>
    <arr>SSW</arr>
    <arr>SW</arr>
    <arr>WSW</arr>
    <arr>W</arr>
    <arr>WNW</arr>
    <arr>NW</arr>
    <arr>NNW</arr>
    <arr>N</arr>
   </compassDir16>

   <hdr o="metar">METAR Report</hdr>
   <hdr o="metar_ul">============</hdr>
   <hdr o="speci">SPECI Report</hdr>
   <hdr o="speci_ul">============</hdr>
   <hdr o="af">aerodrome forecast</hdr>
   <hdr o="taf_hour">|-hour aerodrome forecast</hdr>
   <hdr o="taf_ul">==================</hdr>
   <hdr o="obsStation">Airport-Id:&#9;&#9;</hdr>
   <hdr o="obsTime">Report time:&#9;&#9;</hdr>
   <hdr o="issueTime">Issue time:&#9;&#9;</hdr>
   <hdr o="fcstPeriod">Forecast period:&#9;</hdr>
   <hdr o="visPrev">Visibility:&#9;&#9;</hdr>
   <hdr o="visMin">&#9;&#9;&#9;</hdr>
   <hdr o="visRwy">visibility runway |:&#9;</hdr>
   <hdr o="visTrend">&#9;trend:&#9;&#9;</hdr>
   <hdr o="visVert">Vert. visibility:&#9;</hdr>
   <hdr o="sfcWind">Wind:&#9;&#9;&#9;</hdr>
   <hdr o="weather-1">Weather:&#9;&#9;</hdr>
   <hdr o="cloud-1">Sky condition:&#9;&#9;</hdr>
   <hdr o="ceiling">ceiling:&#9;&#9;</hdr>
   <hdr o="temperature-temp">Temperature:&#9;&#9;</hdr>
   <hdr o="temperature-dew">Dewpoint:&#9;&#9;</hdr>
   <hdr o="tempHourly-temp">1h avg. temperature:&#9;</hdr>
   <hdr o="tempHourly-dew">1h avg. dewpoint:&#9;</hdr>
   <hdr o="relHumid">relative humidity:&#9;</hdr>
   <hdr o="tempMax">max. temperature:&#9;</hdr>
   <hdr o="tempMin">min. temperature:&#9;</hdr>
   <hdr o="temp6hMax">6h max. temperature:&#9;</hdr>
   <hdr o="temp6hMin">6h min. temperature:&#9;</hdr>
   <hdr o="temp24hMax">24h max. temperature:&#9;</hdr>
   <hdr o="temp24hMin">24h min. temperature:&#9;</hdr>
   <hdr o="tempAt">temperature:&#9;&#9;</hdr>
   <hdr o="tempMaxFQ">max. temperature:&#9;</hdr>
   <hdr o="QNH">Pressure:&#9;&#9;</hdr>
   <hdr o="somePressure">Some pressure:&#9;&#9;</hdr>
   <hdr o="stateOfRwy">state |:&#9;</hdr>
   <hdr o="windShearRwy">|:&#9;&#9;</hdr>
   <hdr o="recentWeather-1">recent weather:&#9;&#9;</hdr>
   <hdr o="colourCode">Colour code:&#9;&#9;</hdr>
   <hdr o="windShearLvl">WIND SHEAR! Wind:&#9;</hdr>
   <hdr o="cloudMaxCover">max. cloud cover:&#9;</hdr>
   <hdr o="cloudCoverVar">Sky condition:&#9;&#9;</hdr>
   <hdr o="cloudCoverVar2">varying to:&#9;&#9;&#9;</hdr>
   <hdr o="reportConcerns">report concerns:&#9;&#9;</hdr>
   <hdr o="cloudOpacityLvl">phenomenon w. opacity:&#9;</hdr>
   <hdr o="trendList">trends within the next 2 hours:</hdr>
   <hdr o="trendList_ul">===============================</hdr>
   <hdr o="trendListTAF">trend forecast:</hdr>
   <hdr o="trendListTAF_ul">===============</hdr>
   <hdr o="remarkList">Remarks:</hdr>
   <hdr o="remarkList_ul">========</hdr>
   <hdr o="visLoc">visibility|:&#9;</hdr>
   <hdr o="gridWind">Grid wind:&#9;&#9;</hdr>
   <hdr o="rwyWind">wind for runway |:&#9;</hdr>
   <hdr o="thrWind">wind for runway |:&#9;</hdr>
   <hdr o="peakWind">peak wind|:&#9;</hdr>
   <hdr o="SLPhPa">sea level pressure:&#9;</hdr>
   <hdr o="SLPdPa">sea level pressure:&#9;</hdr>
   <hdr o="SLPinHg">sea level pressure:&#9;</hdr>
   <hdr o="regQNH">reg. QNH:&#9;&#9;</hdr>
   <hdr o="QFE">QFE pressure:&#9;&#9;</hdr>
   <hdr o="QFF">QFF pressure:&#9;&#9;</hdr>
   <hdr o="rmkVisMin">minimum visibility:&#9;</hdr>
   <hdr o="rmkVisVar">visibility varies from:&#9;</hdr>
   <hdr o="correctedAt">report corrected at:&#9;</hdr>
   <hdr o="precip1Hour">1-hour precip. amount:&#9;</hdr>
   <hdr o="precip3Hour">3-hour precip. amount:&#9;</hdr>
   <hdr o="precip6Hour">6-hour precip. amount:&#9;</hdr>
   <hdr o="precip24Hour">24-hour precip. amount:&#9;</hdr>
   <hdr o="precip36Hour">3-/6-hour precip. amount:&#9;</hdr>
   <hdr o="ERROR">error at '@':&#9;&#9;</hdr>
   <hdr o="SST">sea surface temp.:&#9;</hdr>
   <hdr o="OAT">outside air temp.:&#9;</hdr>
   <hdr o="AI">AI:&#9;&#9;&#9;</hdr>
   <hdr o="snowIncr">snow increasing rapidly:&#9;</hdr>
   <hdr o="cloudTypeFamily">cloud types:&#10;</hdr>
   <hdr o="windShift">wind shift</hdr>
   <hdr o="beginEndPrecip">precipitation:&#9;</hdr>
   <hdr o="conditionMountain">mountains:&#9;&#9;</hdr>
   <hdr o="conditionValley">valleys:&#9;&#9;</hdr>
   <hdr o="turbulence">turbulence:&#9;&#9;</hdr>
   <hdr o="icing">icing:&#9;&#9;&#9;</hdr>
   <hdr o="tracesOf">traces of:&#9;&#9;</hdr>
   <hdr o="seaCondition">condition of the sea:&#9;</hdr>
   <hdr o="swellCondition">condition of the swell:&#9;</hdr>
   <hdr o="cloudLayer">cloud layer:&#9;&#9;</hdr>
   <hdr o="cloudLayerThin">thin cloud layer:&#9;</hdr>
   <hdr o="obscuration">due to |:&#9;</hdr>
   <hdr o="variableCeiling">ceiling variable:&#9;</hdr>
   <hdr o="pressureTendency3h">3-h pressure tend.:&#9;</hdr>
   <hdr o="ceilVisVariable">ceiling at or below 900 m and variable, visibility varies from:&#9;</hdr>
   <hdr o="rwySfcCondition">rwy surface condition:&#9;</hdr>
   <hdr o="rainfall">rainfall:&#9;&#9;</hdr>
   <hdr o="NEFO_PLAYA">NEFO PLAYA:&#9;&#9;</hdr>
   <hdr o="densityAlt">density altitude:&#9;</hdr>
   <hdr o="pressureAlt">pressure altitude:&#9;</hdr>
   <hdr o="obsTimeOffset">offset for observation time:&#9;</hdr>
   <hdr o="nextFcstBy">next forecast by:&#9;</hdr>
   <hdr o="nextFcstAt">next forecast:&#9;&#9;</hdr>
   <hdr o="amdAt">amendment:&#9;&#9;</hdr>
   <hdr o="fcstAutoObs">forecast based on automated observation</hdr>
   <hdr o="waterEquivOfSnow">water equivalent of snow on ground:&#9;</hdr>
   <hdr o="snowOnGround">snow on ground:&#9;&#9;</hdr>
   <hdr o="snowCover">snow cover:&#9;&#9;</hdr>
   <hdr o="fcstNotAvbl">forecast not available:&#9;</hdr>
   <hdr o="temp1">temperature 1:&#9;&#9;</hdr>
   <hdr o="temp2">temperature 2:&#9;&#9;</hdr>
   <hdr o="precipAmount1">precipitation 1:&#9;</hdr>
   <hdr o="precipAmount2">precipitation 2:&#9;</hdr>
   <hdr o="notRecognised">NOT RECOGNISED:&#9;&#9;</hdr>
   <hdr o="RSNK">data for Rattlesnake Mountain:</hdr>
   <hdr o="LAG_PK">data for Laguna Peak:</hdr>
   <hdr o="RADAT">radiosonde observation data for freezing level:</hdr>
   <hdr o="freezingLvl">freezing level:&#9;&#9;</hdr>
   <hdr o="durationOfSunshine">sunshine yesterday:&#9;</hdr>
   <hdr o="hailStones">hail stones:&#9;&#9;</hdr>

   <t o="notAvailable">(not available)</t>
   <t o="invalidFormat">invalid format</t>
   <t o="calm">calm</t>
   <t o="onThe">on the |., </t>
   <t o="dirVariable">from variable directions</t>
   <t o="dirNotAvailable">direction not available,</t>
   <t o="speedNotAvailable"> speed not available</t>
   <t o="wind-from">from the</t>
   <t o="last">last</t>
   <t o="segment">segment</t>
   <t o="wind-at">at</t>
   <t o="wind-gusts">&#9;&#9;&#9;with gusts</t>
   <t o="cloud-at">at</t>
   <t o="cloud-above">above</t>
   <t o="cloudTypeNotAvailable">(cloud type not observable)</t>
   <t o="baseBelowStation">cloud base below station level</t>
   <t o="time-at"> at |</t>
   <t o="afterHour">| minutes after the hour</t>
   <t o="time-from">from |</t>
   <t o="time-till">till |</t>
   <t o="variable">&#9;&#9;&#9;variable</t>
   <t o="variable-from">from</t>
   <t o="variable-to">to</t>
   <t o="varying-to">&#9;&#9;to:&#9;</t>
   <t o="visVertNA">impossible to determine</t>
   <t o="windShear">critical wind shear</t>
   <t o="rwyNotInUse">runway not in use</t>
   <t o="rwyVisNotAvailable">(visibility not available)</t>
   <t o="rwyDesigAll">all runways</t>
   <t o="rwyDesigRep">runway REP</t>
   <t o="rwyDesig">runway |</t>
   <t o="SNOCLO">aerodrome closed for snow</t>
   <t o="cleared">cleared</t>
   <t o="friction">friction: </t>
   <t o="depositExtent"> of runway covered</t>
   <t o="depositDepth">deposit depth |</t>
   <t o="NOSIG">no significant change</t>
   <t o="BECMG">becoming:</t>
   <t o="TEMPO">temporarily:</t>
   <t o="PROB">:</t>
   <t o="CAVOK">cloud and visibility OK</t>
   <t o="RVRNO">runway visual range should be reported but is missing</t>
   <t o="PWINO">sensor to identify present weather not operating</t>
   <t o="FZRANO">sensor to decect freezing rain not operating</t>
   <t o="TSNO">sensor to decect lightning not operating</t>
   <t o="PNO">sensor not operating: tipping bucket rain gauge</t>
   <t o="CHINO">secondary ceiling height indicator | not operating</t>
   <t o="VISNO">secondary visibility sensor | not operating</t>
   <t o="NOSPECI">no SPECI reports taken at this station</t>
   <t o="VIA_PHONE">via phone</t>
   <t o="RCRNR">runway condition reading not reported</t>
   <t o="HALO">halo</t>
   <t o="FROIN">frost on the indicator</t>
   <t o="LGT_FROIN">light frost on the indicator</t>
   <t o="HVY_FROIN">heavy frost on the indicator</t>
   <t o="VRBL_CONDS">variable conditions</t>
   <t o="ACFT_MSHP">aircraft mishap</t>
   <t o="CIG_RAG">ceiling ragged</t>
   <t o="needMaint">automated system needs maintenance</t>
   <t o="loc-and">and</t>
   <t o="loc-to">to</t>
   <t o="predictedColour">predicted:</t>
   <t o="prob">with |% probability</t>
   <t o="nextDay"> on the following day</t>
   <t o="distant"> in the distance</t>
   <t o="isStationary"> stationary</t>
   <t o="obscgMtns"> obscuring mountains</t>
   <t o="isGrid"> grid</t>
   <t o="quadrant">quadrant</t>
   <t o="snowIncrPastHour">| in. past hour</t>
   <t o="snowIncrOnGround">| in. on ground</t>
   <t o="low">low:&#9;&#9;</t>
   <t o="middle">mid-level:&#9;</t>
   <t o="high">high:&#9;&#9;</t>
   <t o="cloudLayerAboveOvercast">layer above overcast</t>
   <t o="FROPA">due to frontal passage</t>
   <t o="MOV"> moving</t>
   <t o="MOVD"> moved</t>
   <t o="began">began</t>
   <t o="ended">ended</t>
   <t o="compassDirLocation">|</t>
   <t o="compassDirTo"> to the|</t>
   <t o="compassDirFrom"> from the|</t>
   <t o="compassDirThrough"> through|</t>
   <t o="compassDirDescr"> |</t>
   <t o="compassDirDescrQuad"> | quadrant</t>
   <t o="isLower">lower</t>
   <t o="isLow">low</t>
   <t o="isFrequent">frequent</t>
   <t o="isOccasional">occasional</t>
   <t o="isThick">thick</t>
   <t o="isPrettyThick">pretty thick</t>
   <t o="isVeryThick">very thick</t>
   <t o="isThin">thin</t>
   <t o="isPrettyThin">pretty thin</t>
   <t o="isVeryThin">very thin</t>
   <t o="isFeeble">feeble</t>
   <t o="isPrettyFeeble">pretty feeble</t>
   <t o="isVeryFeeble">very feeble</t>
   <t o="isLight">light</t>
   <t o="isPrettyLight">pretty light</t>
   <t o="isVeryLight">very light</t>
   <t o="isModerate">moderate</t>
   <t o="isIntermittent">intermittent</t>
   <t o="isContinuous">continuous</t>
   <t o="isIsolated">isolated</t>
   <t o="isConvective">convective</t>
   <t o="isDissipated">dissipated</t>
   <t o="isFreezing">freezing</t>
   <t o="isPatchy">patchy</t>
   <t o="inPastHour">in past hour</t>
   <t o="isAloft">aloft</t>
   <t o="isAround">around</t>
   <t o="topOfLayer">top of layer</t>
   <t o="level-from">from</t>
   <t o="level-to">to</t>
   <t o="toTopOfCloud"> to top of cloud</t>
   <t o="isNotScheduled">is not scheduled</t>
   <t o="isLtdToCldVisWind">limited to cloud, visibility, and wind</t>
   <t o="amendment">amendment</t>
   <t o="ceiling">ceiling</t>
   <t o="approach">approach</t>
   <t o="cloudTypeAsoctd">| associated</t>
   <t o="cloudTypeEmbd">| embedded</t>
   <t o="change-by"> by</t>
   <t o="decelerometerReading">decelerometer reading</t>
   <t o="decelerometerReadingNA">no decelerometer reading available</t>
   <t o="rainfall10min"> mm in the last 10 minutes, </t>
   <t o="rainfall0900"> mm since 09:00 airport time</t>
   <t o="minutes">minutes</t>
   <t o="fcstAutoMETAR">forecast based on automated METAR</t>
   <t o="CAVU">clear or scattered clouds and visibility &gt;10 US-miles</t>
   <t o="EPC">estimated pass closed</t>
   <t o="EPO">estimated pass open</t>
   <t o="EPM">estimated pass marginal</t>
   <t o="RTS">return to service</t>
   <t o="visibilityAt">visibility at</t>
   <t o="traces">traces</t>
   <t o="firstObs">first| observation</t>
   <t o="nextObs">next| observation</t>
   <t o="lastObs">last| observation</t>
   <t o="isStaffed"> staffed</t>
   <t o="isManned"> manned</t>
   <t o="balloonDisapp">balloon disappeared at |</t>
   <t o="balloonVisib">balloon visible to |</t>
   <t o="estimated">estimated</t>
   <t o="dueToIceAccretion"> due to ice accretion</t>
   <t o="BA_GOOD">braking action good</t>
   <t o="BA_POOR">braking action poor</t>
   <t o="THN_SPTS_IOVC">thin spots in overcast</t>
   <t o="FUOCTY">smoke over city</t>
   <t o="ALTM_MISG">altimeter value missing</t>
   <t o="ALL_WNDS_GRID">all wind directions grid</t>
   <t o="CONTRAILS">condensation trails</t>
   <t o="SKY_OBSC">sky obscured</t>
   <t o="MTNS_OBSC">mountains obscured</t>
   <t o="FOGGY">foggy</t>
   <t o="TWLGT">twilight</t>
   <t o="missing">missing</t>
   <t o="slash">/</t>
   <t o="FIBI">filed but impracticable to transmit</t>
   <t o="hailStoneSize">biggest diameter </t>

   <reportModifierType o="NIL" >report missing</reportModifierType>
   <reportModifierType o="AUTO">automatically generated</reportModifierType>
   <reportModifierType o="COR" >manually corrected</reportModifierType>
   <reportModifierType o="RTD" >routine delayed</reportModifierType>
   <reportModifierType o="P"   >segmented, </reportModifierType>
   <reportModifierType o="RR"  >delayed</reportModifierType>
   <reportModifierType o="CC"  >corrected</reportModifierType>
   <reportModifierType o="AA"  >amended</reportModifierType>
   <reportModifierType o="AMD" >amended</reportModifierType>

   <compassDir o="N">north</compassDir>
   <compassDir o="NNE">north-north-east</compassDir>
   <compassDir o="NE">north-east</compassDir>
   <compassDir o="ENE">east-north-east</compassDir>
   <compassDir o="E">east</compassDir>
   <compassDir o="ESE">east-south-east</compassDir>
   <compassDir o="SE">south-east</compassDir>
   <compassDir o="SSE">south-south-east</compassDir>
   <compassDir o="S">south</compassDir>
   <compassDir o="SSW">south-south-west</compassDir>
   <compassDir o="SW">south-west</compassDir>
   <compassDir o="WSW">west-south-west</compassDir>
   <compassDir o="W">west</compassDir>
   <compassDir o="WNW">west-north-west</compassDir>
   <compassDir o="NW">north-west</compassDir>
   <compassDir o="NNW">north-north-west</compassDir>

   <units o="M"> m</units>
   <units o="KM"> km</units>
   <units o="MM"> mm</units>
   <units o="SM"> US-miles</units>
   <units o="NM"> NM</units>
   <units o="FT"> ft</units>
   <units o="IN"> in.</units>
   <units o="KMH"> km/h</units>
   <units o="KT"> kt</units>
   <units o="MPH"> mph</units>
   <units o="MPS"> m/s</units>
   <units o="hPa"> hPa</units>
   <units o="inHg"> in. Hg</units>
   <units o="MIN"> min.</units>
   <units o="H"> hour(s)</units>

   <locationSpec o="OMTNS">over mountains</locationSpec>
   <locationSpec o="OHD">overhead</locationSpec>
   <locationSpec o="ALQDS">all quadrants</locationSpec>
   <locationSpec o="AT_AP">at airport</locationSpec>
   <locationSpec o="OVR_AP">over airport</locationSpec>
   <locationSpec o="IN_VLY">in valley</locationSpec>
   <locationSpec o="V_D">to various directions</locationSpec>
   <locationSpec o="OVR_LK">over lake</locationSpec>
   <locationSpec o="OVR_RIVER">over river</locationSpec>
   <locationSpec o="OVR_VLYS">over valleys</locationSpec>
   <locationSpec o="ALG_LK">along lake</locationSpec>
   <locationSpec o="ALG_MT">along mountains</locationSpec>
   <locationSpec o="ALG_RIVER">along river</locationSpec>
   <locationSpec o="UNKN">in unknown direction</locationSpec>

   <cloudCover o="SKC-s">clear skies</cloudCover>
   <cloudCover o="NSC-s">clear skies</cloudCover>
   <cloudCover o="CLR-s">clear skies</cloudCover>
   <cloudCover o="NCD-s">no cloud detected</cloudCover>

   <cloudCover o="SKC">sky clear</cloudCover>
   <cloudCover o="NSC">nil significant clouds</cloudCover>
   <cloudCover o="CLR">no clouds below 10000 ft</cloudCover>
   <cloudCover o="NCD">no cloud detected</cloudCover>
   <cloudCover o="FEW">few clouds</cloudCover>
   <cloudCover o="SCT">scattered clouds</cloudCover>
   <cloudCover o="BKN">broken clouds</cloudCover>
   <cloudCover o="OVC">sky overcast</cloudCover>

   <cloudType o="AC">altocumulus</cloudType>
   <cloudType o="ACC">altocumulus castellanus</cloudType>
   <cloudType o="ACSL">altocumulus standing lenticular</cloudType>
   <cloudType o="AS">altostratus</cloudType>
   <cloudType o="CB">cumulonimbus</cloudType>
   <cloudType o="CBMAM">cumulonimbus mammatus</cloudType>
   <cloudType o="CC">cirrocumulus</cloudType>
   <cloudType o="CCSL">cirrocumulus standing lenticular</cloudType>
   <cloudType o="CF">cumulus fractus</cloudType>
   <cloudType o="CI">cirrus</cloudType>
   <cloudType o="CS">cirrostratus</cloudType>
   <cloudType o="CU">cumulus</cloudType>
   <cloudType o="CUFRA">cumulus fractus</cloudType>
   <cloudType o="NS">nimbostratus</cloudType>
   <cloudType o="SAC">stratoaltocumulus</cloudType>
   <cloudType o="SC">stratocumulus</cloudType>
   <cloudType o="SCSL">stratocumulus standing lenticular</cloudType>
   <cloudType o="SF">stratus fractus</cloudType>
   <cloudType o="ST">stratus</cloudType>
   <cloudType o="STFRA">stratus fractus</cloudType>
   <cloudType o="TCU">towering cumulus</cloudType>

<!-- thanks to http://www.srh.noaa.gov/eyw/HTML/Jim_Clouds/CloudTypes/low.html -->
   <cloudTypeLow o="0">no clouds</cloudTypeLow>
   <cloudTypeLow o="1">cumulus (little vertical extent)</cloudTypeLow>
   <cloudTypeLow o="2">cumulus (moderate/strong vertical extent or towering cumulus)</cloudTypeLow>
   <cloudTypeLow o="3">cumulonimbus (tops not fibrous or in form of an anvil)</cloudTypeLow>
   <cloudTypeLow o="4">stratocumulus (formed by spreading cumulus)</cloudTypeLow>
   <cloudTypeLow o="5">stratocumulus (not formed by spreading cumulus)</cloudTypeLow>
   <cloudTypeLow o="6">stratus (fairly continuous sheet and/or layer)</cloudTypeLow>
   <cloudTypeLow o="7">stratus fractus or cumulus fractus of bad weather</cloudTypeLow>
   <cloudTypeLow o="8">cumulus and stratocumulus (not formed by spreading cumulus)</cloudTypeLow>
   <cloudTypeLow o="9">cumulonimbus (tops fibrous or in form of an anvil)</cloudTypeLow>

   <cloudTypeMiddle o="0">no clouds</cloudTypeMiddle>
   <cloudTypeMiddle o="1">altostratus (predominantly semi-transparent)</cloudTypeMiddle>
   <cloudTypeMiddle o="2">altostratus (predominantly opaque)</cloudTypeMiddle>
   <cloudTypeMiddle o="3">altocumulus (not progressively invading the sky)</cloudTypeMiddle>
   <cloudTypeMiddle o="4">altocumulus (lenticularis)</cloudTypeMiddle>
   <cloudTypeMiddle o="5">altocumulus (progressively invading the sky or semi-transparent)</cloudTypeMiddle>
   <cloudTypeMiddle o="6">altocumulus (formed by spreading cumulus or cumulonimbus)</cloudTypeMiddle>
   <cloudTypeMiddle o="7">altocumulus (mainly opaque, not expanding; or with altostratus)</cloudTypeMiddle>
   <cloudTypeMiddle o="8">altocumulus (with sproutings or tufts)</cloudTypeMiddle>
   <cloudTypeMiddle o="9">chaotic sky with altocumulus at several levels</cloudTypeMiddle>

   <cloudTypeHigh o="0">no clouds</cloudTypeHigh>
   <cloudTypeHigh o="1">cirrus (filaments, strands, or hooks)</cloudTypeHigh>
   <cloudTypeHigh o="2">cirrus (dense, with sproutings, or in tufts)</cloudTypeHigh>
   <cloudTypeHigh o="3">cirrus (dense, remaining from cumulonimbus anvil)</cloudTypeHigh>
   <cloudTypeHigh o="4">cirrus (hooks or filaments, progressively invading the sky)</cloudTypeHigh>
   <cloudTypeHigh o="5">cirrus and/or stratocumulus (progressively invading the sky, veil &lt;45° above horizon)</cloudTypeHigh>
   <cloudTypeHigh o="6">cirrus and/or stratocumulus (progressively invading the sky, veil &gt;45° above horizon)</cloudTypeHigh>
   <cloudTypeHigh o="7">cirrostratus (covering the entire sky)</cloudTypeHigh>
   <cloudTypeHigh o="8">cirrostratus (not invading or covering the entire sky)</cloudTypeHigh>
   <cloudTypeHigh o="9">cirrocumulus (as predominant high cloud)</cloudTypeHigh>

   <weather o="phen-light">light </weather>
   <weather o="phen-moderate">moderate </weather>
   <weather o="phen-heavy">heavy </weather>
   <weather o="inVicinity"> in the vicinity</weather>
   <weather o="BCFG">|patches of fog</weather>
   <weather o="BLDU">|blowing dust</weather>
   <weather o="BLSA">|blowing sand</weather>
   <weather o="BLSN">|blowing snow</weather>
   <weather o="BR">|mist</weather>
   <weather o="DRSA">|low drifting sand</weather>
   <weather o="DRSN">|low drifting snow</weather>
   <weather o="DS">|duststorm</weather>
   <weather o="DU">|widespread dust</weather>
   <weather o="DZ">|drizzle</weather>
   <weather o="DZRA">|drizzle with rain</weather>
   <weather o="DZSN">|drizzle with snow</weather>
   <weather o="FC">|funnel cloud</weather>
   <weather o="FG">|fog</weather>
   <weather o="FU">|smoke</weather>
   <weather o="FZBCFG">|freezing patches of fog</weather>
   <weather o="FZBR">|freezing mist</weather>
   <weather o="FZDZ">|freezing drizzle</weather>
   <weather o="FZFG">|freezing fog</weather>
   <weather o="FZRA">|freezing rain</weather>
   <weather o="FZRAPL">|freezing rain with ice pellets</weather>
   <weather o="FZRAPLSN">|freezing rain with ice pellets and snow</weather>
   <weather o="FZRASN">|freezing rain with snow</weather>
   <weather o="GR">|hail</weather>
   <weather o="GRRA">|hail with rain</weather>
   <weather o="GS">|small hail and/or snow pellets</weather>
   <weather o="HZ">|haze</weather>
   <weather o="IC">|ice crystals</weather>
   <weather o="JP">|adjacent precipitation</weather>
   <weather o="MIFG">|shallow fog</weather>
   <weather o="NSW">nil significant weather</weather>
   <weather o="PL">|ice pellets</weather>
   <weather o="PO">|dust/sand whirls</weather>
   <weather o="PRFG">|partial fog</weather>
   <weather o="RA">|rain</weather>
   <weather o="RADZ">|rain with drizzle</weather>
   <weather o="RAPL">|rain with ice pellets</weather>
   <weather o="RASN">|rain with snow</weather>
   <weather o="SA">|sand</weather>
   <weather o="SG">|snow grains</weather>
   <weather o="SH">|showers</weather>
   <weather o="SHGR">|hail showers</weather>
   <weather o="SHGSRA">|showers of small hail and/or snow pellets with rain</weather>
   <weather o="SHPL">|showers of ice pellets</weather>
   <weather o="SHRA">|rain showers</weather>
   <weather o="SHRADZ">|showers of rain with drizzle</weather>
   <weather o="SHRAGS">|showers of rain with small hail and/or snow pellets</weather>
   <weather o="SHSN">|snow showers</weather>
   <weather o="SHRAPL">|showers of rain with ice pellets</weather>
   <weather o="SHRASN">|showers of rain with snow</weather>
   <weather o="SHSNGS">|showers of snow with small hail and/or snow pellets</weather>
   <weather o="SHSNPL">|showers of snow with ice pellets</weather>
   <weather o="SHSNRA">|showers of snow with rain</weather>
   <weather o="SN">|snow</weather>
   <weather o="SNPL">|snow with ice pellets</weather>
   <weather o="SNRA">|snow with rain</weather>
   <weather o="SQ">|squalls</weather>
   <weather o="SS">|sandstorm</weather>
   <weather o="TS">|thunderstorm</weather>
   <weather o="TSDZ">thunderstorm with |drizzle</weather>
   <weather o="TSRA">thunderstorm with |rain</weather>
   <weather o="TSRAGR">thunderstorm with |rain and hail</weather>
   <weather o="TSGS">thunderstorm with |small hail and/or snow pellets</weather>
   <weather o="UP">|unknown precipitation</weather>
   <weather o="VA">|volcanic ash</weather>
   <weather o="tornado">tornado/waterspout</weather>

   <tornadicActivity o="tornado">tornado</tornadicActivity>
   <tornadicActivity o="funnel_cloud">funnel cloud</tornadicActivity>
   <tornadicActivity o="waterspout">waterspout</tornadicActivity>

   <lightningType o="CA">cloud-air</lightningType>
   <lightningType o="CC">cloud-cloud</lightningType>
   <lightningType o="CG">cloud-ground</lightningType>
   <lightningType o="CW">cloud-water</lightningType>
   <lightningType o="IC">in-cloud</lightningType>

   <visTrend o="U">increasing</visTrend>
   <visTrend o="N">no change</visTrend>
   <visTrend o="D">decreasing</visTrend>

   <stationType o="AO1">automated station without precipitation discriminator</stationType>
   <stationType o="AO2">automated station with precipitation discriminator</stationType>
   <stationType o="AO2A">automated station with precipitation discriminator and manual augmentation</stationType>

   <depositType o="0">clear and dry</depositType>
   <depositType o="1">damp</depositType>
   <depositType o="2">wet or puddles</depositType>
   <depositType o="3">frost</depositType>
   <depositType o="4">dry snow</depositType>
   <depositType o="5">wet snow</depositType>
   <depositType o="6">slush</depositType>
   <depositType o="7">ice</depositType>
   <depositType o="8">compacted snow</depositType>
   <depositType o="9">frozen ridges</depositType>

   <depositExtent o="0">0%|</depositExtent>
   <depositExtent o="1">1-10%|</depositExtent>
   <depositExtent o="2">11-25%|</depositExtent>
   <depositExtent o="5">26-50%|</depositExtent>
   <depositExtent o="9">51-100%|</depositExtent>

   <friction o="91">poor braking action</friction>
   <friction o="92">poor/medium braking action</friction>
   <friction o="93">medium braking action</friction>
   <friction o="94">medium/good braking action</friction>
   <friction o="95">good braking action</friction>
   <friction o="99">friction: unreliable measurement</friction>

   <colour o="BLACK"     >airport closed for technical reasons</colour>
   <colour o="BLUplus"   >ceiling 20000 ft, visibility 8 km</colour>
   <colour o="BLU"       >ceiling 2500 ft, visibility 8 km</colour>
   <colour o="WHT"       >ceiling 1500 ft, visibility 5 km</colour>
   <colour o="GRN"       >ceiling 700 ft, visibility 3700 m</colour>
   <colour o="YLO1"      >ceiling 500 ft, visibility 2500 m</colour>
   <colour o="YLO2"      >ceiling 300 ft, visibility 1600 m</colour>
   <colour o="YLO"       >ceiling 300 ft, visibility 1600 m</colour>
   <colour o="AMB"       >ceiling 200 ft, visibility 800 m</colour>
   <colour o="RED"       >ceiling &lt;200 ft, visibility &lt;800 m</colour>
   <colour o="FCSTCANCEL">forecast cancelled</colour>
   <colour o="noChange">no change of ceiling or visibility</colour>

   <visibilityAtLoc o="MAR">visibility at sea:&#9;</visibilityAtLoc>
   <visibilityAtLoc o="SFC">visibility at surface:&#9;</visibilityAtLoc>
   <visibilityAtLoc o="TWR">visibility at tower:&#9;</visibilityAtLoc>

   <concernsChange o="M">deterioration of | conditions</concernsChange>
   <concernsChange o="B">improvement of | conditions</concernsChange>
   <concernsSubject o="0">gust</concernsSubject>
   <concernsSubject o="1">wind</concernsSubject>
   <concernsSubject o="2">visibility</concernsSubject>
   <concernsSubject o="3">cloud</concernsSubject>
   <concernsSubject o="4">precipitation</concernsSubject>
   <concernsSubject o="5">pressure</concernsSubject>
   <concernsSubject o="6">state of sea or swell</concernsSubject>
   <concernsSubject o="7">duststorm, sandstorm or blowing snow</concernsSubject>
   <concernsSubject o="8">thunderstorm</concernsSubject>
   <concernsSubject o="9">squalls or tornado</concernsSubject>

   <phenomenon o="LTG">lightning</phenomenon>
   <phenomenon o="VIRGA">virga</phenomenon>
   <phenomenon o="AURBO">aurea borealis</phenomenon>
   <phenomenon o="FG_BNK">fog bank</phenomenon>
   <phenomenon o="PCPN">precipitation</phenomenon>
   <phenomenon o="VLY_FG">valley fog</phenomenon>
   <phenomenon o="HIR_CLDS">higher clouds</phenomenon>
   <phenomenon o="FULYR">smoke layer</phenomenon>
   <phenomenon o="HZY">hazy</phenomenon>
   <phenomenon o="BINOVC">breaks in overcast</phenomenon>
   <phenomenon o="ICG">icing</phenomenon>
   <phenomenon o="SH">shower</phenomenon>
   <phenomenon o="SHS">showers</phenomenon>
   <phenomenon o="DEW">dew</phenomenon>
   <phenomenon o="VIS_HYR">visibility higher</phenomenon>
   <phenomenon o="VIS_LWR">visibility lower</phenomenon>
   <phenomenon o="VIS_RDCD">visibility reduced</phenomenon>
   <phenomenon o="CIG_HYR">ceiling higher</phenomenon>
   <phenomenon o="CIG_LWR">ceiling lower</phenomenon>
   <phenomenon o="CLD">cloud</phenomenon>
   <phenomenon o="CLDS">clouds</phenomenon>
   <phenomenon o="CLD_EMBD">cloud embedded</phenomenon>
   <phenomenon o="CLDS_EMBD">clouds embedded</phenomenon>
   <phenomenon o="PRESFR">pressure trend: falling rapidly</phenomenon>
   <phenomenon o="PRESRR">pressure trend: rising rapidly</phenomenon>
   <phenomenon o="FIRE">fire</phenomenon>
   <phenomenon o="FIRES">fires</phenomenon>
   <phenomenon o="GRASS_FIRE">grass fire</phenomenon>
   <phenomenon o="GRASS_FIRES">grass fires</phenomenon>

   <quadrant o="1">first</quadrant>
   <quadrant o="2">second</quadrant>
   <quadrant o="3">third</quadrant>
   <quadrant o="4">forth</quadrant>

   <condMounType o="LIB">free of clouds</condMounType>
   <condMounType o="CLD_SCT">partially covered in isolated clouds</condMounType>
   <condMounType o="VERS_INC">slopes in clouds, top is free</condMounType>
   <condMounType o="CNS_POST">free from side of observer, other side in clouds</condMounType>
   <condMounType o="CLD_CIME">clouds touch top</condMounType>
   <condMounType o="CIME_INC">top in clouds, slopes free</condMounType>
   <condMounType o="GEN_INC">generally in clouds, some tops free</condMounType>
   <condMounType o="INC">in clouds</condMounType>
   <condMounType o="INVIS">not visible</condMounType>

   <condMounChange o="NC">no change</condMounChange>
   <condMounChange o="CUF">cumuli developing</condMounChange>
   <condMounChange o="ELEV_SLW">raising slowly</condMounChange>
   <condMounChange o="ELEV_RAPID">raising rapidly</condMounChange>
   <condMounChange o="ELEV_STF">raising and stratifying</condMounChange>
   <condMounChange o="ABB_SLW">sinking slowly</condMounChange>
   <condMounChange o="ABB_RAPID">sinking rapidly</condMounChange>
   <condMounChange o="STF">stratifying</condMounChange>
   <condMounChange o="STF_ABB">stratifying and sinking</condMounChange>
   <condMounChange o="VAR_RAPID">varying rapidly</condMounChange>

   <condVallType o="NIL">no low clouds, fog or haze</condVallType>
   <condVallType o="FOSCHIA">haze</condVallType>
   <condVallType o="FOSCHIA_SKC_SUP">haze, sky clear above</condVallType>
   <condVallType o="NEBBIA">fog</condVallType>
   <condVallType o="NEBBIA_SCT">isolated fog banks</condVallType>
   <condVallType o="CLD_SCT">isolated clouds</condVallType>
   <condVallType o="CLD_SCT_NEBBIA_INF">isolated clouds, fog below</condVallType>
   <condVallType o="MAR_CLD">sea in clouds</condVallType>
   <condVallType o="INVIS">not visible</condVallType>

   <condVallChange o="NC">no change</condVallChange>
   <condVallChange o="DIM">decreasing</condVallChange>
   <condVallChange o="DIM_ELEV">decreasing and raising</condVallChange>
   <condVallChange o="DIM_ABB">decreasing and sinking</condVallChange>
   <condVallChange o="AUM">increasing</condVallChange>
   <condVallChange o="AUM_ELEV">increasing and raising</condVallChange>
   <condVallChange o="AUM_ABB">increasing and sinking</condVallChange>
   <condVallChange o="ELEV">raising</condVallChange>
   <condVallChange o="ABB">sinking</condVallChange>
   <condVallChange o="NEBBIA_INTER">intermittent fog at station</condVallChange>

   <!-- WMO 306 Vol I.1 Part A, coding table 0300 -->
   <turbulenceDescr o="0">none</turbulenceDescr>
   <turbulenceDescr o="1">light</turbulenceDescr>
   <turbulenceDescr o="2">occasional, moderate, in clear air</turbulenceDescr>
   <turbulenceDescr o="3">frequent, moderate, in clear air</turbulenceDescr>
   <turbulenceDescr o="4">occasional, moderate, in cloud</turbulenceDescr>
   <turbulenceDescr o="5">frequent, moderate, in cloud</turbulenceDescr>
   <turbulenceDescr o="6">occasional, severe, in clear air</turbulenceDescr>
   <turbulenceDescr o="7">frequent, severe, in clear air</turbulenceDescr>
   <turbulenceDescr o="8">occasional, severe, in cloud</turbulenceDescr>
   <turbulenceDescr o="9">frequent, severe, in cloud</turbulenceDescr>

   <!-- WMO 306 Vol I.1 Part A, coding table 1733 -->
   <icingDescr o="0">none</icingDescr>
   <icingDescr o="1">light</icingDescr>
   <icingDescr o="2">light, in cloud</icingDescr>
   <icingDescr o="3">light, in precipitation</icingDescr>
   <icingDescr o="4">moderate</icingDescr>
   <icingDescr o="5">moderate, in cloud</icingDescr>
   <icingDescr o="6">moderate, in precipitation</icingDescr>
   <icingDescr o="7">severe</icingDescr>
   <icingDescr o="8">severe, in cloud</icingDescr>
   <icingDescr o="9">severe, in precipitation</icingDescr>

   <seaCondition o="0">calm (glassy)</seaCondition>
   <seaCondition o="1">calm (rippled)</seaCondition>
   <seaCondition o="2">smooth (wavelets)</seaCondition>
   <seaCondition o="3">slight waves</seaCondition>
   <seaCondition o="4">moderate waves</seaCondition>
   <seaCondition o="5">rough</seaCondition>
   <seaCondition o="6">very rough</seaCondition>
   <seaCondition o="7">high waves</seaCondition>
   <seaCondition o="8">very high waves</seaCondition>
   <seaCondition o="9">phenomenal waves</seaCondition>

   <swellCondition o="0">none</swellCondition>
   <swellCondition o="1">length: short or average, height: low</swellCondition>
   <swellCondition o="2">length: long, height: low</swellCondition>
   <swellCondition o="3">length: short, height: moderate</swellCondition>
   <swellCondition o="4">length: medium, height: moderate</swellCondition>
   <swellCondition o="5">length: long, height: moderate</swellCondition>
   <swellCondition o="6">length: short, height: high</swellCondition>
   <swellCondition o="7">length: medium height: high</swellCondition>
   <swellCondition o="8">length: long, height: high</swellCondition>
   <swellCondition o="9">chaotic</swellCondition>

   <cloudPhenom o="PWR_PLNT">power plant</cloudPhenom>
   <cloudPhenom o="PWR_PLNT_PLUME">power plant plume</cloudPhenom>

   <pressureTend o="0">increasing, then decreasing</pressureTend>
   <pressureTend o="1">increasing, then steady, or increasing then increasing more slowly</pressureTend>
   <pressureTend o="2">increasing steadily or unsteadily</pressureTend>
   <pressureTend o="3">decreasing or steady, then increasing; or increasing then increasing more rapidly</pressureTend>
   <pressureTend o="4">steady</pressureTend>
   <pressureTend o="5">decreasing then increasing</pressureTend>
   <pressureTend o="6">decreasing, then steady, or decreasing then decreasing more slowly</pressureTend>
   <pressureTend o="7">decreasing steadily or unsteadily</pressureTend>
   <pressureTend o="8">steady or increasing, then decreasing; or decreasing then decreasing more rapidly</pressureTend>

   <rwySfc o="SLR">slush on runway</rwySfc>
   <rwySfc o="LSR">loose snow on runway</rwySfc>
   <rwySfc o="PSR">packed snow on runway</rwySfc>
   <rwySfc o="P">patchy</rwySfc>
   <rwySfc o="SANDED">sanded</rwySfc>
   <rwySfc o="WET">wet</rwySfc>
   <rwySfc o="DRY">dry</rwySfc>
   <rwySfc o="IR">ice on runway</rwySfc>
   <rwySfc o="WR">wet runway</rwySfc>

   <snowCoverType o="ONE_LOOSE">one loose</snowCoverType>
   <snowCoverType o="MUCH_LOOSE">much loose</snowCoverType>
   <snowCoverType o="TRACE_LOOSE">trace loose</snowCoverType>
   <snowCoverType o="MEDIUM_PACKED">medium packed</snowCoverType>
   <snowCoverType o="HARD_PACKED">hard packed</snowCoverType>
   <snowCoverType o="NIL">nil</snowCoverType>

   <estimatedItem o="WND">wind</estimatedItem>
   <estimatedItem o="CIG">ceiling</estimatedItem>
   <estimatedItem o="CIG_BLN">ceiling from balloon data</estimatedItem>
   <estimatedItem o="CLD_HGTS">cloud heights</estimatedItem>
   <estimatedItem o="SLP">sea level pressure</estimatedItem>
   <estimatedItem o="ALSTG">altimeter setting</estimatedItem>

   <fcstNotAvblReason o="NOOBS">no observation</fcstNotAvblReason>
   <fcstNotAvblReason o="INSUFFICIENTOBS">insufficient observation</fcstNotAvblReason>

   <error o="obsStation">not a station code</error>
   <error o="obsTime">not an observation time</error>
   <error o="other">invalid format</error>

   <cgi o="title">METAR/TAF decoder</cgi>
   <cgi o="infosrc">A good source for up-to-date METAR and TAF messages is</cgi>
   <cgi o="outdated">Warning: forecast data for many stations has not been updated at NOAA since August, 3rd, 2006.</cgi>
   <cgi o="infofetch">If the keyword "FETCH" and one or more Airport-Ids are used, messages are fetched from the selected source (or if this option is disabled from a file on the server where this web page comes from).</cgi>
   <cgi o="example">examples for messages:</cgi>
   <cgi o="message">message:</cgi>
   <cgi o="type">is of type:</cgi>
   <cgi o="source">fetch from:</cgi>
   <cgi o="language">language:</cgi>
   <cgi o="format">output as:</cgi>
   <cgi o="decode">decode</cgi>
   <cgi o="disclaimer">Warning: The information on this page may be out-dated, inaccurate, or both. It is not suited for use in aviation.</cgi>
  </en>

  <es> <!-- thanks to es.allmetsat.com -->
   <compassDir16>
    <arr>N</arr>
    <arr>NNE</arr>
    <arr>NE</arr>
    <arr>ENE</arr>
    <arr>E</arr>
    <arr>ESE</arr>
    <arr>SE</arr>
    <arr>SSE</arr>
    <arr>S</arr>
    <arr>SSO</arr>
    <arr>SO</arr>
    <arr>OSO</arr>
    <arr>O</arr>
    <arr>ONO</arr>
    <arr>NO</arr>
    <arr>NNO</arr>
    <arr>N</arr>
   </compassDir16>

   <hdr o="metar">METAR observación</hdr>
   <hdr o="metar_ul">=================</hdr>
   <hdr o="speci">SPECI observación</hdr>
   <hdr o="speci_ul">=================</hdr>
   <hdr o="taf">previsión por aeropuerto</hdr>
   <hdr o="taf_hour">|-hora previsión por aeropuerto</hdr>
   <hdr o="taf_ul">========================</hdr>
   <hdr o="obsStation">id de la estación:&#9;</hdr>
   <hdr o="obsTime">tiempo del observación:&#9;</hdr>
   <hdr o="issueTime">tiempo del publicación:&#9;</hdr>
   <hdr o="fcstPeriod">validad de pronóstico:&#9;</hdr>
   <hdr o="visPrev">visibilidad:&#9;&#9;</hdr>
   <hdr o="visMin">&#9;&#9;&#9;</hdr>
   <hdr o="visRwy">visibilidad pista |:&#9;</hdr>
   <hdr o="visTrend">&#9;tendencia:&#9;&#9;</hdr>
   <hdr o="visVert">Vert. visibilidad:&#9;</hdr>
   <hdr o="sfcWind">viento:&#9;&#9;&#9;</hdr>
   <hdr o="weather-1">tiempo:&#9;&#9;&#9;</hdr>
   <hdr o="cloud-1">nubes:&#9;&#9;&#9;</hdr>
   <hdr o="ceiling">techo:&#9;&#9;&#9;</hdr>
   <hdr o="temperature-temp">temperatura:&#9;&#9;</hdr>
   <hdr o="temperature-dew">punto de rocío:&#9;&#9;</hdr>
   <hdr o="tempHourly-temp">1h media temperatura:&#9;</hdr>
   <hdr o="tempHourly-dew">1h media punto de rocío:&#9;</hdr>
   <hdr o="relHumid">rel. humedad:&#9;&#9;</hdr>
   <hdr o="tempMax">max. temperatura:&#9;</hdr>
   <hdr o="tempMin">min. temperatura:&#9;</hdr>
   <hdr o="temp6hMax">6h max. temperatura:&#9;</hdr>
   <hdr o="temp6hMin">6h min. temperatura:&#9;</hdr>
   <hdr o="temp24hMax">24h max. temperatura:&#9;</hdr>
   <hdr o="temp24hMin">24h min. temperatura:&#9;</hdr>
   <hdr o="tempAt">temperatura:&#9;&#9;</hdr>
   <hdr o="tempMaxFQ">max. temperatura:&#9;</hdr>
   <hdr o="QNH">presión:&#9;&#9;</hdr>
   <hdr o="somePressure">presión differente:&#9;&#9;</hdr>
   <hdr o="stateOfRwy">estado |:&#9;</hdr>
   <hdr o="windShearRwy">|:&#9;&#9;</hdr>
   <hdr o="recentWeather-1">tiempo reciente:&#9;&#9;</hdr>
   <hdr o="colourCode">código de color:&#9;&#9;</hdr>
   <hdr o="windShearLvl">CIZALLADURA DEL VIENTO! Viento:&#9;</hdr>
   <hdr o="cloudMaxCover">max. cubierta de nubes:&#9;</hdr>
   <hdr o="cloudCoverVar">nubes:&#9;&#9;</hdr>
   <hdr o="cloudCoverVar2">variando a:&#9;&#9;&#9;</hdr>
   <hdr o="reportConcerns">informe concierne:&#9;&#9;</hdr>
   <hdr o="cloudOpacityLvl">fenómeno con opacidad:&#9;</hdr>
   <hdr o="trendList">tendencias por los 2 horas siguiente:</hdr>
   <hdr o="trendList_ul">=====================================</hdr>
   <hdr o="trendListTAF">previsión de tendencias:</hdr>
   <hdr o="trendListTAF_ul">========================</hdr>
   <hdr o="remarkList">comentarios:</hdr>
   <hdr o="remarkList_ul">============</hdr>
   <hdr o="visLoc">visibilidad|:&#9;</hdr>
   <hdr o="gridWind">Grid viento:&#9;&#9;</hdr>
   <hdr o="rwyWind">viento por pista |:&#9;</hdr>
   <hdr o="thrWind">viento por pista |:&#9;</hdr>
   <hdr o="peakWind">viento mayor|:&#9;</hdr>
   <hdr o="SLPhPa">presión al nivel del mar:&#9;</hdr>
   <hdr o="SLPdPa">presión al nivel del mar:&#9;</hdr>
   <hdr o="SLPinHg">presión al nivel del mar:&#9;</hdr>
   <hdr o="regQNH">reg. QNH:&#9;&#9;</hdr>
   <hdr o="QFE">QFE presión:&#9;&#9;</hdr>
   <hdr o="QFF">QFF presión:&#9;&#9;</hdr>
   <hdr o="rmkVisMin">minimum visibilidad:&#9;</hdr>
   <hdr o="rmkVisVar">visib. variando desde:&#9;</hdr>
   <hdr o="correctedAt">informe correctado a:&#9;</hdr>
   <hdr o="precip1Hour">pluviosidad desde 1h:&#9;</hdr>
   <hdr o="precip3Hour">pluviosidad desde 3h:&#9;</hdr>
   <hdr o="precip6Hour">pluviosidad desde 6h:&#9;</hdr>
   <hdr o="precip24Hour">pluviosidad desde 24h:&#9;</hdr>
   <hdr o="precip36Hour">pluviosidad desde 3/6h:&#9;</hdr>
   <hdr o="ERROR">error a '@':&#9;&#9;</hdr>
   <hdr o="SST">temp. del superficie del mar:&#9;</hdr>
   <hdr o="OAT">temp. del aire exterior:&#9;</hdr>
   <hdr o="AI">AI:&#9;&#9;&#9;</hdr>
   <hdr o="snowIncr">nieve creciente rápidamente:&#9;</hdr>
   <hdr o="cloudTypeFamily">typos de nubes:&#10;</hdr>
   <hdr o="windShift">cambio del viento</hdr>
   <hdr o="beginEndPrecip">precipitación:&#9;</hdr>
   <hdr o="conditionMountain">montañas:&#9;&#9;</hdr>
   <hdr o="conditionValley">valles:&#9;&#9;</hdr>
   <hdr o="turbulence">turbulencia:&#9;&#9;</hdr>
   <hdr o="icing">congelación:&#9;&#9;</hdr>
   <hdr o="tracesOf">vestigios de:&#9;&#9;</hdr>
   <hdr o="seaCondition">estado del mar:&#9;</hdr>
   <hdr o="swellCondition">estado del oleaje:&#9;</hdr>
   <hdr o="cloudLayer">capa de nubes:&#9;&#9;</hdr>
   <hdr o="cloudLayerThin">capa fina de nubes:&#9;</hdr>
   <hdr o="obscuration">debido a |:&#9;</hdr>
   <hdr o="variableCeiling">techo variando:&#9;</hdr>
   <hdr o="pressureTendency3h">3-h tend. de presión:&#9;</hdr>
   <hdr o="ceilVisVariable">techo a o debajo de 900 m y variando, visibilidad variando desde:&#9;</hdr>
   <hdr o="rwySfcCondition">estado del superficie de la pista:&#9;</hdr>
   <hdr o="rainfall">pluviosidad:&#9;&#9;</hdr>
   <hdr o="NEFO_PLAYA">NEFO PLAYA:&#9;&#9;</hdr>
   <hdr o="densityAlt">altitud densimétrica:&#9;</hdr>
   <hdr o="pressureAlt">altitud de presión:&#9;</hdr>
   <hdr o="obsTimeOffset">desplazamiento para tiempo del observación:&#9;</hdr>
   <hdr o="nextFcstBy">próx. previsión hasta:&#9;</hdr>
   <hdr o="nextFcstAt">próx. previsión:&#9;</hdr>
   <hdr o="amdAt">enmienda:&#9;&#9;</hdr>
   <hdr o="fcstAutoObs">previsión basa en observación automática</hdr>
   <hdr o="waterEquivOfSnow">agua equivalente a nieve al suelo:&#9;</hdr>
   <hdr o="snowOnGround">nieve al suelo:&#9;&#9;</hdr>
   <hdr o="snowCover">tapa de nieve:&#9;&#9;</hdr>
   <hdr o="fcstNotAvbl">previsión no disponible:&#9;</hdr>
   <hdr o="temp1">temperatura 1:&#9;&#9;</hdr>
   <hdr o="temp2">temperatura 2:&#9;&#9;</hdr>
   <hdr o="precipAmount1">precipitación 1:&#9;</hdr>
   <hdr o="precipAmount2">precipitación 2:&#9;</hdr>
   <hdr o="notRecognised">NO RECONOCIDO:&#9;&#9;</hdr>
   <hdr o="RSNK">datos para Rattlesnake Mountain:</hdr>
   <hdr o="LAG_PK">datos para Laguna Peak:</hdr>
   <hdr o="RADAT">datos de observación de radiosonda para nivel de 0 °C:</hdr>
   <hdr o="freezingLvl">nivel de 0 °C:&#9;&#9;</hdr>
   <hdr o="durationOfSunshine">luz del sol ayer:&#9;</hdr>
   <hdr o="hailStones">granizos:&#9;&#9;</hdr>

   <t o="notAvailable">(no disponible)</t>
   <t o="invalidFormat">formato no válido</t>
   <t o="calm">en calma</t>
   <t o="onThe">el |., </t>
   <t o="dirVariable">de direcciónes variables</t>
   <t o="dirNotAvailable">dirección no disponible,</t>
   <t o="speedNotAvailable"> velocidad no disponible</t>
   <t o="wind-from">del</t>
   <t o="last">último</t>
   <t o="segment">segmento</t>
   <t o="wind-at">a</t>
   <t o="wind-gusts">&#9;&#9;&#9;con ráfagas</t>
   <t o="cloud-at">a</t>
   <t o="cloud-above">encima de</t>
   <t o="cloudTypeNotAvailable">(tipo de nubes impossibile observar)</t>
   <t o="baseBelowStation">base de nubes debajo de nivel de estación</t>
   <t o="time-at"> a las |</t>
   <t o="afterHour">| minutes despues de la hora</t>
   <t o="time-from">de las |</t>
   <t o="time-till">a las |</t>
   <t o="variable">&#9;&#9;&#9;variando</t>
   <t o="variable-from">entre</t>
   <t o="variable-to">y</t>
   <t o="varying-to">&#9;&#9;a:&#9;</t>
   <t o="visVertNA">imposible determinarlo</t>
   <t o="windShear">cizalladura crítica del viento</t>
   <t o="rwyNotInUse">pista no en usa</t>
   <t o="rwyVisNotAvailable">(visibilidad no disponible)</t>
   <t o="rwyDesigAll">todos pistas</t>
   <t o="rwyDesigRep">pista REP</t>
   <t o="rwyDesig">pista |</t>
   <t o="SNOCLO">aeropuerto cerrado por nieve</t>
   <t o="cleared">despejado</t>
   <t o="friction">fricción: </t>
   <t o="depositExtent"> de pista tapada</t>
   <t o="depositDepth">profundidad de depósito |</t>
   <t o="NOSIG">no cambio significativo</t>
   <t o="BECMG">tornando:</t>
   <t o="TEMPO">temporalmente:</t>
   <t o="PROB">:</t>
   <t o="CAVOK">nubes y visibilidad OK</t>
   <t o="RVRNO">RVR no disponible</t>
   <t o="PWINO">sensor para identificar el tiempo actual no funciona</t>
   <t o="FZRANO">sensor para identificar lluvia engelante no funciona</t>
   <t o="TSNO">sensor para identificar relámpago no funciona</t>
   <t o="PNO">sensor no funciona: lluvia indicador</t>
   <t o="CHINO">indicador secundario para la altura de techo | no funciona</t>
   <t o="VISNO">indicador secundario para la visibilidad | no funciona</t>
   <t o="NOSPECI">no SPECI informes producido a esta estación</t>
   <t o="VIA_PHONE">vía teléfono</t>
   <t o="RCRNR">indicaciónes del estado de pistas no presentado</t>
   <t o="HALO">halo</t>
   <t o="FROIN">escarcha en el indicador</t>
   <t o="LGT_FROIN">escarcha ligera en el indicador</t>
   <t o="HVY_FROIN">escarcha fuerte en el indicador</t>
   <t o="VRBL_CONDS">condiciones variables</t>
   <t o="ACFT_MSHP">desgracia de avión</t>
   <t o="CIG_RAG">techo desigual</t>
   <t o="needMaint">estación automática necesita mantenimiento</t>
   <t o="loc-and">y</t>
   <t o="loc-to">hasta</t>
   <t o="predictedColour">predicho:</t>
   <t o="prob">con |% probabilidad</t>
   <t o="nextDay"> el día siguiente</t>
   <t o="distant"> lejano</t>
   <t o="isStationary"> inmóvil</t>
   <t o="obscgMtns"> ocultand(o,a)(s) los montañas</t>
   <t o="isGrid"> cuadrícula</t>
   <t o="quadrant">cuadrante</t>
   <t o="snowIncrPastHour">| in. desde 1h</t>
   <t o="snowIncrOnGround">| in. al suelo</t>
   <t o="low">bajo:&#9;&#9;</t>
   <t o="middle">medio:&#9;&#9;</t>
   <t o="high">alto:&#9;&#9;</t>
   <t o="cloudLayerAboveOvercast">nubes encima de cielo cubierto</t>
   <t o="FROPA">debido al paso de una frente</t>
   <t o="MOV"> moviendo</t>
   <t o="MOVD"> movió</t>
   <t o="began">empezó</t>
   <t o="ended">acabó</t>
   <t o="compassDirLocation"> al|</t>
   <t o="compassDirTo"> al|</t>
   <t o="compassDirFrom"> desde|</t>
   <t o="compassDirThrough"> y|</t>
   <t o="compassDirDescr"> |</t>
   <t o="compassDirDescrQuad"> | cuadrante</t>
   <t o="isLower">más baj(o,a)(s)</t>
   <t o="isLow">baj(o,a)(s)</t>
   <t o="isFrequent">frecuente</t>
   <t o="isOccasional">esporádic(o,a)</t>
   <t o="isThick">denso</t>
   <t o="isPrettyThick">bastante denso</t>
   <t o="isVeryThick">muy denso</t>
   <t o="isThin">fino</t>
   <t o="isPrettyThin">bastante fino</t>
   <t o="isVeryThin">muy fino</t>
   <t o="isFeeble">débil</t>
   <t o="isPrettyFeeble">bastante débil</t>
   <t o="isVeryFeeble">muy débil</t>
   <t o="isLight">leve</t>
   <t o="isPrettyLight">bastante leve</t>
   <t o="isVeryLight">muy leve</t>
   <t o="isModerate">moderado</t>
   <t o="isIntermittent">intermitente</t>
   <t o="isContinuous">continuamente</t>
   <t o="isIsolated">aislados</t>
   <t o="isConvective">convectivas</t>
   <t o="isDissipated">disipados</t>
   <t o="isFreezing">engelante</t>
   <t o="isPatchy">variable</t>
   <t o="inPastHour">en la última hora</t>
   <t o="isAloft">arriba</t>
   <t o="isAround">alrededor</t>
   <t o="topOfLayer">top of layer</t>
   <t o="level-from">desde</t>
   <t o="level-to">hasta</t>
   <t o="toTopOfCloud"> a la cima de nubes</t>
   <t o="isNotScheduled">no es programada</t>
   <t o="isLtdToCldVisWind">limitado a nubes, visibilidad y viento</t>
   <t o="amendment">enmienda</t>
   <t o="ceiling">techo</t>
   <t o="approach">acercamiento</t>
   <t o="cloudTypeAsoctd">asociado con |</t>
   <t o="cloudTypeEmbd">| embebida</t>
   <t o="change-by"> en un</t>
   <t o="decelerometerReading">indicación de decelerometer</t>
   <t o="decelerometerReadingNA">no hay indicaciónes de decelerometer</t>
   <t o="rainfall10min"> mm de 10 minutes, </t>
   <t o="rainfall0900"> mm desde 09:00 hora de aeropuerto</t>
   <t o="minutes">minutos</t>
   <t o="fcstAutoMETAR">previsión basa en METAR automática</t>
   <t o="CAVU">cielo despejado o nubes dispersas y visibilidad &gt;10 US-miles</t>
   <t o="EPC">estimado puerto de montaña cerrado</t>
   <t o="EPO">estimado puerto de montaña abierto</t>
   <t o="EPM">estimado puerto de montaña marginal</t>
   <t o="RTS">vuelto en servicio</t>
   <t o="visibilityAt">visibilidad al</t>
   <t o="traces">vestigios</t>
   <t o="firstObs">primera observación|</t>
   <t o="nextObs">siguiente observación|</t>
   <t o="lastObs">última observación|</t>
   <t o="isStaffed"> proveída de personal</t>
   <t o="isManned"> proveída de personal</t>
   <t o="balloonDisapp">globo desapareció al |</t>
   <t o="balloonVisib">globo visible hasta |</t>
   <t o="estimated">estimado</t>
   <t o="dueToIceAccretion"> debido a aumento de hielo</t>
   <t o="BA_GOOD">frenar bueno</t>
   <t o="BA_POOR">frenar malo</t>
   <t o="THN_SPTS_IOVC">puntos delgados en cielo cubierto</t>
   <t o="FUOCTY">humo sobre ciudad</t>
   <t o="ALTM_MISG">valor de altímetro falla</t>
   <t o="ALL_WNDS_GRID">todas direcciones de viento grid</t>
   <t o="CONTRAILS">estelas de condensación</t>
   <t o="SKY_OBSC">cielo obscurecido</t>
   <t o="MTNS_OBSC">montañas obscurecido</t>
   <t o="FOGGY">nebuloso</t>
   <t o="TWLGT">crepúsculo</t>
   <t o="missing">fallan</t>
   <t o="slash">/</t>
   <t o="FIBI">archivado pero irrealizable transmitir</t>
   <t o="hailStoneSize">diámetro más grande </t>

   <reportModifierType o="NIL" >informe falta</reportModifierType>
   <reportModifierType o="AUTO">generado automáticamente</reportModifierType>
   <reportModifierType o="COR" >correctado manual</reportModifierType>
   <reportModifierType o="RTD" >rutina pospuesto</reportModifierType>
   <reportModifierType o="P"   >segmentado, </reportModifierType>
   <reportModifierType o="RR"  >pospuesto</reportModifierType>
   <reportModifierType o="CC"  >correctado</reportModifierType>
   <reportModifierType o="AA"  >enmendado</reportModifierType>
   <reportModifierType o="AMD" >enmendado</reportModifierType>

   <compassDir o="N">norte</compassDir>
   <compassDir o="NNE">norte-nordeste</compassDir>
   <compassDir o="NE">nordeste</compassDir>
   <compassDir o="ENE">este-nordeste</compassDir>
   <compassDir o="E">este</compassDir>
   <compassDir o="ESE">este-sudeste</compassDir>
   <compassDir o="SE">sudeste</compassDir>
   <compassDir o="SSE">sur-sudeste</compassDir>
   <compassDir o="S">sur</compassDir>
   <compassDir o="SSW">sur-sudoeste</compassDir>
   <compassDir o="SW">sudoeste</compassDir>
   <compassDir o="WSW">oeste-sudoeste</compassDir>
   <compassDir o="W">oeste</compassDir>
   <compassDir o="WNW">oeste-noroeste</compassDir>
   <compassDir o="NW">noroeste</compassDir>
   <compassDir o="NNW">norte-noroeste</compassDir>

   <units o="M"> m</units>
   <units o="KM"> km</units>
   <units o="MM"> mm</units>
   <units o="SM"> US-miles</units>
   <units o="NM"> NM</units>
   <units o="FT"> ft</units>
   <units o="IN"> in.</units>
   <units o="KMH"> km/h</units>
   <units o="KT"> kt</units>
   <units o="MPH"> mph</units>
   <units o="MPS"> m/s</units>
   <units o="hPa"> hPa</units>
   <units o="inHg"> in. Hg</units>
   <units o="MIN"> min.</units>
   <units o="H"> hora(s)</units>

   <locationSpec o="OMTNS">sobre las montañas</locationSpec>
   <locationSpec o="OHD">por encima</locationSpec>
   <locationSpec o="ALQDS">en todos los cuadrantes</locationSpec>
   <locationSpec o="AT_AP">al aeropuerto</locationSpec>
   <locationSpec o="OVR_AP">sobre aeropuerto</locationSpec>
   <locationSpec o="IN_VLY">en valle</locationSpec>
   <locationSpec o="V_D">a varias direcciones</locationSpec>
   <locationSpec o="OVR_LK">sobre el lago</locationSpec>
   <locationSpec o="OVR_RIVER">sobre el río</locationSpec>
   <locationSpec o="OVR_VLYS">sobre valles</locationSpec>
   <locationSpec o="ALG_LK">a lo largo del lago</locationSpec>
   <locationSpec o="ALG_MT">a lo largo las montañas</locationSpec>
   <locationSpec o="ALG_RIVER">a lo largo del río</locationSpec>
   <locationSpec o="UNKN">en dirección desconocida</locationSpec>

   <cloudCover o="SKC-s">cielo despejado</cloudCover>
   <cloudCover o="NSC-s">no nubes significativo</cloudCover>
   <cloudCover o="CLR-s">no nubes abajo de 10000 ft</cloudCover>
   <cloudCover o="NCD-s">no nubes detectado</cloudCover>

   <cloudCover o="SKC">cielo despejado</cloudCover>
   <cloudCover o="NSC">no nubes significativo</cloudCover>
   <cloudCover o="CLR">no nubes abajo de 10000 ft</cloudCover>
   <cloudCover o="NCD">no nubes detectado</cloudCover>
   <cloudCover o="FEW">escasas nubes (1-2/8)</cloudCover>
   <cloudCover o="SCT">nubes dispersas (3-4/8)</cloudCover>
   <cloudCover o="BKN">cielo nuboso (5-7/8)</cloudCover>
   <cloudCover o="OVC">cielo cubierto (8/8)</cloudCover>

   <cloudType o="AC">altocumulus</cloudType>
   <cloudType o="ACC">altocumulus castellanus</cloudType>
   <cloudType o="ACSL">altocumulus standing lenticular</cloudType>
   <cloudType o="AS">altostratus</cloudType>
   <cloudType o="CB">cumulonimbus</cloudType>
   <cloudType o="CBMAM">cumulonimbus mammatus</cloudType>
   <cloudType o="CC">cirrocumulus</cloudType>
   <cloudType o="CCSL">cirrocumulus standing lenticular</cloudType>
   <cloudType o="CF">cumulus fractus</cloudType>
   <cloudType o="CI">cirrus</cloudType>
   <cloudType o="CS">cirrostratus</cloudType>
   <cloudType o="CU">cumulus</cloudType>
   <cloudType o="CUFRA">cumulus fractus</cloudType>
   <cloudType o="NS">nimbostratus</cloudType>
   <cloudType o="SAC">stratoaltocumulus</cloudType>
   <cloudType o="SC">stratocumulus</cloudType>
   <cloudType o="SCSL">stratocumulus standing lenticular</cloudType>
   <cloudType o="SF">stratus fractus</cloudType>
   <cloudType o="ST">stratus</cloudType>
   <cloudType o="STFRA">stratus fractus</cloudType>
   <cloudType o="TCU">cúmulo altísimo</cloudType>

   <cloudTypeLow o="0">ningunas nubes</cloudTypeLow>
   <cloudTypeLow o="1">cumulus (poca extensión vertical)</cloudTypeLow>
   <cloudTypeLow o="2">cumulus (moderada/grande extensión vertical o cumulus altísimas)</cloudTypeLow>
   <cloudTypeLow o="3">cumulonimbus (copas no fibrous o en la forma de yunque)</cloudTypeLow>
   <cloudTypeLow o="4">stratocumulus (formado de cumulus extendiendas)</cloudTypeLow>
   <cloudTypeLow o="5">stratocumulus (no formado de cumulus extendiendas)</cloudTypeLow>
   <cloudTypeLow o="6">stratus (bastante cubierta continuo)</cloudTypeLow>
   <cloudTypeLow o="7">stratus fractus o cumulus fractus de tiempo mal</cloudTypeLow>
   <cloudTypeLow o="8">cumulus and stratocumulus (no formado de cumulus extendiendas)</cloudTypeLow>
   <cloudTypeLow o="9">cumulonimbus (copas fibrous o en la forma de yunque)</cloudTypeLow>

   <cloudTypeMiddle o="0">ningunas nubes</cloudTypeMiddle>
   <cloudTypeMiddle o="1">altostratus (predominantemente semi-transparente)</cloudTypeMiddle>
   <cloudTypeMiddle o="2">altostratus (predominantemente opacas)</cloudTypeMiddle>
   <cloudTypeMiddle o="3">altocumulus (no invadiendas progresivamente el cielo)</cloudTypeMiddle>
   <cloudTypeMiddle o="4">altocumulus (lenticularis)</cloudTypeMiddle>
   <cloudTypeMiddle o="5">altocumulus (invadiendo progresivamente el cielo o semi-transparente)</cloudTypeMiddle>
   <cloudTypeMiddle o="6">altocumulus (formado de cumulus extendiendas o cumulonimbus)</cloudTypeMiddle>
   <cloudTypeMiddle o="7">altocumulus (principalmente opacas, no extendiendas; o con altostratus)</cloudTypeMiddle>
   <cloudTypeMiddle o="8">altocumulus (con brotes o mechónes)</cloudTypeMiddle>
   <cloudTypeMiddle o="9">cielo caótico con altocumulus en varias alturas</cloudTypeMiddle>

   <cloudTypeHigh o="0">ningunas nubes</cloudTypeHigh>
   <cloudTypeHigh o="1">cirrus (filamentos, hebras, o ganchos)</cloudTypeHigh>
   <cloudTypeHigh o="2">cirrus (densas, con brotes, o mechónes)</cloudTypeHigh>
   <cloudTypeHigh o="3">cirrus (densas, quedado de yunque de cumulonimbus)</cloudTypeHigh>
   <cloudTypeHigh o="4">cirrus (ganchos o filamentos, invadiendo progresivamente el cielo)</cloudTypeHigh>
   <cloudTypeHigh o="5">cirrus y/o stratocumulus (invadiendo progresivamente el cielo, velo &lt;45° encima del horizonte)</cloudTypeHigh>
   <cloudTypeHigh o="6">cirrus y/o stratocumulus (invadiendo progresivamente el cielo, velo &gt;45° encima del horizonte)</cloudTypeHigh>
   <cloudTypeHigh o="7">cirrostratus (cubriendo el cielo entero)</cloudTypeHigh>
   <cloudTypeHigh o="8">cirrostratus (no invadiendo o cubriendo el cielo entero)</cloudTypeHigh>
   <cloudTypeHigh o="9">cirrocumulus (como alta nube predominante)</cloudTypeHigh>

   <weather o="phen-light">leve </weather>
   <weather o="phen-moderate">moderado </weather>
   <weather o="phen-heavy">fuerte </weather>
   <weather o="inVicinity"> en las proximidades</weather>
   <weather o="BCFG">|niebla en bancos</weather>
   <weather o="BLDU">|polvo soplanda</weather>
   <weather o="BLSA">|arena soplanda</weather>
   <weather o="BLSN">|ventisca</weather>
   <weather o="BR">|neblina</weather>
   <weather o="DRSA">|arena soplanda baja</weather>
   <weather o="DRSN">|ventisca baja</weather>
   <weather o="DS">|tormenta de polvo</weather>
   <weather o="DU">|polvo extendido</weather>
   <weather o="DZ">|llovizna</weather>
   <weather o="DZRA">|llovizna con lluvia</weather>
   <weather o="DZSN">|llovizna con nieve</weather>
   <weather o="FC">|nube chimenea</weather>
   <weather o="FG">|niebla</weather>
   <weather o="FU">|humo</weather>
   <weather o="FZBCFG">|niebla engelante en bancos</weather>
   <weather o="FZBR">|neblina engelante</weather>
   <weather o="FZDZ">|llovizna engelante</weather>
   <weather o="FZFG">|niebla engelante</weather>
   <weather o="FZRA">|lluvia engelante</weather>
   <weather o="FZRAPL">|lluvia engelante con hielo granulado</weather>
   <weather o="FZRAPLSN">|lluvia engelante con hielo granulado y nieve</weather>
   <weather o="FZRASN">|lluvia engelante con nieve</weather>
   <weather o="GR">|granizo</weather>
   <weather o="GRRA">|granizo con lluvia</weather>
   <weather o="GS">|granizo pequeño o nieve granulada</weather>
   <weather o="HZ">|calima</weather>
   <weather o="IC">|cristales de hielo</weather>
   <weather o="JP">|precipitación adyacente</weather>
   <weather o="MIFG">|niebla llana</weather>
   <weather o="NSW">ninguno tiempo significativo</weather>
   <weather o="PL">|hielo granulado</weather>
   <weather o="PO">|remolinos de polvo/arena</weather>
   <weather o="PRFG">|niebla parcialmente</weather>
   <weather o="RA">|lluvia</weather>
   <weather o="RADZ">|lluvia con llovizna</weather>
   <weather o="RAPL">|lluvia con hielo granulado</weather>
   <weather o="RASN">|llovizna con nieve</weather>
   <weather o="SA">|arena</weather>
   <weather o="SG">|cinarra</weather>
   <weather o="SH">|chaparrones</weather>
   <weather o="SHGR">|chaparrones de granizo</weather>
   <weather o="SHGSRA">|chaparrones de granizo pequeño o nieve granulada con lluvia</weather>
   <weather o="SHPL">|chaparrones de hielos granulados</weather>
   <weather o="SHRA">|chaparrones de lluvia</weather>
   <weather o="SHRADZ">|chaparrones de lluvia con llovizna</weather>
   <weather o="SHRAGS">|chaparrones de lluvia con granizo pequeño o nieve granulada</weather>
   <weather o="SHSN">|chaparrones de nieve</weather>
   <weather o="SHRAPL">|chaparrones de lluvia con hielo granulado</weather>
   <weather o="SHRASN">|chaparrones de lluvia con nieve</weather>
   <weather o="SHSNGS">|chaparrones de nieve con granizo pequeño o nieve granulada</weather>
   <weather o="SHSNPL">|chaparrones de nieve con hielo granulado</weather>
   <weather o="SHSNRA">|chaparrones de nieve con lluvia</weather>
   <weather o="SN">|nieve</weather>
   <weather o="SNPL">|nieve con hielo granulado</weather>
   <weather o="SNRA">|nieve con lluvia</weather>
   <weather o="SQ">|ráfagas</weather>
   <weather o="SS">|tormenta de arena</weather>
   <weather o="TS">|tormenta</weather>
   <weather o="TSDZ">tormenta con |llovizna</weather>
   <weather o="TSRA">tormenta con |lluvia</weather>
   <weather o="TSRAGR">tormenta con |lluvia y granizo</weather>
   <weather o="TSGS">tormenta con |granizo pequeño o nieve granulada</weather>
   <weather o="UP">|precipitación desconocido</weather>
   <weather o="VA">|ceniza volcánica</weather>
   <weather o="tornado">tornado/tromba</weather>

   <tornadicActivity o="tornado">tornado</tornadicActivity>
   <tornadicActivity o="funnel_cloud">funnel cloud</tornadicActivity>
   <tornadicActivity o="waterspout">tromba</tornadicActivity>

   <lightningType o="CA">nube al aire</lightningType>
   <lightningType o="CC">nube a la nube</lightningType>
   <lightningType o="CG">nube a la tierra</lightningType>
   <lightningType o="CW">nube a la agua</lightningType>
   <lightningType o="IC">en nubes</lightningType>

   <visTrend o="U">subiendo</visTrend>
   <visTrend o="N">no cambiando</visTrend>
   <visTrend o="D">bajando</visTrend>

   <stationType o="AO1">estación automática sin precipitación discriminador</stationType>
   <stationType o="AO2">estación automática con precipitación discriminador</stationType>
   <stationType o="AO2A">estación automática con precipitación discriminador y aumentos manuales</stationType>

   <depositType o="0">despejado y seco</depositType>
   <depositType o="1">húmedo</depositType>
   <depositType o="2">mojado o charcos</depositType>
   <depositType o="3">escarcha</depositType>
   <depositType o="4">nieve seca</depositType>
   <depositType o="5">nieve mojada</depositType>
   <depositType o="6">nieve medio derretida</depositType>
   <depositType o="7">hielo</depositType>
   <depositType o="8">nieve comprimida</depositType>
   <depositType o="9">crestas heladas</depositType>

   <depositExtent o="0">0%</depositExtent>
   <depositExtent o="1">1-10%</depositExtent>
   <depositExtent o="2">11-25%</depositExtent>
   <depositExtent o="5">26-50%</depositExtent>
   <depositExtent o="9">51-100%</depositExtent>

   <friction o="91">frenar malo</friction>
   <friction o="92">frenar malo/mediano</friction>
   <friction o="93">frenar mediano</friction>
   <friction o="94">frenar mediano/bueno</friction>
   <friction o="95">frenar bueno</friction>
   <friction o="99">fricción: medida poco fiable</friction>

   <colour o="BLACK"     >aeropuerto cerrado por razónes técnicas</colour>
   <colour o="BLUplus"   >techo 20000 ft, visibilidad 8 km</colour>
   <colour o="BLU"       >techo 2500 ft, visibilidad 8 km</colour>
   <colour o="WHT"       >techo 1500 ft, visibilidad 5 km</colour>
   <colour o="GRN"       >techo 700 ft, visibilidad 3700 m</colour>
   <colour o="YLO1"      >techo 500 ft, visibilidad 2500 m</colour>
   <colour o="YLO2"      >techo 300 ft, visibilidad 1600 m</colour>
   <colour o="YLO"       >techo 300 ft, visibilidad 1600 m</colour>
   <colour o="AMB"       >techo 200 ft, visibilidad 800 m</colour>
   <colour o="RED"       >techo &lt;200 ft, visibilidad &lt;800 m</colour>
   <colour o="FCSTCANCEL">previsión cancelado</colour>
   <colour o="noChange">techo o visibilidad no cambian</colour>

   <visibilityAtLoc o="MAR">visibilidad a la orilla del mar:&#9;</visibilityAtLoc>
   <visibilityAtLoc o="SFC">visibilidad al superficie:&#9;</visibilityAtLoc>
   <visibilityAtLoc o="TWR">visibilidad al torre:&#9;</visibilityAtLoc>

   <concernsChange o="M">empeoramiento de estado de |</concernsChange>
   <concernsChange o="B">mejora de estado de |</concernsChange>
   <concernsSubject o="0">ráfagas</concernsSubject>
   <concernsSubject o="1">viento</concernsSubject>
   <concernsSubject o="2">visibilidad</concernsSubject>
   <concernsSubject o="3">nubes</concernsSubject>
   <concernsSubject o="4">precipitación</concernsSubject>
   <concernsSubject o="5">presión</concernsSubject>
   <concernsSubject o="6">mar o oleaje</concernsSubject>
   <concernsSubject o="7">tormenta de polvo, tormenta de arena o ventisca</concernsSubject>
   <concernsSubject o="8">tormenta</concernsSubject>
   <concernsSubject o="9">ráfagas o tormenta</concernsSubject>

   <phenomenon o="LTG">relámpago</phenomenon>
   <phenomenon o="VIRGA">virga</phenomenon>
   <phenomenon o="AURBO">aurora boreal</phenomenon>
   <phenomenon o="FG_BNK">niebla en banco</phenomenon>
   <phenomenon o="PCPN">precipitación</phenomenon>
   <phenomenon o="VLY_FG">niebla de valle</phenomenon>
   <phenomenon o="HIR_CLDS">nubes más alto</phenomenon>
   <phenomenon o="FULYR">capa de humo</phenomenon>
   <phenomenon o="HZY">hay calima</phenomenon>
   <phenomenon o="BINOVC">claros en cielo cubierto</phenomenon>
   <phenomenon o="ICG">glaciación</phenomenon>
   <phenomenon o="SH">chaparrón</phenomenon>
   <phenomenon o="SHS">chaparrones</phenomenon>
   <phenomenon o="DEW">rocío</phenomenon>
   <phenomenon o="VIS_HYR">visibilidad superior</phenomenon>
   <phenomenon o="VIS_LWR">visibilidad peor</phenomenon>
   <phenomenon o="VIS_RDCD">visibilidad reducido</phenomenon>
   <phenomenon o="CIG_HYR">techo más alto</phenomenon>
   <phenomenon o="CIG_LWR">techo más bajo</phenomenon>
   <phenomenon o="CLD">nubes</phenomenon>
   <phenomenon o="CLDS">nubes</phenomenon>
   <phenomenon o="CLD_EMBD">nubes embebidas</phenomenon>
   <phenomenon o="CLDS_EMBD">nubes embebidas</phenomenon>
   <phenomenon o="PRESFR">tendencia de presión: cayendo rápidamente</phenomenon>
   <phenomenon o="PRESRR">tendencia de presión: aumentando rápidamente</phenomenon>
   <phenomenon o="FIRE">fuego</phenomenon>
   <phenomenon o="FIRES">fuegos</phenomenon>
   <phenomenon o="GRASS_FIRE">fuego de hierba</phenomenon>
   <phenomenon o="GRASS_FIRES">fuegos de hierba</phenomenon>

   <quadrant o="1">primero</quadrant>
   <quadrant o="2">segundo</quadrant>
   <quadrant o="3">tercero</quadrant>
   <quadrant o="4">quartero</quadrant>

   <condMounType o="LIB">libre de nubes</condMounType>
   <condMounType o="CLD_SCT">parcialmente cubrido en nubes aisladas</condMounType>
   <condMounType o="VERS_INC">pendientes en nubes, la cima libre</condMounType>
   <condMounType o="CNS_POST">libre del lado del observador, otro lado en nubes</condMounType>
   <condMounType o="CLD_CIME">nubes tocan la cima</condMounType>
   <condMounType o="CIME_INC">la cima en nubes, pendientes libre</condMounType>
   <condMounType o="GEN_INC">generalmente en nubes, algunas cimas libre</condMounType>
   <condMounType o="INC">en nubes</condMounType>
   <condMounType o="INVIS">no visible</condMounType>

   <condMounChange o="NC">no cambio</condMounChange>
   <condMounChange o="CUF">cumuli se desarrollando</condMounChange>
   <condMounChange o="ELEV_SLW">levantando despacio</condMounChange>
   <condMounChange o="ELEV_RAPID">levantando rápidamente</condMounChange>
   <condMounChange o="ELEV_STF">levantando y estratificando</condMounChange>
   <condMounChange o="ABB_SLW">hundiendo despacio</condMounChange>
   <condMounChange o="ABB_RAPID">hundiendo rápidamente</condMounChange>
   <condMounChange o="STF">estratificando</condMounChange>
   <condMounChange o="STF_ABB">estratificando y hundiendo</condMounChange>
   <condMounChange o="VAR_RAPID">variando rápidamente</condMounChange>

   <condVallType o="NIL">no nubes bajas ni niebla ni calima</condVallType>
   <condVallType o="FOSCHIA">calima</condVallType>
   <condVallType o="FOSCHIA_SKC_SUP">calima, cielo despejado más arriba</condVallType>
   <condVallType o="NEBBIA">niebla</condVallType>
   <condVallType o="NEBBIA_SCT">aislada niebla en bancos</condVallType>
   <condVallType o="CLD_SCT">nubes aisladas</condVallType>
   <condVallType o="CLD_SCT_NEBBIA_INF">nubes aisladas, niebla más abajo</condVallType>
   <condVallType o="MAR_CLD">mar en nubes</condVallType>
   <condVallType o="INVIS">no visible</condVallType>

   <condVallChange o="NC">no cambio</condVallChange>
   <condVallChange o="DIM">disminuyendo</condVallChange>
   <condVallChange o="DIM_ELEV">disminuyendo y levantando</condVallChange>
   <condVallChange o="DIM_ABB">disminuyendo y hundiendo</condVallChange>
   <condVallChange o="AUM">aumentando</condVallChange>
   <condVallChange o="AUM_ELEV">aumentando y levantando</condVallChange>
   <condVallChange o="AUM_ABB">aumentando y hundiendo</condVallChange>
   <condVallChange o="ELEV">levantando</condVallChange>
   <condVallChange o="ABB">hundiendo</condVallChange>
   <condVallChange o="NEBBIA_INTER">niebla intermitente a la estación</condVallChange>

   <turbulenceDescr o="0">ninguna</turbulenceDescr>
   <turbulenceDescr o="1">leve</turbulenceDescr>
   <turbulenceDescr o="2">esporádico, moderado, en aire claro</turbulenceDescr>
   <turbulenceDescr o="3">frecuente, moderado, en aire claro</turbulenceDescr>
   <turbulenceDescr o="4">esporádico, moderado, en cloud</turbulenceDescr>
   <turbulenceDescr o="5">frecuente, moderado, en nubes</turbulenceDescr>
   <turbulenceDescr o="6">esporádico, severo, en aire claro</turbulenceDescr>
   <turbulenceDescr o="7">frecuente, severo, en aire claro</turbulenceDescr>
   <turbulenceDescr o="8">esporádico, severo, en nubes</turbulenceDescr>
   <turbulenceDescr o="9">frecuente, severo, en nubes</turbulenceDescr>

   <icingDescr o="0">ninguna</icingDescr>
   <icingDescr o="1">leve</icingDescr>
   <icingDescr o="2">leve, en nubes</icingDescr>
   <icingDescr o="3">leve, en precipitación</icingDescr>
   <icingDescr o="4">moderado</icingDescr>
   <icingDescr o="5">moderado, en nubes</icingDescr>
   <icingDescr o="6">moderado, en precipitación</icingDescr>
   <icingDescr o="7">severo</icingDescr>
   <icingDescr o="8">severo, en nubes</icingDescr>
   <icingDescr o="9">severo, en precipitación</icingDescr>

   <seaCondition o="0">en calma (llana)</seaCondition>
   <seaCondition o="1">en calma (ondulada)</seaCondition>
   <seaCondition o="2">tranquilo (olas mínimas)</seaCondition>
   <seaCondition o="3">olas pequeñas</seaCondition>
   <seaCondition o="4">olas moderadas</seaCondition>
   <seaCondition o="5">bravo</seaCondition>
   <seaCondition o="6">muy bravo</seaCondition>
   <seaCondition o="7">olas altas</seaCondition>
   <seaCondition o="8">olas muy altas</seaCondition>
   <seaCondition o="9">olas fenomenalas</seaCondition>

   <swellCondition o="0">ningun</swellCondition>
   <swellCondition o="1">longitud: corta o media, altura: baja</swellCondition>
   <swellCondition o="2">longitud: larga, altura: baja</swellCondition>
   <swellCondition o="3">longitud: corta, altura: moderada</swellCondition>
   <swellCondition o="4">longitud: media, altura: moderada</swellCondition>
   <swellCondition o="5">longitud: larga, altura: moderada</swellCondition>
   <swellCondition o="6">longitud: corta, altura: alta</swellCondition>
   <swellCondition o="7">longitud: media, altura: alta</swellCondition>
   <swellCondition o="8">longitud: larga, altura: alta</swellCondition>
   <swellCondition o="9">caótico</swellCondition>

   <cloudPhenom o="PWR_PLNT">central eléctrica</cloudPhenom>
   <cloudPhenom o="PWR_PLNT_PLUME">columna de central eléctrica</cloudPhenom>

   <pressureTend o="0">aumentando, luego disminuyendo</pressureTend>
   <pressureTend o="1">aumentando, luego estable, o aumentando luego aumentando más despacio</pressureTend>
   <pressureTend o="2">aumentando establemente o inestablemente</pressureTend>
   <pressureTend o="3">disminuyendo o estable, luego aumentando; o aumentando luego aumentando más rapidly</pressureTend>
   <pressureTend o="4">estable</pressureTend>
   <pressureTend o="5">disminuyendo luego aumentando</pressureTend>
   <pressureTend o="6">disminuyendo, luego estable, o disminuyendo luego disminuyendo más despacio</pressureTend>
   <pressureTend o="7">disminuyendo establemente o inestablemente</pressureTend>
   <pressureTend o="8">estable o aumentando, luego disminuyendo; o disminuyendo luego disminuyendo más rapidly</pressureTend>

   <rwySfc o="SLR">nieve medio derretida en la pista</rwySfc>
   <rwySfc o="LSR">nieve floja en la pista</rwySfc>
   <rwySfc o="PSR">nieve comprimida en la pista</rwySfc>
   <rwySfc o="P">variable</rwySfc>
   <rwySfc o="SANDED">enarenada</rwySfc>
   <rwySfc o="WET">mojada</rwySfc>
   <rwySfc o="DRY">seca</rwySfc>
   <rwySfc o="IR">hielo en la pista</rwySfc>
   <rwySfc o="WR">pista mojada</rwySfc>

   <snowCoverType o="ONE_LOOSE">one loose</snowCoverType>
   <snowCoverType o="MUCH_LOOSE">mucho suelto</snowCoverType>
   <snowCoverType o="TRACE_LOOSE">rastro suelto</snowCoverType>
   <snowCoverType o="MEDIUM_PACKED">medio embalado</snowCoverType>
   <snowCoverType o="HARD_PACKED">embalado con fuerza</snowCoverType>
   <snowCoverType o="NIL">nada</snowCoverType>

   <estimatedItem o="WND">viento</estimatedItem>
   <estimatedItem o="CIG">techo</estimatedItem>
   <estimatedItem o="CIG_BLN">techo de datos de globo</estimatedItem>
   <estimatedItem o="CLD_HGTS">altura de nubes</estimatedItem>
   <estimatedItem o="SLP">presión al nivel del mar</estimatedItem>
   <estimatedItem o="ALSTG">el ajuste del altímetro</estimatedItem>

   <fcstNotAvblReason o="NOOBS">no observación</fcstNotAvblReason>
   <fcstNotAvblReason o="INSUFFICIENTOBS">observación insuficiente</fcstNotAvblReason>

   <error o="obsStation">no una id de estación</error>
   <error o="obsTime">no un tiempo de observación</error>
   <error o="other">formato no válido</error>

   <cgi o="title">METAR/TAF traductor</cgi>
   <cgi o="infosrc">Una buena fuente por mensajes actuales de METAR y TAF es</cgi>
   <cgi o="outdated">Warning: forecast data for many stations has not been updated at NOAA since August, 3rd, 2006.</cgi>
   <cgi o="infofetch">Si se usa la palabra clave "FETCH" y uno o más ids de la estación, los mensajes serán traído de la fuente elegida (o si esta opción es minusválida de un fichero del servidor de donde viene este página web).</cgi>
   <cgi o="example">ejemplos para mensajes:</cgi>
   <cgi o="message">mensaje:</cgi>
   <cgi o="type">es del typo:</cgi>
   <cgi o="source">trae de:</cgi>
   <cgi o="language">lengua:</cgi>
   <cgi o="format">presenta como:</cgi>
   <cgi o="decode">traduce</cgi>
   <cgi o="disclaimer">Aviso: Las informaciones de esta página web puedan ser antiguas o falsas o los dos. No son apropiadas para el uso en la aviación.</cgi>
  </es>

  <ru>
  <!-- thanks to translation2.paralink.com and russian.wunderground.com -->
  <!-- thanks to http://www.cpilot.info/show_article.php?id=43 -->
   <compassDir16>
    <arr>С</arr>
    <arr>ССВ</arr>
    <arr>СВ</arr>
    <arr>ВСВ</arr>
    <arr>В</arr>
    <arr>ВЮВ</arr>
    <arr>ЮВ</arr>
    <arr>ЮЮВ</arr>
    <arr>Ю</arr>
    <arr>ЮЮЗ</arr>
    <arr>ЮЗ</arr>
    <arr>ЗЮЗ</arr>
    <arr>З</arr>
    <arr>ЗСЗ</arr>
    <arr>СЗ</arr>
    <arr>ССЗ</arr>
    <arr>С</arr>
   </compassDir16>

   <hdr o="metar">сообщение МЕТАР</hdr>
   <hdr o="metar_ul">===============</hdr>
   <hdr o="speci">выборочное специальное СПЕЦИ</hdr>
   <hdr o="speci_ul">===============</hdr>
   <hdr o="taf">прогноз аэродрома</hdr>
   <hdr o="taf_hour">| ч. прогноз аэродрома</hdr>
   <hdr o="taf_ul">==================</hdr>
   <hdr o="obsStation">код аэродрома:&#9;&#9;</hdr>
   <hdr o="obsTime">время наблюдения:&#9;</hdr>
   <hdr o="issueTime">время издания:&#9;&#9;</hdr>
   <hdr o="fcstPeriod">период прогноза:&#9;</hdr>
   <hdr o="visPrev">видимость:&#9;&#9;</hdr>
   <hdr o="visMin">&#9;&#9;&#9;</hdr>
   <hdr o="visRwy">видимость ВПП |:&#9;</hdr>
   <hdr o="visTrend">&#9;тенденция:&#9;&#9;</hdr>
   <hdr o="visVert">верт. видимость:&#9;</hdr>
   <hdr o="sfcWind">ветер:&#9;&#9;&#9;</hdr>
   <hdr o="weather-1">погода:&#9;&#9;&#9;</hdr>
   <hdr o="cloud-1">облачность:&#9;&#9;</hdr>
   <hdr o="ceiling">нижняя граница облаков:&#9;</hdr>
   <hdr o="temperature-temp">температура:&#9;&#9;</hdr>
   <hdr o="temperature-dew">точка росы:&#9;&#9;</hdr>
   <hdr o="tempHourly-temp">температура с 1 ч. средним числом:&#9;</hdr>
   <hdr o="tempHourly-dew">точка росы с 1 ч. средним числом:&#9;</hdr>
   <hdr o="relHumid">относит. влажность:&#9;</hdr>
   <hdr o="tempMax">макс. температура:&#9;</hdr>
   <hdr o="tempMin">мин. температура:&#9;</hdr>
   <hdr o="temp6hMax">6 ч. макс. температура:&#9;</hdr>
   <hdr o="temp6hMin">6 ч. мин. температура:&#9;</hdr>
   <hdr o="temp24hMax">24 ч. макс. температура:&#9;</hdr>
   <hdr o="temp24hMin">24 ч. мин. температура:&#9;</hdr>
   <hdr o="tempAt">температура:&#9;&#9;</hdr>
   <hdr o="tempMaxFQ">макс. температура::&#9;</hdr>
   <hdr o="QNH">давление:&#9;&#9;</hdr>
   <hdr o="somePressure">некоторое давление:&#9;&#9;</hdr>
   <hdr o="stateOfRwy">состояние |:&#9;</hdr>
   <hdr o="windShearRwy">|:&#9;&#9;</hdr>
   <hdr o="recentWeather-1">недавняя погода:&#9;&#9;</hdr>
   <hdr o="colourCode">цветной код:&#9;&#9;</hdr>
   <hdr o="windShearLvl">СДВИГ ВЕТРА! ветер:&#9;</hdr>
   <hdr o="cloudMaxCover">макс. облачность:&#9;</hdr>
   <hdr o="cloudCoverVar">облачность:&#9;&#9;</hdr>
   <hdr o="cloudCoverVar2">изменение к:&#9;&#9;&#9;</hdr>
   <hdr o="reportConcerns">сообщение касается:&#9;&#9;</hdr>
   <hdr o="cloudOpacityLvl">явление с непрозрачностью:&#9;</hdr>
   <hdr o="trendList">тенденции в течение следующих 2 ч.:</hdr>
   <hdr o="trendList_ul">======================================</hdr>
   <hdr o="trendListTAF">тенденция прогноза:</hdr>
   <hdr o="trendListTAF_ul">===============</hdr>
   <hdr o="remarkList">замечания:</hdr>
   <hdr o="remarkList_ul">==========</hdr>
   <hdr o="visLoc">видимость|:&#9;</hdr>
   <hdr o="gridWind">ветер сетки:&#9;&#9;</hdr>
   <hdr o="rwyWind">ветер для взлётно-посадочной полосы |:&#9;</hdr>
   <hdr o="thrWind">ветер для взлётно-посадочной полосы |:&#9;</hdr>
   <hdr o="peakWind">макс. ветер|:&#9;</hdr>
   <hdr o="SLPhPa">давление на уровне моря:&#9;</hdr>
   <hdr o="SLPdPa">давление на уровне моря:&#9;</hdr>
   <hdr o="SLPinHg">давление на уровне моря:&#9;</hdr>
   <hdr o="regQNH">рег. QNH:&#9;&#9;</hdr>
   <hdr o="QFE">давление QFE:&#9;&#9;</hdr>
   <hdr o="QFF">давление QFF:&#9;&#9;</hdr>
   <hdr o="rmkVisMin">мин видимость:&#9;</hdr>
   <hdr o="rmkVisVar">видимость изменяется от:&#9;</hdr>
   <hdr o="correctedAt">сообщение было исправлено в:&#9;</hdr>
   <hdr o="precip1Hour">1 ч. количество осаждения:&#9;</hdr>
   <hdr o="precip3Hour">3 ч. количество осаждения:&#9;</hdr>
   <hdr o="precip6Hour">6 ч. количество осаждения:&#9;</hdr>
   <hdr o="precip24Hour">24 ч. количество осаждения:&#9;</hdr>
   <hdr o="precip36Hour">3/6 ч. количество осаждения:&#9;</hdr>
   <hdr o="ERROR">ошибка в '@':&#9;&#9;</hdr>
   <hdr o="SST">темп. поверхности моря:&#9;</hdr>
   <hdr o="OAT">темп. внешнего воздуха:&#9;</hdr>
   <hdr o="AI">AI:&#9;&#9;&#9;</hdr>
   <hdr o="snowIncr">снег увеличивается быстро:&#9;</hdr>
   <hdr o="cloudTypeFamily">тип семьи облака:&#10;</hdr>
   <hdr o="windShift">изменение ветра</hdr>
   <hdr o="beginEndPrecip">осаждения:&#9;</hdr>
   <hdr o="conditionMountain">горы:&#9;&#9;&#9;</hdr>
   <hdr o="conditionValley">долины:&#9;&#9;</hdr>
   <hdr o="turbulence">буря:&#9;&#9;</hdr>
   <hdr o="icing">обледенение:&#9;&#9;&#9;</hdr>
   <hdr o="tracesOf">следы:&#9;&#9;</hdr>
   <hdr o="seaCondition">состояние моря:&#9;</hdr>
   <hdr o="swellCondition">состояние волнения:&#9;</hdr>
   <hdr o="cloudLayer">слой облаков:&#9;&#9;</hdr>
   <hdr o="cloudLayerThin">тонкий слой облаков:&#9;</hdr>
   <hdr o="obscuration">из-за |:&#9;</hdr>
   <hdr o="variableCeiling">переменная нижняя граница облаков:&#9;</hdr>
   <hdr o="pressureTendency3h">тенденция давления 3 ч.:&#9;</hdr>
   <hdr o="ceilVisVariable">нижняя граница облаков в или ниже 900 м и переменная, видимость изменяется от:&#9;</hdr>
   <hdr o="rwySfcCondition">состояние поверхности взлётно-посадочной полосы:&#9;</hdr>
   <hdr o="rainfall">ливень:&#9;&#9;</hdr>
   <hdr o="NEFO_PLAYA">NEFO PLAYA:&#9;&#9;</hdr>
   <hdr o="densityAlt">высота плотности:&#9;</hdr>
   <hdr o="pressureAlt">высота давления:&#9;</hdr>
   <hdr o="obsTimeOffset">расстояние времени сообщения:&#9;</hdr>
   <hdr o="nextFcstBy">следующий прогноз до:&#9;</hdr>
   <hdr o="nextFcstAt">следующий прогноз:&#9;&#9;</hdr>
   <hdr o="amdAt">поправка:&#9;&#9;</hdr>
   <hdr o="fcstAutoObs">прогноз основан на автоматизированном сообщении</hdr>
   <hdr o="waterEquivOfSnow">водный эквивалент снега на земле:&#9;</hdr>
   <hdr o="snowOnGround">снег на земле:&#9;&#9;</hdr>
   <hdr o="snowCover">покрытие снега:&#9;&#9;</hdr>
   <hdr o="fcstNotAvbl">прогноз не доступен:&#9;</hdr>
   <hdr o="temp1">температура 1:&#9;&#9;</hdr>
   <hdr o="temp2">температура 2:&#9;&#9;</hdr>
   <hdr o="precipAmount1">осаждения 1:&#9;&#9;</hdr>
   <hdr o="precipAmount2">осаждения 2:&#9;&#9;</hdr>
   <hdr o="notRecognised">НЕ ПРИЗНАННЫЙ:&#9;&#9;</hdr>
   <hdr o="RSNK">данные для Rattlesnake Mountain:</hdr>
   <hdr o="LAG_PK">данные для Laguna Peak:</hdr>
   <hdr o="RADAT">наблюдательные данные радиозонда для 0 °C-границы:</hdr>
   <hdr o="freezingLvl">0 °C-граница:&#9;&#9;</hdr>
   <hdr o="durationOfSunshine">продолжительность света вчера:&#9;</hdr>
   <hdr o="hailStones">градины:&#9;&#9;</hdr>

   <t o="notAvailable">(не доступен)</t>
   <t o="invalidFormat">недействительный формат</t>
   <t o="calm">спокоен</t>
   <t o="onThe">в |., </t>
   <t o="dirVariable">от переменных указаний</t>
   <t o="dirNotAvailable">от недоступных указаний,</t>
   <t o="speedNotAvailable"> с недоступными скоростями</t>
   <t o="wind-from">из</t>
   <t o="last">последняя</t>
   <t o="segment">доля</t>
   <t o="wind-at">в</t>
   <t o="wind-gusts">&#9;&#9;&#9;с порывами</t>
   <t o="cloud-at">в</t>
   <t o="cloud-above">выше</t>
   <t o="cloudTypeNotAvailable">(тип облака не заметен)</t>
   <t o="baseBelowStation">нижняя граница облаков ниже уровня станции</t>
   <t o="time-at"> в |</t>
   <t o="afterHour">| минут после часа</t>
   <t o="time-from">от |</t>
   <t o="time-till">до |</t>
   <t o="variable">&#9;&#9;&#9;переменный</t>
   <t o="variable-from">от</t>
   <t o="variable-to">до</t>
   <t o="varying-to">&#9;&#9;до:&#9;</t>
   <t o="visVertNA">невозможна определить</t>
   <t o="windShear">критическая сдвиг ветра</t>
   <t o="rwyNotInUse">взлётно-посадочная полоса не в использовании</t>
   <t o="rwyVisNotAvailable">(видимость не заметен)</t>
   <t o="rwyDesigAll">все взлётно-посадочные полосы</t>
   <t o="rwyDesigRep">повторная взлётно-посадочная полоса</t>
   <t o="rwyDesig">взлётно-посадочная полоса |</t>
   <t o="SNOCLO">аэродром закрыт из-за снега</t>
   <t o="cleared">очищен</t>
   <t o="friction">трение: </t>
   <t o="depositExtent"> взлетно-посадочной полосы покрыты</t>
   <t o="depositDepth">глубина депозита |</t>
   <t o="NOSIG">никакое существенное изменение</t>
   <t o="BECMG">станет:</t>
   <t o="TEMPO">временно:</t>
   <t o="PROB">:</t>
   <t o="CAVOK">условия хорошие</t>
   <t o="RVRNO">видимость на ВПП нужно сообщить, но отсутствует</t>
   <t o="PWINO">датчик, чтобы идентифицировать существующую погоду не работает</t>
   <t o="FZRANO">датчик, чтобы обнаружить замораживающийся дождь не работает</t>
   <t o="TSNO">датчик, чтобы обнаружить молнию не работает</t>
   <t o="PNO">датчик не работает: tipping bucket rain gauge</t>
   <t o="CHINO">вторичный индикатор граница основания облаков | не работает</t>
   <t o="VISNO">вторичный датчик видимости | не работает</t>
   <t o="NOSPECI">никакие сообщения СПЕЦИ не взяты на этой станции</t>
   <t o="VIA_PHONE">по телефону</t>
   <t o="RCRNR">о чтении условия ВПП не сообщают</t>
   <t o="HALO">гало</t>
   <t o="FROIN">мороз на индикаторе</t>
   <t o="LGT_FROIN">легкий мороз на индикаторе</t>
   <t o="HVY_FROIN">сильный мороз на индикаторе</t>
   <t o="VRBL_CONDS">переменные условия</t>
   <t o="ACFT_MSHP">неудача самолета</t>
   <t o="CIG_RAG">нижняя граница облаков рваной</t>
   <t o="needMaint">автоматизированная система нуждается в обслуживании</t>
   <t o="loc-and">и</t>
   <t o="loc-to">или</t>
   <t o="predictedColour">предсказанный:</t>
   <t o="prob">с |%-ой вероятностью</t>
   <t o="nextDay"> на следующий день</t>
   <t o="distant"> на расстоянии</t>
   <t o="isStationary"> неподвижно</t>
   <t o="obscgMtns"> закрывают горы</t>
   <t o="isGrid"> сетка</t>
   <t o="quadrant">сектор</t>
   <t o="snowIncrPastHour">| дюймов в прошедший час</t>
   <t o="snowIncrOnGround">| дюймов на земле</t>
   <t o="low">низко:&#9;&#9;</t>
   <t o="middle">среда высоко:&#9;</t>
   <t o="high">высоко:&#9;&#9;</t>
   <t o="cloudLayerAboveOvercast">поверх закрытого слоя облаков</t>
   <t o="FROPA">из-за прохода фронта</t>
   <t o="MOV"> двигается</t>
   <t o="MOVD"> двигался</t>
   <t o="began">начинался</t>
   <t o="ended">кончался</t>
   <t o="compassDirLocation"> в|</t>
   <t o="compassDirTo"> в направлении|</t>
   <t o="compassDirFrom"> из направлении|</t>
   <t o="compassDirThrough"> до|</t>
   <t o="compassDirDescr"> |</t>
   <t o="compassDirDescrQuad"> | сектор</t>
   <t o="isLower">ниже</t>
   <t o="isLow">низко</t>
   <t o="isFrequent">часто</t>
   <t o="isOccasional">при случае</t>
   <t o="isThick">дремучий</t>
   <t o="isPrettyThick">довольно дремучий</t>
   <t o="isVeryThick">очень дремучий</t>
   <t o="isThin">тонко</t>
   <t o="isPrettyThin">довольно тонко</t>
   <t o="isVeryThin">очень тонко</t>
   <t o="isFeeble">слабо</t>
   <t o="isPrettyFeeble">довольно слабо</t>
   <t o="isVeryFeeble">очень слабо</t>
   <t o="isLight">легко</t>
   <t o="isPrettyLight">довольно легко</t>
   <t o="isVeryLight">очень легко</t>
   <t o="isModerate">умеренно</t>
   <t o="isIntermittent">спорадический</t>
   <t o="isContinuous">непрерывный</t>
   <t o="isIsolated">отдельно</t>
   <t o="isConvective">конвективный</t>
   <t o="isDissipated">рассредоточенный</t>
   <t o="isFreezing">замораживающийся</t>
   <t o="isPatchy">местами</t>
   <t o="inPastHour">в прошедший час</t>
   <t o="isAloft">наверх</t>
   <t o="isAround">вокруг</t>
   <t o="topOfLayer">вершина слоя</t>
   <t o="level-from">от</t>
   <t o="level-to">до</t>
   <t o="toTopOfCloud"> к вершине облака</t>
   <t o="isNotScheduled">не намечается</t>
   <t o="isLtdToCldVisWind">ограниченный облаком, видимостью и ветром</t>
   <t o="amendment">поправка</t>
   <t o="ceiling">нижняя граница облаков</t>
   <t o="approach">подход</t>
   <t o="cloudTypeAsoctd">| связанный</t>
   <t o="cloudTypeEmbd">| вложено</t>
   <t o="change-by"></t>
   <t o="decelerometerReading">чтение деселерометер</t>
   <t o="decelerometerReadingNA">чтение деселерометер не заметен</t>
   <t o="rainfall10min"> мм за прошлые 10 минут, </t>
   <t o="rainfall0900"> мм с тех пор 09:00 время аэропорта</t>
   <t o="minutes">минут</t>
   <t o="fcstAutoMETAR">прогноз основан на автоматизированном МЕТАР</t>
   <t o="CAVU">ясное небо или рассеянные облака и видимость &gt;10 ам. милей</t>
   <t o="EPC">проход вероятно закрыт</t>
   <t o="EPO">проход вероятно открыт</t>
   <t o="EPM">проход вероятно маргинальный</t>
   <t o="RTS">возвратитесь к обслуживанию</t>
   <t o="visibilityAt">видимость в</t>
   <t o="traces">следы</t>
   <t o="firstObs">первое| наблюдение</t>
   <t o="nextObs">следующее| наблюдение</t>
   <t o="lastObs">последнее| наблюдение</t>
   <t o="isStaffed"> укомплектованное</t>
   <t o="isManned"> укомплектованное</t>
   <t o="balloonDisapp">аэростат исчез в |</t>
   <t o="balloonVisib">аэростат был видим до |</t>
   <t o="estimated">оценено</t>
   <t o="dueToIceAccretion"> из-за присоединения водного льда</t>
   <t o="BA_GOOD">действие тормозов хорошо</t>
   <t o="BA_POOR">действие тормозов плохо</t>
   <t o="THN_SPTS_IOVC">маленькие пробелы в закрытом слое облаков</t>
   <t o="FUOCTY">дым о городе</t>
   <t o="ALTM_MISG">дорого для высотомера отсутствует</t>
   <t o="ALL_WNDS_GRID">все направления ветра грид</t>
   <t o="CONTRAILS">следы инверсии самолета</t>
   <t o="SKY_OBSC">небо закрыто</t>
   <t o="MTNS_OBSC">горы закрыты</t>
   <t o="FOGGY">туманно</t>
   <t o="TWLGT">сумерки</t>
   <t o="missing">отсутствуют</t>
   <t o="slash">/</t>
   <t o="FIBI">подано, но невыполнимо передать</t>
   <t o="hailStoneSize">самый большой диаметр </t>

   <reportModifierType o="NIL" >сообщение отсутствует</reportModifierType>
   <reportModifierType o="AUTO">произведено автоматически</reportModifierType>
   <reportModifierType o="COR" >вручную исправлено</reportModifierType>
   <reportModifierType o="RTD" >рутина отсрочена</reportModifierType>
   <reportModifierType o="P"   >сегментировано, </reportModifierType>
   <reportModifierType o="RR"  >отсрочено</reportModifierType>
   <reportModifierType o="CC"  >исправлено</reportModifierType>
   <reportModifierType o="AA"  >дополнено</reportModifierType>
   <reportModifierType o="AMD" >дополнено</reportModifierType>

   <compassDir o="N">север</compassDir>
   <compassDir o="NNE">северный северо-восток</compassDir>
   <compassDir o="NE">северо-восток</compassDir>
   <compassDir o="ENE">восточный северо-восток</compassDir>
   <compassDir o="E">восток</compassDir>
   <compassDir o="ESE">восточный юго-восток</compassDir>
   <compassDir o="SE">юго-восток</compassDir>
   <compassDir o="SSE">южный юго-восток</compassDir>
   <compassDir o="S">юго</compassDir>
   <compassDir o="SSW">южный юго-запад</compassDir>
   <compassDir o="SW">юго-запад</compassDir>
   <compassDir o="WSW">западных юго-запада</compassDir>
   <compassDir o="W">запад</compassDir>
   <compassDir o="WNW">западных северо-запада</compassDir>
   <compassDir o="NW">северо-запада</compassDir>
   <compassDir o="NNW">северный северо-запада</compassDir>

   <units o="M"> м</units>
   <units o="KM"> км</units>
   <units o="MM"> мм</units>
   <units o="SM"> ам. милей</units>
   <units o="NM"> мор. милей</units>
   <units o="FT"> фт</units>
   <units o="IN"> дюймов</units>
   <units o="KMH"> км/ч</units>
   <units o="KT"> уз</units>
   <units o="MPH"> ам. милей/ч</units>
   <units o="MPS"> м/с</units>
   <units o="hPa"> гПа</units>
   <units o="inHg"> дюймов рт. ст.</units>
   <units o="MIN"> мин.</units>
   <units o="H"> час(ы)</units>

   <locationSpec o="OMTNS">по горам</locationSpec>
   <locationSpec o="OHD">наверху</locationSpec>
   <locationSpec o="ALQDS">все сектора</locationSpec>
   <locationSpec o="AT_AP">в аэропорту</locationSpec>
   <locationSpec o="OVR_AP">выше аэропорта</locationSpec>
   <locationSpec o="IN_VLY">в долине</locationSpec>
   <locationSpec o="V_D">к различным указаниям</locationSpec>
   <locationSpec o="OVR_LK">выше озера</locationSpec>
   <locationSpec o="OVR_RIVER">выше реки</locationSpec>
   <locationSpec o="OVR_VLYS">выше долин</locationSpec>
   <locationSpec o="ALG_LK">по озеру</locationSpec>
   <locationSpec o="ALG_MT">по горам</locationSpec>
   <locationSpec o="ALG_RIVER">по реке</locationSpec>
   <locationSpec o="UNKN">в неизвестное руководство</locationSpec>

   <cloudCover o="SKC-s">ясно</cloudCover>
   <cloudCover o="NSC-s">нулевые существенные облака</cloudCover>
   <cloudCover o="CLR-s">никакие облака ниже 1000 футов</cloudCover>
   <cloudCover o="NCD-s">никакие обнаруженные облака</cloudCover>

   <cloudCover o="SKC">ясно</cloudCover>
   <cloudCover o="NSC">нулевые существенные облака</cloudCover>
   <cloudCover o="CLR">никакие облака ниже 1000 футов</cloudCover>
   <cloudCover o="NCD">никакие обнаруженные облака</cloudCover>
   <cloudCover o="FEW">отдельная (1-2/8)</cloudCover>
   <cloudCover o="SCT">разбросанная (3-4/8)</cloudCover>
   <cloudCover o="BKN">рассеянная (5-7/8)</cloudCover>
   <cloudCover o="OVC">сплошная (8/8)</cloudCover>

   <cloudType o="AC">altocumulus</cloudType>
   <cloudType o="ACC">altocumulus castellanus</cloudType>
   <cloudType o="ACSL">altocumulus standing lenticular</cloudType>
   <cloudType o="AS">altostratus</cloudType>
   <cloudType o="CB">cumulonimbus</cloudType>
   <cloudType o="CBMAM">cumulonimbus mammatus</cloudType>
   <cloudType o="CC">cirrocumulus</cloudType>
   <cloudType o="CCSL">cirrocumulus standing lenticular</cloudType>
   <cloudType o="CF">cumulus fractus</cloudType>
   <cloudType o="CI">cirrus</cloudType>
   <cloudType o="CS">cirrostratus</cloudType>
   <cloudType o="CU">cumulus</cloudType>
   <cloudType o="CUFRA">cumulus fractus</cloudType>
   <cloudType o="NS">nimbostratus</cloudType>
   <cloudType o="SAC">stratoaltocumulus</cloudType>
   <cloudType o="SC">stratocumulus</cloudType>
   <cloudType o="SCSL">stratocumulus standing lenticular</cloudType>
   <cloudType o="SF">stratus fractus</cloudType>
   <cloudType o="ST">stratus</cloudType>
   <cloudType o="STFRA">stratus fractus</cloudType>
   <cloudType o="TCU">towering cumulus</cloudType>

   <cloudTypeLow o="0">никакие облака</cloudTypeLow>
   <cloudTypeLow o="1">cumulus (небольшая вертикальная степень)</cloudTypeLow>
   <cloudTypeLow o="2">cumulus (умеренная/сильная вертикальная степень или towering cumulus)</cloudTypeLow>
   <cloudTypeLow o="3">cumulonimbus (вершины не волокно или в форме наковальни)</cloudTypeLow>
   <cloudTypeLow o="4">stratocumulus (сформированы распространяя cumulus)</cloudTypeLow>
   <cloudTypeLow o="5">stratocumulus (не сформированы распространяя cumulus)</cloudTypeLow>
   <cloudTypeLow o="6">stratus (довольно непрерывный лист и/или слой)</cloudTypeLow>
   <cloudTypeLow o="7">stratus fractus или cumulus fractus из плохой погоды</cloudTypeLow>
   <cloudTypeLow o="8">cumulus and stratocumulus (не сформированы распространяя cumulus)</cloudTypeLow>
   <cloudTypeLow o="9">cumulonimbus (вершины волокно или в форме наковальни)</cloudTypeLow>

   <cloudTypeMiddle o="0">никакие облака</cloudTypeMiddle>
   <cloudTypeMiddle o="1">altostratus (преобладающе полупрозрачный)</cloudTypeMiddle>
   <cloudTypeMiddle o="2">altostratus (преобладающе непрозрачный)</cloudTypeMiddle>
   <cloudTypeMiddle o="3">altocumulus (не прогрессивно вторжение в небо)</cloudTypeMiddle>
   <cloudTypeMiddle o="4">altocumulus (lenticularis)</cloudTypeMiddle>
   <cloudTypeMiddle o="5">altocumulus (прогрессивно вторгаясь в небо или полупрозрачный)</cloudTypeMiddle>
   <cloudTypeMiddle o="6">altocumulus (сформированный распространяя cumulus или cumulonimbus)</cloudTypeMiddle>
   <cloudTypeMiddle o="7">altocumulus (главным образом непрозрачный, не расширение; или с altostratus)</cloudTypeMiddle>
   <cloudTypeMiddle o="8">altocumulus (со спроутингс или пучками)</cloudTypeMiddle>
   <cloudTypeMiddle o="9">хаотическое небо с altocumulus на нескольких уровнях</cloudTypeMiddle>

   <cloudTypeHigh o="0">никакие облака</cloudTypeHigh>
   <cloudTypeHigh o="1">cirrus (нити, берега, или крюки)</cloudTypeHigh>
   <cloudTypeHigh o="2">cirrus (плотный, со спроутингс, или в пучках)</cloudTypeHigh>
   <cloudTypeHigh o="3">cirrus (плотный, оставаясь от наковальни cumulonimbus)</cloudTypeHigh>
   <cloudTypeHigh o="4">cirrus (крюки или нити, прогрессивно вторгаясь в небо)</cloudTypeHigh>
   <cloudTypeHigh o="5">cirrus and/or stratocumulus (прогрессивно вторгаясь в небо, завеса &lt;45° выше горизонта)</cloudTypeHigh>
   <cloudTypeHigh o="6">cirrus and/or stratocumulus (прогрессивно вторгаясь в небо, завеса &gt;45° выше горизонта)</cloudTypeHigh>
   <cloudTypeHigh o="7">cirrostratus (покрывает все небо)</cloudTypeHigh>
   <cloudTypeHigh o="8">cirrostratus (не вторгается или покрывает все небо)</cloudTypeHigh>
   <cloudTypeHigh o="9">cirrocumulus (как преобладающее высокое облако)</cloudTypeHigh>

   <weather o="phen-light">слабый </weather>
   <weather o="phen-moderate">умеренный </weather>
   <weather o="phen-heavy">сильный </weather>
   <weather o="inVicinity"> в близости</weather>
   <weather o="BCFG">|участки тумана</weather>
   <weather o="BLDU">|двигающаяся пыль</weather>
   <weather o="BLSA">|двигающийся песок</weather>
   <weather o="BLSN">|двигающийся снег</weather>
   <weather o="BR">|дымка</weather>
   <weather o="DRSA">|низко дрейфующий песок</weather>
   <weather o="DRSN">|низко дрейфующий снег</weather>
   <weather o="DS">|пыльная буря</weather>
   <weather o="DU">|пыль (обложная)</weather>
   <weather o="DZ">|морось</weather>
   <weather o="DZRA">|морось с дождём</weather>
   <weather o="DZSN">|морось со снегом</weather>
   <weather o="FC">|облако воронки</weather>
   <weather o="FG">|туман</weather>
   <weather o="FU">|дым</weather>
   <weather o="FZBCFG">|замораживающийся участки тумана</weather>
   <weather o="FZBR">|замораживающийся дымка</weather>
   <weather o="FZDZ">|замораживающийся морось</weather>
   <weather o="FZFG">|замораживающийся туман</weather>
   <weather o="FZRA">|замораживающийся дождь</weather>
   <weather o="FZRAPL">|замораживающийся дождь с ледянём дождём</weather>
   <weather o="FZRAPLSN">|замораживающийся дождь с ледянём дождём и снегом</weather>
   <weather o="FZRASN">|замораживающийся дождь со снегом</weather>
   <weather o="GR">|град</weather>
   <weather o="GRRA">|град с дождём</weather>
   <weather o="GS">|ледяная и/или снежная крупа</weather>
   <weather o="HZ">|мгла</weather>
   <weather o="IC">|ледяные иглы</weather>
   <weather o="JP">|смежное осаждение</weather>
   <weather o="MIFG">|низкий туман</weather>
   <weather o="NSW">никакой знаменательной погоды</weather>
   <weather o="PL">|ледяной дождь</weather>
   <weather o="PO">|выраженные песчаные/пыльные вихри</weather>
   <weather o="PRFG">|частичные туманы</weather>
   <weather o="RA">|дождь</weather>
   <weather o="RADZ">|дождь с моросью</weather>
   <weather o="RAPL">|дождь с ледянём дождём</weather>
   <weather o="RASN">|дождь со снегом</weather>
   <weather o="SA">|песок</weather>
   <weather o="SG">|снежные зерна</weather>
   <weather o="SH">|ливни</weather>
   <weather o="SHGR">|ливни градов</weather>
   <weather o="SHGSRA">|ливни ледяный и/или снежный крупы с дождём</weather>
   <weather o="SHPL">|ливни ледяной дождя</weather>
   <weather o="SHRA">|ливни дождя</weather>
   <weather o="SHRADZ">|ливни дождя с моросью</weather>
   <weather o="SHRAGS">|ливни дождя с ледяной и/или снежной крупой</weather>
   <weather o="SHSN">|ливни снега</weather>
   <weather o="SHRAPL">|ливни дождя с ледянём дождём</weather>
   <weather o="SHRASN">|ливни дождя со снегом</weather>
   <weather o="SHSNGS">|ливни снега с ледяной и/или снежной крупой</weather>
   <weather o="SHSNPL">|ливни снега с ледянём дождём</weather>
   <weather o="SHSNRA">|ливни снега с дождём</weather>
   <weather o="SN">|снег</weather>
   <weather o="SNPL">|снег с ледянём дождём</weather>
   <weather o="SNRA">|снег с дождём</weather>
   <weather o="SQ">|шквалы</weather>
   <weather o="SS">|песчаная буря</weather>
   <weather o="TS">|гроза</weather>
   <weather o="TSDZ">гроза с |моросью</weather>
   <weather o="TSRA">гроза с |дождём</weather>
   <weather o="TSRAGR">гроза с |дождём и градом</weather>
   <weather o="TSGS">гроза с |ледяной и/или снежной крупой</weather>
   <weather o="UP">|неизвестное осаждение</weather>
   <weather o="VA">|вулканический пепел</weather>
   <weather o="tornado">смерч</weather>

   <tornadicActivity o="tornado">смерч</tornadicActivity>
   <tornadicActivity o="funnel_cloud">облако воронки</tornadicActivity>
   <tornadicActivity o="waterspout">тромб</tornadicActivity>

   <lightningType o="CA">от облака до воздуха</lightningType>
   <lightningType o="CC">от облака до облака</lightningType>
   <lightningType o="CG">от облака до земли</lightningType>
   <lightningType o="CW">от облака до воды</lightningType>
   <lightningType o="IC">в пределах облака</lightningType>

   <visTrend o="U">увеличение</visTrend>
   <visTrend o="N">никакое изменение</visTrend>
   <visTrend o="D">уменьшение</visTrend>

   <stationType o="AO1">автоматизированная станция без дискриминатора осаждения</stationType>
   <stationType o="AO2">автоматизированная станция с дискриминатором осаждения</stationType>
   <stationType o="AO2A">автоматизированная станция с дискриминатором осаждения и ручным увеличением</stationType>

   <depositType o="0">очиститесь и сухой</depositType>
   <depositType o="1">влажно</depositType>
   <depositType o="2">влажный или лужи</depositType>
   <depositType o="3">мороз</depositType>
   <depositType o="4">сухой снег</depositType>
   <depositType o="5">влажный снег</depositType>
   <depositType o="6">слякоть</depositType>
   <depositType o="7">лед</depositType>
   <depositType o="8">уплотненный снег</depositType>
   <depositType o="9">замороженные горные хребты</depositType>

   <depositExtent o="0">0%|</depositExtent>
   <depositExtent o="1">1-10%|</depositExtent>
   <depositExtent o="2">11-25%|</depositExtent>
   <depositExtent o="5">26-50%|</depositExtent>
   <depositExtent o="9">51-100%|</depositExtent>

   <friction o="91">действие тормозов плохо</friction>
   <friction o="92">действие тормозов плохо/умеренно</friction>
   <friction o="93">действие тормозов умеренно</friction>
   <friction o="94">действие тормозов умеренно/хорошо</friction>
   <friction o="95">действие тормозов хорошо</friction>
   <friction o="99">трение: измерение ненадежно</friction>

   <colour o="BLACK"     >аэропорт закрылся по техническим причинам</colour>
   <colour o="BLUplus"   >потолок 20000 фт, видимость 8 км</colour>
   <colour o="BLU"       >потолок 2500 фт, видимость 8 км</colour>
   <colour o="WHT"       >потолок 1500 фт, видимость 5 км</colour>
   <colour o="GRN"       >потолок 700 фт, видимость 3700 м</colour>
   <colour o="YLO1"      >потолок 500 фт, видимость 2500 м</colour>
   <colour o="YLO2"      >потолок 300 фт, видимость 1600 м</colour>
   <colour o="YLO"       >потолок 300 фт, видимость 1600 м</colour>
   <colour o="AMB"       >потолок 200 фт, видимость 800 м</colour>
   <colour o="RED"       >потолок &lt;200 фт, видимость &lt;800 м</colour>
   <colour o="FCSTCANCEL">прогноз отменен</colour>
   <colour o="noChange">никакое изменение потолка или видимости</colour>

   <visibilityAtLoc o="MAR">видимость в море:&#9;</visibilityAtLoc>
   <visibilityAtLoc o="SFC">видимость в поверхности:&#9;</visibilityAtLoc>
   <visibilityAtLoc o="TWR">видимость в башне:&#9;</visibilityAtLoc>

   <concernsChange o="M">ухудшение условий |</concernsChange>
   <concernsChange o="B">усовершенствование условий |</concernsChange>
   <concernsSubject o="0">порыва</concernsSubject>
   <concernsSubject o="1">ветра</concernsSubject>
   <concernsSubject o="2">видимости</concernsSubject>
   <concernsSubject o="3">облаков</concernsSubject>
   <concernsSubject o="4">осаждения</concernsSubject>
   <concernsSubject o="5">давления</concernsSubject>
   <concernsSubject o="6">состояние моря или волнения</concernsSubject>
   <concernsSubject o="7">пыльная буря, песчаная буря или двигающийся снег</concernsSubject>
   <concernsSubject o="8">гроза</concernsSubject>
   <concernsSubject o="9">шквалы или смерч</concernsSubject>

   <phenomenon o="LTG">молния</phenomenon>
   <phenomenon o="VIRGA">virga</phenomenon>
   <phenomenon o="AURBO">северное полярное сияние</phenomenon>
   <phenomenon o="FG_BNK">полоса тумана</phenomenon>
   <phenomenon o="PCPN">осаждения</phenomenon>
   <phenomenon o="VLY_FG">туман долины</phenomenon>
   <phenomenon o="HIR_CLDS">более высокие облака</phenomenon>
   <phenomenon o="FULYR">слой дыма</phenomenon>
   <phenomenon o="HZY">туманный</phenomenon>
   <phenomenon o="BINOVC">пробелы в закрытой облачности</phenomenon>
   <phenomenon o="ICG">обледенение</phenomenon>
   <phenomenon o="SH">ливень</phenomenon>
   <phenomenon o="SHS">ливни</phenomenon>
   <phenomenon o="DEW">роса</phenomenon>
   <phenomenon o="VIS_HYR">видимость выше</phenomenon>
   <phenomenon o="VIS_LWR">видимость ниже</phenomenon>
   <phenomenon o="VIS_RDCD">видимость уменьшена</phenomenon>
   <phenomenon o="CIG_HYR">нижняя граница облаков выше</phenomenon>
   <phenomenon o="CIG_LWR">нижняя граница облаков ниже</phenomenon>
   <phenomenon o="CLD">облако</phenomenon>
   <phenomenon o="CLDS">облака</phenomenon>
   <phenomenon o="CLD_EMBD">облако вложено</phenomenon>
   <phenomenon o="CLDS_EMBD">облака вложены</phenomenon>
   <phenomenon o="PRESFR">тенденция давления: падение быстро</phenomenon>
   <phenomenon o="PRESRR">тенденция давления: повышение быстро</phenomenon>
   <phenomenon o="FIRE">огонь</phenomenon>
   <phenomenon o="FIRES">огни</phenomenon>
   <phenomenon o="GRASS_FIRE">огонь травы</phenomenon>
   <phenomenon o="GRASS_FIRES">огни травы</phenomenon>

   <quadrant o="1">первый</quadrant>
   <quadrant o="2">второй</quadrant>
   <quadrant o="3">третий</quadrant>
   <quadrant o="4">четвертый</quadrant>

   <condMounType o="LIB">свободный от облаков</condMounType>
   <condMounType o="CLD_SCT">частично покрытый в отдельных облаках</condMounType>
   <condMounType o="VERS_INC">наклоны в облаках, вершина свободна</condMounType>
   <condMounType o="CNS_POST">свободный от стороны наблюдателя, другая сторона в облаках</condMounType>
   <condMounType o="CLD_CIME">облака касаются вершины</condMounType>
   <condMounType o="CIME_INC">вершина в облаках, наклоны свободные</condMounType>
   <condMounType o="GEN_INC">вообще в облаках, некоторые свободные вершины</condMounType>
   <condMounType o="INC">в облаках</condMounType>
   <condMounType o="INVIS">не видимый</condMounType>

   <condMounChange o="NC">никакое изменение</condMounChange>
   <condMounChange o="CUF">cumuli развиваются</condMounChange>
   <condMounChange o="ELEV_SLW">поднимают медленно</condMounChange>
   <condMounChange o="ELEV_RAPID">поднимают быстро</condMounChange>
   <condMounChange o="ELEV_STF">поднимают и наслаиваются</condMounChange>
   <condMounChange o="ABB_SLW">снижаются медленно</condMounChange>
   <condMounChange o="ABB_RAPID">снижаются быстро</condMounChange>
   <condMounChange o="STF">наслаиваются</condMounChange>
   <condMounChange o="STF_ABB">наслаиваются и снижаются</condMounChange>
   <condMounChange o="VAR_RAPID">изменяются быстро</condMounChange>

   <condVallType o="NIL">никакие низкие облака, туман или мгла</condVallType>
   <condVallType o="FOSCHIA">мгла</condVallType>
   <condVallType o="FOSCHIA_SKC_SUP">мгла, небо ясное выше</condVallType>
   <condVallType o="NEBBIA">туман</condVallType>
   <condVallType o="NEBBIA_SCT">отдельные полосы тумана</condVallType>
   <condVallType o="CLD_SCT">отдельные облака</condVallType>
   <condVallType o="CLD_SCT_NEBBIA_INF">отдельные облака, туман ниже</condVallType>
   <condVallType o="MAR_CLD">море в облаках</condVallType>
   <condVallType o="INVIS">не видимый</condVallType>

   <condVallChange o="NC">никакое изменение</condVallChange>
   <condVallChange o="DIM">уменьшаются</condVallChange>
   <condVallChange o="DIM_ELEV">уменьшаются и поднимают</condVallChange>
   <condVallChange o="DIM_ABB">уменьшаются и снижаются</condVallChange>
   <condVallChange o="AUM">увеличиваются</condVallChange>
   <condVallChange o="AUM_ELEV">увеличиваются и поднимают</condVallChange>
   <condVallChange o="AUM_ABB">увеличиваются и снижаются</condVallChange>
   <condVallChange o="ELEV">поднимают</condVallChange>
   <condVallChange o="ABB">снижаются</condVallChange>
   <condVallChange o="NEBBIA_INTER">неустойчивый туман на станции</condVallChange>

   <turbulenceDescr o="0">нет</turbulenceDescr>
   <turbulenceDescr o="1">легка</turbulenceDescr>
   <turbulenceDescr o="2">случайна, умеренна, в ясном воздухе</turbulenceDescr>
   <turbulenceDescr o="3">часта, умеренна, в ясном воздухе</turbulenceDescr>
   <turbulenceDescr o="4">случайна, умеренна, в облаках</turbulenceDescr>
   <turbulenceDescr o="5">часта, умеренна, в облаках</turbulenceDescr>
   <turbulenceDescr o="6">случайна, серьезна, в ясном воздухе</turbulenceDescr>
   <turbulenceDescr o="7">часта, серьезна, в ясном воздухе</turbulenceDescr>
   <turbulenceDescr o="8">случайна, серьезна, в облаках</turbulenceDescr>
   <turbulenceDescr o="9">часта, серьезна, в облаках</turbulenceDescr>

   <!-- WMO 306 Vol I.1 Part A, coding table 1733 -->
   <icingDescr o="0">нет</icingDescr>
   <icingDescr o="1">легка</icingDescr>
   <icingDescr o="2">легка, в облаках</icingDescr>
   <icingDescr o="3">легка, в осаждении</icingDescr>
   <icingDescr o="4">умеренна</icingDescr>
   <icingDescr o="5">умеренна, в облаках</icingDescr>
   <icingDescr o="6">умеренна, в осаждении</icingDescr>
   <icingDescr o="7">серьезна</icingDescr>
   <icingDescr o="8">серьезна, в облаках</icingDescr>
   <icingDescr o="9">серьезна, в осаждении</icingDescr>

   <seaCondition o="0">спокойно (гладким)</seaCondition>
   <seaCondition o="1">спокойно (волнистость)</seaCondition>
   <seaCondition o="2">гладко (небольшие волны)</seaCondition>
   <seaCondition o="3">небольшие волны</seaCondition>
   <seaCondition o="4">умеренные волны</seaCondition>
   <seaCondition o="5">грубо</seaCondition>
   <seaCondition o="6">очень грубо</seaCondition>
   <seaCondition o="7">высокие волны</seaCondition>
   <seaCondition o="8">очень высокие волны</seaCondition>
   <seaCondition o="9">феноменальные волны</seaCondition>

   <swellCondition o="0">никого</swellCondition>
   <swellCondition o="1">длина: коротка или средняя, высота: низкая</swellCondition>
   <swellCondition o="2">длина: длинная, высота: низкая</swellCondition>
   <swellCondition o="3">длина: коротка, высота: умеренная</swellCondition>
   <swellCondition o="4">длина: средняя, высота: умеренная</swellCondition>
   <swellCondition o="5">длина: длинная, высота: умеренная</swellCondition>
   <swellCondition o="6">длина: коротка, высота: высокая</swellCondition>
   <swellCondition o="7">длина: средняя, высота: высокая</swellCondition>
   <swellCondition o="8">длина: длинная, высота: высокая</swellCondition>
   <swellCondition o="9">хаотично</swellCondition>

   <cloudPhenom o="PWR_PLNT">электростанция</cloudPhenom>
   <cloudPhenom o="PWR_PLNT_PLUME">перо электростанции</cloudPhenom>

   <pressureTend o="0">увеличивается, после уменьшается</pressureTend>
   <pressureTend o="1">увеличивается, после устойчиво, или увеличивается после увеличивается более медленно</pressureTend>
   <pressureTend o="2">увеличивается устойчиво или неустойчиво</pressureTend>
   <pressureTend o="3">уменьшается или устойчиво, после увеличивается; или увеличивается после увеличивается более быстро</pressureTend>
   <pressureTend o="4">устойчиво</pressureTend>
   <pressureTend o="5">уменьшается после увеличивается</pressureTend>
   <pressureTend o="6">уменьшается, после устойчиво, или уменьшается после уменьшается более медленно</pressureTend>
   <pressureTend o="7">уменьшается устойчиво или неустойчиво</pressureTend>
   <pressureTend o="8">устойчиво или увеличивается, после уменьшается; или уменьшается после уменьшается более быстро</pressureTend>

   <rwySfc o="SLR">слякоть на ВПП</rwySfc>
   <rwySfc o="LSR">свободный снег на ВПП</rwySfc>
   <rwySfc o="PSR">упакованный снег на ВПП</rwySfc>
   <rwySfc o="P">местами</rwySfc>
   <rwySfc o="SANDED">смешанный с песком</rwySfc>
   <rwySfc o="WET">влажна</rwySfc>
   <rwySfc o="DRY">суха</rwySfc>
   <rwySfc o="IR">лед на ВПП</rwySfc>
   <rwySfc o="WR">влажная ВПП</rwySfc>

   <snowCoverType o="ONE_LOOSE">one loose</snowCoverType>
   <snowCoverType o="MUCH_LOOSE">много свободный</snowCoverType>
   <snowCoverType o="TRACE_LOOSE">следы свободный</snowCoverType>
   <snowCoverType o="MEDIUM_PACKED">средний упакован</snowCoverType>
   <snowCoverType o="HARD_PACKED">трудно упакован</snowCoverType>
   <snowCoverType o="NIL">ноль</snowCoverType>

   <estimatedItem o="WND">ветер</estimatedItem>
   <estimatedItem o="CIG">нижняя граница облаков</estimatedItem>
   <estimatedItem o="CIG_BLN">нижняя граница облаков от данных аэростата</estimatedItem>
   <estimatedItem o="CLD_HGTS">высота облаков</estimatedItem>
   <estimatedItem o="SLP">давление на уровне моря</estimatedItem>
   <estimatedItem o="ALSTG">урегулирование высотомера</estimatedItem>

   <fcstNotAvblReason o="NOOBS">никакое наблюдение</fcstNotAvblReason>
   <fcstNotAvblReason o="INSUFFICIENTOBS">недостаточное наблюдение</fcstNotAvblReason>

   <error o="obsStation">не код аэродрома</error>
   <error o="obsTime">не время наблюдения</error>
   <error o="other">недействительный формат</error>

   <cgi o="title">МЕТАР/ТАФ декодер</cgi>
   <cgi o="infosrc">Хороший источник для современных сообщений МЕТАР и ТАФ</cgi>
   <cgi o="outdated">предупреждение: Данные прогноза для многих станций не были обновлены в НОАА с тех пор August, 3rd, 2006.</cgi>
   <cgi o="infofetch">Если ключевое слово "FETCH" и одни или более ид аэропорта используется, сообщения принесены из отобранного источника (или если этот выбор инвалиды от файла на сервере, откуда эта веб-страница прибывает).</cgi>
   <cgi o="example">примеры для сообщений:</cgi>
   <cgi o="message">сообщение:</cgi>
   <cgi o="type">имеет тип:</cgi>
   <cgi o="source">усилия от:</cgi>
   <cgi o="language">язык:</cgi>
   <cgi o="format">показа в:</cgi>
   <cgi o="decode">переводить</cgi>
   <cgi o="disclaimer">Предупреждение: Информация относительно этой страницы может быть устарелой, неточной, или оба. Этому не удовлетворяют для использования в авиации.</cgi>
  </ru>
 </trans>
</xsl:stylesheet>
