#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <errno.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdarg.h>

#ifdef HAVE_ASSERT_H
#include <assert.h>
#endif

#ifdef HAVE_ERRX
#include <err.h>
#endif

#include "list.h"

#define MGSTAT_VER      "0.11" 

//#define DEBUG

#define DEBUG_FLAG	1
#define MG_POS		"mgstat.pos"
#define MG_HIST		"mgstat.hist"
#define HTML_HDR	"<HTML><BODY BGCOLOR=#EAE6D4>"
#define HTML_FOOT	"<BR><BR></CENTER><FONT SIZE=2 COLOR=#707070>Report generated by " \
			"<A HREF=\"http://wizard.ae.krakow.pl/~mike/mgstat/\">mgstat " MGSTAT_VER "</A> " \
			"</BODY></HTML>"

#define MAX_STATUS_NR   32
#define CHART_HITS	0
#define CHART_BYTES	1

extern unsigned int months_nr;
extern struct list_head status_l;
extern char *m_name[];
extern char *out_dir;
extern char *server_name;
extern int out_ft;

struct status_t {
	struct list_head head;
	char status[64];
	unsigned int nr;
};

struct year_t {
	struct list_head head;
	struct list_head months;
	unsigned short year;
	unsigned short nr_months;
};

struct month_t {
	struct list_head head;
	struct list_head days;
	struct list_head l_year;
	unsigned long long status[MAX_STATUS_NR];
	char month[4];
	unsigned short year;
	unsigned short nr_days;
	
};
	
struct entry_t {
	struct list_head l_month;
	unsigned short day;
	unsigned long long req_c;	/* total number of requests 	 	*/
	unsigned long long comp_c;	/* number of requests compressed 	*/
	unsigned long long ncomp_c;	/* number of requests NOT compressed  	*/
	unsigned long long actual_b; 	/* data count of compressable objects	*/
	unsigned long long comp_b;	/* data count of compressed content 	*/
	unsigned long long all_b; 	/* data count of all objects	 	*/
	unsigned long long sent_b; 	/* data count of objects sent		*/
};

//extern struct gd_image;

void echo_out(struct entry_t *);
void table_hdr(FILE *);
void month_html(struct month_t *, FILE *);
void make_index(struct year_t *, FILE *);
void print_msg(const char *, ...);

#ifdef HAVE_GD
/* graph.c */
struct gd_image *open_graph(int, int, unsigned long long);
void close_graph(struct gd_image *, char *);
void draw_val(struct gd_image *, int, int, unsigned long long);
#endif

/* status.c */
struct status_t *new_status(char *, int );
unsigned int find_status(char *, int );
void write_status(int);
void read_status(int);
char *find_by_nr(unsigned int );

#ifndef HAVE_ERRX
void errx(int d, const char *, ...);
#endif

#ifndef HAVE_SNPRINTF
int snprintf(char *, int, const char *, ...);
#endif

 
