
/* signal handling */
extern void catch_signals _((void (* catchfunc) (void)));
extern FLAG cansuspendmyself;
extern void suspendmyself _((void));

/* tty handling */
extern void raw_mode _((FLAG state));
extern void get_term _((void));
extern void getwinsize _((void));

/* i/o handling */
extern void flush _((void));
extern int inputreadyafter _((int fid, int msec));
extern void putescape _((char * s));

/* screen mode handling */
#ifdef msdos
extern void set_video_lines _((int r));
	/* 0/1/2: 200/350/400 lines */
extern void set_grafmode_height _((int r, int l));
	/* 0/1/2: font height 8/14/16 ; 1/2/3/n: 14/25/43/n lines */
extern void set_fontbank _((int f));
	/* 0..7 */
#endif
extern void set_textmode_height _((int r));
	/* 0/1/2: font height 8/14/16 */
extern void set_font_height _((int r));
	/* set font height in character pixels, <= 32 */
extern void set_screen_mode _((int mode));
extern void maximize_restore_screen _((void));
extern void resize_the_screen _((FLAG sb, FLAG keep_columns));
extern void switch_textmode_height _((FLAG cycle));
	/* True: cycle through font heights 8/14/16 
	   False: switch between font heights 8/16 */

/* screen manipulation */
extern void clear_screen _((void));
extern void clear_eol _((void));
extern void scroll_forward _((void));
extern void scroll_reverse _((void));
extern void add_line _((int));
extern void delete_line _((int));
extern void set_cursor _((int, int));
extern int current_cursor_y;

/* screen output */
extern void putstring _((char *));
extern void __putchar _((character));
extern void ring_bell _((void));
extern void putblockchar _((character));

/* screen attributes: ANSI sequences */
extern char * dimansi;		/* line indicator dimming */
extern char * selansi;		/* menu selection */
extern char * selfgansi;	/* menu selection background */
extern char * ctrlansi;		/* control character display */
extern char * uniansi;		/* Unicode character display */
extern char * unimarkansi;	/* Unicode (lineend) marker display */
extern char * combiningansi;	/* combining character display */
extern char * menuansi;		/* menu line */
extern char * HTMLansi;		/* HTML display */
extern char * diagansi;		/* dialog (bottom status) line */
extern char * scrollfgansi;	/* scrollbar foreground */
extern char * scrollbgansi;	/* scrollbar background */

/* screen attributes handling */
extern void disp_normal _((void));
extern void disp_selected _((FLAG bg, FLAG border));
extern void disp_colour _((int));
extern void reverse_on _((void));
extern void reverse_off _((void));
extern void altcset_on _((void));
extern void altcset_off _((void));
extern void dim_on _((void));
extern void dim_off _((void));
extern void bold_on _((void));
extern void bold_off _((void));
extern void unidisp_on _((void));
extern void unidisp_off _((void));
extern void ctrldisp_on _((void));
extern void ctrldisp_off _((void));
extern void menudisp_on _((void));
extern void menudisp_off _((void));
extern void dispHTML_code _((void));
extern void dispHTML_jsp _((void));
extern void dispHTML_comment _((void));
extern void dispHTML_off _((void));
extern void unimarkdisp_on _((void));
extern void unimarkdisp_off _((void));
extern void combiningdisp_on _((void));
extern void combiningdisp_off _((void));
extern void diagdisp_on _((void));
extern void diagdisp_off _((void));
extern void disp_scrollbar_foreground _((void));
extern void disp_scrollbar_background _((void));
extern void disp_scrollbar_off _((void));
extern void menuheader_on _((void));
extern void menuheader_off _((void));
extern void menuborder_on _((void));
extern void menuborder_off _((void));
extern void menuitem_on _((void));
extern void menuitem_off _((void));

/* input functions */
extern int get_digits _((int *));
extern int __readchar _((void));
extern int __readchar_report_winchg _((void));

/* basic keyboard to function mappings */
extern voidfunc key_map [256];
extern voidfunc ws_key_map [32];
extern voidfunc pico_key_map [32];
extern voidfunc emacs_key_map [32];
struct pc_fkeyentry {
	voidfunc fp;
	unsigned char fkeyshift;
};
extern struct pc_fkeyentry pc_fkey_map [256];
struct fkeyentry {
	char * fk;
	voidfunc fp;
	unsigned char fkeyshift;
};
extern void set_fkeymap _((char *));

/* keyboard functions */
extern unsigned long readcharacter_allbuttons _((void));
extern unsigned long readcharacter _((void));
extern unsigned long readcharacter_mapped _((void));
extern unsigned long readcharacter_unicode _((void));
extern unsigned long readcharacter_unicode_mapped _((void));
extern unsigned long _readchar_nokeymap _((void));
extern int read1byte _((void));
extern int char_ready_within _((int));

/* mouse handling functions */
extern void DIRECTcrttool _((void));
extern void DIRECTxterm _((void));
extern void TRACKxterm _((void));
extern void TRACKxtermT _((void));
extern FLAG mouse_hilite_tracking;
extern FLAG mouse_button_event_tracking;

/* auxiliary menu functions */
extern void menu_mouse_mode _((FLAG));
extern FLAG in_menu_border;

/* terminal feature indications */
extern FLAG can_scroll_reverse;
extern FLAG can_add_line;
extern FLAG can_delete_line;
extern FLAG can_clear_eol;
extern FLAG can_alt_cset;

/* terminal feature usage flags */
extern FLAG use_ascii_graphics;		/* use ASCII graphics for borders */
extern FLAG use_vga_block_graphics;	/* charset is VGA with block graphics */
extern FLAG use_pc_block_graphics;	/* alternate charset is VGA with block graphics */
extern FLAG use_vt100_block_graphics;
extern FLAG use_appl_keypad;
extern char menu_border_style;
extern int menumargin;
extern FLAG use_stylish_menu_selection;
extern int use_unicode_menubar _((void));
extern FLAG explicit_border_style;
extern FLAG use_mouse;
extern FLAG use_bold;
extern FLAG use_bgcolor;
extern FLAG use_modifyOtherKeys;
extern FLAG colours_256;
extern FLAG colours_88;
extern FLAG ansi_esc;
extern FLAG standout_glitch;

/* keyboard mapping setup functions */
extern void toggleKEYMAP _((void));
extern void setupKEYMAP _((void));
extern void setKEYMAP _((char *));
extern int get_string_nokeymap _((char *, char *, FLAG, char *));
extern char * keyboard_mapping;

/* keyboard input special results (additional information) */
extern voidfunc keyproc;	/* function addressed by entered function key */

extern unsigned char keyshift;	/* shift state of entered function key */
/* shift state indications of escape sequences */
/*
ctrl	alt	shift	ESC code/ -1	keyshift code
0	0	0	0		000
0	0	1	2	1	001
0	1	0	3	2	010
0	1	1	4	3	011
1	0	0	5	4	100
1	0	1	6	5	101
1	1	0	7	6	110
1	1	1	8	7	111
*/
/* shift state masks (indications decremented by 1) */
#define shift_mask	0x01
#define alt_mask	0x02
#define ctrl_mask	0x04
#define ctrlshift_mask	(ctrl_mask | shift_mask)
#define altshift_mask	(alt_mask | shift_mask)
#define altctrl_mask	(alt_mask | ctrl_mask)
#define altctrlshift_mask	(alt_mask | ctrl_mask | shift_mask)
#define applkeypad_mask	0x08
/* skip 0x30 (may be included from keyboard.c) */
#define report_mask	0x40

extern int ansi_params;
extern int ansi_param [];
extern char ansi_fini;

