/*======================================================================*\
|*		Editor mined						*|
|*		keyboard mappings to commands and characters		*|
\*======================================================================*/

#include "mined.h"
#include "io.h"


/*======================================================================*\
|*	Dispatch function keys and some keypad keys to mined functions	*|
\*======================================================================*/

#include "dispatch.c"


/*======================================================================*\
|*			Key and function key -> command mapping		*|
\*======================================================================*/

/* The mapping between input codes and functions */

#define Sch (voidfunc) Scharacter

voidfunc key_map [256] =
{	/* characters to functions map */
  /* ^@-^G */	MARK, MPW, DCC, PD, MRT, MUP, MNW, GOTO,
  /* ^H-^O */	DPC, Sch, SNL, DLN, HOP, SNL, RS, LIB,
  /* ^P-^W */	PASTEstay, HOP, PU, MLF, DNW, CUT, CTRLINS, SU,
  /* ^X-^_ */	MDN, COPY, SD, ESCAPE, CANCEL, MARK, DPW, (voidfunc) BADch,
  /* 040-057 */	Sch, Sch, Sdoublequote, Sch, Sch, Sch, Sch, Ssinglequote,
		Sch, Sch, Sch, Sch, Sch, Sdash, Sch, Sch,
  /* 060-077 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 100-117 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 120-137 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 140-157 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 160-177 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, 
		Sch, Sch, Sch, Sch, Sch, Sch, Sch, DELchar,
  /* 200-217 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 220-237 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 240-257 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 260-277 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 300-317 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 320-337 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 340-357 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
  /* 360-377 */	Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch, Sch,
};

voidfunc ws_key_map [32] =
{	/* characters to functions map */
  /* ^@-^G */	I, MPW, JUS, PD, MRT, MUP, MNW, DCC,
  /* ^H-^O */	MLF, Sch, Sch, ctrlK, RS, SNL, LIB, ctrlO,
  /* ^P-^W */	CTRLINS, ctrlQ, PU, MLF, DNW, (voidfunc) BADch, TOGINS, SU,
  /* ^X-^_ */	MDN, DLINE, SD, ESCAPE, CANCEL, (voidfunc) BADch, (voidfunc) BADch, (voidfunc) BADch,
};

voidfunc pico_key_map [32] =
{	/* characters to functions map */
  /* ^@-^G */	MNW, BLINE, MLF, FS, DCC, ELINE, MRT, HELP,
  /* ^H-^O */	DPC, Sch, JUS, DLN, RDwin, SNL, MDNEL, WTU,
  /* ^P-^W */	MUP, I, INSFILE, I, SPELL, PASTE, PD, SFW,
  /* ^X-^_ */	QUED, PU, I, ESCAPE, CANCEL, MARK, toggleMARK, CTRLINS,
};

voidfunc emacs_key_map [32] =
{	/* characters to functions map */
  /* ^@-^G */	MARK, BLINE, MLF, I, DCC, ELINE, MRT, CANCEL,
  /* ^H-^O */	HELP, Sch, Sch, DLN, RD, SNL, MDN, LIB,
  /* ^P-^W */	MUP, CTRLINS, SRV, SFW, I, (voidfunc) REPT, PD, CUT,
  /* ^X-^_ */	EMAX, PASTE, SUSP, META, HOP, I, HOP, UNDO,
};


/* mapping function key codes -> functions
   function keys deliver NUL and the following codes:
block1:	RGISOQHKPM
block2:	GHIKMOPQRS	Pos1 Up PgUp Left Center Right End Down PdDn Ins
ctrl:	st <-/->
ctrl:	wu	Pos1 End
	0x84v	PgUp PgDn	(first char is a diaeresis in CP437)
F1-F10:	;<=>?@ABCD
shift:	TUVWXYZ[\]
ctrl:	^_`abcdefg
alt:	hijklmnopq
*/
struct pc_fkeyentry pc_fkey_map [256] =
{
   /* 00-0F */ {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I},
   /* 10 alt-Q */ {I},
   /* 11 alt-W */ {I},
   /* 12 alt-E */ {EDITMENU},
   /* 13 alt-R */ {I},
   /* 14 alt-T */ {I},
   /* 15 alt-Y */ {I},
   /* 16 alt-U */ {I},
   /* 17 alt-I */ {I},
   /* 18 alt-O */ {OPTIONSMENU},
   /* 19 alt-P */ {PARAMENU},
   /* 1A-1D */ {I}, {I}, {I}, {I},
   /* 1E alt-A */ {I},
   /* 1F alt-S */ {SEARCHMENU},
   /* 20 alt-D */ {I},
   /* 21 alt-F */ {FILEMENU},
   /* 22 alt-G */ {I},
   /* 23 alt-H */ {HTML},
   /* 24 alt-J */ {I},
   /* 25 alt-K */ {I},
   /* 26 alt-L */ {I},
   /* 27-2B */ {I}, {I}, {I}, {I}, {I},
   /* 2C alt-Z */ {I},
   /* 2D alt-X */ {I},
   /* 2E alt-C */ {I},
   /* 2F alt-V */ {I},
   /* 30 alt-B */ {I},
   /* 31 alt-N */ {I},
   /* 32 alt-M */ {I},
   /* 33-36 */ {I}, {I}, {I}, {I},
   /* 37 alt-* */ {I, alt_mask},
   /* 38 */ {I},
   /* 39 alt-control-space */ {MARK},
   /* 3A */ {I},
   /* 3B F1 */ {F1},
   /* 3C F2 */ {F2},
   /* 3D F3 */ {F3},
   /* 3E F4 */ {F4},
   /* 3F F5 */ {F5},
   /* 40 F6 */ {F6},
   /* 41 F7 */ {F7},
   /* 42 F8 */ {F8},
   /* 43 F9 */ {F9},
   /* 44 F10 */ {F10},
   /* 45-46 */ {I}, {I},
   /* 47 home */ {HOMEkey},
   /* 48 up */ {MUP},
   /* 49 pgup */ {PU},
   /* 4A alt-- */ {screenlesslines, alt_mask},
   /* 4B lf */ {MLF},
   /* 4C 5 */ {HOP},
   /* 4D rt */ {MRT},
   /* 4E alt-+ */ {screenmorelines, alt_mask},
   /* 4F end */ {ENDkey},
   /* 50 dn */ {MDN},
   /* 51 pgdn */ {PD},
   /* 52 ins */ {INSkey},
   /* 53 del */ {DELkey},
   /* 54 shift-F1 */ {F1, shift_mask},
   /* 55 shift-F2 */ {F2, shift_mask},
   /* 56 shift-F3 */ {F3, shift_mask},
   /* 57 shift-F4 */ {F4, shift_mask},
   /* 58 shift-F5 */ {F5, shift_mask},
   /* 59 shift-F6 */ {F6, shift_mask},
   /* 5A shift-F7 */ {F7, shift_mask},
   /* 5B shift-F8 */ {F8, shift_mask},
   /* 5C shift-F9 */ {F9, shift_mask},
   /* 5D shift-F10 */ {F10, shift_mask},
   /* 5E control-F1 */ {F1, ctrl_mask},
   /* 5F control-F2 */ {F2, ctrl_mask},
   /* 60 control-F3 */ {F3, ctrl_mask},
   /* 61 control-F4 */ {F4, ctrl_mask},
   /* 62 control-F5 */ {F5, ctrl_mask},
   /* 63 control-F6 */ {F6, ctrl_mask},
   /* 64 control-F7 */ {F7, ctrl_mask},
   /* 65 control-F8 */ {F8, ctrl_mask},
   /* 66 control-F9 */ {F9, ctrl_mask},
   /* 67 control-F10 */ {F10, ctrl_mask},
   /* 68 alt-F1 */ {F1, alt_mask},
   /* 69 alt-F2 */ {F2, alt_mask},
   /* 6A alt-F3 */ {F3, alt_mask},
   /* 6B alt-F4 */ {F4, alt_mask},
   /* 6C alt-F5 */ {F5, alt_mask},
   /* 6D alt-F6 */ {F6, alt_mask},
   /* 6E alt-F7 */ {F7, alt_mask},
   /* 6F alt-F8 */ {F8, alt_mask},
   /* 70 alt-F9 */ {F9, alt_mask},
   /* 71 alt-F10 */ {F10, alt_mask},
   /* 72 */ {I},
   /* 73 control-lf */ {MLF, ctrl_mask},
   /* 74 control-rt */ {MRT, ctrl_mask},
   /* 75 control-end */ {ENDkey, ctrl_mask},
   /* 76 control-pgdn */ {PD, ctrl_mask},
   /* 77 control-home */ {HOMEkey, ctrl_mask},
   /* 78 alt-1 */ {key_1, alt_mask},
   /* 79 alt-2 */ {key_2, alt_mask},
   /* 7A alt-3 */ {key_3, alt_mask},
   /* 7B alt-4 */ {key_4, alt_mask},
   /* 7C alt-5 */ {key_5, alt_mask},
   /* 7D alt-6 */ {key_6, alt_mask},
   /* 7E alt-7 */ {key_7, alt_mask},
   /* 7F alt-8 */ {key_8, alt_mask},
   /* 80 alt-9 */ {key_9, alt_mask},
   /* 81 alt-0 */ {key_0, alt_mask},
   /* 82-83 */ {I}, {I},
   /* 84 control-pgup */ {PU, ctrl_mask},
   /* 85 F11 */ {F11},
   /* 86 F12 */ {F12},
   /* 87 shift-F11 */ {F11, shift_mask},
   /* 88 shift-F12 */ {F12, shift_mask},
   /* 89 control-F11 */ {F11, ctrl_mask},
   /* 8A control-F12 */ {F12, ctrl_mask},
   /* 8B alt-F11 */ {F11, alt_mask},
   /* 8C alt-F12 */ {F12, alt_mask},
   /* 8D control-up */ {MUP, ctrl_mask},
   /* 8E control-- */ {screensmaller, ctrl_mask},
   /* 8F control-5 */ {HOP, ctrl_mask},
   /* 90 control-+ */ {screenbigger, ctrl_mask},
   /* 91 control-dn */ {MDN, ctrl_mask},
   /* 92 control-ins */ {INSkey, ctrl_mask},
   /* 93 control-del */ {DELkey, ctrl_mask},
   /* 94 */ {I},
   /* 95 control-/ */ {LNCI, ctrl_mask},
   /* 96 control-* */ {I, ctrl_mask},
   /* 97 alt-home */ {HOMEkey, alt_mask},
   /* 98 alt-up */ {MUP, alt_mask},
   /* 99 alt-pgup */ {PU, alt_mask},
   /* 9A */ {I},
   /* 9B alt-lf */ {MLF, alt_mask},
   /* 9C */ {I},
   /* 9D alt-rt */ {MRT, alt_mask},
   /* 9E */ {I},
   /* 9F alt-end */ {ENDkey, alt_mask},
   /* A0 alt-dn */ {MDN, alt_mask},
   /* A1 alt-pgdn */ {PD, alt_mask},
   /* A2 alt-ins */ {INSkey, alt_mask},
   /* A3 alt-del */ {DELkey, alt_mask},
   /* A4 alt-/ */ {LNSW, alt_mask},
   /* A5-AF */ {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I},
   /* B0-BF */ {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I},
   /* C0-CF */ {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I},
   /* D0-DF */ {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I},
   /* E0-EF */ {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I},
   /* F0-FF */ {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I}, {I},
};


#ifndef msdos

/* mapping table: function key escape sequences -> mined functions */
struct fkeyentry fkeymap [] =
{
	/* Alt-Letter sequences for manual menu activation */
/*
	{"\033f",	FILEMENU},
	{"\033e",	EDITMENU},
	{"\033s",	SEARCHMENU},
	{"\033p",	PARAMENU},
	{"\033o",	OPTIONSMENU},
*/

	/* Alt-Letter sequences for keyboard switching functions 
	   to be recognised on prompt line */
	{"\033k",	toggleKEYMAP},
	{"\033K",	setupKEYMAP},
	{"\033I",	setupKEYMAP},

	/* VT100 and Sun */
	{"\033[A",	MUP},	/* move cursor up	*/
	{"\033[B",	MDN},	/* more cursor down	*/
	{"\033[C",	MRT},	/* more cursor right	*/
	{"\033[D",	MLF},	/* more cursor left	*/

	/* Sun raw function key codes */
	{"\033[215z",	MUP},	/* move cursor up	*/
	{"\033[221z",	MDN},	/* more cursor down	*/
	{"\033[219z",	MRT},	/* more cursor right	*/
	{"\033[217z",	MLF},	/* more cursor left	*/

	/* SuSe Linux console */
	{"\033[1~",	smallHOMEkey},	/* Pos1	*/
	{"\033[4~",	smallENDkey},	/* End	*/

	/* RedHat Linux console */
	{"\033[[A",	F1},	/* F1	*/
	{"\033[[B",	F2},	/* F2	*/
	{"\033[[C",	F3},	/* F3	*/
	{"\033[[D",	F4},	/* F4	*/
	{"\033[[E",	F5},	/* F5	*/
	{"\033[G",	HOP},	/* 5	*/
	{"\033[1G",	HOP},	/* pattern for shifted 5? (or some other terminal)	*/

	/* PuTTY */
	{"\033OG",	HOP},	/* 5	*/

	/* Linux X / xterm */
	{"\033OP",	F1},	/* F1, VT100 PF1	*/
	{"\033OQ",	F2},	/* F2, VT100 PF2	*/
	{"\033OR",	F3},	/* F3, VT100 PF3	*/
	{"\033OS",	F4},	/* F4, VT100 PF4	*/
	{"\033OH",	HOMEkey},	/* Pos1	*/
	{"\033OF",	ENDkey},	/* End	*/
	{"\033OE",	HOP},	/* 5	*/

	/* non-application mode xterm */
	{"\033[H",	smallHOMEkey},	/* Pos1, esp on left keypad	*/
	{"\033[F",	smallENDkey},	/* End, esp on left keypad	*/
	{"\033[E",	HOP},	/* 5, Begin	*/

	/* xterm generic patterns for modified keypad keys */
	{"\033[1H",	HOMEkey},	/* Pos1	*/
	{"\033[1F",	ENDkey},	/* End	*/
	{"\033[1E",	HOP},	/* 5	*/
	{"\033[1A",	MUP},	/* Up	*/
	{"\033[1D",	MLF},	/* Left	*/
	{"\033[1B",	MDN},	/* Down	*/
	{"\033[1C",	MRT},	/* Right	*/

	/* xterm generic patterns for modified function keys */
	{"\033[1P",	F1},	/* F1	*/
	{"\033[1Q",	F2},	/* F2	*/
	{"\033[1R",	F3},	/* F3	*/
	{"\033[1S",	F4},	/* F4	*/

	/* xterm specials */
	{"\033[200~",	I},	/* begin bracketed paste */
	{"\033[201~",	I},	/* end bracketed paste */

	/* SiC! keypad redefinitions */
	{"\033[57~",	SNL},	/* KP_Enter	*/
	{"\033[58~",	INSkey, ctrl_mask},	/* control-Ins	*/

	/* Deprecated; mined keyboard add-ons: shifted digits etc*/
	{"\033[00~",	key_0},
	{"\033[01~",	key_1},
	{"\033[02~",	key_2},
	{"\033[03~",	key_3},
	{"\033[04~",	key_4},
	{"\033[05~",	key_5},
	{"\033[06~",	key_6},
	{"\033[07~",	key_7},
	{"\033[08~",	key_8},
	{"\033[09~",	key_9},
	{"\033[~",	DPC},	/* modified BackSpace (ctrl/shift) */

	/* various modified keypad keys (non-application mode) */
	{"\033\r",	Popmark},	/* alt-Enter	*/
	{"\033\n",	Popmark},	/* alt-Enter	*/
	{"\033[2H",	smallHOMEkey, shift_mask},	/* shift-Pos1	*/
	{"\033[2F",	smallENDkey, shift_mask},	/* shift-Ende	*/
	{"\033[5H",	smallHOMEkey, ctrl_mask},	/* control-Pos1	*/
	{"\033[5F",	smallENDkey, ctrl_mask},	/* control-Ende	*/
	{"\0332A",	MUP, shift_mask},	/* shift-Up	*/
	{"\0332B",	MDN, shift_mask},	/* shift-Down	*/
	{"\0332C",	MRT, shift_mask},	/* shift-Right	*/
	{"\0332D",	MLF, shift_mask},	/* shift-Left	*/
	{"\0335A",	MUP, ctrl_mask},	/* control-Up	*/
	{"\0335B",	MDN, ctrl_mask},	/* control-Down	*/
	{"\0335C",	MRT, ctrl_mask},	/* control-Right	*/
	{"\0335D",	MLF, ctrl_mask},	/* control-Left	*/
	{"\0336A",	MUP, ctrlshift_mask},	/* control-shift-Up	*/
	{"\0336B",	MDN, ctrlshift_mask},	/* control-shift-Down	*/
	{"\0336C",	MRT, ctrlshift_mask},	/* control-shift-Right	*/
	{"\0336D",	MLF, ctrlshift_mask},	/* control-shift-Left	*/

	/* vim mouse wheel mappings for xterm */
	{"\033[64~",	PU},	/* shift-wheel-up */
	{"\033[65~",	PD},	/* shift-wheel-down */
	{"\033[62~",	SU},	/* wheel-up */
	{"\033[63~",	SD},	/* wheel-down */

	/* various VT100-style Fn function keys */
	{"\033[11~",	F1},	/* F1	*/
	{"\033[12~",	F2},	/* F2	*/
	{"\033[13~",	F3},	/* F3	*/
	{"\033[14~",	F4},	/* F4	*/
	{"\033[15~",	F5},	/* F5	*/
	{"\033[17~",	F6},	/* F6	*/
	{"\033[18~",	F7},	/* F7	*/
	{"\033[19~",	F8},	/* F8	*/
	{"\033[20~",	F9},	/* F9	*/
	{"\033[21~",	F10},	/* F10	*/

	/* VT220-style Fn function keys (control-Fn with xterm VT220 mode) */
	{"\033[23~",	F11},	/* F11	*/
	{"\033[24~",	F12},	/* F12	*/
	/* the following are also attached to Control-Fn by xterm 216 
	   with the "old function keys" option - it should better 
	   not be used, especially as the DO (vt220) sequence 
	   is ambiguously emitted by both Shift-F6 / Control-F6 and 
	   Menu keys */
	{"\033[25~",	F3, shift_mask},	/* F13	*/
	{"\033[26~",	F4, shift_mask},	/* F14	*/
	{"\033[28~",	F5, shift_mask},	/* HELP (vt220) */
	{"\033[29~",	HOP},			/* DO (vt220), Menu (xterm) */
	{"\033[31~",	F7, shift_mask},	/* F17	*/
	{"\033[32~",	F8, shift_mask},	/* F18	*/
	{"\033[33~",	F9, shift_mask},	/* F19	*/
	{"\033[34~",	F10, shift_mask},	/* F20	*/

	/* xterm VT220 mode Fn function keys (control-Fn, actually),
	   with xterm 216, also with oldFunctionKeys mode
	 */
	{"\033[42~",	F11, shift_mask}, /* control-F11 */
	{"\033[43~",	F12, shift_mask}, /* control-F12 */

	/* further VT100 keys - some have been disabled by linux sequences */
	{"\033[6~",	PD},	/* Next Screen, xterm PgDn	*/
	{"\033[5~",	PU},	/* Prev Screen, xterm PgUp	*/
	{"\033[3~",	DELkey},	/* Remove, xterm Del	*/
	{"\033[2~",	INSkey},	/* Insert Here, xterm Ins	*/
	{"\033[@",	HOMEkey},	/* Pos1, PC-xterm	*/
	{"\033[e",	ENDkey},	/* End, PC-xterm	*/
	/* application cursor keys */
	{"\033OA",	MUP},	/* up	*/
	{"\033OB",	MDN},	/* dn	*/
	{"\033OC",	MRT},	/* rt	*/
	{"\033OD",	MLF},	/* lf	*/
	{"\033O@",	HOMEkey},	/* Pos1, PC-xterm	*/
	{"\033Oe",	ENDkey},	/* End, PC-xterm	*/
	/* application keypad */
	{"\033Op",	INSkey},	/* Ins, keypad 0	*/
	{"\033Oq",	ENDkey},	/* End, keypad 1	*/
	{"\033Or",	MDN},	/* dn, keypad 2	*/
	{"\033Os",	PD},	/* PgDn, keypad 3	*/
	{"\033Ot",	MLF},	/* lf, keypad 4	*/
	{"\033Ou",	HOP},	/* mid, keypad 5	*/
	{"\033Ov",	MRT},	/* rt, keypad 6	*/
	{"\033Ow",	HOMEkey},	/* Pos1, keypad 7	*/
	{"\033Ox",	MUP},	/* up, keypad 8	*/
	{"\033Oy",	PU},	/* PgUp, keypad 9	*/
	{"\033OM",	SNL},	/* Enter */
	{"\033Ol",	DELkey},	/* Del, keypad ,	*/
	{"\033Om",	SU},	/* PF3, keypad - 	*/
	{"\033On",	DELkey},	/* Del, keypad .	*/
	/* xterm/vt100 application keypad */
	{"\033Oo",	I},	/* PF1, keypad /	*/
	{"\033Oj",	I},	/* PF2, keypad *	*/
	{"\033Ok",	SD},	/* PF4, keypad +	*/
	{"\033O ",	HOP},	/* Space, also hanterm keypad 5	*/
	{"\033OI",	STAB},	/* Tab */

	/* Sun */
	{"\033[208z",	F6, shift_mask},	/* R1 -> grave */
	{"\033[209z",	F6, ctrl_mask},		/* R2 -> circumflex */
	{"\033[210z",	F6},			/* R3 -> acute */
	{"\033[211z",	F5},			/* R4 -> diaeresis */
	{"\033[212z",	F5, shift_mask},	/* R5 -> tilde */
	{"\033[213z",	F5, ctrl_mask},		/* R6 -> angstrom */
	{"\033[214z",	SU},	/* R7	*/
	{"\033[216z",	PU},	/* R9	*/
	{"\033[218z",	HOP},	/* R11	*/
	{"\033[220z",	SD},	/* R13	*/
	{"\033[222z",	PD},	/* R15	*/
	{"\033[254z",	GOMA},	/* - */
	{"\033[253z",	MARK},	/* + */
	{"\033[250z",	COPY},	/* Enter */
	{"\033[249z",	DELkey},	/* Del */
	{"\033[247z",	INSkey, ctrl_mask},	/* Ins */
	{"\033[1z",	HOMEkey},	/* Home/Pos1, non-appl */
	{"\033[4z",	ENDkey},	/* End, non-appl */
	{"\033[2z",	INSkey},	/* Ins on VT100 block */
	{"\033[3z",	DELkey},	/* Del (xterm/Sun) */
	{"\033[5z",	PU},	/* PgUp on VT100 block */
	{"\033[6z",	PD},	/* PgDn on VT100 block */
	{"\033[192z",	MARK},	/* Stop (F11 with xterm "Sun Function-Keys") */
	{"\033[193z",	AGAIN},	/* Again (F12 with xterm "Sun Function-Keys") */
	{"\033[194z",	FS},	/* Props */
	{"\033[195z",	I},	/* Undo */
	{"\033[197z",	COPY},	/* Copy */
	{"\033[199z",	INSkey},	/* Paste */
	{"\033[200z",	FIND},	/* Find */
	{"\033[201z",	CUT},	/* Cut */
	{"\033[196z",	HELP},	/* Help */

	{"\033[224z",	F1},	/* F1, xterm "Sun Function-Keys" */
	{"\033[225z",	F2},	/* F2 */
	{"\033[226z",	F3},	/* F3 */
	{"\033[227z",	F4},	/* F4 */
	{"\033[228z",	F5},	/* F5 */
	{"\033[229z",	F6},	/* F6 */
	{"\033[230z",	F7},	/* F7 */
	{"\033[231z",	F8},	/* F8 */
	{"\033[232z",	F9},	/* F9 */
	{"\033[233z",	F10},	/* F10 */
	{"\033[234z",	F11},	/* F11 */
	{"\033[235z",	F12},	/* F12 */

	/* Iris */
	{"\033[209q",	HOMEkey},	/* Print Screen */
	{"\033[213q",	ENDkey},	/* Scroll Lock */
/*	{"\033[217q",	I},	*//* Pause */
	{"\033[139q",	INSkey},	/* Insert, Ins */
	{"\033[P",	DELkey},	/* Del */
/*	{"\033[H",	smallHOMEkey},	*//* Home */
	{"\033[150q",	PU},	/* PgUp */
	{"\033[146q",	smallENDkey},	/* End */
	{"\033[154q",	PD},	/* PgDn */
	{"\033[000q",	HOP},	/* 5 */
	{"\033[001q",	F1},	/* F1 */
	{"\033[002q",	F2},	/* F2 */
	{"\033[003q",	F3},	/* F3 */
	{"\033[004q",	F4},	/* F4 */
	{"\033[005q",	F5},	/* F5 */
	{"\033[006q",	F6},	/* F6 */
	{"\033[007q",	F7},	/* F7 */
	{"\033[008q",	F8},	/* F8 */
	{"\033[009q",	F9},	/* F9 */
	{"\033[010q",	F10},	/* F10 */
	{"\033[011q",	F11},	/* F11 */
	{"\033[012q",	F12},	/* F12 */
	{"\033[013q",	F1, shift_mask},	/* shift-F1 ? */
	{"\033[014q",	F2, shift_mask},	/* shift-F2 ? */
	{"\033[015q",	F3, shift_mask},	/* shift-F3 ? */
	{"\033[016q",	F4, shift_mask},	/* shift-F4 ? */
	{"\033[017q",	F5, shift_mask},	/* shift-F5 ? */
	{"\033[018q",	F6, shift_mask},	/* shift-F6 ? */
	{"\033[019q",	F7, shift_mask},	/* shift-F7 ? */
	{"\033[020q",	F8, shift_mask},	/* shift-F8 ? */
	{"\033[021q",	F9, shift_mask},	/* shift-F9 ? */
	{"\033[022q",	F10, shift_mask},	/* shift-F10 */
	{"\033[023q",	F11, shift_mask},	/* shift-F11 */
	{"\033[024q",	F12, shift_mask},	/* shift-F12 */

	/* VT100+, older xterm, Mach console, AT&T, QNX ansi */
	{"\033OT",	F5},	/* F5	*/
	{"\033OU",	F6},	/* F6	*/
	{"\033OV",	F7},	/* F7	*/
	{"\033OW",	F8},	/* F8	*/
	{"\033OX",	F9},	/* F9, conflict with VT102 appl. mode =	*/
	{"\033OY",	F10},	/* F10	*/
	{"\033OZ",	F11},	/* F11	*/
	{"\033O[",	F12},	/* F12	*/

	/* rxvt */
	{"\033[7~",	smallHOMEkey},	/* 	*/
	{"\033[8~",	smallENDkey},	/* 	*/
	{"\033[Z",	MPW, shift_mask},	/* shift-TAB */

	/* SCO ansi */
	{"\033[L",	INSkey},	/* (termcap: insert character) */

	{NIL_PTR}
};

struct fkeyentry fkeymap_vt52 [] = {
	/* VT52 and HP */
	{"\033A",	MUP},	/* up	*/
	{"\033B",	MDN},	/* dn	*/
	{"\033C",	MRT},	/* rt	*/
	{"\033D",	MLF},	/* lf	*/
	{"\033P",	F1},	/* PF1 */
	{"\033Q",	F2},	/* PF2 */
	{"\033R",	F3},	/* PF3 */
	{"\033S",	F4},	/* PF4 */

	/* keypad application mode */
	{"\033?p",	INSkey},	/* keypad 0 */
	{"\033?q",	ENDkey},	/* keypad 1 */
	{"\033?r",	MDN},	/* keypad 2 */
	{"\033?s",	PD},	/* keypad 3 */
	{"\033?t",	MLF},	/* keypad 4 */
	{"\033?u",	HOP},	/* keypad 5 */
	{"\033?v",	MRT},	/* keypad 6 */
	{"\033?w",	HOMEkey},	/* keypad 7 */
	{"\033?x",	MUP},	/* keypad 8 */
	{"\033?y",	PU},	/* keypad 9 */
	{"\033?l",	DELkey},	/* keypad , */
	{"\033?m",	SU},	/* keypad - */
	{"\033?n",	DELkey},	/* keypad . */
	{"\033?M",	SNL},	/* keypad ENTER */

	/* xterm/VT52 application mode */
	{"\033?j",	I},	/* keypad * */
	{"\033?k",	SD},	/* keypad + */
	{"\033?o",	I},	/* keypad / */
	{"\033?X",	HOP},	/* keypad = */
	{"\033?I",	STAB},	/* Tab */
	{"\033? ",	SSPACE},	/* Space ? */

	/* xterm/VT52 */
	{"\033H",	HOMEkey},	/* Pos1	*/
	{"\033F",	ENDkey},	/* End	*/
	{"\033E",	HOP},		/* keypad 5	*/
	{"\0331H",	HOMEkey},	/* modified Pos1	*/
	{"\0331F",	ENDkey},	/* modified End	*/
	{"\0331E",	HOP},		/* modified keypad 5	*/
	{"\0331A",	MUP},	/* modified up	*/
	{"\0331B",	MDN},	/* modified dn	*/
	{"\0331C",	MRT},	/* modified rt	*/
	{"\0331D",	MLF},	/* modified lf	*/
	{"\0331P",	F1},	/* modified PF1 (could be) */
	{"\0331Q",	F2},	/* modified PF2 (could be) */
	{"\0331R",	F3},	/* modified PF3 (could be) */
	{"\0331S",	F4},	/* modified PF4 (could be) */

	{NIL_PTR}
};

struct fkeyentry fkeymap_hp [] = {
	/* VT52 and HP */
	{"\033A",	MUP},	/* up	*/
	{"\033B",	MDN},	/* dn	*/
	{"\033C",	MRT},	/* rt	*/
	{"\033D",	MLF},	/* lf	*/
	{"\033P",	DELkey}, /* VT52 PF1 Del */
	{"\033Q",	INSkey}, /* VT52 PF2 Ins (termcap: insert character) */
	{"\033R",	HOP},	/* VT52 PF3 */
	{"\033S",	PD},	/* VT52 PF4
				   termcap xterm-hp: PgDn
				   termcap hp*: scroll-forward/backward key
				*/
	/* HP */
	{"\033T",	PU},	/* termcap xterm-hp: PgUp
				   termcap hp*: scroll-backward/forward key
				*/
	{"\033h",	HOMEkey},	/* Pos1	*/
	{"\033F",	ENDkey},	/* End	*/
	{"\033V",	PU},
	{"\033U",	PD},
	{"\033L",	LIB},	/* insert line	*/
	{"\033J",	DELchar},	/* erase (clear to (end of) screen)	*/
	{"\033K",	DLN},	/* clear to end of line	*/
	{"\033M",	DLINE},	/* delete line	*/
	{"\033i",	MPW},	/* back-tab	*/
	{"\033p",	F1},	/* F1 */
	{"\033q",	F2},	/* F2 */
	{"\033r",	F3},	/* F3 */
	{"\033s",	F4},	/* F4 */
	{"\033t",	F5},	/* F5 */
	{"\033u",	F6},	/* F6 */
	{"\033v",	F7},	/* F7 */
	{"\033w",	F8},	/* F8 */

	/* xterm HP mode generic patterns for modified function keys */
	{"\033[1p",	F1},	/* F1 */
	{"\033[1q",	F2},	/* F2 */
	{"\033[1r",	F3},	/* F3 */
	{"\033[1s",	F4},	/* F4 */
	{"\033[1t",	F5},	/* F5 */
	{"\033[1u",	F6},	/* F6 */
	{"\033[1v",	F7},	/* F7 */
	{"\033[1w",	F8},	/* F8 */

	/* xterm HP mode generic patterns for modified keypad keys */
	{"\033[1h",	HOMEkey},	/* Pos1	*/
	{"\033[1T",	PU},		/* PgUp */
	{"\033[1S",	PD},		/* PgDn */
	{"\033[1Q",	INSkey},	/* Ins */
	{"\033[1P",	DELkey},	/* Del */

	/* crttool */
	{"\033m",	DIRECTcrttool},	/* direct cursor address */

	/* ?? */
	{"\033&",	SNL},	/* keypad Enter */

	{NIL_PTR}
};

#ifdef hp_console_dont_know_how_to_trigger_this
	/* HP workstation keyboard without NumLock */
	/* conflicts with VT100+ etc, see above */
	{"\033OU",	MARK},	/* Pos1	*/
	{"\033OV",	MLF},	/* lf	*/
	{"\033OW",	MUP},	/* up	*/
	{"\033OX",	MRT},	/* rt	*/
	{"\033OY",	MDN},	/* dn	*/
	{"\033OZ",	PU},	/* PgUp	*/
	{"\033O?",	PD},	/* PgDn; End, Ins, Del?	*/
#endif

struct fkeyentry fkeymap_rxvt [] = {
	/* rxvt */
	{"\033[2~",	INSkey, ctrl_mask},	/* small keypad Ins key	*/
	{"\033[3~",	DELkey, ctrl_mask},	/* small keypad Del key	*/
	/* xterm */
	{"\033[M",	DIRECTxterm},	/* direct cursor address */
	{"\033[t",	TRACKxterm},	/* cursor hilite tracking */
	{"\033[T",	TRACKxtermT},	/* cursor hilite tracking */

	{NIL_PTR}
};

struct fkeyentry fkeymap_xterm [] = {
	/* xterm */
	{"\033[M",	DIRECTxterm},	/* direct cursor address */
	{"\033[t",	TRACKxterm},	/* cursor hilite tracking */
	{"\033[T",	TRACKxtermT},	/* cursor hilite tracking */

	{NIL_PTR}
};

struct fkeyentry fkeymap_vt100 [] = {
	/* VT100 */
	{"\033[1~",	FIND},	/* Find */
	{"\033[4~",	MARK},	/* Select */
	{"\033[29~",	COPY},	/* Do */
	{"\033[28~",	HELP},	/* Help */

	{"\033OX",	HOP},	/* appl. mode =, conflict with older xterm F9 */

	{NIL_PTR}
};

struct fkeyentry fkeymap_scoansi [] = {
	{"\033[M",	F1},	/* F1 */
	{"\033[N",	F2},	/* F2 */
	{"\033[O",	F3},	/* F3 */
	{"\033[P",	F4},	/* F4 */
	{"\033[Q",	F5},	/* F5 */
	{"\033[R",	F6},	/* F6 */
	{"\033[S",	F7},	/* F7 */
	{"\033[T",	F8},	/* F8 */
	{"\033[U",	F9},	/* F9 */
	{"\033[V",	F10},	/* F10 */
	{"\033[W",	F11},	/* F11, PuTTY SCO */
	{"\033[X",	F12},	/* F12, PuTTY SCO */
	{"\033[Y",	F1, shift_mask},	/* shift-F1, PuTTY SCO */
	{"\033[Z",	F2, shift_mask},	/* shift-F2, PuTTY SCO */
	{"\033[a",	F3, shift_mask},	/* shift-F3, PuTTY SCO */
	{"\033[b",	F4, shift_mask},	/* shift-F4, PuTTY SCO */
	{"\033[c",	F5, shift_mask},	/* shift-F5, PuTTY SCO */
	{"\033[d",	F6, shift_mask},	/* shift-F6, PuTTY SCO */
	{"\033[e",	F7, shift_mask},	/* shift-F7, PuTTY SCO */
	{"\033[f",	F8, shift_mask},	/* shift-F8, PuTTY SCO */
	{"\033[g",	F9, shift_mask},	/* shift-F9, PuTTY SCO */
	{"\033[h",	F10, shift_mask},	/* shift-F10, PuTTY SCO */
	{"\033[i",	F11, shift_mask},	/* shift-F11, PuTTY SCO */
	{"\033[j",	F12, shift_mask},	/* shift-F12, PuTTY SCO */
	{"\033[k",	F1, ctrl_mask},	/* control-F1, PuTTY SCO */
	{"\033[l",	F2, ctrl_mask},	/* control-F2, PuTTY SCO */
	{"\033[m",	F3, ctrl_mask},	/* control-F3, PuTTY SCO */
	{"\033[n",	F4, ctrl_mask},	/* control-F4, PuTTY SCO */
	{"\033[o",	F5, ctrl_mask},	/* control-F5, PuTTY SCO */
	{"\033[p",	F6, ctrl_mask},	/* control-F6, PuTTY SCO */
	{"\033[q",	F7, ctrl_mask},	/* control-F7, PuTTY SCO */
	{"\033[r",	F8, ctrl_mask},	/* control-F8, PuTTY SCO */
	{"\033[s",	F9, ctrl_mask},	/* control-F9, PuTTY SCO */
	{"\033[t",	F10, ctrl_mask},	/* control-F10, PuTTY SCO */
	{"\033[u",	F11, ctrl_mask},	/* control-F11, PuTTY SCO */
	{"\033[v",	F12, ctrl_mask},	/* control-F12, PuTTY SCO */
	{"\033OA",	MUP, ctrl_mask},	/* control-up, PuTTY SCO */
	{"\033OB",	MDN, ctrl_mask},	/* control-dn, PuTTY SCO */
	{"\033OC",	MRT, ctrl_mask},	/* control-rt, PuTTY SCO */
	{"\033OD",	MLF, ctrl_mask},	/* control-lf, PuTTY SCO */
	{"\033[L",	INSkey},	/* (termcap: insert character) */
	{"\033[H",	HOMEkey},	/* 	*/
	{"\033[F",	ENDkey},	/* (xterm-sco)	*/
	{"\033[G",	PD},	/* 	*/
	{"\033[I",	PU},	/* 	*/

	{NIL_PTR}
};

struct fkeyentry fkeymap_interix [] = {
	/* Interix console ("Windows Services for UNIX") */
	{"\033[H",	HOMEkey},
	{"\033[S",	PU},
	{"\033[T",	PD},
	{"\033[U",	ENDkey},
	{"\033[F-",	MUP, shift_mask},
	{"\033[F+",	MDN, shift_mask},
	{"\033[F$",	MRT, shift_mask},
	{"\033[F^",	MLF, shift_mask},
	{"\033[L",	INSkey},
/*	{"",	DELkey, ctrl_mask},	*/

	{"\033F1",	F1},
	{"\033F2",	F2},
	{"\033F3",	F3},
	{"\033F4",	F4},
	{"\033F5",	F5},
	{"\033F6",	F6},
	{"\033F7",	F7},
	{"\033F8",	F8},
	{"\033F9",	F9},
	{"\033FA",	F10},
	{"\033FB",	F11},
	{"\033FC",	F12},
	{"\033FD",	F1, shift_mask},
	{"\033FE",	F2, shift_mask},
	{"\033FF",	F3, shift_mask},
	{"\033FG",	F4, shift_mask},
	{"\033FH",	F5, shift_mask},
	{"\033FI",	F6, shift_mask},
	{"\033FJ",	F7, shift_mask},
	{"\033FK",	F8, shift_mask},
	{"\033FL",	F9, shift_mask},
	{"\033FM",	F10, shift_mask},
	{"\033FN",	F11, shift_mask},
	{"\033FO",	F12, shift_mask},
	{"\033FP",	F1, alt_mask},
	{"\033FQ",	F2, alt_mask},
	{"\033FR",	F3, alt_mask},
	{"\033FS",	F4, alt_mask},
	{"\033FT",	F5, alt_mask},
	{"\033FU",	F6, alt_mask},
	{"\033FV",	F7, alt_mask},
	{"\033FW",	F8, alt_mask},
	{"\033FX",	F9, alt_mask},
	{"\033FY",	F10, alt_mask},
	{"\033FZ",	F11, alt_mask},
	{"\033Fa",	F12, alt_mask},
	{"\033Fb",	F1, ctrl_mask},
	{"\033Fc",	F2, ctrl_mask},
	{"\033Fd",	F3, ctrl_mask},
	{"\033Fe",	F4, ctrl_mask},
	{"\033Ff",	F5, ctrl_mask},
	{"\033Fg",	F6, ctrl_mask},
	{"\033Fh",	F7, ctrl_mask},
	{"\033Fi",	F8, ctrl_mask},
	{"\033Fj",	F9, ctrl_mask},
	{"\033Fk",	F10, ctrl_mask},
	{"\033Fm",	F11, ctrl_mask},
	{"\033Fn",	F12, ctrl_mask},
	{"\033Fo",	F1, ctrlshift_mask},
	{"\033Fp",	F2, ctrlshift_mask},
	{"\033Fq",	F3, ctrlshift_mask},
	{"\033Fr",	F4, ctrlshift_mask},
	{"\033Fs",	F5, ctrlshift_mask},
	{"\033Ft",	F6, ctrlshift_mask},
	{"\033Fu",	F7, ctrlshift_mask},
	{"\033Fv",	F8, ctrlshift_mask},
	{"\033Fw",	F9, ctrlshift_mask},
	{"\033Fx",	F10, ctrlshift_mask},
	{"\033Fy",	F11, ctrlshift_mask},
	{"\033Fz",	F12, ctrlshift_mask},

	{NIL_PTR}
};

struct fkeyentry fkeymap_siemens [] = {
	/* Siemens 97801/97808 */
	{"\033[Z",	MPW},		/* |<- */
	{"\0339",	MPW},		/* <~- */
	{"\033:",	MNW},		/* -~> */
	{"\0336",	HOP},		/* key next to END, above cursor block */
	{"\033[@",	INSkey},	/* Insert */
	{"\033[S",	PU},
	{"\033[T",	PD},
	{"\033^",	HOP},

	{"\033@",	F1},	/* F1 */
	{"\033A",	F2},	/* F2 */
	{"\033B",	F3},	/* F3 */
	{"\033C",	F4},	/* F4 */
	{"\033D",	F5},	/* F5 */
	{"\033F",	F6},	/* F6 */
	{"\033G",	F7},	/* F7 */
	{"\033H",	F8},	/* F8 */
	{"\033I",	F9},	/* F9 */
	{"\033J",	F10},	/* F10 */
	{"\033K",	F11},	/* F11 */
	{"\033L",	F12},	/* F12 */
	{"\033M",	F3, ctrl_mask},	/* F13 */
	{"\033N",	F4, ctrl_mask},	/* F14 */
	{"\033O",	F5, ctrl_mask},	/* F15 */
	{"\033P",	F6, ctrl_mask},	/* F16 */
	{"\0330",	F7, ctrl_mask},	/* F17 */
	{"\033_",	F8, ctrl_mask},	/* F18 */
	{"\033d",	F9, ctrl_mask},	/* F19 */
	{"\033T",	F10, ctrl_mask},	/* F20 */
	{"\033V",	F11, ctrl_mask},	/* F21 */
	{"\033X",	F12, ctrl_mask},	/* F22 */
	{"\033 ",	F1, shift_mask},	/* shift-F1 */
	{"\033;",	F2, shift_mask},	/* shift-F2 */
	{"\033\"",	F3, shift_mask},	/* shift-F3 */
	{"\033#",	F4, shift_mask},	/* shift-F4 */
	{"\033$",	F5, shift_mask},	/* shift-F5 */
	{"\033%",	F6, shift_mask},	/* shift-F6 */
	{"\033&",	F7, shift_mask},	/* shift-F7 */
	{"\033'",	F8, shift_mask},	/* shift-F8 */
	{"\033<",	F9, shift_mask},	/* shift-F9 */
	{"\033=",	F10, shift_mask},	/* shift-F10 */
	{"\033*",	F11, shift_mask},	/* shift-F11 */
	{"\033+",	F12, shift_mask},	/* shift-F12 */
	{"\033,",	F3, ctrlshift_mask},	/* shift-F13 */
	{"\033-",	F4, ctrlshift_mask},	/* shift-F14 */
	{"\033.",	F5, ctrlshift_mask},	/* shift-F15 */
	{"\033/",	F6, ctrlshift_mask},	/* shift-F16 */
	{"\0331",	F7, ctrlshift_mask},	/* shift-F17 */
	{"\0332",	F8, ctrlshift_mask},	/* shift-F18 */
	{"\0333",	F9, ctrlshift_mask},	/* shift-F19 */
	{"\033U",	F10, ctrlshift_mask},	/* shift-F20 */
	{"\033W",	F11, ctrlshift_mask},	/* shift-F21 */
	{"\033Y",	F12, ctrlshift_mask},	/* shift-F22 */

	{NIL_PTR}
};

#endif	/* #ifndef msdos */


/*======================================================================*\
|*				End					*|
\*======================================================================*/
