/*======================================================================*\
	Check function valid_cjk with all mapping entries
	of all CJK character code mapping tables.
\*======================================================================*/

#include "charcode.c"

int width_data_version;
int nonbmp_width_data = 0;
int combining_data_version = 3;

FLAG utf8_text = 0;
FLAG utf16_file = 0;
FLAG utf16_little_endian = 0;
FLAG cjk_text = 0;
FLAG mapped_text = 0;

FLAG utf8_screen;
FLAG utf8_input;
FLAG cjk_term;
FLAG mapped_term;


/**
   Return # character codes marked non-valid.
 */
static
unsigned long
check (char tag)
{
	unsigned int i = 0;
	unsigned long cjkchar;
	unsigned long ok = 0;
	unsigned long non = 0;

	(void) set_text_encoding (NIL_PTR, tag, "validcjk");

	struct encoding_table_entry * cjk_table_poi = text_table;
	while (i ++ < text_table_len) {
#ifdef split_map_entries
		cjkchar = decode_cjk (cjk_table_poi, text_table);
#else
		cjkchar = cjk_table_poi->cjk;
#endif
		if (valid_cjk (cjkchar, NIL_PTR)) {
			ok ++;
		} else {
			printf ("%c %04X\n", text_encoding_tag, cjkchar);
			non ++;
		}
		cjk_table_poi ++;
	}
	printf ("%c: valid %d, not valid %d\n", text_encoding_tag, ok, non);
	return non;
}

int
main ()
{
	unsigned long non = 0;
	non += check ('B');
	non += check ('G');
	non += check ('C');
	non += check ('J');
	non += check ('S');
	non += check ('K');
	non += check ('H');

	return non > 0;
}


/*======================================================================*\
	end
\*======================================================================*/
