
#include "ming.h"

int main()
{
  SWFBitmap b;
  SWFShape s;
  SWFMovie m;
  SWFDisplayItem i;

  int n;

  Ming_init();
  Ming_setScale(1.0);

  b = newSWFJpegBitmap(fopen("../common/backyard.jpg", "rb"));
  s = newSWFShape();

  SWFShape_setRightFill(s, SWFShape_addBitmapFill(s, b, SWFFILL_TILED_BITMAP));
  SWFShape_drawLine(s, SWFBitmap_getWidth(b), 0);
  SWFShape_drawLine(s, 0, SWFBitmap_getHeight(b));
  SWFShape_drawLine(s, -SWFBitmap_getWidth(b), 0);
  SWFShape_drawLine(s, 0, -SWFBitmap_getHeight(b));

  m = newSWFMovie();
  SWFMovie_setDimension(m, SWFBitmap_getWidth(b), SWFBitmap_getHeight(b));

  i = SWFMovie_add(m, s);

  for(n=0; n<20; ++n)
  {
    SWFDisplayItem_multColor(i, 1.0-n/10.0, 1.0, 1.0, 1.0);
    SWFDisplayItem_addColor(i, 0xff*n/20.0, 0, 0, 0);
    SWFMovie_nextFrame(m);
  }
  for(n=20; n>0; --n)
  {
    SWFDisplayItem_multColor(i, 1.0-n/10.0, 1.0, 1.0, 1.0);
    SWFDisplayItem_addColor(i, 0xff*n/20.0, 0, 0, 0);
    SWFMovie_nextFrame(m);
  }

  SWFMovie_save(m, "test.swf");

  exit(0);
}
