
from ming import *

Ming_setScale(1.0)

m = SWFMovie()
m.setRate(36.0)
m.setDimension(1200, 800)
m.setBackground(0, 0, 0)

# mouse tracking sprite - empty, but follows mouse so we can
# get its x and y coordinates

i = m.add(SWFSprite())
i.setName('mouse')

# '1' means lock sprite to the mouse
m.add(SWFAction("startDrag('/mouse', 1);"))

# might as well turn off antialiasing, since these are just squares.
m.add(SWFAction("this.quality = 0;"))

# morphing box
r = SWFMorph()
s = r.getShape1()

s.setLeftFill(s.addFill(0xff, 0xff, 0xff))
s.movePenTo(-40, -40)
s.drawLine(80, 0)
s.drawLine(0, 80)
s.drawLine(-80, 0)
s.drawLine(0, -80)

s = r.getShape2()

s.setLeftFill(s.addFill(0x00, 0x00, 0x00))
s.movePenTo(-1, -1)
s.drawLine(2, 0)
s.drawLine(0, 2)
s.drawLine(-2, 0)
s.drawLine(0, -2)

# sprite container for morphing box -
# this is just a timeline w/ the box morphing

box = SWFSprite()
box.add(SWFAction("stop();"))
i = box.add(r)

for n in range(0,21):
  i.setRatio(n/20.0)
  box.nextFrame()


# this container sprite allows us to use the same action code many times

cell = SWFSprite()
i = cell.add(box)
i.setName('box')

# ...x means the x coordinate of the parent, i.e. (..).x
cell.add(SWFAction("\
  setTarget('box'); \
  dx = (/mouse.x + random(6)-3 - ...x)/5; \
  dy = (/mouse.y + random(6)-3 - ...y)/5; \
  gotoFrame(int(dx*dx + dy*dy)); \
"))

cell.nextFrame()
cell.add(SWFAction("gotoFrame(0); play();"))

cell.nextFrame()


# finally, add a bunch of the cells to the movie

for x in range(0,12):
  for y in range(0,8):
    i = m.add(cell)
    i.moveTo(100*x+50, 100*y+50)

m.nextFrame()

m.add(SWFAction("gotoFrame(1); play();"))

m.save("test.swf")
